/* This creates a Main Window with a Group of 1 multiple-select LIST with the
   END flag set.  Whenever the user makes a selection in the LIST, RXDLG
   returns, and if the user selected the 'all' item, we force all items to be
   selected.  If the user selected the 'none' item, we force all items to be
   deselected.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is LIST */
RXTYPE.1 = 'LIST'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END|MULTIPLE'

/* Label for control. No Groupbox */
RXLABEL.1 = ' '

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 90 6'

/* REXX variable where initial text stored */
RXVAL.1 = 'STRS'

/* Position */
RXX.1 = 10
RXY.1 = 10

/* Text */
STRS.1 = 'all'
STRS.2 = 'none'
STRS.3 = 'something'
STRS.4 = 'more'
STRS.5 = 'more stuff'
STRS.6 = ' '

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Since there is only 1 group and 1 control, we know that the LISTBOX caused
   RXDLG to return. Check the selections for the list. If the user selected
   the 'all' item, force all items to be selected.  If the user selected the
   'none' item, then force all items to be deselected.  We placed 'all'
   and 'none' as the first and second items in the list.  So, if either one is
   selected, then it must be the first item returned (ie, first selection).
*/

/* Did he select at least one item? */
IF STRS.0 > 0 THEN DO
   /* If 'all' or 'none' were selected, then either one must be the first
     selected item. So, just check the first returned item */
   IF STRS.0.1 = 'all' THEN DO
       RXSAY 'Selecting all...'
       RXSET '""' 1 1 'VAL' '|' 1
   END

   IF STRS.0.1 = 'none' THEN DO
       RXSAY 'Deselecting all...'
       RXSET '""' 1 1 'VAL' '|' 0
   END
END

SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
