/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* VPIDTID - Example of DosVerifyPidTid usage                       */

/*                                                                  */

/* Verify that a PID/TID is still valid.                            */

/* Richard Moore 16th November 98                                   */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax VPIDTID /P=pid [/T=tid]                                   */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_DOSMISC  



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosVerifyPidTid validates a PID/TID pair. If the thread and process exist then    */

/* a zero return code is set, otherwise the return code indicates whether the thread */

/* or the process are invalid.                                                       */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Prototype definition for DosVerifyPidTid                    */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* APIRET APIENTRY DosVerifyPidTid(PID pid, TID tid);                                */ 

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/*                       Returns the following return codes:                         */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* NO_ERROR                0                                                         */

/* ERROR_INVALID_PROCID    303                                                       */

/* ERROR_INVALID_THREADID  309                                                       */

/*                                                                                   */

/*************************************************************************************/





int main(int argc, char *argv[], char *envp[])

{

   PID pid=0;

   TID tid=1;

   int i;

   APIRET rc;



   if (argc<2) {

      printf("VPIDTID /P=pid [/T=tid]\n");

      return;

   } /* endif */



   for (i=1; i<argc ;++i ) {

      if (strnicmp(argv[i],"/P=",3)==0) pid=strtoul(argv[i]+3,NULL,16);

      else if (strnicmp(argv[i],"/T=",3)==0) tid=strtoul(argv[i]+3,NULL,16);

   } /* endfor */



   if (pid == 0) {

      printf("VPIDTID /P=pid [/T=tid]\n");

      return;

   } /* endif */



   rc=DosVerifyPidTid(pid,tid);



   printf("Verify pid=0x%04x tid=0x%04x rc=%u\n",pid,tid,rc);    



   return 0;

}



