/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* MEMSTATE - Example of DosQueryMemState usage.                    */

/*                                                                  */

/* Get Status of a range of pages in memory.                        */

/*                                                                  */

/* Richard Moore 6th January 99                                     */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax MEMSTATE <addr> <size>                                    */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_PROFILE



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>

#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosQueryMemState takes as input parameters an address and size. The address       */

/* is rounded down to page boundary and size up to a whole number of pages.          */

/*                                                                                   */

/* The status of the pages in the range is returned in state parameter and the       */

/* size of the range queried is also returned in the size parameter.                 */

/*                                                                                   */

/* If pages in the range have conflicting states then the state of the first page    */

/* is returned.                                                                      */

/*************************************************************************************/





/*************************************************************************************/

/*                                                                                   */

/*                      Prototype definition for DosQueryMemState                    */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* APIRET APIENTRY DosQueryMemState(PVOID pMem, PULONG size, PULONG state);          */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* Use the following ordinal to import DosQueryMemState.                             */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* #define ORD_DOS32QUERYMEMSTATE          307                                       */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* Return flags indicate the following page states:                                  */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* #define PAG_NPOUT       0x00000000         page is not present, not in core       */

/* #define PAG_PRESENT     0x00000001         page is present                        */

/* #define PAG_NPIN        0x00000002         page is not present, in core           */

/* #define PAG_PRESMASK    0x00000003         present state mask                     */

/* #define PAG_INVALID     0x00000000         page is invalid                        */

/* #define PAG_RESIDENT    0x00000010         page is resident                       */

/* #define PAG_SWAPPABLE   0x00000020         page is swappable                      */

/* #define PAG_DISCARDABLE 0x00000030         page is discardable                    */

/* #define PAG_TYPEMASK    0x00000030         type mask                              */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/* DosQueryMemState returns the following:                                           */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/*  0      NO_ERROR                                                                  */

/*  87     ERROR_INVALID_PARAMETER                                                   */

/*  487    ERROR_INVALID_ADDRESS                                                     */

/*                                                                                   */

/*************************************************************************************/



int main(int argc, char *argv[], char *envp[])

{

   APIRET rc=0;

   PVOID pMem;       

   ULONG status;     

   ULONG size;     

   ULONG pages;     

   ULONG onepage = 0x1000;     



   if (argc < 3) {



      printf("Syntax: MEMSTATE <address> <size>\n");

      return 0;

      

   } else {



      pMem = (PVOID) strtoul(argv[1], NULL, 0);

      size = strtoul(argv[2], NULL, 0);

      pages = (size+0x0fff) >> 12;



      printf("addess     state\n");

      while (pages--) {



         rc = DosQueryMemState(pMem, &onepage, &status);

   

         if (rc) printf("0x%08x DosQueryMemState returned %u\n",pMem, rc); 

         else { 

            printf("0x%08x 0x%08x ", pMem, status);

            if ((status & PAG_PRESMASK) == PAG_NPOUT) printf("not present, not in-core, ");

            else if (status & PAG_PRESENT) printf("present, in-core, ");

            else if (status & PAG_NPIN) printf("not present, in-core, ");

   

            if ((status & PAG_TYPEMASK) == PAG_INVALID) printf("invalid\n");

            if ((status & PAG_TYPEMASK) == PAG_RESIDENT) printf("resident\n");

            if ((status & PAG_TYPEMASK) == PAG_SWAPPABLE) printf("swappable\n");

            if ((status & PAG_TYPEMASK) == PAG_DISCARDABLE) printf("discardable\n");

         }

         pMem = (PVOID)((ULONG)pMem + 0x1000);



      } /* endwhile */



   } /* end if*/



   return rc;

   

}



