/********************************************************************/
/*                                                                  */
/* (C) Copyright IBM UK Ltd. 1996                                   */
/*                                                                  */
/* GETPROC - Example of DosGetProcessorStatus usage.                */
/*                                                                  */
/* Get Status of all processors. Offline processors are unavailable */
/* to run work until made online with DosSetProcessorStatus.        */
/*                                                                  */
/* Richard Moore 4th January 99                                     */
/* Version 1.0                                                      */
/*                                                                  */
/* Syntax GETPROC <procid1 procid2 .....>                           */
/*                                                                  */
/*                                                                  */
/********************************************************************/


#define INCL_DOSSPINLOCK

#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */


/*************************************************************************************/
/*                                                                                   */
/* Purpose:                                                                          */
/*                                                                                   */
/* DosGetProcessorStatus returns the ONLINE or OFFLINE status of each processor      */
/* of an SMP system. The processor status may be set using DosSetProcessorStatus.    */
/* ONLINE status imples the processor is available for running work.                 */
/* OFFLINE status implies the processor is not available for running work.           */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                      Prototype definition for DosGetProcessorStatus               */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  APIRET APIENTRY DosGetProcessorStatus(ULONG procid, PULONG status);              */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* Use either the SMP version of OS2386.LIB or the following ordinals in the .DEF    */
/* file at link edit time.                                                           */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* #define ORD_DOS32GETPROCESSORSTATUS     447                                       */
/*                                                                                   */
/*************************************************************************************/
  
/*************************************************************************************/
/*                                                                                   */
/* procid is the processor ID numbered from 1 through n, where there are n           */
/* processors in total.                                                              */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* status is one of the following:                                                   */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  #define PROC_OFFLINE    0x00000000         processor is offline                  */
/*  #define PROC_ONLINE     0x00000001         processor is online                   */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* DosGetProcessorStatus returns the following:                                      */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  0      NO_ERROR                                                                  */
/*  87     ERROR_INVALID_PARAMETER                                                   */
/*                                                                                   */
/*************************************************************************************/


int main(int argc, char *argv[], char *envp[])
{
   APIRET rc=0;
   ULONG procid;     
   ULONG status;     
   int i;

   if (argc == 1) {
      for (procid=1; rc==0 ;++procid ) {
         rc = DosGetProcessorStatus(procid, &status);
         if (rc==0) {
            if (status == PROC_OFFLINE) printf("Processor %u offline\n", procid);
            else printf("Processor %u online\n", procid);
         } /* endif */
      } /* endfor */
      
   } else for (i=1; i<argc ; ++i ) {
      procid = atol(argv[i]);
      rc = DosGetProcessorStatus(procid, &status);
      if (rc) printf("DosGetProcesorStatus returned %u\n",rc); 
      else {
         if (status == PROC_OFFLINE) printf("Processor %u offline\n", procid);
         else printf("Processor %u online\n", procid);
      } /* endif */
   } /* endfor */

   return rc;
   
}

