/* Sample to show simple mouse event handling */

import java.applet.*;
import java.awt.*;

public class Event1 extends Applet {

// Define objects, data used within the applet

  String pFirst, pFont;

  boolean bMouse = false;
  boolean bPaint = false;
  int xStart, yStart, xEnd, yEnd;


/*--------------------------------------------------------*/
/* init method -                                          */
/*  this method performs layout and initialization of     */
/*  objects for the class.                                */
/*--------------------------------------------------------*/

  public void init() {


// Now show the panel (this is required)

    show();

  }

/*--------------------------------------------------------*/
/* paint method -                                         */
/*  this method performs repaint of the text using the    */
/*  specified font parameters.  The font style is         */
/*  determined from the checkbox group.  The font size is */
/*  determined from the size choice list.                 */
/*--------------------------------------------------------*/

  public void paint(Graphics g) {
    int iStyle = Font.BOLD;

    g.setFont(new Font("TimesNewRoman", iStyle, 18 ));
    if (bPaint) {
       bPaint = false;
       g.drawString("Start here", xStart, yStart);
       g.drawString("End here", xEnd, yEnd);
    } 
    

  }


/*---------------------------------------------------------*/
/* handle event method -                                   */
/*---------------------------------------------------------*/

  public boolean handleEvent(Event e) {

    if (e.id == Event.MOUSE_DOWN) {
       bMouse = true;
       xStart = e.x;
       yStart = e.y;
    }
     
    if (e.id == Event.MOUSE_UP) {
       if (bMouse) {
          bMouse = false;
          xEnd = e.x;
          yEnd = e.y;
          bPaint = true;
          repaint();
       }
    }
    
    return super.handleEvent(e);
  }

}
