..
..ENGLISH LANGUAGE
..Documentation WSedit in Write&Set / Wordstar (DOS) format.
..You can read this file by using WSEDIT.
..The Help file WSedit.hlp was created from this source file by Hypermake.
..
.gs220
.bt wsedit
.ti Documentation WSedit 0.99k
.if WSformat
.he sfE  WSedit 0.99k  
.sfJ
  WSedit 0.99k Documentation
.sf



.end
.<>
.ic#
.bt blackdot
.ti Documentation WSedit 0.99k
.1
Introduction

.bm center
.bm wsedit
WSedit - Write&Set Editor 0.99k, September 5 2009

.ID P_INTRO
Freeware Editor for OS/2, eCS, Windows95/98/ME/NT/2000/XP and Linux (planned) which reads Wordstar (DOS) 4-7 and ASCII (ISO and IBM codepage) and writes Wordstar 4 and ASCII format (ISO and IBM codepage). User Interface CUA (Windows Standard) and Wordstar (with Ctrl shortkeys).

Most Wordstar Ctrl commands are supported. The behaviour of WSedit depends on the text file extension. In the settings notebook, you can define different properties dependent on the file extension of the file.

The idea of WSedit is to have a modern graphical 32-bit application with look-and-feel of old "Wordstar for DOS" and "Windows editor" behaviour simultaneously. You can also use WSedit without knowing Wordstars Ctrl commands ("Ctrl" is abbreviated ^) and without knowing about the Wordstar file format: if you don't use the Wordstar file format, WSedit is a powerful text editor for large ASCII files with/without word wrapping. In this case, it will be nevertheless useful for you to take a look at the dot commands for unformatted files and at the Ctrl commands.

The WSedit Freeware program is a part of the full-featured wordprocessing suite Write&Set. Write&Set consists of two programs: one for writing (WSedit) and one for "setting" - means formatting, previewing and printing (WSformat). If you have installed both WSedit and WSformat, you get the look-and-feel of a single program. Write&Set is based on Wordstar dot commands (formatting commands in the text, with a dot at the beginning of a line). You enter a raw text with dot commands and without fixed margin in WSedit (WS file). After you have finished writing, WSformat will compile the raw text to a formatted text (FMT file) with fixed margins which can be viewed again in WSedit. This formatted text can be previewed and printed to all printers which are installed on your operating system. Write&Set supports contents, index, footnotes, bitmaps, hyphenation. In opposite to Winword-like programs, Write&Set won't get problems if text documents get large. For more information, visit http://www.WriteAndSet.com .

If you are searching for an editor with more basic functionality to get a substitute for Windows Notepad or OS/2 System Editor, without wordprocessing functionality and without ability of reading/writing Wordstar files, take a look at "Martins System Editor ME", a "WSedit light". The look-and-feel of ME is closer to Windows Notepad and OS/2 System Editor than WSedit. ME has got print ability, WSedit not. The chapter "General functionality" describes the functionality which is part of both editors.

To convert Write&Set files to hypertext formats, you are encouraged to download Hypermake http://www.hypermake.com . It is a hypertext compiler which compiles Write&Set files, Wordstar 4 files or ASCII files with Write&Set syntax to HTML, Winhelp, MS HTML-Help or IBM Help. Hypermake is Freeware for a text file length up to 20 kB, otherwise Shareware.

To get a short impression how a Write&Set raw text file looks like, you will find the raw text of this documentation in the Write&Set archive file (docusrc\WSedit-e.WS). You can format and print this raw text by using WSformat. I have used Hypermake to generate a Help file from this raw text file. The graphical Hypermake program also contains an editor which is very close to WSedit and is also Wordstar-enabled.

Important note for Wordstar 5-7 users: please note that WSedit always saves Wordstar files in Wordstar 4.0 Format. Additional Wordstar 5-7 features get lost or, e.g. footnotes, will be converted to Write&Set format.

.2
Feature list

.in Features
WSedit and its little brother ME have got the following properties:

reading and writing TXT files
when working with an unformatted file, text is reformatted if the window width is changed (word wrap)
marking lines with Hard Return and Soft Return in the rightmost column
CUA key support (Windows key commands), Wordstar key support
multi undo
switching between different screen fonts (for the whole document)
nearly no file size limit (there seems to be a limit at approximately 20 MB)
reading Microsoft DOC files (text without formatting, read-only)
supports workgroups (one person has write access, the others can only read)
last but not least, very fast and stable.

WSedit-only properties:

reading WS4 and WS5-WS7, writing WS4
detail behaviour appropriate to WS4-7
holding different user settings dependent on the file extension of the text file
paragraph formatting with soft characters ("snow characters") like Wordstar
contents tree in a separate window like a directory tree to navigate in large documents
command highlightning (e.g. for HTML files)
undo slider window
TXT Import and Export (IBM and ISO codepage)
highlightning spell-checking function where you can let analyse your own already spell-checked files to get a personal dictionary
translation functionality if you download separate translation files
Macro recorder for defining Function keys

In comparison to Wordstar (DOS), there's no 80 column limit on the screen and long filenames are supported, of course.

.2
(no) installation

.in installation
.if IPF
Using WSedit as an stand-alone application does not need a real installation program. Unpack the files of the archive to a new directory of your choice. To "install", simply create a new program object. Now you can drag and drop arbitrary text files to the WSedit icon on your desktop.
.ELSE
Using WSedit as an stand-alone application: Simply run the self-extracting archive. It copies the files to a new program directory and creates a shortcut "WSedit" on the desktop where you can drag and drop text files to. The installation program does not make any entries in the Windows registry. Double clicking to a text file with unknown extension will show a dialog where you can choose the WSedit.EXE file as the default program to open with.
.END

To uninstall, simply delete the shortcut on the desktop and the program directory.

When installing Write&Set (WSedit together with WSformat), the install program is more complicated. It has got an uninstall command.

.2
More about Write&Set

WSedit has no #formatting and #printing ability. This does WSformat. WSedit and WSformat together are "Write&Set". This is a full-featured word-processing software supporting hyphenation, graphics, footnotes, contents and so on. Please visit http://www.WriteAndSet.com

Word processing with Write&Set is very different from those Windows word processing programs such as Winword or StarOffice, and also differs in some respects from Wordstar for DOS. Word processing operations are closer to Latex than to Winword. With Write&Set, the task of 'text content editing' and that of 'typesetting' are sequention operations, rather than simultaneously. This concept simplifies word processing and enables you compiling a single document with hundreds of pages without any problems. The way to get a complex document involved some or all of the following steps:

.tb9
Step 1:Editing Text is prepared as an (unformatted) 'raw' text file (a WS file) using WSedit. Such a text file will not include fixed margins. If you use WSedit, the margin of the displayed text depends only on the settings of the editing window and the screen font.

Step 2:Starting WSformat, formatting the unformatted raw-text WS file to produce a formatted FMT file:

The WSformat 'format' function reads the raw-text WS file and writes an FMT file. It does not modify the WS file in any way. In the FMT file, which can be also viewed using WSedit or Wordstar (DOS), the right margin is now fixed, the page breaks are apparent, and words at the end of the line which require hyphenation are displayed accordingly.

Step 3:Minor changes by hand on the formatted FMT file

If you are not satisfied with some formatting details, you can make small changes to the FMT file. These include such things as incorrect hyphenations, and more importantly, page breaks which can be improved.

However, avoid making bigger changes to the FMT file; if these are considered necessary, it is more expedient to make the changes to the WS file and run WSformat again. Because WSformat formatting is extremely fast (about 100 pages per second, depending on your processor and the nature of the text), this does not represent a significant delay in production.

The WSformat preview feature helps in locating sections of the text where the printout can be improved. The printout in the Preview window mirrors exactly page printout.

Step 4:Printing the final version of the document

After making the final changes to the FMT file, select in WSformat the physical or virtual printer installed on your computer and print your document. This is done the same way as it would be for other current word processors. Besides physical printers (laser or inkjet printers), it is possible to use 'virtual' printers (FAX and PDF creation programs).

.2
Differences to Wordstar 4

I tried to get the same look-and-feel like #Wordstar 4. If you find differences, please let me know.

But there are some essential differences caused by the different internal structure of WSedit.

The WSedit editor is based on a non-wordwrap line-orientated editor written for programmers which already supports some Wordstar Ctrl commands. It's an object-orientated program, so I had to add or to overwrite some parts like word-wrapping, spell-checking, paragraph indention and so on. But I can't change some essentials of the editor. These essential properties - different to Wordstar DOS - are:

.tb4,6
The editor holds all characters in lines which are limited to 255 characters.

The characters you will see are the same which are stored in the memory of the computer. In consequence, some Wordstar behaviour of showing text is not possible:
-It won't be possible to draw a line behind ".PA", instead WSedit shows the page break by background-highlightning
-^OD "do not show toggles" is available since 0.92, but pressing any key will show the toggles again: You can't type while toggles are not shown.
-Snow characters (soft spaces) are directly stored in the memory by the ASCII character you will see in WSedit (ALT-176); you can directly enter this character by ALT-176 or ^I. The TAB key is identical to ^OG.
-If you enter ^OB to omit the snow characters, all snow characters of the file are changed from ALT-176 to ALT-255 which is a second SPACE character; after retyping ^OB, ALT-255 is re-changed to ALT-176. So don't use these two characters in your text for other purpose.
-For hyphenation characters at the end of the line, ALT-240 is used.

After saving a WSedit WS file, the file is accurately identical to Wordstar 4 format.

.dp#2
.WA verti 35
.1
Bars and Menus

.2
Titlebar

The titlebar of the WSedit window shows a lot of information.

(4,226*) in parenthesis means Column 4 and Line 226, the * star shows you that the file was modified since the last Save.

The "Par" (german "Abs") number counts the Hard Returns up to the cursor position, dot commands are also counted. In unformatted files, the line number in parenthesis is dependent on the current formatting, so the "Par" number is the only useful orientation you will have in unformatted files! With the "Paragraph Dialog" ^QH you can jump to a specific paragraph number.

In Write&Set formatted files (FMT files), an additional "P" and "L" number (Page, Line) is shown like Wordstar does (german "S" and "Z"). These values depend on the page formatting dot commands.

Then, the filename is shown.

If the column block mode (^KN) is activated, "COLUMN" is shown.

If column block is activated and exclusively numbers are marked, you will see the sum of all numbers in the title bar: ^U = [Sum] and the sum is copied into the trash buffer.

.2
Menu Bar, Popup Menu

WSedit has got a Menu Bar and a Popup menu (activated with the right mouse button) which are functionally identical. To get a maximum of room for text, you can disable the Menu Bar (Options - Show/Omit Menu Bar). To get the Menu Bar back, press the right mouse button and select the same menu item again. "Options" - "Windows-like Popup" switches between two appearances of the popup menu.

The Menu shows important commands or commands which are not expected in a "Wordstar-like" editor. Some functionality which affects the whole file and which is not often used is only located in the Menu and is not in reach from Ctrl key commands. Macro recording only works with key commands and not with the Menu.

..Gened Anfang
.dp#2
.WA verti 35
.1
General Functionality

.2
Martins Editor Family

I have written several editors and programs containing editors. All these editors have got an identical general functionality and share the same program source code. These programs are:

WSedit Freeware editor
ME Freeware editor (Martins System Editor, a WSedit "light")
integrated editor in the Hypermake program which is very close to WSedit
integrated editor in the accounting program "Textbuch" (only in german language).

If you use more than one of these programs, this chapter is valid for all these editors.

.2
Rightmost Column, Wrapping

WSedit does not handle lines longer than 250 characters. When handling normal text files, the text gets wrapped after 250 characters, even the txt file menu option Options - word wrap  is off.

The background of the #:rightmost column; of the editor shows different colors if this property is enabled.

.if WSedit
You can enable and disable this setting via settings notebook - highlt. (Ctrl-OO)
.end
.if ME
You can enable and disable this setting via settings notebook - General.
.end

..this is a comment line!
Lines beginning with two dots (comment lines)
Lines beginning with a single dot (dot commands)
Lines with a Hard Return at the end
Lines with a Soft Return at the end
Lines with a Break Return at the end.

.it Hard Return
.it Soft Return
.it Break Return
A #Hardreturn is the end of a line where you have entered RETURN manually. In any formatting, this Return will exist.

A #Softreturn disappears if the formatting gets different. If you change the window size and you edit an unformatted file, the editor let appear and disappear Soft Returns.

A #Breakreturn also disappears if the formatting gets different. In comparison to the Softreturn which is always related to a space character, the Breakreturn can occur everywhere. But appears only if a long line has got no spaces.

In the "special functions" menubar item, you will find commands where you can transform text with Softreturns into text with Hardreturns and reverse.

.2
Marking Text

.in marking
In this editor, blocks can exist independent from the cursor. In classic graphical text editors and wordprocessing applications, a block is a "big cursor" and the cursor is no more existing while a #block is marked. The blocks here will only disappear if you click with the mouse again into the window, but not with Cursor movements by using Cursor keys.

Blocks created by Wordstar Ctrl commands have got different properties, they do not disappear even you click with the mouse into the window again, see Chapter Ctrl Commands - Block commands.

Column Block

To switch between column block mode and normal block mode, type Ctrl-KN or Edit - Column Block.

If you have turned Column Block on and mark a column of numbers, the numbers gets added automatically and you see the result in the title bar. Ctrl-U copies the sum to the cursor position.

To mark a column block with keys without switching to column block mode, simply press the Alt key in addition to Shift-Cursor keys; you'll return to non column block mode automatically.

The column block functionality works with clipboard content if the text contains lines with the same length. If column block is not activated, it asked whether to switch to column block mode or not.

.2
Drag and drop

You are allowed to drag and drop a marked block to another text position or to another editor window. To drag and drop, use the right mouse button. The default function is moving the block within a window and copying between two windows. Pressing CTRL while dropping will copy the block and SHIFT will move a block.

OS/2 only: You are also allowed to drag text file icons to a specific position of the text area. This will read the file. If you press SHIFT while dragging, the name of the file without directories is copied instead of the file content. Pressing CTRL-SHIFT copies the whole filename with directory names. Reverse, you are allowed to drop marked text to a desktop folder. You will automatically get a filename, based on the beginning text of the marked block. (I'm sorry, but Windows does not offer such a functionality.)

.2
Undo

You can undo your input by typing Ctrl-Backspace and redo by typing Shift-Ctrl-Backspace. The default number of remembered undo events is 1000.

.if WSedit
In WSedit, you can open the Undo Slider window by pressing ^OU and the number of undo events can be set by the user, see Misc Page of the settings notebook. The recommendend number of undo events depends on the settings (press ^OO) of the Wrap Page.
.end

.2
Search/Replace dialog

.ID P_SEARCHREPLACE
You can reach the search/replace dialog via menu item Edit - Search and Edit - Replace, or you can use the key commands Ctrl-QF ("find") and Ctrl-QA.

Case sensitive

"Case sensitive" means that the search function makes a difference between capital and lowercase letters.

Search or replace several words

The search algorithm works line-orientated. If you enter an expression containing two words or more, and the second word is in the next line, you won't find the expression. (I will improve that in a later version.)

How to enter special characters into the edit field

.if WSedit
For Wordstar and Write&Set user, it is important to know that the WSedit search and search/replace dialog accepts printer characters: for example, enter ^ and B for the printer character Ctrl-PB.

.end
To enter an arbitrary ASCII character which is not available on the keyboard, write a hash (double cross), followed by three digits for the ASCII decimal code. If the ASCII code has only one or two digits, then use zero characters: hash-002. Enterig ^ and B (^B) accesses the same character in Wordstar notation.

If the hash sign is not followed by three digits, the string is treated normally.

Anyway, you can use the clipboard to copy these special characters from the editor into the clipboard (Ctrl-Ins) and then to the edit field of the search/replace dialog (Shift-Ins).

.2
Locate String Window

.ID P_LOCATESTRING
.if ME
Locate Strings can be edited in the edit field between the prev and next buttons in the function bar.
.else
You have got access to the Locate String Dialog Window by pressing Ctrl-OF (in contrast to Ctrl-QF Search  Dialog).
.end

In addition to the classic Search Dialog (Ctrl-QF) and the Incremental Search (Ctrl-QG), "Locate Strings" are the third possibility to search text strings in a text. In opposite to the other two variants which only move the cursor, all occurences of the string get highlighted in the text simultaneously. With the Prev and Next key, you can jump to the next highlighted expression in the text. The Locate String Window is not case-sensitive.

In the locate string edit field, you can concat several strings simultaneously, separated by semicolons:

Bush;Bin Laden;Saddam

The expressions in the text gets highlighted with different colors; the fourth expression gets the color of the first expression again and so on. It is allowed to use spaces in the expression, but if the expression in the text is part of two different lines, the text won't be found.

.2
Screen Fonts

.id P_EDITORFONTS
With Options - Select Fonts you can select screen fonts.

This editor only handles fonts with fixed spacing. On every system, different fonts can be installed. On a Windows system, fonts for files with IBM codepage are distinguished from fonts for files with Windows codepage. This is the reason why some fonts are disabled in the menu.

When starting the editor the very first time, the program asks the operating system for the available fonts and these fonts are saved in the file edifonts.ini which resides (besides Windows Vista) in the same directory as the program executable. You can edit this file by yourself. If you delete the file, it gets recreated when starting the editor the next time. With Windows, only a selection of fonts is generated: "Courier", "Terminal", "Fixedsys", "Courier", "System VIO" (if installed), "Lucida" and "Consolas" (Vista only). You can select additional fonts with the font dialog, these fonts get appended to the edifonts.ini file.

.2
Line drawing with cursor keys

.sw line drawing
This functionality is only available when using the IBM codepage. The IBM codepage contains characters which can be used for boxes and frames. In the Windows codepage, additional text characters for foreign languages are located here.

Simply press Ctrl-Alt-Cursor keys for single lines and Shift-Alt-Cursor keys for double lines. Edge characters are calculated automatically.

.2
Other Text formats

The editor can open Microsoft DOC files in read-only mode. At the moment, the functionality is not perfect; it can happen that DOC files are not shown up to the real end and the document shown in the editor stops somewhere within the document.

ME and Textbuch can read and write TXT files in Unix and Macintosh file format, here the encoding of the Return is different from the normal PC. In WSedit and Hypermake, this functionality is disabled permanently.

.WA verti 30
.1
Ctrl Commands

.2
Wordstar keycodes and other keycodes

This editor knows nearly all Wordstar key commands. These commands are activated by pressing Ctrl (Control). There are Wordstar commands with Strng and a single character key and commands with two character keys. the commands with two character keys are beginning with Ctrl-K, Ctrl-O or Ctrl-Q, in WSedit also Ctrl-P.

In WSedit, the "Wordstar" keymapping cannot be changed. In the other editors (Hypermake, ME, Textbuch), you can also select the keycodes "CUA" and "Mixed". "CUA" does not know Ctrl-commands with two character keys and the commands are close to other Windows editors - although there are no clear default standards. When selecting "CUA", some functionality of the editor is no more in reach.

When selecting "Mixed", the single-character Ctrl commands are like "CUA", nevertheless you have got access to the double-character "Wordstar" Ctrl commands.

Ctrl is abbreviated with ^ in this documentation.

.in Ctrl Commands
.2
Using the Editor without the Mouse

WordStar is a very old editor which was already available before the first IBM PC existed. In this time (end of the 70's), the computers had got a Ctrl key but nearly nothing more than a typewriter keyboard. Keys like "Page down" were not available on all computers this time. The mouse was not invented yet. So it was necessary to have the full functionality of a Computer text editor by using Ctrl and the character keys from A to Z.

Today, the Wordstar Ctrl commands can be very useful for people who type blind to the keyboard. If you can type blind, you should take a look at the Ctrl commands. They offer you the ability of blind cursor movement, block manipulation and more - all commands where you normally use the mouse.

.if WSedit
If you take a look at the Ctrl Dialog window (press Ctrl-J) and you are not familiar with Wordstar Ctrl commands, you will think it's difficult to learn this. But it is easier than it looks, because there's a logical principle behind the key combinations.

Ctrl is abbreviated ^. The Ctrl-keys overview window (Ctrl Menu, press ^J) is complete, this overview not.

If you press ^OA, you get a text file listing with all Ctrl commands which are listed in the Ctrl Dialog window. The name of this file is CTRLS.WS or CTRLS.TXT and is located in the directory where WSedit.exe resides.


To locate the text cursor which your eyes lost, press the CTRL key alone without another key. This will force Cursor highlightning, if it is enabled (^OO settings notebook, page misc).

.2
Ctrl Menu

You can activate the Ctrl Menu by typing ^J (means Ctrl-J) or by typing the "Wordstar Ctrl-key menu commands" ^K ^Q ^O and ^P. These four Ctrl commands expect a second character key and are not typed alone. If you type one of these commands alone and wait a moment, the Ctrl Menu automatically appears.

If the Ctrl Menu has got the focus, you can type the missing second character key or you can double-click to the function you want to have executed.

When typing Ctrl commands fast (by heart), the Ctrl Menu does not appear automatically. In the settings notebook, page misc, you can define the time delay for activating the Ctrl Menu.

The commands which are marked with a * star sign are only available in the WSedit editor and not in the Hypermake editor.

.end
.2
Cursor movement

Take a look at your keyboard. Between the S and the D key, you have to imagine a central point (+). This is the geometrical center of all cursor movement keys:

..press Ctrl-OD to see the correct alignment
.sfM
  W   E   R
A   S + D   F
  Z   X   C
.sf

^S, ^D: Cursor left, right
^A, ^F: Word left, right
^E, ^X: Cursor up, down
^R, ^C: Page up, down
^W, ^Z: Scroll up, down

.2
Quick commands

.it Quick commands
By typing ^Q ("Quick") before some of the commands above, you will get a "strong" or "repeat" effect:

^QS, ^QD: Cursor to the begin, to the end of the line
^QE, ^QX: Cursor to top, end of window
^QR, ^QC: Cursor to the begin, end of the document

^QP: Cursor to the previous position

.2
Block commands

.it Block commands
In addition to the Windows-mouse selection of text with the mouse, this editor supports the Wordstar block commands. Blocks marked by Wordstar commands are not transient. The marking of the block disappears only if you delete the block (^KY) or if you hide the block (^KH). Marking a block by using the mouse will be transient: clicking into the text with the mouse will let go the block. Nevertheless, you can mix CUA commands (like Ctrl-Ins for "copy block into clipboard") with Wordstar Ctrl commands.

^KB: mark the beginning of the block
^KK or ^KE: mark the end of the block (Wordstar only ^KK)

^QB: jump "quick" to the beginning of the block
^QK: jump "quick" to the end of the block

^KC: copy the block to the cursor position
^KV: move the block to the cursor position

^KR: read file into block at the current cursor position
^KW: write block into file

^KY: delete block
^KH: hide/show block marking

^KM: running text to comment lines and reverse

.2
Delete text

.in delete
The deleting keys are located in the middle of the keyboard:

^G: delete character on cursor position (same as DEL)
^H: delete character left from cursor (same as BACKSPACE)
^T: delete word right from cursor
^Y: delete line
^QY: delete line right from cursor
^QT: delete right up to punctuation mark.

.2
The Trash Buffer

If you use ^T, ^Y, ^QY or ^QT for deleting, the deleted text part will be stored in a "#:trash buffer:". With ^U, you can paste the content of the trash buffer to the current cursor position. This is e.g. useful for changing the position of two words: ^T^F^U. The trash buffer is independent from the clipboard.

Multi trash buffer

You can use e.g. ^T "delete right word" and ^U "paste deleted word/line" several times and move e.g. several words or lines. But if you move the cursor between several ^T keypresses, the multi-undo is no more available. It also works with ^Y "delete line": you are able to move whole pararaphs by this way.

Sample:
one two five six three four seven

Place the cursor at the beginning of 'five'
press Ctrl-T Ctrl-T to delete two words
place the cursor at the beginning of 'seven'
press Ctrl-U Ctrl-U to eject the two words at the current cursor position

.2
Ctrl Key Overview

WSedit has only got the Wordstar keymapping, in the Hypermake, ME and Textbuch Editors you can choose between three different keymappings:

Keymapping CUA: none Wordstar commands
Keymapping Wordstar: Wordstar commands only
Keymapping mixed: Single-Ctrl commands CUA, double Ctrl commands Wordstar.

This list describes the common Wordstar commands which are available for all editors above. WSedit has got more Ctrl key commands, press Ctrl-J for the WSedit Ctrl Dialog.

Ctrl commands with only one letter, available with keycode Wordstar only

^A: cursor word left
^B: reformat paragraph
^C: page down
^D: cursor right
^E: cursor up
^F: cursor word left
^G: delete character on cursor position
^H: delete character left from cursor
^L: repeat last search or search/replace
^N: new line, cursor rests in old line
^R: page up
^S: cursor left
^T: delete word right from cursor
^U: paste deleted word/line to cursor position
^V: toggle insert/overwrite mode
^W: scroll down text in window
^X: cursor down
^Y: delete line
^Z: scroll up text in window

Ctrl-K: Block and File Menu

^KB: mark block begin
^KC: copy block to cursor position
^KD: save file and exit
^KE: mark block end
^KG: select all (global)
^KH: hide/restore block
^KI: move block right (normal spaces)
^KJ: block in uppercase letters
^KK: mark block end
^KL: mark line as block
^KN: column block mode on/off
^KQ: exit with query "save yes/no"
^KR: read block from file
^KS: save file
^KT: mark word
^KU: move block left (normal spaces)
^KV: move block to cursor position
^KW: write block to file
^KX: save file and exit
^KY: delete block
^KZ: block in lowercase letters
^K0: set bookmark 0 (up to 9 available)

Ctrl-Q: Quick Menu

^QA: Search/Replace Dialog
^QB: go to block begin
^QC: go to end of document
^QD: cursor to end of line
^QE: go to window top
^QF: Search Dialog
^QG: incremental search by title bar
^QJ: word in uppercase letters
^QK: go to block end
^QP: go to last cursor position
^QR: go to begin of document
^QS: cursor to begin of line
^QT: delete right from cursor until punctuation mark
^QV: go to old block position before ^KV
^QX: go to window bottom
^QY: delete from cursor to end of line
^QZ: word in downcase letters
^Q0: go to bookmark 0 (up to 9 available)

Ctrl-O: Screen Menu

^OE: enlarge editor font
^OR: reduce editor font
^OW: change Softreturn <-> Hardreturn
^OX: Cursor movement in emty areas yes/no

..Gened Ende
.2
Toggles and Special chars

.in toggle char
.in special char
You can enter the ASCII characters with the decimal numbers from 1 up to 26 by entering ^P, followed by a character key from A to Z. To get ASCII 1, enter ^PA, for ASCII 2 enter ^PB and so on.

There are a few exeptions:

To get an ASCII character 0 in Wordstar files (^P@), press ^PZ.
The ^Z character is not supported, of course. (Some editors interprete this character as "end of file".)
^M and ^J (decimal 13 and 10) is also omitted. These characters represents a Return in an ASCII text.

Write&Set and Wordstar use some of these characters as "toggles", that means they are used in pairs. E.g. ^PS turns underlining on and off.

Besides ^PZ (Wordstar ^P@), the corresponding character images of the IBM Codepage are shown, e.g. ^PB is a face, ^PS a double exclamation mark.

If WSedit was loaded with a Wordstar file, a new item "emphasize" appears in the menu bar. With this menu, you can insert toggles and special chars with the mouse. Marking a block before using this command let you insert toggle chars in pairs.

Only the editor itself accepts ^P commands. If you want to enter these ASCII charcters into an edit field of the search dialog or the search/replace dialog, you can choose one of the following possibilities:

use the ALT-(Number) commands
or put the ^P character from the editor into the clipboard and paste it to the editfield
or type the character ^, followed by a letter, e.g. ^B for the "bold" character
..the Hash sign is # (but it is used here for the index, so it can't be placed in text)
or type the hash (doublecross) sign, always followed by three digits representing the decimal ASCII value.

By default, WSedit provides syntax highlightning for the toggles

^PB bold
^PS underlined
^PT superscript
^PV subscript
^PY italic

but you can change this in the Highlt page of the settings notebook.

Since WSedit 1.00, Underlined, Bold and Italic can be shown Underlined, Bold and Italic instead of colored text. But some fonts have problems in showing these attributes. If your favourite font does not show these attributes or shows it in an horrible manner, you can turn back to colored normal font on the Settings notebook, Highlight page at the end of the left checkbox list.

.2
On-screen Formatting

.in formatting
^B reformats a paragraph on-screen. After some special commands, a line can exceed the window width. In this case, typing ^B will reformat the current paragraph.

If you edit an unformatted file, the text fits always the window width. Changing the window size will always reformat the whole file. You can also force reformatting the whole file by typing ^OF.

If you want to indent a paragraph, you can enter a TAB or ^OG at the beginning of the paragraph. The indention depends on the last ".TB" dot command.

.dp
.1
Dot commands

.in dot command
A dot command is part of normal text you type into the editor. A dot command is a complete line beginning with a dot, for example

.BD

If there's not a dot at the first column, the line will be printed and not interpretated.
.. (Here in the source text, I cannot begin with a dot because
..  I want to get these commands printed and not interpretated)

If you want to use WSedit as an ASCII editor, you can use dot commands nevertheless. In the "File - Export" function, there's a dot command filter.

Dot commands aren't case sensitive. Some dot commands require parameters, for example

.TB10

will set a tabulator stop at column 10. You can leave a space between the dot command and the parameter.

A very useful dot command is a line beginning with a double dot:

..don't forget to add this and this!

This is a comment line which won't be printed. In the "File - Export" function, you can choose whether to export comment lines or not.

With Ctrl-KM, you can toggle a block content from comment line to normal text and reverse.

.2
unformatted files

In comparison to WSformat and Hypermake, WSedit (#unformatted) interpretes only a few dot commands:

.ic
 .TB 5,7,10,#25,30

With ".TB" (a Wordstar 5 command), you can set the tabulator stops: You can let jump the cursor to the next tabulator stop by typing TAB or ^OG; up to the tabulator stop, "snow characters" are automatically inserted. The default setting is ".TB4". With "File - Export", snow characters are converted to spaces or ASCII tab characters.

The Hash character # tells WSedit that the number relates to the last character in the column. That means the column gets right-orientated. Wordstar also knows the # character, but in Wordstar, the number describes the position of the dot separator of a number and not the last character.

.ic#
You can change the ".TB" value and then type Ctrl-B on the lines which you want to have modified. Ctrl-B is a on-screen formatting command which uses the tab stops of the last ".TB" command.

 .BE   (enabling word wrap)
 .BD   (disable word wrap) (or .BA)

Normally, word wrap is on. In tables, it can be necessary to turn off and on word wrap functionality. You can do it by typing the commands ".BE" word wrap enabled and ".BD" word wrap disabled.

Because WSedit cannot handle lines larger than 255 chars, ".BA" sets the right margin to 250, and this will have (nearly) the effect of turning word wrap off. The same fact is with the "Word wrap" on menu item when handling normal text files.

A .BD command in the very first line will be ignored by WSedit, (but not by WSformat).

 .RM 60

The Wordstar Right Margin command is interpreted while writing an unformatted WS file to disk. By default, a WS file created by WSedit will have set the right margin to 78, so you can read the WS file with a DOS Wordstar without problems. On the WSedit screen, you won't see an effect of ".RM".

.2
formatted files

If you don't use Write&Set or Wordstar (DOS) and use WSedit stand-alone, you won't need to work with formatted files. "WSedit (formatted)" means using WSedit together with files with extension ".FMT" instead of ".WS" or ".TXT". FMT files are automatically created by WSformat.

WSedit (#formatted) shows the page breaks like Wordstar does it. For counting lines and pages, only four commands are interpreted:

 .PL  (Page length)
 .MT  (Margin Top)
 .MB  (Margin Bottom)
 .LH  (Line Height)

Since WSedit/WSformat 0.99, additional Line Height commands are interpretated which are no more compatible to Wordstar (DOS):

 .SH (Soft Height) line height within a paragraph
 .HH (Hard Height) line height between two paragraphs
 .EH (Empty Height) line height of empty lines.

Instead of showing a page break line, WSedit (formatted) shows the page break by highlightning the background, dependend on the "Highlightning" settings in the Highlt Page of the settings notebook.

In formatted files, automatic word wrapping is disabled. This is defined on the "wrap" page of the settings notebook.

In formatted files, you can jump to a specific page with the "page dialog" ^QI.

.1
Special Functionality

.2
Contents window

.ID P_CONTENT
The #:contents window: is activated by entering ^OC or ^OI. You enter a #heading in your text by using the dot commands

 .1
 This is a level-1 heading
 .2
 This is a level-2 heading
 .3
 This is a level-3 heading
 .3
 This is also a level-3 heading

In the printed document and in the contents window, you will get a structure like

 1. This is a level-1 heading
 1.1 This is a level-2 heading
 1.1.1 This is a level-3 heading
 1.1.2 This is also a level-3 heading

If you use "File - Export", the dot command will be interpreted and converted e.g. to "1.1.2".

WSformat and Hypermake are based on this heading syntax.

Wordstar dot commands ".i1", ".i2" are automatically converted when loading a WS file.

If the contents window is open, you can double click to a line and you will get to the editor position where the corresponding heading is located.

If you press ^OC, the contents window will be simply opened. When typing ^OI, in addition the heading will be marked where the editor cursor is currently located. (In WSedit for OS/2, you have to scroll sometimes to see the marked heading line.)

There are some buttons at the bottom of the window:

expand and collapse the function tree
refresh: the contents window and the go-to information for double-clicking to the heading lines will be actualized. If you double click and get to a wrong editor position, use "refresh".
>clip: copies the text of the selected heading into the clipboard
>clip all: writes the complete current contents into the clipboard
digit in editfield: represents the heading level which is written into the clipboard. If you enter "3", the heading levels 1, 2 and 3 are written when using >clip all.

.2
Spell checking

In WSedit, there is a simple but effective #:spell checking: function implemented.

.3
How to get a dictionary

To use the spell checking function, you have to create a #dictionary by yourself or you can visit http://www.WriteAndSet.com and download the current dictionary collected by WSedit users.

All spell checking functionality is available from the Menu, item "spell checking".

You can enter a filename for the dictionary in the Dict Page of the settings notebook. If you don't enter a directory, the spell checking file has to be located at the same directory where WSedit.exe resides.

If you want to create a dictionary by yourself, you need to have existing Wordstar or ASCII files which are already spell-checked or where you can be sure that there are no incorrect words: Load the file into WSedit and choose "spell checking - absorb current file to dictionary".

If you have received another WSedit dictionary file from a friend or from the Internet, you can merge this file with "your" dictionary file by using "import external directory".

The principle of the WSedit dictionary is quite simple: If a word has to be absorbed, the endings

(english) es 's s ions ion ings ing
(german) es e 's s en em n

are cutted and the first character is converted to lower-case. Then it is compared to the contents of the dictionary. If no similar entry is found, it is placed into the dictionary.

The dictionary file is a normal ASCII file in IBM codepage. The words are sorted by an internal sort algorithm, not by the alphabet. You can add manually words at any position.

.3
Working with the spell checking function

You can turn on and off spell checking by entering ^QL. The background of unknown words is getting red. There's no spell checking dialog window. You simply press ^QO, and WSedit learns all words from the beginning of the file up to the line of the editor cursor. Some marking of words below the cursor will automatically disappear. To go to the next marked (wrong) word, you can simply type ^L. (If spell checking is disabled, ^L is the command for "search/replace text again".)

If you find an incorrect word which is not highlighted and in consequence the wrong word is part of the dictionary, you can correct your dictionary by moving the mouse over the wrong word and choosing "remove single word from dictionary" in the popup menu.

.2
Function key macros

.ID P_MACRO
.in macro
Perhaps you have noticed that you won't find "press F7 to get this and this" in the WSedit documentation. #:Function keys: are not defined in WSedit, besides some function keys used by the operating system (F1 for help, F10 for system menu, this depends on your operating system). All other function keys can be defined by the user.

.3
Storing macros

Press ESC to get the "function key macros" window. There are four listboxes: FX, Shift-FX, Ctrl-FX and ALT-FX. Combinated keys like Shift-Ctrl-F7 are not supported, but 4x12=48 macro definitions should be sufficient!

Clicking to a function key name like "F4=" will show a window where you can record and play macros like a music tape.

The macro commands are saved in separate files in a new directory F-MACROS located in the directory where WSEDIT.EXE resides. You can copy the files located in the F-MACROS directory and send it to another WSedit user. The name of the macro file shows the key, e.g. SHIFT-F5.DTA. (When german language is set, the file name will also be "SHIFT.." or "CTRL..").

You can change the allocated key of a macro by renaming the file and reopening the function keys window.

.3
Recording macros

The function key macro recorder records only keystrokes, with some exceptions. So don't use the Menu, don't use the Ctrl menu. Instead, type the key commands.

It is allowed to use the dialog windows

^QF find dialog
^QA search/replace dialog
^KR read block from file
^KW write block to file.

If you play the macro, the dialog window won't appear. The information which was produced by the dialog is stored directly in the macro. So you can write a macro "write block to the file TEMP1.WS". While recording, the usage inside the dialog makes no difference. You can click to the filenname or type it.

It can happen that some specific function keys do not work at all. These function keys are defined by your Operating System and are not available (e.g. Alt-F4 for closing a window).

.2
Read only files, Workgroups

If you are a single-worker, this chapter won't be interested for you.

.in workgroup
If serveral persons work with the same text files, you will normally get a problem. Some editors like DOS Wordstar do not allow two programs (or users) to read a file. So you won't have a problem by overwriting a file, but on the other hand reading a file simultaneously won't be possible. Others allow reading and writing, but if two persons have opened the text file simultaneously, only the changes of the person who saved the file at last are written to the file.

The WSedit workgroup functionality is enabled by checking when opening, set file to read only (for workgroups) on the Save Page in the settings notebook (^OO).

WSedit sets the #:read-only flag: of the text file if a user opens the file. The first user has got #:write-access:. All users who open the file later won't have write-access, but they can read the file. To remember that writing is not possible, the background is gray instead of white or blue and in the title bar "READ ONLY" appears.

After the user which had got write-access leaves the file, the WSedit program of the other ("read-only") user catches automatically the write-access and the window background turns to white (or blue).

If the user with write-access saves the file, the other users will get automatically an actualized file content.

In the Menu, you will find a command "File - let go write access". Here you can give your write-access to the other user - your WSedit switches to read-only.

To simulate a dual-user mode, open one text file twice by starting WSedit two times.

If the workgroup functionality is enabled, the text file which is opened by WSedit is set to read-only. If WSedit crashes (what we won't hope!), the text file will rest in read-only state. To turn on or off the read-only workgroup feature, open the settings notebook of the text file icon (right mouse button, properties) and activate/deactivate the "read only" checkbox.

.2
Backup functionality

WSedit supports two kinds of backup functionality which can be set in the Save Page of the settings notebook.

With a specific time delay, WSedit saves the content of the editor into an ASCII file (even the current file is in WS format). The name of the file is always the same. It is located in the directory where the text file resides.

WSedit writes the text to the #backup file every e.g. 3 minutes, but waits for a moment where for e.g. 5 seconds no character key was pressed.

In addition, you can let rename the old text file to *.BAK when the file is saved by the user.

.2
Translation

.ID P_TRANSLATION
WSedit supports two kinds of translation: #:Bubble Translation; and #:Dialog Translation;. Normally you will use Bubble Translation when reading a text in a foreign language and Dialog Translation when writing a text in a foreign language.

To use translation functionality, you have to download the translation dictionary files from http://www.WriteAndSet.com (yet only German to English and English to German). Then copy the two files to the location where WSedit.exe resides and fill out the settings notebook Dict Page.

Bubble Translation: After typing ^OT, words or expressions at the mouse position are translated and the result is shown in a yellow bubble help window.

Dialog Translation: ^OV activates a dialog where you can enter the expression into the edit field. In the Listbox below, several possible translations are shown. If Bubble Translation is also activated, these several possible translations are re-translated in parenthesis so it will be easier to select the correct translation.

The re-translation has the effect of a Thesaurus: a single expression translated to another language and re-translated back will show 10 or 20 slightly different expressions.

Double clicking to a listbox item or single clicking and pressing OK copies the translated expression into the Trash buffer. It can be copied to the cursor position by typing ^U.

.2
File export/import, Clipboard

.ID P_FILEEXPORT
File - import TXT is only available if a WS (Wordstar) or Write&Set TXT file has been loaded; The menu item File - export TXT/HTML is also available when running normal text files. When selecting File - export, you will get a file dialog where you can select between the file types TXT and HTML. With TXT, you will get a second dialog window where you can change some detail behaviour when converting WS or W&S specific commands like toggles, dot commands and special characters to pure ASCII text. The "snow char" setting is obsolete if you have got a normal text file.

If a block is currently selected, only the block gets converted, otherwise the whole text.

When selecting HTML, you don't get a second dialog window. The HTML converion is quite simple. Toggles for bold, underline and italic, "umlauts" and other special characters are converted and chapter headings are enumerated and converted to default HTML style.

To insert other HTML commands to the generated HTML file, you are allowed to place these commands into WS and W&S comment lines:

  ..<HTML command> <HTML command>

It is necessary that the < character (begin of HTML command) follows the two dots directly, othwerwise the whole line gets ignored.
Sample:

 ..<a href="##A"> A </a>
 ..<a href="##B"> B </a>
 ..<a href="##C"> C </a>
 My addressbook
 ..<a name="A"></a>
 Aaron, Telephone: 555-555555
 ..<a name="B"></a>

The HTML file will begin with a link list A, B, C. Use this commands to get your text-based address list to an HTML file, e.g. for your HTML-enabled mobile phone.

For more sophisticated HTML files, please use Hypermake (www.hypermake.com).

WSedit Clipboard

.in Clipboard
If you copy text from WSedit into the Clipboard (press Ctrl-Ins), WSedit copies the markded text to the clipboard three times and the corresponding program decides which format to use:

W&S/WS format: for exchange between two instances of WSedit (or Hypermake); dot commands and special characters are also moved
TXT format: Only text gets moved, dot commands and special characters are filtered
RTF format: for interchanging text between WSedit and Windows wordprocessors like MS Word.

With RTF clipboard export, you can transfer not only simple text to arbitrary Windows wordprocessors like Word. Also all relevant printer characters (^B, ^S, ^Y, ^T,  ^V, ^K, ^@) are converted and every kind of indention (via soft spaces) is transferred correctly; even tables with soft spaces are working. But dot commands are not converted, only .TS Tab stretch is interpretated.

RTF clipboard support is only supported in the export direction (from WSedit to another application).

.2
Double-click for accessing WSformat

.ID P_DOUBLECLICK
If WSformat is already running, double-clicking into WSedit activates a specific WSformat functionality. The double-click is context-sensitive, which means the result differs dependendent on the context of the mouse position. But remember that WSformat has to run and the current WS file should be selected in WSformat. If WSformat does not run, you can execute it from WSedit by selecting the menu item "File - Save+WSformat" or pressing ^KF.

Double-clicking into normal text opens a second WSedit window with the corresponding formatted or unformatted file, and the cursor jumps to the same location, which means you can easily switch between the unformatted (WS) and the formatted (FMT) file.

Double-clicking into a font dot command activates a small font sample window. Double-clicking again activates the WSformat dot command window, and a third double-click activates the font sample window again and so on.

Double-clicking into a dot command activates the WSformat dot command window, with the current dot command selected.

Double-clicking into the filename parameter of dot command ".BM" (Bitmap/Graphics dot command) opens the WSformat graphics dialog and shows you the current graphic file. Another way to have access to the WSformat graphics dialog is to select Edit - Paste in WSedit and the clipboard contains a graphic and not text.

Double-clicking into the filename parameter of dot command ".FI" (File) opens another WSedit instance containing the text file behind the ".FI" command.

Some of the mentioned WSformat functions do also work in the other direction (from WSformat to WSedit). For example, if you run the graphics dialog by double-clicking to the ".BM" parameter in WSedit and you change the filename of the bitmap in the graphics dialog, the ".BM" line in WSedit gets updated automatically.

.2
Command line arguments

.in Command line arguments
To start WSedit together with a text file from the commandline, simply type:

C:\> WSEDIT Textfilename

If you want to copy a file into the clipboard without executing the editor, type

C:\> WSEDIT /clip Filename.ws

Opening a text file with specific Codepages

WS (Wordstar) files are always in IBM (OEM/DOS) codepage. But the codepage of TXT files depends on the operating system. WSedit for OS/2 uses the IBM codepage and WSedit for Windows the Windows (Ansi) codepage. If you want to open a text file with the non-default codepage, you can use the /WIN and /IBM parameters:

C:\WINDOWS> WSEDIT /IBM Filename.txt

[C:\OS2] WSEDIT /WIN Filename.txt

WSedit for Windows has got access to both IBM and WIN codepage fonts. WSedit for OS/2 only knows the IBM codepage and the text will be converted while loading and saving the file.

This functionality is not available via menu commands.

Opening a file with an explicit file type

If you have got a file where WSedit cannot recognize the file type via file extension, you can explicitly enter the file type:

C:\> wsedit /.ws Filename.xxx

This functionality is not available via menu commands.

Principally, the order of the commandline parameters makes no difference.

.wa verti 25
.1
Settings Notebook

.ID P_NOTEBOOK
.2
General

.ID P_GENERAL
WSedit has got a settings notebook: select "Window - WSedit settings" or press Ctrl-OO. The information is stored in the binary WSEDIT.DTA file which is located in the same directory where WSEDIT.EXE resides. WSEDIT.DTA is read when WSedit is started and it is written when you exit WSedit. If several WSedit windows are opened, the last window overwrites the settings of the other programs. So if you want to make changes, make sure that only one WSedit is running.

The contents of the settings notebook is dependent on the file extension. It is possible to store entries for up to 20 different file types.

There are also some other settings stored in the WSEDIT.DTA file dependent on the file type which are not part of the settings notebook, e.g. window size and the selected font.

You can enter a new file type by pressing the "New" button outside the notebook itself. The entry field near the "New" button gets empty and you can enter a new file extension. You are allowed to enter more than one file extension for one file type, separated by colon and without spaces, e.g.

HTM,HTML

If you define a new file type, the notebook entries of the type which was active before pressing "New" rest in the notebook. So choose the file type with the closest settings before pressing "New".

.dp#2
.2
File Page

.ID P_FILEFORMAT
In the settings notebook, page File, you can define the text file type Wordstar / ASCII and "with word wrap", "no word wrap" for arbitrary file name extensions. These file name extensions do occur in the dropdown box of the File - Open dialog.

ASCII Codepages

The codepage of the ASCII file depends on your operating system: OS/2 and eCS uses IBM (DOS) codepage, Windows and Linux ISO codepage. But Wordstar file format has always IBM (DOS) codepage.

If you want to save or read a file in the not default codepage, then use the file - import/export function in the menu of WSedit.

Wordstar format

"Unformatted" shows Wordstar/Write&Set files like in an ASCII Editor with word wrap on; saving an "unformatted Wordstar file" will create a right margin of 78, so the file will fit the screen of a DOS Wordstar with its 80 column window. While saving a file, "Wordstar formatted" stores the formatting of the text (the position of the Soft Returns, the hyphenation), "WordStar unformatted" will destroy all Soft Return and hyphenation information!

If you reformat a "Wordstar formatted" file, WSedit fetches the right margin value from the last ".RM" (right margin) dot command.

In Wordstar 5, 6 and 7, the data format differs from Wordstar 3.4 and 4. WSedit reads Wordstar 3.4 up to 7, but writes always Wordstar 4 format (which can be read by Wordstar 5, 6, 7 without problems). But it is possible that some formatting information gets lost. Footnotes/endenotes gets converted to Write&Set/Hypermake format.

Distinguish WS tabs is only relevant if you have got Wordstar (DOS) files. Wordstar knows two different tabulators: the ^I and the ^OG tab keys. If you check this box, the ^I tabs are converted to normal spaces, otherwise they are converted to snow chars.

Mixed snow chars in WS5-7 should not be set if you often read WS5-7 files. If soft spaces (snow characters) gets swallowed while reading an original Wordstar file, you should activate this setting.

Default checkboxes

The two "Default..." checkboxes can be checked only by one file type.

.2
Wrap Page

.ID P_WRAP
The Wrap Page has got a great influence to the "feeling" of WSedit. If the file type supports word wrapping (see "file" page), you can choose the personal behaviour of wrapping text:

with time delay is my personal favourite setting. If enabled, you can select a delay time which omits a continious reformatting while typing text. I prefer 0 quarter seconds.

after every keypress is the behaviour of most word wrap editors. Because of the need of reformatting a big paragraph after every keypress, the amount of processor time becomes noticeable on slow computers. If you type very fast and your computer is not fast, this setting is not recommended.

only by hand (^B) is the classic old DOS Wordstar behaviour. A lot of people get confused if the text is reformatted automatically while writing. Ctrl-B reformats the paragraph from the cursor to the end of the paragraph. In any case, the paragraph is reformatted if the cursor exceeds the line.

not at all deactivates reformatting. Soft Returns are handled like Hard Returns. Even ^B has no effect.

The Cursor left/right checkbox influences the behaviour of cursor movement. If disabled, the behaviour is like in a programmers editor: you can reach every point of the screen by using the cursor. If enabled, the cursor follows the text. Where there is no text, you have to fill the line with spaces to reach a position where no text is written yet (or simply use the mouse). The behaviour does remember to the ^OX Wordstar command, but it's not the same. Anyway, you can toggle this behaviour by typing ^OX.

.it horizontal scrollbar
The horizontal scrollbar can be shown or omitted. Dependent on formatting on/off shows/omits the horizontal scrollbar, dependent on the local text: between .BE and .BD dot commands (enable/disable formatting), the scrollbar is shown, otherwise not. Permanently off omits the horizontal scrollbar permanently, Permanently on always shows it. But if the file type is Wordstar formatted, it is shown anyway.

.2
Save Page

.ID P_SAVE
The "Save" Page is related on opening, saving and write access.

Starting WSedit without parameter influences the behaviour when starting WSedit without opening a file at the beginning. You can get a file dialog at the beginning or you get an empty editor field with the filename Newtext1, Newtext2, Newtext3 (up to 9). These files are located where WSedit.exe resides.

When opening, set file to read only is the read only workgroup functionality of WSedit. This helps you sharing text files with your collegues in the network where several people have got access to a text file: the user which opens the file first has got write access, the others have got only read access.

Refresh WSedit if file was written by an external editor is useful for files which are created by another program and are read in WSedit. Every 1,5 seconds, WSedit compares the file date with the date where the file has been read the last time. If the date has changed, WSedit automatically reads the actualized file. If you have changed the text file in the editor, WSedit asks whether to loose changes or not.

Do not write Soft Returns in WS files does not write Soft Returns into WS files when saving a file. If you choose this selection, you will loose Wordstar (DOS) compatibility. (To be more precise, you can read this files with Wordstar DOS, but you need to reformat the text to see the whole text.) The advantage of this setting is that tables won't get corrupted even you haven't turned off formatting (.BA).

If close, save without querying
If checked, closing the WSedit window by clicking the Close button in the title bar will automatically save the text file without question.

There are two independent Backup functionalities.

Backup helps you to restore a file if your computer or WSedit crashes. WSedit writes the text e.g. every 3 minutes to a TXT file (even Wordstar format is used; use the clipboard to copy the text back). The file is  located in the directory where your current text file resides. You can change the name of the file. If you have got several WSedit files open where the text files shares the same directory, all editors uses the same backup file. (I assume this is not relevant in practice.)

Create *.BAK files renames the old text file to *.BAK when the file is saved again.
.if IPF
If you use OS/2 or eCS and start WSedit by double clicking the text file icon, I cannot recommend this setting. The text file icons shows the gray open background after WSedit is closed; this is caused by the object structure of the WPS which is independent from the file names.
.end

.2
Feeling Page

.ID P_FEELING
The "Feeling" Page of the settings notebook relates to settings which let you adapt the behaviour of WSedit to Wordstar (DOS) or to current editors like Windows Notepad, OS/2 System Editor or Windows wordprocessors like Word. If you enable all settings, you get the feeling of Wordstar (DOS), and if you disable them all, you'll get the feeling of current Windows editors. All these settings are very subjective and depend on your individual preferences.

Here some explanations:

Begin text selection only if mouse does not move is independent of the Wordstar/Windows feeling settings neither exists on Wordstar nor on Windows editors. If you unintended mark a block when selecting the text cursor position with the mouse, because the mouse gets little moved while clicking the mouse button, turn this setting on.

Ctrl-KC  block marker remains at source
relates to Wordstar block functionality Ctrl-KC "copy block to current cursor position" and is only accessible with "Wordstar" and "mixed" keymapping. If you do not use Wordstar keys, this setting is not relevant.

Only Ctrl-Del deletes transient block, not Del alone
The backspace key is treated similar.

Take word under cursor for default value in search/replace dialog
copies the word at the current cursor position to the "Find" edit field in the search or in the search/replace dialog. This behavoiour is more typical for non-wordprocessing usage.

Cursor word right/left orientate to spaces instead of characters
influences the behaviour of the "cursor word right/left" buttons Ctrl-Cursor left/right (Wordstar commands Ctrl-F and Ctrl-A). The difference gets visible when the cursors jumps over characters which are no letters like punctuation marks or parenthesis.

.2
Dict Page

.ID P_DICT
For the spell checking function (^QL), you can enter a file name of the dictionary. It has to be in WSedit/Hypermake format. Before a word is compared with the words in the dictionary, the ending of the word is cutted. You can define other endings if you use WSedit in another language.

WSedit supports two different kinds of translation functionality: Bubble Translation (^OT) and Dialog Translation (^OV).

If you don't enter a full pathname, the two translation dictionary files are searched in the directory where WSEDIT.EXE resides.

Both spell checking and translation files can be downloaded from http://www.WriteAndSet.com

.2
Misc Page

.ID P_MISC
The miscellanneous page holds all settings which are not part of the other topics.

WSformat-related bubble help let you turn on and off bubble help for dot commands which is shown in the WSedit editor, but generated by WSformat. This also affects the font sample window when moving the mouse cursor over font dot commands.

max Undo steps influences the behaviour of the Undo slider. If you choose a high value (e.g. 10000), a slow motion of the slider will redo a lot of events, so it can get less practicable. If you choose a low value (e.g. 100), the undo functionality will be too limited.

delete word right from cursor (^T) influences the behaviour of the ^T command. The middle setting is the same as in Wordstar DOS, auto correct spaces is a self-made further development improving changing the position of two words where one word is located near a dot or a comma, but sometimes it shows a not Wordstar-like behaviour.

Ctrl Menu time delay defines the time from pressing e.g. ^K and activating the Ctrl Menu. Experienced users know the commands, and between the first and the second key of the double-key commands like ^KB (mark beginning of block) there's only a close moment. But if the user hesitates, the Ctrl Menu should appear. The time value depends on your knowledge of Wordstar commands and your key typing speed.

.in Mouse Wheel
Mouse wheel sensivity modifies the effect of the mouse wheel movement. 1 means small scroll effect and 10 strong scroll effect. If your mouse doesn't have a mouse wheel, this setting is not interesting for you.

.if IPF
On the OS/2 platform, you need the AMouse mouse driver. WSedit can change the mouse wheel sensivity if you have installed AMouse 2.7 or later. (In this case, mouse wheel events are interpretated directly by WSedit, while in former AMouse versions the mouse driver converts the mouse wheel events into scroll events.) The current AMouse driver requires OS/2 Version 4.5 (Warp 4 with Fixpack 13 or later).

Homepage of AMouse: http://www.nbsoftware.de
.endif

Cursor highlightning when editor idle
If you don't use the editor for a while, it can be visually difficult to detect the cursor position again. WSedit shows a lightblue cross after a while. Enable this setting and enter a smaller time, if you have got problems in detecting the cursor. After every keystroke or mouse click, the counter controlling the appearance the cursor highlightning restarts. Typing the CTRL key without another key forces the highlighted cursor immidiately.

.2
Highlt Page

.ID P_HIGHLT
The usage of #Highlightning depends on the used file type. E.g. in Write&Set/Wordstar/Hypermake files, dot commands and printer characters are shown highlighted. The left checkbox window (double clicking and not single-clicking changes the checkbox state), the Wordstar, Hypermake and Write&Set syntax is supported. On the right window, you can enable and disable HTML syntax. Do you miss other highlightning functionality?

Independent from the syntax of the text you write, one highlightning feature is useful anyway: the checkbox rightmost column shows type of line (outside the listboxes) let you distinguish Soft Return lines from Hard Return lines. This is very useful if you use the word wrapping functionality. Lightblue shows Soft Return lines, darkgreen shows Hard Return lines.

Note that two different Color settings are accessible for the whole editor (press ^OM).

The Syntax highlightning enabled checkbox disables all highlightning functionality in the two listboxes. The Softreturn / Hardreturn (rightmost column shows type of line) function is independent from this main checkbox setting.

The first two Wordstar highlightning functions (Toggles, Highlightning toggles) are dependent on the Toggle characters defined below (toggle chars). The toggles itself are shown red and between two toggle characters, the text is shown blue. You can also define special characters which are simply shown colored (special chars). If you enter normal letters here, the function is related to the corresponding Ctrl key, e.g. to enter ^B (Wordstar bold print), simply enter a B capital letter.

If you use nested IF conditions, it is highly recommended to turn on the If cond. level background setting. It highlights the background dependent on the nested if conditions level and helps you to remember closing the if condition (.IF) with an end command (.END). WSformat and Hypermake do support if conditions. Alternatively to the "if level highlightning", you can open the "if condition dialog" (^OK) and select "if conditions". The non-acitvated text background turns to gray color.

Since WSedit 0.99d, Underlined, Bold and Italic can be shown Underlined, Bold and Italic instead of colored text. But some fonts have problems in showing these attributes. If your favourite font does not show these attributes or shows it in an horrible manner, you can turn back to colored normal font at the end of the left checkbox list.

The command Ctrl-OD hides the printer characters, a second Ctrl-OD shows them again. You can edit the text while the printer chars are not shown. But they rest at the same place, so it is better to make only few changes while the printer characters are not visible.

.2
WS page

.ID P_WS
The "WS" page does not hold separately data for each file type. It stores settings related to Wordstar/Write&Set file format and about the WSformat program.

The dot command default groupbox stores the dot command default values which are necessary to calulate the page breaks in files with file type "Wordstar formatted". These values should be identical to the default values in the WSformat settings notebook, page "Layout". Otherwise, the page breaks shown in WSedit and previewed/printed by WSformat are not the same.

Full filename of WSformat executable: If you want to use the ^KF command "Save file and run WSformat", WSedit has to know the filename of WSformat.

.dp
.wa hori 35
.1
About WSedit

.ID P_ABOUT
.2
Freeware - Disclaimer

WSedit is #Freeware. You are allowed to distribute this program on Freeware/Shareware CD's, to place it on Internet Servers, to bundle it with new Computers and so on. But all rights to the program remain with the author.

WSedit is provided as is and comes with no warranty of any kind, either expressed or implied. In no event will the author be liable for any damages resulting from the use of this software.

The full featured Wordprocessing suite Write&Set containing both WSedit and WSformat is Freeware for documents with less than 10 pages and otherwise Shareware.

.2
Why did I write WSedit?

I had got different reasons for writing WSedit.

I do a lot of word processing and I like Wordstar. But today, a DOS program is no more acceptable. And I missed some functionality in Wordstar.

For my Shareware program Hypermake, I need a powerful integrated editor. It is much more efficient to develop the editor as a separate project. Hypermake and WSedit shares a lot of program code. Fixing a bug in WSedit will fix the same bug in the Hypermake editor and reverse.

The majority of editor code was already available in the program developing environment I use. So the amount of work was not as much as it looks like. The WSedit project is based on a programmers editor without wordwrap functionality which is part of the cross-platform Pascal developing environment "Sibyl".

WSedit is an important part of the wordprocessing suite Write&Set. I think it is necessary to offer a non Winword-like wordprocessing software which is not "Tex". Too much users are frustrated with Winword and Winword-like programs.

.2
How this program help file has been created

#Hypermake is a hypertext compiler which compiles Write&Set (Wordstar 4) files or ASCII files with dot commands and toggles to HTML, Winhelp, MS HTML-Help or IBM Help. The source of this help file is a WS file with dot commands which can be formatted and printed with Write&Set. You will find this source file in the Write&Set archiv file, subdirectory DOCUSRC.

Hypermake has got a lot of dot commands similar to Write&Set, many are the same. The commands for fonts, footnotes, line drawing, headings, index are identical! Since Hypermake 4.1, Hypermake directly supports the Write&Set/Wordstar WS file format, also in the Hypermake editor which which shares a lot of code with the WSedit editor.

Please visit http://www.WriteAndSet.com
http://www.hypermake.com

.2
Bugs and Versions

.in bugs
.in versions
New functionality/improvements in WSedit 0.99k:

Line drawing with cursor keys (IBM codepage only): Simply press Ctrl-Alt-Cursor keys for single lines and Shift-Alt-Cursor keys for double lines. Edge characters are calculated automatically.

Bugs fixed in WSedit 0.99k:

Malfunction with block operations within indented paragraphs (snow characters)
program hangs when using "Undo" after text insertion (paste from clipboard, Ctrl-KC, Ctrl-KV)


New functionality/improvements in WSedit 0.99h:

.ic
(0.99h1) Ctrl-OJ "generate character map" generates an ASCII table in comment lines
Ctrl-OD "show printer chars": without printer chars text an be edited now (restricted, because printer chars remain on previous position)
Ctrl-B and Ctrl-OG indention gets calculated correctly when using with printer chars
Ctrl-QA "search/replace" affects only running text and not dot commands. New command Ctrl-QN affects dot dommands only
Tab key in overwrite mode jumps to tabulator positions
right-orientated columns with ".tb#10,#20", while the numbers behind ".tb" relates to the last character in the column
undo/redo keycode is now Ctrl-Backspace (Alt-Backspace still works, but forces a system beep in Windows)
"File - New Window" did not work (Windows version only)
Ctrl-U "paste trash buffer" created an additional single space (Windows version only)
and a lot of minor bugfixes, not worth to mention.

.ic#
New functionality/improvements in WSedit 0.99g:

Extended screen font handling
DOC files which are saved by StarOffice/OpenOffice get open properly
new heap management increases max. text file size from 20 to 300 MB
(Windows version) adaption to Vista (especially HTML-Help; Winhelp support gets continued)
minor improvements and bugfixes.

New functionality/improvements in WSedit 0.99f:

New highlight functionality: highlightning the background dependent on the nested if conditions level (new checkbox in settings notebook, page Highlight)
New dialog window "choosing if conditions" ^OK (impacts the text background color, the content window and the command "calc number of chars" ^OZ).
Improved reading of MS DOC files.
Improved Support (Import/Export, Highlightning) of Write&Set TXT format
Syntax Highlightning for E-Mail (Quotes)
File - Export RTF (Rich Text Format)

New functionality/improvements in WSedit 0.99e:

Ctrl commands are accepted now while pressing Shift or Capslock
horizontal scrollbar appears/disappears depenending on formatting state (.BE, .BD)
"Page Down" improved: it was not possible to get an nearly empty screen at the end of the document
File-Open, File-Save dialog window is sizeable now
Find Dialog and Replace Dialog history dropdown-box now implemented (but it remembers only the entries of the current session)
Now the feeling settings are general and not dependent on the file extension. New settings on the "feeling" page of the settings notebook:
Ctrl-KC block marker remains at source
Only Ctrl-Del deletes block, not Del alone
Interchange cursor shape for overwite/insert mode.

Bugs fixed in WSedit 0.99e:

(Windows) bug fixed drag and drop text (right mouse button!)
redraw problems with italic font fixed
when creating BAK files, casually crash fixed
remember foreground/background color bugs fixed
some DOC files were not imported
Bug in Move Column Block fixed
Bugs in showing page breaks fixed (casually different results when scrolling or PgDn; sometimes page breaks were not identical with Wordstar and WSformat)

New functionality/improvements in WSedit 0.99d:

"Feeling" page in the settings notebook
Locate String Window (Ctrl-OF)
(WS/W&S text format) underlined/italic/bold text (printer character ^S, ^Y, ^B) is shown underlined/italic/bold

0.99d is an important bugfix, a lot of minor bugs were fixed (some of them forced a termination).

New functionality/improvements in WSedit 0.99c:

WSedit does not only distinguish anymore between Softreturns and Hardreturns. The new "Breakreturn" (gray color at the rightmost column) shows that a line without spaces has been broken to show it at the next line. This can be necessary in technical text files where lines do not contain spaces (e.g. PATH= statement in CONFIG.SYS of OS/2 or DOS). To create a Breakreturn, continously type a character without spaces.
The Wordstar 7 import functionality has been improved; two bugs concerning soft spaces are fixed.
In addition to TXT file format, File - Export also supports basic HTML export (codepage, underlined, bold, italic, headings)
reading Microsoft DOC files in read-only mode; only text is converted, no formatting
A lot of minor improvements, not worth to mention. E.g. when marking a block with the mouse and you run outside the window while marking, the scrolling speed relates to the distance of the mouse position to the window margin. Improved drag and drop functionality.

New functionality/improvements in WSedit 0.99b:

"File - New" menu item
Full "Write&Set TXT format" support which was yet only implemented in WSformat. "Write&Set TXT" is a new file format which exists both in IBM ASCII and Windows ASCII format and is helpful if someone wants to edit a Write&Set unformatted file with an arbitrary editor.
RTF clipboard export: You can transfer not only simple text to arbitrary Windows wordprocessors like Word. Also all relevant printer characters (^B, ^S, ^Y, ^T,  ^V, ^K, ^@) are converted and every kind of indention (via soft spaces) is transferred correctly; even tables with soft spaces are working. Dot commands are not converted (only .TS Tab stretch is interpretated)
/IBM /WIN commandline parameter for opening a TXT file with IBM codepage on the Windows platform  and a TXT file with Windows (ANSI) codepage on the OS/2 platform
/.XXX commandline parameter for explicit selection of a file type if WSedit cannot derive the file type from the filename extension.

New functionality/improvements in WSedit 0.99:

Ctrl-QP (quick to last position) was missing. Now implemented.
Different window title text, dependent on having focus or not (to get useful information in the Windows taskbar)
Wheel mouse support for Windows
full Drag and Drop in the Windows version (but with the right, not the left mouse button!)
better screen font support: all available fixed fonts can be selected and are stored in the text file "edifonts.ini"
Support of the "Write&Set TXT format" in File - Import, File - Export

Fixed Bugs in 0.99: a few, not worth to mention

New functionality/improvements in WSedit 0.98:

Better clipboard support. WSedit distinguishes now between Wordstar/Write&Set clipboard content and ASCII clipboard content. Copying a WS text to another editor converts soft spaces (snow characters) to a TAB character. (This enables you copying a WS table with soft spaces to an Excel spreadsheet.) German umlauts and other extended characters are converted correctly.
Moving the mouse over green chapter heading text shows bubble help e.g. "heading of chapter 7.4.1".
Adaption to new WSformat graphics functionality: If the clipboard contains a graphic, pressing Shift-Ins in WSedit runs the WSformat graphic dialog and inserts the required graphic dot command.
Moving the mouse over a "dot command macro" (see WSformat documentation) prompts the definition in a help bubble
In the contents window, the whole contents is written into the clipboard instead of a file ("clip all").

In WSedit 0.98, the following bugs were fixed:

0.98.01: Wrong line count in formatted files (wrong interpretation of ".CP", wrong ".LH" default)
0.98.02: (Win) extended characters like German umlauts were not handled correctly in uppercase <-> lowercase conversion
0.98.03: (OS/2) Bubble help did not work anymore if eCom-Center was running
0.98.04: In the open/save file dialog, a drive letter in the filename like "a:text.txt" did not work properly.

In WSedit 0.98a, the following bugs were fixed:

0.98a.1: ^A and ^F interpretates digits not as "normal characters" (jumps over digits)
0.98a.2: spellchecker failed with ANSI codepage and languages with extended characters
0.98a.3: calculating the sum of numbers in a column block failed if numbers had more than one dot or comma (e.g. 1.000.000,00 $)

New functionality/improvements in WSedit 0.97:

Reduced amount of processor time while typing new text with the keyboard
Move block (^KV), copy block (^KC) and insert clipboard (Shift-Ins) is now implemented for column block mode (^KN)
Multi trash buffer: You can use e.g. ^T "delete right word" and ^U "paste deleted word/line" several times and move e.g. several words
^QH Paragraph dialog window let you jump to a specific paragraph (Par) number.

In WSedit 0.97, the following bugs were fixed:

0.97.01: Characters with an ASCII value higher than 127 did not work correctly in the Windows version (e.g. french characters with accents), but german "Umlauts" did work
0.97.02: In FMT files, sometimes a wrong page break was shown (WSformat was not envolved)
0.97.03: "File - Save as" to a floppy disk drive forced a malfunction with a missing Backslash
0.97.04: "File - export" did not omit the first dot command of the document
0.97.05: ^OZ "calc number of chars" did also count characters in dot commands
0.97.06: WSedit did not interprete ".CN" (content numbering)
0.97.07: WSedit did not interprete ".EP" (enumerate paragraphs) correctly
0.97.08: When reading an ASCII file, Tabs (ASCII value 9) are now converted correctly to spaces.

Improvements, changes or bugfixes in WSedit 0.96 (June 2003)

calculating the sum of numbers when using column block (^KN), if the block contains digits only (observe the title bar!)
count words (special fct - calc number of chars)
no occasionally malfunction anymore when typing an indented paragraph
Bugfix: on Windows 98, 2000 and later, double-clicking into the Editor to activate the corresponding WS/FMT editor did not work (the window remained in the background).
scrolling down to empty area behind end of document (^Z and PgDn) improved
Bugfix: In the OS/2 verson of WSedit, only lowercase letters were accepted for the second character (^KX, X is the second character), and in Windows, only capital letters were accepted.
New command ^QT: delete right from cursor until punctuation mark
New command ^OA: create a text file containg a Ctrl command overview
modified commands for changing text to uppercase/lowercase (^KJ, ^KZ, ^QJ, ^QZ)

Improvements, changes or bugfixes in WSedit 0.95 (May 2003)

the WSedit search and search/replace dialog accepts printer characters (enter ^ and B or write a hash, followed by three digits for the ASCII decimal code)
more communication between WSedit and WSformat

Improvements, changes or bugfixes in WSedit 0.94 (March 2003)

Communication between WSedit and WSformat to get part of Write&Set
Menu bar (can be switched off, see menuitem Options)
Alternate appearance of popup menu (see menuitem Options)
"highlighted cursor": after a while with no cursor movement, the cursor is marked by a lightblue cross; pressing CTRL without another key forces the highlighted cursor immediately
modified behaviour when starting WSedit without a file (see Settings notebook - page Save).

Improvements, changes or bugfixes in WSedit 0.92 (November 2002)

A great number of small bugfixes, not worth to mention all.
^OD "do not show toggles" is available now, but pressing any key will show the toggles again: You can't type while toggles are not shown. The old ^OD command (show translation window) has moved to ^OV.
The cursor gets highlighted if WSedit is idle for a specific time. See Settings Notebook, page misc.
If spell checking is enabled, ^L goes to the next marked (wrong) word.
WSedit is adapted now for use together with WSformat. The look and feel is like a single program. E.g. pointing with the cursor to a font dot command in WSedit opens a font example window near the cursor which is drawn by WSformat. All documentation refering to communication between these two programs is hold in the WSformat documentation.

Fixed bugs and improvements in WSedit 0.91 (June 2000)

Improved reading of Wordstar 5, 6, 7 files (footnotes, style sheets)
recording a macro which exits WSedit now possible
in "popup menu - options", you can set the background and (default) foreground color for each file type

#Version 0.90 (March 2000) was the first version of WSedit, available only for OS/2.

If you will get a window "error found at address..., Exit program Yes/No ?" or something like that, then press "no" for do not exit, save your file immediately, exit and restart WSedit. If you can reproduce this bug, please send me an E-Mail with a description of the bug.

.2
How to contact the author

.bw 20
.bm center
.bm Martin

.in Author
.in E-Mail
Dr. Martin Vieregg. I've studied economics. My main job is working in my own consulting company http://www.vr-transport.com . Our special subject is public transport: railways and airports. The title of my doctoral (PhD) thesis was "increasing efficiency of railway long-distance passenger traffic".

E-Mail: Martin@hypermake.de

Homepage:
http://www.hypermake.com
WSedit Homepage:
http://www.WriteAndSet.com

.2
Other Freeware/Shareware

I've written some other programs, Freeware and Shareware. Please visit my Homepage

http://www.hypermake.com

ME (Freeware) Martins System Editor, a WSedit "light"
Simple Zipshell (Freeware) Using the Info-Zip Freeware packer from the Windows desktop
Tiny Alarm (Freeware) A slider from 0 to 60 minutes, alarm and chime.
cd-shortcut (Freeware) is a substitute for the "CD" command in the command line. It is sufficient to enter substrings.
4allCalc/pmCalc (Shareware) is a "pocket" calculator with a separate input and output field and no "=" button: while editing your input, the output is actualized immediately. Calculating with variables, regression, programmers functions, scientific functions. Works together with WSedit (Clipboard and column block mode ^KN)
Hypermake www.hypermake.com Hypertext builder (Shareware) let you generate Winhelp, HTML, IBM  Help and MS HTML-Help from one source text. This Help file was generated by HyperMake. The integrated editor is very similar to WSedit and the Hypertext source file format is Wordstar-like with dot commands and toggles.

End of text