/* REXX */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SysCls

say ''
say 'Installation utility of Russian Pack for Lotus WordPro96/97, ver 0.5'
say 'CopyLEFT by Ivan Borovicov, 2:5020/955'
say ''
say 'This program will install Lotus WordPro96/97 Russian language files.'
say ''

say'Do you want to auto-search your WordPro directory at current drive (y/n)?' 

pull answer

if answer = 'N'
   then
    call get_name
else
  do
  curdir=directory()
  call directory('\')
  call SysFileTree 'wordpro.exe', files, 'FS'
     if files.0 = 0
         then 
          do
           say ''
           say 'Installation program can`t find wordpro.exe at current drive.'
           say ''
           call get_name
          end
     else     
      do
       lotuspath = delword(files.1, 1, 4)
       tmp = length(lotuspath) - 12
       lotuspath = LEFT(lotuspath, tmp)
       tmp = delstr(lotuspath,1,1)
       lotuspath = tmp 
       say lotuspath
       say ''
       say 'Your WordPro directory is 'lotuspath
       say 'Is this path correct (Y/N)?'
        pull answer
         if answer = 'N'
          then
           call get_name
      end
       call directory(curdir)      
 end

say '' 
say "Updating LWP files..."

target_file =  '..\smasters\wordpro\default.mwp'
source_file = 'default.mwp'
call update_file

'@copy lotusru?.dic 'lotuspath'\..\compnent\spell\*.* >nul'
'@copy ltsuser1.udc 'lotuspath'\..\compnent\spell\*.* >nul'
'@copy lotusru2.hyp 'lotuspath' >nul'

target_file = 'lwp866.cst'
source_file = 'lwp866.cst'
call update_file

say ''
say 'Installation is complete. Now you may run your WordPro, select "default.mwp"'
say 'template to activate Russian spellchecking'
say 'Check, that at active LWP and user dictionaries selected language is Russian.'
exit

update_file:

if SysFileDelete(lotuspath'\'target_file) > 0
   then 
     do
     say 'Unable to update file "'source_file'". You`ll need to replace it manually.'
     say lotuspath'\'target_file
     return
     end

'@copy 'source_file lotuspath'\'target_file'>nul'

return

get_name:

       say 'Please enter full path and name of your Lotus WordPro directory or '
       say 'just press <ENTER> to exit.'
       say ''
       say 'Example: c:\utl\lotusw4\wordpro'
       say ''
       pull lotuspath
       if lotuspath='' 
         then exit
       else return       
