<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledSphere.com -->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fo="http://www.w3.org/1999/XSL/Format"
               version="1.0">
   
  <xsl:include href="variables.xml" />
  
 <!-- <xsl:output method="html"/> -->

  
<xsl:template match="/">

<xsl:text>
</xsl:text>

<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:text>
</xsl:text>

<fo:layout-master-set>

  <fo:simple-page-master master-name="title-page-centered"
	margin-bottom=".5in"
	margin-left="1in"
	margin-right="1in"
	margin-top=".5in"
	page-height="11in"
	page-width="8.5in" >
	<fo:region-before region-name="title-page-header-centered"
		extent="1in"/>
	<fo:region-body region-name="title-page-body-centered" 
           margin-bottom="1.5in"
	   margin-top="1in"/>
	<fo:region-after region-name="title-page-footer-centered" 
		extent="1in"/>
  </fo:simple-page-master>

  <fo:simple-page-master master-name="info-page-centered"
	margin-bottom=".5in"
	margin-left="1in"
	margin-right="1in"
	margin-top=".5in"
	page-height="11in"
	page-width="8.5in" >
	<fo:region-before region-name="info-page-header-centered"
		extent="1in"/>
	<fo:region-body region-name="info-page-body-centered" 
           margin-bottom="1.5in"
	   margin-top="1in"/>
	<fo:region-after region-name="info-page-footer-centered" 
		extent="1in"/>
  </fo:simple-page-master>

  <fo:simple-page-master master-name="toc-page-centered"
	margin-bottom=".5in"
	margin-left="1in"
	margin-right="1in"
	margin-top=".5in"
	page-height="11in"
	page-width="8.5in" >
	<fo:region-before region-name="toc-page-header-centered"
		extent="1in"/>
	<fo:region-body region-name="toc-page-body-centered" 
           margin-bottom="1.5in"
	   margin-top="1in"/>
	<fo:region-after region-name="toc-page-footer-centered" 
		extent="1in"/>
  </fo:simple-page-master>

  <fo:simple-page-master master-name="page-centered"
	margin-bottom=".5in"
	margin-left="1in"
	margin-right="1in"
	margin-top=".5in"
	page-height="11in"
	page-width="8.5in" >
	<fo:region-before region-name="header-centered"
		extent="1in"/>
	<fo:region-body region-name="body-centered" 
           margin-bottom="1.5in"
	   margin-top="1in"/>
	<fo:region-after region-name="footer-centered" 
		extent="1in"/>
  </fo:simple-page-master>

  <fo:page-sequence-master master-name="titlepage">
 	<fo:repeatable-page-master-alternatives>
		<fo:conditional-page-master-reference 
			master-reference="title-page-centered"
			odd-or-even="even"/>
		<fo:conditional-page-master-reference 
			master-reference="title-page-centered"
			odd-or-even="odd"/>
	</fo:repeatable-page-master-alternatives>
  </fo:page-sequence-master>

  <fo:page-sequence-master master-name="infopage">
 	<fo:repeatable-page-master-alternatives>
		<fo:conditional-page-master-reference 
			master-reference="info-page-centered"
			odd-or-even="even"/>
		<fo:conditional-page-master-reference 
			master-reference="info-page-centered"
			odd-or-even="odd"/>
	</fo:repeatable-page-master-alternatives>
  </fo:page-sequence-master>

  <fo:page-sequence-master master-name="tocpage">
 	<fo:repeatable-page-master-alternatives>
		<fo:conditional-page-master-reference 
			master-reference="toc-page-centered"
			odd-or-even="even"/>
		<fo:conditional-page-master-reference 
			master-reference="toc-page-centered"
			odd-or-even="odd"/>
	</fo:repeatable-page-master-alternatives>
  </fo:page-sequence-master>

  <fo:page-sequence-master master-name="mainpage">
 	<fo:repeatable-page-master-alternatives>
		<fo:conditional-page-master-reference 
			master-reference="page-centered"
			odd-or-even="even"/>
		<fo:conditional-page-master-reference 
			master-reference="page-centered"
			odd-or-even="odd"/>
	</fo:repeatable-page-master-alternatives>
  </fo:page-sequence-master>
</fo:layout-master-set>

<xsl:text>
</xsl:text>

<fo:page-sequence master-reference="titlepage">
	<fo:static-content flow-name="title-page-header-centered">
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="center"
			border-after-color="black"
			border-after-style="solid"
			border-after-width=".01em"
			padding-after="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="5in"/>
			<fo:table-column column-width="1in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block padding-before="2em" ><xsl:value-of select="//Title" /></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block alignment-baseline="central"><fo:external-graphic src="images/MiniLogo.jpg" content-height=".6in" content-width=".9in" scaling="uniform" scaling-method="auto"/></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:static-content flow-name="title-page-footer-centered">
		<fo:block
			font-family="Times"
			font-size="9pt"
			font-style="normal"
			font-weight="normal"
			text-align="center"
			border-before-color="blue"
			border-before-style="solid"
			border-before-width="0.02em"
			padding-before="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="1.2in"/>
			<fo:table-column column-width="4in" />
			<fo:table-column column-width="1.2in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block><xsl:value-of select="$OrgName"/><xsl:text>  </xsl:text><xsl:value-of select="$SecurityLevel"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:value-of select="$ProjectName"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:apply-templates select="//Cover/DocDate" mode="MyORG" /></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:flow flow-name="title-page-body-centered">
		<fo:block
			margin-left="1in"
			margin-right="1in"
			space-after=".5in">
			<fo:block alignment-baseline="central"><fo:external-graphic src="images/Logo.jpg" content-height="3in" content-width="5in" scaling="uniform" scaling-method="auto"/></fo:block>
		</fo:block>
		<fo:block
			font-family="Times"
			font-size="14pt"
			font-style="italic"
			font-weight="bold"
			text-align="center"
			>
			<xsl:value-of select="//Title"/>
		</fo:block>
		<fo:block
			font-family="Times"
			font-size="14pt"
			font-style="normal"
			font-weight="bold"
			text-align="center"
			space-before=".25in"
			>
			for
		</fo:block>
		<fo:block
			font-family="Times"
			font-size="14pt"
			font-style="italic"
			font-weight="bold"
			text-align="center"
			space-before=".25in"
			>
			<xsl:value-of select="$ProjectName"/>
		</fo:block>
		<fo:block 
			font-family="Times"
			font-size="8pt"
			font-style="normal"
			font-weight="normal"
			space-before=".5in"
			text-align="left"
			padding-start="2in">

 		   <fo:table 
				table-layout="fixed"
				width="100%" 
				>
			<fo:table-column column-width="proportional-column-width(1.5)" />
			<fo:table-column column-width="1.25in" />
			<fo:table-column column-width="1.5in" />
			<fo:table-column column-width="proportional-column-width(1)" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell/>
				  <fo:table-cell><fo:block font-weight="bold" >Version Number:</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="normal" font-style="italic"><xsl:value-of select="//Cover/Version" /></fo:block></fo:table-cell>
				  <fo:table-cell/>
				</fo:table-row>
				<fo:table-row>
				  <fo:table-cell/>
				  <fo:table-cell><fo:block font-weight="bold" >Draft/Final as of:</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="normal" ><xsl:apply-templates select="//Cover/DocDate" mode="MyORG2" /></fo:block></fo:table-cell>
				  <fo:table-cell/>
				</fo:table-row>	
				<fo:table-row>
				  <fo:table-cell/>
				  <fo:table-cell><fo:block font-weight="bold" >Printed on:</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="normal" ><xsl:apply-templates select="//Cover/DocDate" mode="MyORG2" /></fo:block></fo:table-cell>
				  <fo:table-cell/>
				</fo:table-row>
				<fo:table-row>
				  <fo:table-cell/>
				  <fo:table-cell><fo:block font-weight="bold" >Author:</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="normal" font-style="italic"><xsl:value-of select="//Cover/AuthorName" /></fo:block></fo:table-cell>
				  <fo:table-cell/>
				</fo:table-row>
				<fo:table-row>
				  <fo:table-cell/>
				  <fo:table-cell><fo:block font-weight="bold" >Owner:</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="normal" font-style="italic" ><xsl:value-of select="//Cover/OwnerName" /></fo:block></fo:table-cell>
				  <fo:table-cell/>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
		
	</fo:flow>
</fo:page-sequence>


<fo:page-sequence master-reference="infopage">
	<fo:static-content flow-name="info-page-header-centered">
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="center"
			border-after-color="black"
			border-after-style="solid"
			border-after-width=".01em"
			padding-after="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="5in"/>
			<fo:table-column column-width="1in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block padding-before="2em" ><xsl:value-of select="//Title" /></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block alignment-baseline="central"><fo:external-graphic src="images/MiniLogo.jpg" content-height=".6in" content-width=".9in" scaling="uniform" scaling-method="auto"/></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:static-content flow-name="info-page-footer-centered">
		<fo:block
			font-family="Times"
			font-size="9pt"
			font-style="normal"
			font-weight="normal"
			text-align="center"
			border-before-color="blue"
			border-before-style="solid"
			border-before-width="0.02em"
			padding-before="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="1.2in"/>
			<fo:table-column column-width="4in" />
			<fo:table-column column-width="1.2in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block><xsl:value-of select="$OrgName"/><xsl:text>  </xsl:text><xsl:value-of select="$SecurityLevel"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:value-of select="$ProjectName"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:apply-templates select="//Cover/DocDate" mode="MyORG" /></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:flow flow-name="info-page-body-centered">
		<fo:block
			font-family="Times"
			font-size="14pt"
			font-style="normal"
			font-weight="bold"
			text-align="left"
			space-after=".25in"
			>
			Document Information
		</fo:block>

		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="left"
			space-after=".25in"
			>
			Document Source
		</fo:block>
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="normal"
			text-align="left"
			space-after=".25in"
			>
			This document is maintained as an online document. Contact the owner for the latest revision
		</fo:block>

		<!-- REVISION HISTORY -->

		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="left"
			space-after=".25in"
			>
			Revision History
		</fo:block>
		
		<fo:block 
			font-family="Times"
			font-size="8pt"
			font-style="normal"
			font-weight="normal"
			text-align="left"
			>

 		   <fo:table
			table-layout="fixed" 
			width="100%"
			>
			<fo:table-column column-width="proportional-column-width(1)"  border-style="solid" border-width=".1pt"/>
			<fo:table-column column-width="proportional-column-width(1)"  border-style="solid" border-width=".1pt" />
			<fo:table-column column-width="proportional-column-width(3)"  border-style="solid" border-width=".1pt" />
			<fo:table-column column-width="proportional-column-width(1)"  border-style="solid" border-width=".1pt" />
			<fo:table-body>
				<fo:table-row >
				  <!-- 
				  <fo:table-cell><fo:block font-weight="bold" border-after-style="solid" border-after-width=".2pt" text-indent=".5em">Version number</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" border-after-style="solid" border-after-width=".2pt" text-indent=".5em">Date</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" border-after-style="solid" border-after-width=".2pt" text-indent=".5em">Summary of changes</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" border-after-style="solid" border-after-width=".2pt" text-indent=".5em">Revision marks</fo:block></fo:table-cell>
				  -->
				  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Version number</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Date</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Summary of changes</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Revision marks</fo:block></fo:table-cell>
				</fo:table-row>
				<xsl:apply-templates select="//TechNote/Cover/RevisionList" />
			</fo:table-body>
		   </fo:table>
		</fo:block>
		

		<!-- SIGNOFF LIST -->

		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="left"
			space-before=".25in"
			space-after=".25in"
			>
			Approvals
		</fo:block>
		
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="normal"
			text-align="left"
			space-after=".25in"
			>
			This document has been approved by the following people.  The signed approval forms
			are filed in the Project Control Book.  (See signoff sheets at the end of the document).
		</fo:block>

		<fo:block 
			font-family="Times"
			font-size="8pt"
			font-style="normal"
			font-weight="normal"
			text-align="left"
			>
			
			<xsl:apply-templates select="//SignoffSheet" mode="MyORG" />

		</fo:block>


		<!-- DISTRIBUTION LIST -->

		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="left"
			space-before=".25in"
			space-after=".25in"
			>
			Distribution
		</fo:block>
		
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="normal"
			text-align="left"
			space-after=".25in"
			>
			This document has been distributed to:
		</fo:block>

		<fo:block 
			font-family="Times"
			font-size="8pt"
			font-style="normal"
			font-weight="normal"
			text-align="left"
			>
			
			<xsl:apply-templates select="//DistributionList" mode="MyORG" />

		</fo:block>

	</fo:flow>
</fo:page-sequence>



<fo:page-sequence master-reference="tocpage">
	<fo:static-content flow-name="toc-page-header-centered">
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="center"
			border-after-color="black"
			border-after-style="solid"
			border-after-width=".01em"
			padding-after="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="5in"/>
			<fo:table-column column-width="1in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block padding-before="2em" ><xsl:value-of select="//Title" /></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block alignment-baseline="central"><fo:external-graphic src="images/MiniLogo.jpg" content-height=".6in" content-width=".9in" scaling="uniform" scaling-method="auto"/></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:static-content flow-name="toc-page-footer-centered">
		<fo:block
			font-family="Times"
			font-size="9pt"
			font-style="normal"
			font-weight="normal"
			text-align="center"
			border-before-color="blue"
			border-before-style="solid"
			border-before-width="0.02em"
			padding-before="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="1.2in"/>
			<fo:table-column column-width="4in" />
			<fo:table-column column-width="1.2in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block><xsl:value-of select="$OrgName"/><xsl:text>  </xsl:text><xsl:value-of select="$SecurityLevel"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:value-of select="$ProjectName"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:apply-templates select="//Cover/DocDate" mode="MyORG" /></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:flow flow-name="toc-page-body-centered">
		<fo:block
			font-family="Times"
			font-size="14pt"
			font-style="normal"
			font-weight="bold"
			text-align="center"
			space-after=".25in"
			>
			Table of Content
		</fo:block>
			<xsl:apply-templates select="//TechNote/Section" mode="toc" />
        		<!--	<xsl:with-param name="numberingPrefix" select="'.'" />
			</xsl:apply-templates> -->

		<fo:block>
		</fo:block>

	</fo:flow>
</fo:page-sequence>





<fo:page-sequence master-reference="mainpage">
	<fo:static-content flow-name="header-centered">
		<fo:block
			font-family="Times"
			font-size="12pt"
			font-style="normal"
			font-weight="bold"
			text-align="center"
			border-after-color="black"
			border-after-style="solid"
			border-after-width=".01em"
			padding-after="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="5in"/>
			<fo:table-column column-width="1in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block padding-before="2em" ><xsl:value-of select="//Title" /></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block alignment-baseline="central"><fo:external-graphic src="images/MiniLogo.jpg" content-height=".6in" content-width=".9in" scaling="uniform" scaling-method="auto"/></fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:static-content flow-name="footer-centered">
		<fo:block
			font-family="Times"
			font-size="9pt"
			font-style="normal"
			font-weight="normal"
			text-align="center"
			border-before-color="blue"
			border-before-style="solid"
			border-before-width="0.02em"
			padding-before="4pt"
			>
 		   <fo:table table-layout="fixed">
			<fo:table-column column-width="1.2in"/>
			<fo:table-column column-width="4in" />
			<fo:table-column column-width="1.2in" />
			<fo:table-body>
				<fo:table-row>
				  <fo:table-cell><fo:block><xsl:value-of select="$OrgName"/><xsl:text>  </xsl:text><xsl:value-of select="$SecurityLevel"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:value-of select="$ProjectName"/></fo:block></fo:table-cell>
				  <fo:table-cell><fo:block><xsl:apply-templates select="//Cover/DocDate" mode="MyORG" /></fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row>
				  <fo:table-cell>  </fo:table-cell>
				  <fo:table-cell><fo:block>Page <fo:page-number/></fo:block></fo:table-cell>
				  <fo:table-cell>  </fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		   </fo:table>
		</fo:block>
	</fo:static-content>

	<fo:flow flow-name="body-centered">
		<xsl:apply-templates select="//TechNote/Section" />
	</fo:flow>


</fo:page-sequence>

<xsl:text>
</xsl:text>

</fo:root>
</xsl:template>



<!--
<xsl:template name="MyORGHeader" >
  <center><xsl:text>
    </xsl:text>
    <table border='0' >
      <tr>
        <td align='center' width='500'><strong><xsl:value-of select="./Title" /></strong></td>
        <td align='right'><img src="images/MiniLogo.jpg" height='80' width='120'/> </td>
      </tr>
    </table>
    </center>
    <hr/>
    <xsl:text>

    </xsl:text>
</xsl:template>
-->


<!--
<xsl:template name="MyORGFooter" >
  <hr/>
  <xsl:text>
  
  </xsl:text>
  <center>
  <small>
  <table border='0'>
    <tr>
      <td align='left' width='200'><small><xsl:value-of select="$OrgName"/><xsl:text>  </xsl:text><xsl:value-of select="$SecurityLevel"/></small></td>
      <td align='center' width='400'><small><xsl:value-of select="$ProjectName"/></small></td>
      <td align='right' width='200'><small><xsl:apply-templates select="./DocDate" mode="MyORG" /></small></td></tr>
    <tr><td>  </td><td align='center'><small>Page 1 of n</small></td><td>  </td></tr>
    <tr></tr>
  </table>
  </small>
  </center>
</xsl:template>
-->


<!--
<xsl:template name="RevisionHistoryMyORG" >
  <table border='1'>
  <tr>
    <td width='100'><strong>Version number</strong></td>
    <td width='100'><strong>Date</strong></td>
    <td width='500'><strong>Summary of changes</strong></td>
    <td width='100'><strong>Revision marks</strong></td>
  </tr>
  <tr>
    <td><i><xsl:value-of select="//Cover/Version" /></i></td>
    <td><i><xsl:apply-templates select="//Cover/DocDate" mode="MyORG" /></i></td>
    <td>Current revision  </td>
    <td>No</td>
  </tr>
  <xsl:if test="./RevisionList">
    <xsl:apply-templates select="./RevisionList" />
  </xsl:if>
  </table>
</xsl:template> 
-->
 
<!--   
<xsl:template match="Cover">
  <xsl:variable name="DocumentDateFull">
    <xsl:apply-templates select="./DocDate" mode="MyORG2" /> 
  </xsl:variable>
  <xsl:call-template name="MyORGHeader" />
      
    <center><img src='images/Logo.jpg' height='320' width='480' /></center>
    <br/>
    <xsl:text>
    </xsl:text><center>
    <strong><i><xsl:value-of select="./Title" /></i></strong>
    <br/><br/>
    <strong>for</strong>
    <br/><br/>
    <strong><i>SYNCHRONOUS MANUFACTURING SYSTEM PROJECT</i></strong>
    </center><br/><br/><br/>
    
    <center>
    <small>
    <table border='0' cellspacing='0'>
    <tr>
      <td><strong><small>Version Number: </small></strong> </td><td><small><i><xsl:value-of select="./Version" /></i></small></td>
    </tr>
    <tr>
      <td><strong><small>Draft/Final as of:  </small></strong> </td><td><small><xsl:value-of select="$DocumentDateFull"/></small></td>
    </tr>
    <tr>
      <td><strong><small>Printed on:  </small></strong> </td><td><small><xsl:value-of select="$DocumentDateFull" /></small> </td>
    </tr>
    <tr>
      <td><strong><small>Author:  </small></strong> </td><td><small><i><xsl:value-of select="./AuthorName" /></i></small></td>
    </tr>
    <tr>
      <td><strong><small>Owner:  </small></strong> </td><td><small><i><xsl:value-of select="./OwnerName" /></i></small></td>
    </tr>
    </table>
    </small>
    </center>
-->    
    <!--
    <xsl:apply-templates select="./SignoffSheet" />
    -->
<!--    
  <br/><br/><br/>
    <xsl:call-template name="MyORGFooter" />
-->
     
  <!-- HERE BEGINS THE DOC INFO SHEET FOR MyORG FORMAT -->
  
<!--
  <br/>
  <h3>Document Information</h3>
  <table border='0'>
  <tr><td width='50'> </td>
  <td>
  <strong>Document source</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <p>This document is maintained as an online document. Contact the owner for the latest version.</p>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <strong>Revision history</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <xsl:call-template name="RevisionHistoryMyORG" />
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <strong>Approvals</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <p>This document has been approved by the following people.  The signed approval forms are filed in the Project Control Book.
    (See signoff sheets at the end of the document).</p>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <xsl:apply-templates select="//SignoffSheet" mode="MyORG" />
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <strong>Distribution</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <p>This document has been distributed to:</p>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <xsl:apply-templates select="//DistributionList" mode="MyORG" />
  </td></tr>
  </table>
-->
  
  <!-- HERE BEGINS THE TOC FOR MyORG FORMAT -->
  
  
<!--  
</xsl:template> 
-->
<!-- COVER -->



<xsl:template match="OwnerName" >
  Owner: <xsl:value-of select="."/>
</xsl:template>


<xsl:template match="SignoffSheet" mode="MyORG" >
  <!--
  <table border='1'>
    <tr>
      <td width='300'><strong>Name</strong></td>
      <td width='500'><strong>Function</strong></td>
    </tr>
  
  </table>
  -->
	   <fo:table 
		table-layout="fixed"
		width="100%"
		>
		<fo:table-column column-width="proportional-column-width(3)"  border-style="solid" border-width=".1pt"/>
		<fo:table-column column-width="proportional-column-width(5)"  border-style="solid" border-width=".1pt" />
		<fo:table-body>
			<fo:table-row >
			  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Name</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Function</fo:block></fo:table-cell>
			</fo:table-row>
			<xsl:apply-templates select="SignoffEntry"  mode="MyORG"/>
		</fo:table-body>
	   </fo:table>
</xsl:template>


<!--
<xsl:template match="SignoffSheet" >
  <center>
  <h2>Signoff Sheet</h2>
  <table border='3'>
    <tr>
      <td><strong>Name</strong></td>
      <td><strong>Function</strong></td>
      <td width='300'><strong>Signature</strong></td>
      <td width='150'><strong>Date</strong></td>
    </tr>
  <xsl:apply-templates select="SignoffEntry" />
  </table>
  </center>
  <br />
  <hr />
</xsl:template>
-->


<xsl:template match="SignoffEntry" mode="MyORG" >
<!--
  <tr>
    <td><xsl:value-of select="Signator"/></td>
    <td><xsl:value-of select="SignatorTitle"/></td>
  </tr>
-->
    <fo:table-row>
      <fo:table-cell><fo:block border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:value-of select="Signator" /></fo:block></fo:table-cell>
      <fo:table-cell><fo:block border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:value-of select="SignatorTitle"  /></fo:block></fo:table-cell>
    </fo:table-row>

</xsl:template>


<!--
<xsl:template match="SignoffEntry" >
  <tr>
    <td><xsl:value-of select="Signator"/></td>
    <td><xsl:value-of select="SignatorTitle"/></td>
    <td><br/><br/></td>
    <td><br/><br/></td>
  </tr>
</xsl:template>
-->


<xsl:template match="DistributionList" mode="MyORG" >
<!--
  <table border='1'>
    <tr>
      <td width='300'><strong>Name</strong></td>
      <td width='500'><strong>Title</strong></td>
    </tr>
  <xsl:apply-templates select="DistributionEntry"  mode="MyORG"/>
  </table>
-->
	   <fo:table 
		table-layout="fixed"
		width="100%"
		>
		<fo:table-column column-width="proportional-column-width(3)"  border-style="solid" border-width=".1pt"/>
		<fo:table-column column-width="proportional-column-width(5)"  border-style="solid" border-width=".1pt" />
		<fo:table-body>
			<fo:table-row >
			  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Name</fo:block></fo:table-cell>
				  <fo:table-cell><fo:block font-weight="bold" text-indent=".5em">Title</fo:block></fo:table-cell>
			</fo:table-row>
			<xsl:apply-templates select="DistributionEntry"  mode="MyORG"/>
		</fo:table-body>
	   </fo:table>
</xsl:template>


<!--
<xsl:template match="DistributionList" >
  <center>
  <h2>Distribution List</h2>
  <table border='3'>
    <tr>
      <td><strong>Name</strong></td>
      <td><strong>Title</strong></td>
    </tr>
  <xsl:apply-templates select="DistributionEntry" />
  </table>
  </center>
  <br />
  <hr />
</xsl:template>
-->


<xsl:template match="DistributionEntry" mode="MyORG" >
<!--
  <tr>
    <td><xsl:value-of select="RecipientName"/></td>
    <td><xsl:value-of select="RecipientTitle"/></td>
  </tr>
-->
    <fo:table-row>
      <fo:table-cell><fo:block border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:value-of select="RecipientName" /></fo:block></fo:table-cell>
      <fo:table-cell><fo:block border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:value-of select="RecipientTitle"  /></fo:block></fo:table-cell>
    </fo:table-row>
</xsl:template>


<!--
<xsl:template match="DistributionEntry" >
  <tr>
    <td><xsl:value-of select="RecipientName"/></td>
    <td><xsl:value-of select="RecipientTitle"/></td>
  </tr>
</xsl:template>
-->




  <!-- THE SECTION TEMPLATE
       is quite elaborate because sections are recursively
     nested, and numbered using the Dewey decimal system
  -->

  <!-- THE TOC VERSION -->

  
  <xsl:template match="Section" mode="toc">
       <xsl:param name="numberingPrefix"/>
     <xsl:variable name="depth" >
       <xsl:value-of select="count(./ancestor::node())" />
     </xsl:variable >
     <xsl:variable name="numberParam">
       <xsl:number />
     </xsl:variable>
     <xsl:variable name="dooeyParam" select="$numberingPrefix" />
     <xsl:variable name="anchorValue">
       <xsl:value-of select="$dooeyParam"/><xsl:number/>
     </xsl:variable>
     <xsl:text>
  </xsl:text>
     <!-- the TITLE element is a pain in the neck because we
         need to create different text styles for each depth
         into the section nesting.
    -->   

      <!-- <a name="toc_{$anchorValue}"></a><a href="#{$anchorValue}"> -->
      <xsl:choose>
       <xsl:when test="$depth='1'">
<!--
       <tr><td colspan='7'>
       <strong><xsl:value-of select="$dooeyParam"/><xsl:number/>
       <xsl:text>    </xsl:text><a name="toc_{$anchorValue}"></a><a href="#{$anchorValue}"><xsl:value-of select="./SectionTitle" /></a></strong>
       </td></tr>
-->
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
        <fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
        </fo:inline>
	</fo:block>

     </xsl:when>

     <xsl:when test="$depth='2'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left=".25in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
        <fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
        </fo:inline>
	</fo:block>

     </xsl:when>

     <xsl:when test="$depth='3'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left=".5in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
	<fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
	</fo:inline>
	</fo:block>
     </xsl:when>

     <xsl:when test="$depth='4'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left=".75in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
        <fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
        </fo:inline>
	</fo:block>
     </xsl:when>

     <xsl:when test="$depth='5'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left="1in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
	<fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
	</fo:inline>
	</fo:block>
     </xsl:when>

     <xsl:when test="$depth='6'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left="1.25in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
	<fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
	</fo:inline>
	</fo:block>
     </xsl:when>

     <xsl:when test="$depth='7'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left="1.5in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
	<fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
	</fo:inline>
	</fo:block>
     </xsl:when>

     <xsl:when test="$depth='8'">
	<fo:block
		font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left="1.75in"
		id="concat('toc',{$anchorValue})"
		>
	<xsl:value-of select="$dooeyParam"/><xsl:number/>
	<fo:inline color="blue" background-color="transparent">
	  <fo:basic-link internal-destination="{$anchorValue}">
	    <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
	  </fo:basic-link>
	</fo:inline>
	</fo:block>
     </xsl:when>



    </xsl:choose>
        
    <xsl:apply-templates select="./Section" mode="toc">
        <xsl:with-param name="numberingPrefix" select="concat($dooeyParam,$numberParam,'.' )" />
     </xsl:apply-templates >

  </xsl:template>  

    
  <!-- END OF TOC VERSION -->

 
  <xsl:template match="Section">
       <xsl:param name="numberingPrefix"/>
     <xsl:variable name="depth" >
       <xsl:value-of select="count(./ancestor::node())" />
     </xsl:variable >
     <xsl:variable name="numberParam">
       <xsl:number />
     </xsl:variable>
     <xsl:variable name="dooeyParam" select="$numberingPrefix" />
     <xsl:variable name="anchorValue">
       <xsl:value-of select="$dooeyParam"/><xsl:number/>
     </xsl:variable>
     <!-- the TITLE is less of a pain in the neck here because.
       we do not have to choose the <h#> level by brute force;
       we can use the <xsl:element> element's name attribute 
       to do the work
    -->  
    <!-- <div>
        <xsl:element name="{concat('h',($depth - 1))}">
          <a name="{$anchorValue}"></a>
          <a href="#toc_{$anchorValue}">
          <xsl:value-of select="$dooeyParam"/><xsl:number/>
          <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
          </a>
        </xsl:element> 
     -->

    <xsl:element name="fo:block" namespace="http://www.w3.org/1999/XSL/Format">
	<xsl:attribute name="font-family">Times</xsl:attribute>
	<xsl:attribute name="font-size">14pt</xsl:attribute>
	<xsl:attribute name="font-style">normal</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="padding-top">1em</xsl:attribute>
	<xsl:attribute name="id"><xsl:value-of select="$anchorValue"/></xsl:attribute>
        <xsl:value-of select="$dooeyParam"/>
	<xsl:number/>
	<xsl:text>    </xsl:text>
	<fo:basic-link internal-destination="concat('toc',{$anchorValue})">
	        <xsl:value-of select="./SectionTitle" />
	</fo:basic-link>
    </xsl:element>

        <xsl:apply-templates select="./SectionContent" />

        <xsl:apply-templates select="./Section">
           <xsl:with-param name="numberingPrefix" select="concat($dooeyParam,$numberParam,'.' )" />
        </xsl:apply-templates >

    <!-- </div>  -->
  </xsl:template>  



<!--
  <xsl:template match="UseCase">
    <table border="1">
    <tr><td>Use Case Name</td><td colspan="2"><xsl:value-of select="./UseCaseTitle" /></td></tr>
    <tr><td>Requirement</td><td colspan="2"><xsl:value-of select="./UCRequirement" /></td></tr>
    <tr><td>Goal</td><td colspan="2"><xsl:value-of select="./UCGoal" /></td></tr>
    <tr><td>Preconditions</td><td colspan="2"><xsl:apply-templates select="./UCPreconditions" /></td></tr>
    <tr><td>Actors</td><td colspan="2"><xsl:apply-templates select="./UCActors" /></td></tr>
    <tr><td>Description</td><td>Step</td><td>Action</td></tr>
    <xsl:apply-templates select="./UCDescription/Paragraph" />
    <tr><td>Result</td><td colspan="2"><xsl:apply-templates select="./UCResult" /></td></tr>
   </table>    
  </xsl:template>
-->

  
<!--
  <xsl:template match="UCDescription/Paragraph">
    <tr><td> </td><td><xsl:number /></td><td><xsl:apply-templates /></td></tr>
  </xsl:template>
-->


  <xsl:template match="ImageLink">
    <fo:external-graphic src='{@xlink:href}' scaling="uniform" scaling-method="integer-pixels"/>
    <fo:block
	  font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="bold"
		text-align="center"
		padding-top="0.5em"
		padding-bottom="1em">
      <xsl:value-of select='.' />
    </fo:block>
  </xsl:template>



  <xsl:template match="PageLink">
    <fo:inline color="blue" background-color="transparent">
    <fo:basic-link external-destination="{@xlink:href}">
	<xsl:value-of select="." />
    </fo:basic-link>
    </fo:inline>    
  </xsl:template>


<!--
  <xsl:template match="PageLink">
	<fo:multi-properties text-decoration="underline">
		<fo:multi-property-set active-state="link" color="blue"/>
		<fo:multi-property-set active-state="visited" color="red"/>
		<fo:multi-property-set active-state="active" color="green"/>
		<fo:multi-property-set active-state="hover" text-decoration="blink"/>
		<fo:multi-property-set active-state="focus" color="yellow"/>
		<fo:wrapper color="merge-property-values()"
			text-decoration="merge-property-values()">
    			<fo:basic-link external-destination="{@xlink:href}">
				<xsl:value-of select="." />
   			 </fo:basic-link>
		</fo:wrapper>
	</fo:multi-properties>    
  </xsl:template>
-->


  <xsl:template match="Paragraph" mode="inTable">
	<fo:block
	  font-family="Times"
		font-size="8pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		padding-left="1em">

       <xsl:apply-templates  />
    </fo:block>
  </xsl:template>

  <xsl:template match="Paragraph">
	<fo:block
	  font-family="Times"
		font-size="12pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		padding-top="1em">

       <xsl:apply-templates  />
    </fo:block>
  </xsl:template>

  <xsl:template match="T">
      <fo:inline><xsl:value-of select="." /></fo:inline>
   </xsl:template>
 
  <xsl:template match="GlossaryEntry">
    <xsl:value-of select="./FullName"/> (<fo:inline font-weight="bold"><xsl:value-of select="normalize-space(./Abbreviation)"/></fo:inline>) 
  </xsl:template>



<!--
  <xsl:template match="List">
    <xsl:if test="@style='ordered'">
    <ol>
    <xsl:apply-templates />
  </ol>
  </xsl:if>
    <xsl:if test="@style!='ordered'">
    <ul>
    <xsl:apply-templates />
  </ul>
  </xsl:if>
  </xsl:template>
-->

  <xsl:template match="List">
     <xsl:if test="@style='ordered'">
      <fo:list-block>
        <xsl:apply-templates select="Member" mode="ordered"/>
      </fo:list-block>
     </xsl:if>
     <xsl:if test="@style!='ordered'">
      <fo:list-block>
        <xsl:apply-templates select="Member" mode="unordered"/>
      </fo:list-block>
     </xsl:if>
  </xsl:template>
  

<!--  <xsl:template match="Member">
    <li><xsl:apply-templates /></li>
  </xsl:template>
-->

  <xsl:template match="Member" mode="ordered">
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block
	  font-family="Times"
		text-align="left"
		>
          <xsl:number />.
         </fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block
	  font-family="Times"
		text-align="left"
		>
           <xsl:apply-templates />
         </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>

  <xsl:template match="Member" mode="unordered">
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block
	  font-family="Times"
		text-align="left"
		>
          &#x2022;
	<!-- That is Unicode for a solid bullet.   Try &#x247D; for a hollow one -->
         </fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block
	  font-family="Times"
		text-align="left"
		>
           <xsl:apply-templates />
         </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>


<!--
  <xsl:template match="Emphasis[@intensity='high']">
    <strong><xsl:text> </xsl:text><xsl:value-of select="."/><xsl:text> </xsl:text></strong>
  </xsl:template>

  <xsl:template match="Emphasis">
    <i><xsl:text> </xsl:text><xsl:value-of select="."/><xsl:text> </xsl:text></i>
  </xsl:template>
-->

  <xsl:template match="Emphasis[@intensity='high']">
    <fo:inline font-weight="bold"><xsl:text> </xsl:text><xsl:value-of select="."/><xsl:text> </xsl:text></fo:inline>
  </xsl:template>
  <xsl:template match="Emphasis">
    <fo:inline font-style="italic"><xsl:text> </xsl:text><xsl:value-of select="."/><xsl:text> </xsl:text></fo:inline>
  </xsl:template>





  <xsl:template match="Table">
    <!-- Calculate the total string length in the first row (titles) to set proportions -->
    <xsl:variable name="titleTotalLength" >
	<xsl:call-template name="setOfStringsLength">
	  <xsl:with-param name="setOfStrings" select="./TableRow[1]/TableCell" />
        </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="numberOfColumns" >
        <xsl:call-template name="sizeOfNodeSet">
          <xsl:with-param name="theNodeSet" select="./TableRow[1]/TableCell" />
        </xsl:call-template>
    </xsl:variable>
<!--
	<xsl:message>
		<xsl:text>Table template: numberOfColumns=</xsl:text><xsl:value-of select="$numberOfColumns"/><xsl:text>
</xsl:text>
	</xsl:message>
	<xsl:message>
		<xsl:text>Table template: titleTotalLength=</xsl:text><xsl:value-of select="$titleTotalLength"/><xsl:text>
</xsl:text>
	</xsl:message>
-->
    <fo:table table-layout="fixed" width="100%">
      <xsl:apply-templates select="./TableRow[1]/TableCell" mode="tableColumnSpecification">
        <xsl:with-param name="totalLength" select="$titleTotalLength div $numberOfColumns" />
      </xsl:apply-templates>
    <fo:table-body>
    <xsl:apply-templates select="./TableRow" mode="tableRow"/>
    </fo:table-body>
  </fo:table>
  </xsl:template>


  <xsl:template name="setOfStringsLength" >
    <xsl:param name="setOfStrings" />
    <xsl:variable name="firstString" >
       <xsl:value-of select="$setOfStrings[1]" />
    </xsl:variable>
<!--
	<xsl:message>
		<xsl:text>setOfStringsLength template: firstString=</xsl:text><xsl:value-of select="normalize-space($firstString)"/><xsl:text>
</xsl:text>
	</xsl:message>
	<xsl:message>
		<xsl:text>setOfStringsLength template: length of firstString=</xsl:text><xsl:value-of select="string-length(normalize-space($firstString))"/><xsl:text>
</xsl:text>
	</xsl:message>
-->
    <xsl:choose>
      <xsl:when test="$setOfStrings">
        <xsl:variable name="lengthOfFirst">
          <xsl:value-of select="string-length(normalize-space($firstString))" />
        </xsl:variable>
	<xsl:variable name="lengthOfRest">
          <xsl:call-template name="setOfStringsLength">
            <xsl:with-param name="setOfStrings" select="$setOfStrings[position()!=1]" />
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$lengthOfFirst + $lengthOfRest" />
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="sizeOfNodeSet" >
    <xsl:param name="theNodeSet" />
    <xsl:choose>
      <xsl:when test="$theNodeSet">
	<xsl:variable name="numberInRest">
          <xsl:call-template name="sizeOfNodeSet">
            <xsl:with-param name="theNodeSet" select="$theNodeSet[position()!=1]" />
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="1 + $numberInRest" />
      </xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
  </xsl:template>


    
  <xsl:template match="TableRow" mode="tableRow" >
    <fo:table-row>
    <xsl:apply-templates select="./TableCell" mode="tableRow" />
  </fo:table-row>
  </xsl:template>


  <xsl:template match="TableCell" mode="tableColumnSpecification">
    <xsl:param name="totalLength" />
<!--
	<xsl:message>
		<xsl:text>TableCell tableColumnSpecification template: totalLength=</xsl:text><xsl:value-of select="$totalLength"/><xsl:text>
</xsl:text>
	</xsl:message>
	<xsl:message>
		<xsl:text>TableCell tableColumnSpecification template: ownStringLength=</xsl:text><xsl:value-of select="string-length(normalize-space(.))"/><xsl:text>
</xsl:text>
	</xsl:message>
-->
    <!-- <fo:table-column column-width="proportional-column-width({6 div last()})" border-style="solid" border-width=".1pt"/> -->
    <fo:table-column column-width="proportional-column-width({string-length(normalize-space(.)) div $totalLength})" border-style="solid" border-width=".1pt"/> -->
  </xsl:template>



  <xsl:template match="TableCell" mode="tableRow">
    <fo:table-cell
		font-family="Times"
		font-size="8pt"
		font-style="normal"
		font-weight="normal"
		text-align="left"
		margin-left="1em"
		wrap-option="wrap"
 		border-before-style="solid" 
		border-before-width="0.1pt" 
		>
       <xsl:apply-templates select="Paragraph" mode="inTable" />
    </fo:table-cell>
  </xsl:template>

  <xsl:template match="DocDate" mode="MyORG"><xsl:apply-templates select="TNDate" mode="MyORG"/></xsl:template>
  <xsl:template match="DocDate" mode="MyORG2"><xsl:apply-templates select="TNDate" mode="MyORG2"/></xsl:template>
  <xsl:template match="DocDate"><xsl:apply-templates select="TNDate"/></xsl:template>

  <xsl:template match="TNDate" mode="MyORG">
    <!-- Year Numeric -->
      <xsl:value-of select="@year" /><xsl:text>/</xsl:text>
      <!-- Month by Number -->
      <xsl:value-of select="@month" /><xsl:text>/</xsl:text>
      <!-- Day of Month -->
      <xsl:value-of select="@dayOfMonth" /><xsl:text>  </xsl:text>
  </xsl:template>

  <xsl:template match="TNDate" mode="MyORG2">
      <!-- Day of Week -->
      <xsl:if test="@dayOfWeek">
        <xsl:value-of select="@dayOfWeek"/><xsl:text>, </xsl:text>
      </xsl:if>
      <!-- Month by Name -->
      <xsl:choose>
      <xsl:when test="@month='1'">January</xsl:when>
      <xsl:when test="@month='2'">February</xsl:when>
      <xsl:when test="@month='3'">March</xsl:when>
      <xsl:when test="@month='4'">April</xsl:when>
      <xsl:when test="@month='5'">May</xsl:when>
      <xsl:when test="@month='6'">June</xsl:when>
      <xsl:when test="@month='7'">July</xsl:when>
      <xsl:when test="@month='8'">August</xsl:when>
      <xsl:when test="@month='9'">September</xsl:when>
      <xsl:when test="@month='10'">October</xsl:when>
      <xsl:when test="@month='11'">November</xsl:when>
      <xsl:when test="@month='12'">December</xsl:when>
    </xsl:choose><xsl:text> </xsl:text>
          <!-- Day of Month -->
      <xsl:value-of select="@dayOfMonth" /><xsl:text>,  </xsl:text>
    <!-- Year Numeric -->
    <xsl:value-of select="@year" />
  </xsl:template>
  
  <xsl:template match="TNDate">
      <!-- Day of Month -->
      <xsl:value-of select="@dayOfMonth" /><xsl:text>  </xsl:text>
      <!-- Month by Name -->
      <xsl:choose>
      <xsl:when test="@month='1'">January</xsl:when>
      <xsl:when test="@month='2'">February</xsl:when>
      <xsl:when test="@month='3'">March</xsl:when>
      <xsl:when test="@month='4'">April</xsl:when>
      <xsl:when test="@month='5'">May</xsl:when>
      <xsl:when test="@month='6'">June</xsl:when>
      <xsl:when test="@month='7'">July</xsl:when>
      <xsl:when test="@month='8'">August</xsl:when>
      <xsl:when test="@month='9'">September</xsl:when>
      <xsl:when test="@month='10'">October</xsl:when>
      <xsl:when test="@month='11'">November</xsl:when>
      <xsl:when test="@month='12'">December</xsl:when>
    </xsl:choose><xsl:text>,  </xsl:text>
    <!-- Year Numeric -->
    <xsl:value-of select="@year" />
  </xsl:template>


  <xsl:template match="BiblioEntry">
    <xsl:apply-templates select="./AuthorList" />
    <xsl:apply-templates select="./Article | ./Book" />
    <xsl:apply-templates select="./Publisher" />
    <xsl:apply-templates select="./EditorList" />
    <xsl:apply-templates select="./PageRange" />
  </xsl:template>


  <xsl:template match="AuthorList">
    <xsl:apply-templates select="./PersonName" /> 
  </xsl:template>

  <xsl:template match="EditorList">
    <xsl:if test="last() > 0">
      <xsl:text>(</xsl:text><xsl:apply-templates select="./PersonName"/><xsl:text> ed.),  </xsl:text>
    </xsl:if>
  </xsl:template>
     
  <xsl:template match="PageRange">
    <xsl:text>pp. </xsl:text><xsl:value-of select="@low"/><xsl:text>-</xsl:text><xsl:value-of select="@high"/><xsl:text>. </xsl:text>
  </xsl:template>
     
  <xsl:template match="PersonName">
    <xsl:value-of select="./FirstName"/><xsl:text> </xsl:text>
    <xsl:value-of select="./Initials" /><xsl:text> </xsl:text>
    <xsl:value-of select="./LastName" /><xsl:text>, </xsl:text>
  </xsl:template>  

  <xsl:template match="Article">
    <fo:inline font-style="italic"><xsl:value-of select="./ArticleTitle"/></fo:inline><xsl:text>, </xsl:text>
    <xsl:value-of select="./PeriodicalName" /><xsl:text>, </xsl:text>
    <xsl:apply-templates select="./PeriodicalIssue" />
    <xsl:apply-templates select="./PeriodicalDate" />
  </xsl:template>

  <xsl:template match="PeriodicalName">
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="PeriodicalIssue">
    <xsl:if test="string-length(@volume) > 0">
      <xsl:text>Vol. </xsl:text><xsl:value-of select="@volume"/>
    </xsl:if>
    <xsl:if test="string-length(@number) > 0">
      <xsl:text> No. </xsl:text><xsl:value-of select="@number"/>
    </xsl:if>
    <xsl:text>, </xsl:text>
  </xsl:template>

  <xsl:template match="PeriodicalDate">
    <xsl:value-of select="./@month"/><xsl:text> </xsl:text><xsl:value-of select="./@year"/><xsl:text>,  </xsl:text>
  </xsl:template>

  <xsl:template match="Publisher">
    <xsl:value-of select="."/><xsl:text>, </xsl:text>
  </xsl:template>


  <xsl:template match="CodeExample">
  <!--
    <br/>
    <center>
    <table border='2'>
    <tr><td bgcolor='DDDDFF'>
    <font face='Courier' size='3' color='black'>
    <b>
    <pre>
       <xsl:value-of select='.' />
    </pre>
    </b>
    </font>
    </td></tr>
    </table>
    </center>
    <br/>
  -->
    <fo:block
	font-family="Courier"
	font-size="8pt"
	font-style="normal"
	font-weight="bold"
	margin-left=".5in"
	margin-right=".5in"
	text-align="left"
	border-color="blue"
	border-style="solid"
	border-width=".1em"
	padding-before="4pt"
	padding-after="4pt"
	padding-left=".25in"
	padding-right=".25in"
	background-color="lightblue"
	white-space-collapse="false"
	white-space-treatment="preserve"
	linefeed-treatment="preserve"
	keep-together.within-page="10"
	>
	<xsl:value-of select="." />
    </fo:block>
  </xsl:template>



  <xsl:template match="Definition" >
      <fo:block font-weight="bold"><xsl:value-of select="./DefName"/></fo:block>
      <fo:block font-weight="normal">
      <xsl:apply-templates select="./DefContent"/>
      </fo:block>
  </xsl:template>


  <xsl:template match="RevisionList" >
    <xsl:apply-templates select="./RevisionEntry" />
  </xsl:template>

  <xsl:template match="RevisionEntry" >
    <fo:table-row>
      <fo:table-cell><fo:block font-style="italic" border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:value-of select="./Version" /></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-style="italic" border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:apply-templates select="./TNDate" mode="MyORG" /></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-style="normal" border-before-style="solid" border-before-width="0.1pt" text-indent=".5em"><xsl:apply-templates select="./VersionComment" /></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-style="normal" border-before-style="solid" border-before-width="0.1pt" text-indent=".5em">
         <xsl:choose>
           <xsl:when test="@revisionMarks='no'">No</xsl:when>
           <xsl:when test="@revisionMarks='yes'">Yes</xsl:when>
           <xsl:otherwise>No</xsl:otherwise>
         </xsl:choose>
      </fo:block></fo:table-cell>

    </fo:table-row>
  </xsl:template>


  <xsl:template match="VersionComment">
    <xsl:apply-templates select="./*" />
  </xsl:template>


</xsl:transform>
