/* REXX Script to create a New_URLs <WEBX_New_URLs_FOLDER> folder on the desktop */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

result = SysIni('USER', 'PM_Workplace:Location', '<WEBX_New_URLs_FOLDER>', 'DELETE:')
if result <> 'ERROR:' then
	SAY '<WEBX_New_URLs_FOLDER> object (New_URLs folder) removed from the USER INI successfully!'

fldrName = 'New_URLs'
destination = '<WEBXURLS>'
If SysSetObjectData('<WEBXURLS>', 'NOTVISIBLE=NO') Then
Do
	If SysCreateObject("WPFolder", fldrName, destination, "CCVIEW=YES;ICONFONT=8.Helv;ALWAYSSORT=YES;DEFAULTSORT=3;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBX_New_URLs_FOLDER>;", "fail") Then
	Do
		rc = SysSetObjectData('<WEBX_New_URLs_FOLDER>', 'ICONFILE=' || DIRECTORY() || '\Icons\NETF.ICO;ICONNFILE=1,' || DIRECTORY() || '\Icons\NETFOP.ICO')
		rc = SysSaveObject('<WEBX_New_URLs_FOLDER>', 0)
		Say 'Created the New_URLs folder'
	End
	Else
	Do
		Say 'Could not create the folder.  Does it exist still?'
		Say 'Maybe the My_URLs folder doesn''t exist...'
		Say 'If not, try running FIX-FOLD.CMD after deleting all the folders'
		Say 'created by Ini2URLs.  (Then reinstall)'
		Say ' '
		Say 'If this still does not work, email jroepcke@compusmart.ab.ca'
		Say 'for free support.'
		Exit
	End
End
Else
Do
	SAY 'The My_URLs folder doesn''t exist.  Either you haven''t run the'
	SAY 'install program yet, or you have and need to run My_URLs.cmd'
	SAY 'to reinstall the My_URLs folder.'
	Exit
End
Exit