/* REXX Script to convert EXPLORE.INI to WebExplorer_Url objects */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'RCSLoadFuncs', 'RCSTools', 'RCSLoadFuncs'
call RCSLoadFuncs

found = 'false'
call SysQueryClassList "list."
do i = 1 to list.0
		if left(list.i, 15) = "WebExplorer_Url" Then do
			found = 'true'
			Say 'Found the WebExplorer_Url object class in the WPS Object registy'
		End
	if found = 'true' then
		Leave
End
           
if found = 'false' then do
	Say 'The WebExplorer_Url object class is not registered with the'
	Say 'Workplace Shell.  This program cannot continue.  You might want to'
	Say 'reinstall WebExplorer 1.03 or later...'
	Say 'email jroepcke@compusmart.ab.ca for free support.'
	Exit
end

If SysSetObjectData("<WEBXURLS>", "NOTVISIBLE=NO") Then
Do
	Say 'I found your URLs folder and can continue.'
	rc = SysOpenObject("<WEBXURLS>", "Icon", 1)
End
Else
Do
	Say 'Could not find your URLs folder.  You should run install.cmd.'
	Say 'email jroepcke@compusmart.ab.ca for free support if problems persist.'
	Exit
End

destination = '<WEBXURLS>'
homedest = destination
fspec = ''
urlname = ''
urlaref = ''

/* if there is a <WEBX_New_URLs_FOLDER> then do the Update. */
If SysSetObjectData("<WEBX_New_URLs_FOLDER>", "NOTVISIBLE=NO") Then
Do
	fspec = SysSearchPath('ETC', 'Explore.Ini')

	if fspec = '' Then
	Do
		SAY 'I cannot find your EXPLORE.INI file.  It should be in the directory'
		SAY 'pointed to by the ETC enviroment variable.  I cannot continue...'
		Exit
	End
	rc = stream(fspec, 'c', 'open read')
	if rc <> 'READY:' then do
		Say 'But I cannot open Explore.Ini.  Terminating...'
		Exit
	End
	fldrPath = RCSGetObjectPath('<WEBX_New_URLs_FOLDER>')
	if fldrPath = 'ERROR:' then
	do
		SAY 'I was unable to locate your New_URLs folder, even though it'
		SAY 'should exist (I found the objectID).  Run New_URLs.cmd to'
		SAY 'recreate the New_URLs folder and then rerun Ini2URLs.'
		Exit
	end
	if SysGetEA(fldrPath, '.longname', 'LONGNAMEINFO') <> 0 then
	Do
		SAY 'I wasn''t able to determine the .longname of the New_URLs folder'
		SAY 'I will use the filename for the title instead.'
		New_URLs_Line = FILESPEC('name', fldrPath)
	End
	Else
	do
		parse var longnameinfo 5 New_URLs_Line
	end
	New_URLs_Line = TRANSLATE(New_URLs_Line, ' ', '_')
	Say 'I found your New_URLs folder and will do a synchronize...'
	rc = SysOpenObject("<WEBX_New_URLs_FOLDER>", "Icon", 1)
	lineread = ''
	FoundNewURLs = 1
	DO WHILE (lineread <> 'quicklist= ____' || New_URLs_Line || '____') & (lineread <> 'quicklist= ____New URLs____') & (lineread <> 'quicklist= ____New_URLs____')
		if stream(fspec, 's') = 'READY' Then
			lineread = LINEIN(fspec)
		else
		do
			FoundNewURLs = 0
			Leave
		end
	END
	If FoundNewURLs = 0 Then
	Do
		SAY 'I couldn''t find the ' || 'quicklist= ____' || New_URLs_Line || '____'
		SAY 'line in your EXPLORE.INI [quicklist] section.  I cannot continue'
		SAY 'with the synchronization.  Manually add these two lines to the'
		SAY 'end of the quicklist in ' || fspec
		SAY ' '
		SAY 'quicklist= ____' || New_URLs_Line || '____'
		SAY 'http://dummy.ini2urls.NewURLsFolder'
		SAY ' '
		SAY 'and then re-run Ini2URLs.'
		theresult = stream(fspec, 'c', 'close')
		Exit
	End
	templine = LINEIN(fspec)
	destination = '<WEBX_New_URLs_FOLDER>'
	DO WHILE stream(fspec, 's') = 'READY'
		lineread = ''
		urlname = ''
		urlaref = ''
		tempstring = LINEIN(fspec)
		if tempstring = '' then
			Leave
		urlaref = LINEIN(fspec)	
		if urlaref = '' then
			Leave
		If LEFT(urlaref, 21) <> 'http://dummy.ini2urls' Then Do
			urlname = SUBSTR(tempstring, 12, length(tempstring) - 11)
			urlname = TRANSLATE(urlname, '_', '*') /* I imagine this is a bad one! */
			urlname = TRANSLATE(urlname, '_', '?') /* I imagine this is a bad one! */
			urlname = STRIP(urlname, 'B', '_')
			urlname = STRIP(urlname, 'B', '+')
			urlname = STRIP(urlname, 'B', '-')
			urlname = STRIP(urlname, 'B', '=')
			urlname = SPACE(urlname, 1, '_')
			If SysCreateObject("WebExplorer_Url", urlname, destination, "LOCATOR=" || urlaref, "update") Then
				Say 'Successfully Created the object for ' || urlname
			Else
				Say 'Failure creating object for ' || urlname
		End
		Else
		Do
			urlname = SUBSTR(tempstring, 12, length(tempstring) - 11)
			urlname = TRANSLATE(urlname, '_', '*') /* I imagine this is a bad one! */
			urlname = TRANSLATE(urlname, '_', '?') /* I imagine this is a bad one! */
			urlname = STRIP(urlname, 'B', '_')
			urlname = STRIP(urlname, 'B', '+')
			urlname = STRIP(urlname, 'B', '-')
			urlname = STRIP(urlname, 'B', '=')
			urlname = SPACE(urlname, 1, '_')
			If SysSetObjectData("<WEBX_" || urlname || "_FOLDER>", "NOTVISIBLE=NO") Then
			Do
				Say 'Successfully Located the folder for ' || urlname
				destination = "<WEBX_" || urlname || "_FOLDER>"
			End
			Else
			Do
				If SysCreateObject("WPFolder", urlname, homedest, "CCVIEW=YES;ICONFONT=8.Helv;ALWAYSSORT=YES;DEFAULTSORT=3;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBX_" || urlname || "_FOLDER>", "update") Then
				Do
					rc = SysSetObjectData("<WEBX_" || urlname || "_FOLDER>", 'ICONFILE=' || DIRECTORY() || '\Icons\NETF.ICO;ICONNFILE=1,' || DIRECTORY() || '\Icons\NETFOP.ICO')
					rc = SysSaveObject("<WEBX_" || urlname || "_FOLDER>", 0)
					Say 'Successfully Created the folder for ' || urlname
					destination = "<WEBX_" || urlname || "_FOLDER>"
				End
				Else
				Do
					Say 'Failure creating/updating object for ' || urlname
					Say 'Try running FIX-FOLD.CMD after deleting ALL of the URL Folders,'
					Say 'the New_URLs folder and the My_URLs folder.. (move your URL objects'
					SAY 'to a safe location in the mean time)'
				End
			End
		End		
	End
End
Else /* else do the full extract, setup New_URLs folder and EXPLORE.INI */
Do
	destination = '<WEBXURLS>'
	fspec = SysSearchPath('ETC', 'Explore.Ini')

	if fspec = '' Then
	Do
		SAY 'I cannot find your EXPLORE.INI file.  It should be in the directory'
		SAY 'pointed to by the ETC enviroment variable.  I cannot continue...'
		Exit
	End
	bakfspec = left(fspec, length(fspec) - 3) || 'BAK'
	SAY 'I''m making a backup of your EXPLORE.INI (EXPLORE.BAK)'
	'copy ' || fspec || ' ' || bakfspec
	if rc = 0 then
		SAY 'Backup Successful...'
	Else
		SAY 'Backup could not be completed...'
	rc = stream(fspec, 'c', 'open read')
	if rc <> 'READY:' then
	do
		Say 'But I cannot open Explore.Ini.  Terminating...'
		Exit
	End
	/* Create the new EXPLORE.INI with the New_URLs folder */
	linenum = 0
	explore.0 = 0
	i = 0
	addNewURLs = 1
	DO WHILE stream(fspec, 's') = 'READY'
		i = i + 1
		lineread = LINEIN(fspec)
		explore.i = lineread
		explore.0 = explore.0 + 1
		if (explore.i = 'quicklist= ____New_URLs____') | (explore.i = 'quicklist= ____New URLs____') then
		do
			addNewURLs = 0
			Leave
		end
	end
	theresult = stream(fspec, 'c' 'close')
	if addNewURLs = 1 then
	do
		quicklistline = -1
		do i=linenum to explore.0
			If STRIP(explore.i, 'T') = '[quicklist]' then
			do
				quicklistline = i
				Leave
			end
		end
		if quicklistline = -1 then
		do
			Say 'I Couldn''t find the [quicklist] section in your current'
			Say 'Explore.Ini.  Terminating...'
			Exit
		end
		blankline = explore.0
		Do i=quicklistline + 1 to explore.0 /* find a blank line */
			If STRIP(explore.i, 'B') = '' then
			do
				blankline = i
				Leave
			end
		end
		/* Now write out the new EXPLORE.INI */
		rc = stream(fspec, 'c', 'open write')
		if rc <> 'READY:' then
		do
			Say 'I cannot open the EXPLORE.INI file to update it.  Terminating...'
			Exit
		End
		rc = LINEOUT(fspec,,1) /* sets the filepos to beginning of file */
		do i=1 to (blankline - 1)
			rc = LINEOUT(fspec, explore.i)
		end
		/* write out the New_URLs folder quicklist entry here */
		rc = LINEOUT(fspec, 'quicklist= ____New URLs____')
		rc = LINEOUT(fspec, 'http://dummy.ini2urls.NewURLs')
		if blankline < explore.0 then
		do
			do i=blankline to explore.0
				rc = LINEOUT(fspec, explore.i)
			end
		end	
		theresult = stream(fspec, 'c' 'close')
	end
	/* done Creating the new EXPLORE.INI with the New_URLs folder */

	rc = stream(fspec, 'c', 'open read')
	if rc <> 'READY:' then do
		Say 'But I cannot open Explore.Ini (to read).  Terminating...'
		Exit
	End
	Say 'I will now create URL objects for each entry in your quicklist...'
	DO WHILE lineread <> '[quicklist]'
		if stream(fspec, 's') = 'READY' Then
			lineread = LINEIN(fspec)
		else
			Leave
	END
	DO WHILE stream(fspec, 's') = 'READY'
		lineread = ''
		urlname = ''
		urlaref = ''
		tempstring = LINEIN(fspec)
		if tempstring = '' then
			Leave
		urlaref = LINEIN(fspec)	
		if urlaref = '' then
			Leave
		If LEFT(urlaref, 21) <> 'http://dummy.ini2urls' Then Do
			urlname = SUBSTR(tempstring, 12, length(tempstring) - 11)
			urlname = TRANSLATE(urlname, '_', '*') /* I imagine this is a bad one! */
			urlname = TRANSLATE(urlname, '_', '?') /* I imagine this is a bad one! */
			urlname = STRIP(urlname, 'B', '_')
			urlname = STRIP(urlname, 'B', '+')
			urlname = STRIP(urlname, 'B', '-')
			urlname = STRIP(urlname, 'B', '=')
			urlname = SPACE(urlname, 1, '_')
			If SysCreateObject("WebExplorer_Url", urlname, destination, "LOCATOR=" || urlaref, "update") Then
				Say 'Successfully Created the object for ' || urlname
			Else
				Say 'Failure creating object for ' || urlname
		End
		Else
		Do
			urlname = SUBSTR(tempstring, 12, length(tempstring) - 11)
			urlname = TRANSLATE(urlname, '_', '*') /* I imagine this is a bad one! */
			urlname = TRANSLATE(urlname, '_', '?') /* I imagine this is a bad one! */
			urlname = STRIP(urlname, 'B', '_')
			urlname = STRIP(urlname, 'B', '+')
			urlname = STRIP(urlname, 'B', '-')
			urlname = STRIP(urlname, 'B', '=')
			urlname = SPACE(urlname, 1, '_')
			If SysSetObjectData("<WEBX_" || urlname || "_FOLDER>", "NOTVISIBLE=NO") Then
			Do
				Say 'Successfully Located the folder for ' || urlname
				destination = "<WEBX_" || urlname || "_FOLDER>"
			End
			Else
			Do
				If SysCreateObject("WPFolder", urlname, homedest, "CCVIEW=YES;ICONFONT=8.Helv;ALWAYSSORT=YES;DEFAULTSORT=3;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBX_" || urlname || "_FOLDER>", "update") Then
				Do
					rc = SysSetObjectData("<WEBX_" || urlname || "_FOLDER>", 'ICONFILE=' || DIRECTORY() || '\Icons\NETF.ICO;ICONNFILE=1,' || DIRECTORY() || '\Icons\NETFOP.ICO')
					rc = SysSaveObject("<WEBX_" || urlname || "_FOLDER>", 0)
					Say 'Successfully Created the folder for ' || urlname
					destination = "<WEBX_" || urlname || "_FOLDER>"
				End
				Else
				Do
					Say 'Failure creating/updating object for ' || urlname
					Say 'Try running FIX-FOLD.CMD after deleting ALL of the URL Folders,'
					Say 'the New_URLs folder and the My_URLs folder.. (move your URL objects'
					SAY 'to a safe location in the mean time)'
				End
			End
		End		
	End
	if SysCreateObject("WPProgram", "URLs2Ini", "<WEBXURLS>", "NOAUTOCLOSE=YES;EXENAME=" || DIRECTORY() || "\URLS2INI.CMD;STARTUPDIR=" || DIRECTORY() ||";", "replace") Then
		Say 'Created the URLs2Ini program object in your My_URLs folder'
	else do
		Say 'Failed to create the URLs2Ini program object in your My_URLs folder'
	end
	if SysCreateObject("WPProgram", "Make a new URL Folder", "<WEBXURLS>", "NOAUTOCLOSE=YES;EXENAME=" || DIRECTORY() || "\NEW_FOLD.CMD;STARTUPDIR=" || DIRECTORY() ||";", "replace") Then
		Say 'Created the `Make a new URL Folder` program object in your My_URLs folder'
	else do
		Say 'Failed to create the `Make a new URL Folder` program object in your My_URLs folder'
	end
End
theresult = stream(fspec, 'c' 'close')
Say 'Finished the conversion!  Happy surfing!'
Exit	
