/* REXX Script to fix OS2.INI's PM_Workplace:Location group for Ini2URLs */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

result = SysIni('USER', 'PM_Workplace:Location', '<WEBXURLS>', 'DELETE:')
if result <> 'ERROR:' then
	SAY '<WEBXURLS> object (My_URLs folder) removed from the USER INI successfully!'
else do
	SAY '<WEBXURLS> object (My_URLs folder) could not not be removed from the USER INI...'
	SAY 'Either it does not exist (in which case, reinstall), or there is a problem.'
	SAY 'The Ini2URLs install.cmd program may not be able to recreate the URLs Folder'
	SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support'
end
result = SysIni('USER', 'PM_Workplace:Location', 'ALL:', 'Keys')
if result <> 'ERROR:' then do
	Say 'I just queried the contents of the PM_Worklace:Location group in the USER INI'
	do j=1 to Keys.0
		if (left(Keys.j, 6) = '<WEBX_') & (right(Keys.j, 8) = '_FOLDER>') then do
			result = SysIni('USER', 'PM_Workplace:Location', Keys.j, 'DELETE:')
			if result <> 'ERROR:' then do
				SAY Keys.j || ' object ' || SUBSTR(Keys.j, 7 , length(Keys.j) - 14)
				SAY 'removed from the USER INI successfully!'
			end
			else do
				SAY Keys.j || ' object ' || SUBSTR(Keys.j, 7 , length(Keys.j) - 14)
				SAY 'could not be removed from the USER INI... '
				SAY SUBSTR(Keys.j, 7 , length(Keys.j) - 14) || 'may not be recreated properly'
				SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support'
			end
		end
	end
end
else
do
	SAY 'I was not able to query the contents of the PM_Workplace:Location group in the'
	SAY 'USER INI file.  I can not guarantee that any old URL folders were removed properly'
	SAY 'by OS/2 (or this maintenance script)'
	SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
end