/* 
 * @(#)src/contract/jvm/pfm/jniproto_md.h, ibmip, xo131, 20011109 1.6
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * IBM Java(tm)2 SDK, Standard Edition, v 1.2 
 *
 * (C) Copyright IBM Corp. 1999 All Rights Reserved.
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 009653  080800 hdngmr  Added XJNICALL definition.
 * 024375  150900 hdrs    Removed dllimport for non-IBM usage
 * 031814  010604 stjones UNDEF JNIEXPORT only if it exists
 * ===========================================================================
 */
 
/* 
 * Define JNI prototype macros. This module was created for 
 * defect 91 because of the difficulties getting VisualAge to
 * accept JNIEXPORT in prototypes on Windows NT.
 * This module is simpler for Visual C++ since JNIEXPORT can
 * be the same for prototypes and definitions.
 *
 */

/*
 * JNIEXPORT_PROTOTYPE should be used in place of JNIEXPORT when 
 * prototyping a JNI function, whereas JNIEXPORT should be used for
 * the actual function definition itself. Then VisualAge is happy.
 */
#ifndef JNIEXPORT_PROTOTYPE
#define JNIEXPORT_PROTOTYPE 
#endif

/*
 *  Define PROTOTYPE_JNI_ONLY before including a header that has
 *  JNIEXPORT (instead of JNIEXPORT_PROTOTYPE) for prototypes, eg as
 *  generated by javah. 
 *  After including the file(s), undefine PROTOTYPE_JNI_ONLY and 
 *  include this header again.
 */
#if defined(JNIEXPORT)
#undef JNIEXPORT
#endif

#if defined(PROTOTYPE_JNI_ONLY)
#define JNIEXPORT
#else
#define JNIEXPORT __declspec(dllexport)
#endif


#ifndef JNIIMPORT
#if defined(__IBM_INTERNAL_LINKAGE)
#define JNIIMPORT __declspec(dllimport)
#else
/* dllimport is not defined by earlier versions of VisualAge compilers
 * ibm@24375
 */
#define JNIIMPORT
#endif
#endif

#ifndef JNICALL
#define JNICALL _System
#endif

#ifndef XJNICALL
#define XJNICALL _System
#endif

/* END OF FILE jniproto_md.h */
