/*****************************************************************************/
/* Lotus 1-2-3 For OS/2 sample @function. 											  */
/* 																								  */
/* @REXX("REXXABRV.CMD",word,range,minLength)                                */
/* 																								  */
/* Returns 1 if 'word' is an abbreviation of a word in 'range', returns 0 if */
/* not.																							  */
/* 																								  */
/* @REXX("REXXABRV.CMD logFileName",word,range,minLength)                    */
/* 																								  */
/* Writes any TRACE or SAY output to a log file named 'logFileName'.         */
/* 																								  */
/* Copyright (c) 1991 Lotus Development Corporation.	This code is supplied  */
/* on an 'as is' basis as an example only.  This code has only received      */
/* informal testing by Lotus.  Permission is granted	to copy and modify	  */
/* this code to your heart's content.  No warrenties expressed or implied.   */
/* Remember, your mileage may vary.  Let us know if you find support of REXX */
/* by 1-2-3 useful.																			  */
/*****************************************************************************/
TRACE R
PARSE ARG word, field, minimum
IF word = "?" THEN SIGNAL Tell    /* give info if called with "?" as 1st arg */
IF field <> "RANGE1" THEN SIGNAL Tell        /* expecting a range as 2nd arg */
IF minimum = "" THEN minimum = 1         /* set default minimum abbreviation */
DO i = 1 TO range1.0 					  /* loop through the cells of the range */
	IF Abbrev(range1.i, word, minimum) = 1 THEN RETURN 1
	END
RETURN 0 														 /* no abbreviation found */

Tell: 													  /* return a brief description */
RETURN '@REXX("REXXABRV.CMD",word,range,minLength) ==> returns 1 if' ,
	"'word' is an abbreviation of a word in 'range'."
