# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Given a config-file path and a host name, we extract the info from the file #
# and  save it is @cfg.  We also look for a few specific lines and save their #
# data in some other global arrays.                                           #
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Read the config file for a host.
sub cfgload {
	local($cfile,$host) = @_;
	local($line);
	@cfg = ();
	unless (open(CFG,$cfile)) {
		print V "$P: Can't read config file \"$cfile\" ($!)\n" if $V>1;
		return undef;
	}
	print V "$P: Reading config info from \"$cfile\"\n" if $V>1;
	for $line (<CFG>) {
		$line =~ s/[\s\r]+$//;
		if ($line =~ /^[+0-9]*\s*(C:)\s*(.*)/) {
			$Getcmd{"$1$host"} = $2;
			print V "$P: Get command \"$2\" for $h (from cfg file)\n" if $V>1;
		} elsif ($line =~ /^[+0-9]*\s*(L:)\s*(\d+)/) {
			$maxlines = $2;
			print V "$P: maxlines=$maxlines for $h (from cfg file)\n" if $V>1;
		} else {
			print V "$P: Config line \"$line\" not matched.\n" if $V>1;
		}
		push @cfg, $line;
	}
	close CFG;
	return 1;
}
1;
