/*
 * Psych0's Astrology Tool
 * (k) 1998, 1999 by Andrew Ziem <ziem@iex.net>
 * http://members.xoom.com/sdexter/psoft/
 *
 */


#include "getseg.c"


int locate_token(char *find, char **strarr, int objects)
{
 int i;


 for (i = 0; i <= objects - 1; i++)
 {
    if (stristr(find, strarr[i]))
      return i;
 }

 return -1;
} /* locate_token() */



int CompChart(const void *C1, const void *C2)
{
    int RetVal = 0;


    if (SortFieldType == SORT_TYPE_NUMEROLOGY)
    {
       RetVal = numerologize_bday(((CHART *) C2)->born.mday, ((CHART *) C2)->born.month, ((CHART *) C2)->born.year, TRUE) -
		numerologize_bday(((CHART *) C1)->born.mday, ((CHART *) C1)->born.month, ((CHART *) C1)->born.year, TRUE);

       if (RetVal == 0)
       {
	   RetVal = numerologize_bday(((CHART *) C2)->born.mday, ((CHART *) C2)->born.month, ((CHART *) C2)->born.year, FALSE) -
		    numerologize_bday(((CHART *) C1)->born.mday, ((CHART *) C1)->born.month, ((CHART *) C1)->born.year, FALSE);

	  /* sort by secondary number */
       }
    }
#ifdef SORT_YMD
    else
    if (SortFieldType == SORT_TYPE_YMD)
    {
       RetVal = ((CHART *) C2)->year -
                ((CHART *) C1)->year;

       if (RetVal == 0)
       {
          RetVal = ((CHART *) C2)->month -
                   ((CHART *) C1)->month;
       }

       if (RetVal == 0)
       {
          RetVal = ((CHART *) C2)->mday -
                   ((CHART *) C1)->mday;
       }
    }
#endif
    else
    if (SortFieldType == SORT_TYPE_CHINESE)
    {

    }
    else
    if (SortFieldType != SORT_TYPE_NAME && SortFieldType != SORT_TYPE_NUMEROLOGY)
    {
       RetVal = ((CHART *) C2)->planet[SortFieldBody].degrees -
                ((CHART *) C1)->planet[SortFieldBody].degrees;

       if (RetVal == 0)
       {
          RetVal = ((CHART *) C2)->planet[SortFieldBody].minutes -
                   ((CHART *) C1)->planet[SortFieldBody].minutes;
       }

    }

    if (0 == RetVal && SortFieldType == SORT_TYPE_DOUBLE)
    {
       RetVal = ((CHART *) C2)->planet[SortFieldBodySecondary].degrees -
		((CHART *) C1)->planet[SortFieldBodySecondary].degrees;

       if (RetVal == 0)
       {
	  RetVal = ((CHART *) C2)->planet[SortFieldBodySecondary].minutes -
		   ((CHART *) C1)->planet[SortFieldBodySecondary].minutes;
       }

    }

    if (RetVal == 0)
       RetVal = stricmp(((CHART *) C2)->name, ((CHART *) C1)->name);

    CompareResult = RetVal;

    /*  Return a 'match' (0) if the item in the list is 'larger' than the
	new data.
    */
    return RetVal >= 0 ? 0 : 1 ;
} /* CompChart() */


int sort_data(int type, int body1, int body2)
{
   CHART c;
   int ListSort;


   SortFieldType = type;
   if (type == SORT_TYPE_BYSIGN || type == SORT_TYPE_DOUBLE)
   {
      SortFieldBody = body1;
   }

   if (type == SORT_TYPE_DOUBLE)
   {
      SortFieldBodySecondary = body2;
   }

   ListSort = LLScreate(SIZEOF_CHART);
   if (ListSort == ERR_MEMORY)
   {
      fprintf(stderr, "error: unable to initilize linked list for sorting (memory error)\n");
      return FALSE;
   }

   LLSnodePtr2First(ListCharts);

   do
   {

      LLSnodeDataTo(ListCharts, &c);
      LLSnodePtr2First(ListSort);
      LLSnodeFind(ListSort, CompChart, &c);
      if (0 <= CompareResult)
	     LLSnodeInsertFrom(ListSort, &c);
      else
	     LLSnodeAddFrom(ListSort, &c);

   } while (LLSnodePtr2Next(ListCharts));

  LLSdelete(ListCharts);
  ListCharts = ListSort;

  return TRUE;
} /* sort_data() */


void usage(void)
{
 printf("Psych0Soft -- " MY_WWW "\n");
 printf("\n");
 printf("usage:  " EXECUTABLE_NAME " [-?] [-i] [-r[cd] <infiles>] [-w[cdnps] <outfile>]\n");
 printf("\n");
 printf("   -?:    information               -wc:   write Sun/Moon combonation report\n");
 printf("   -i:    interactive mode          -wd:   write data\n");
 printf("   -rc:   read Astrolog chart       -wn:   write numerological report\n");
 printf("   -rd:   read data                 -wp:   write plain text\n");
 printf("                                    -ws:   write sign-sorted text\n");

 exit(EXIT_SUCCESS);

} /* usage() */


void exitfunc(void)
{
  /* destroy */
  if (charts)
  {
     LLSdelete(ListCharts);
     charts = 0;
  }
} /* exitfunc() */

int numerologize_int(int n)
{
   int i = 0, x;
   char s[10];


   n = abs(n);


   if (n > 9)
   {
      sprintf(s, "%i", n);

//      printf("debug: go (%s)\n", s);

      /*
	 01234
	 23
	 strlen(2)
	 */

      for (x = 0; x < strlen(s); x++)
      {
	 i = i + (s[x] - 48);
//	 printf("debug: i(x%i) = %i\n", x, i);
      }

      return i;
   }
   else
   {
      return n;
   }



}


int numerologize_bday(int day, int month, int year, int primary)
{
   int t = 0;


   t = numerologize_int(day) + numerologize_int(month) + numerologize_int(year);

   if (primary)
   {
      t = numerologize_int(t);
   }

   return t;

}



char *last_name(char *full_name)
{
   char *ptr, *old;


   /* "andy de ziem" */

   ptr = strchr(full_name, ' ');

   if (!ptr)
   {
      return full_name;
   }

   ptr++;

   do
   {
      old = ptr;
      ptr = strchr(ptr, ' ');
//      printf("ptr=%s\n", ptr);
      if (NULL == ptr)
      {
         ptr = old;
         break;
      }
      ptr++;
   } while(TRUE);


   return ptr;





}


#define LL_LATITUDE   0
#define LL_LONGITUDE  1

char *latlong(int deg, int min, int ll)
{
   static char st_ll[16]; /* don't want to pass a transient variable */
   char ch;


   switch(ll)
   {
      case LL_LATITUDE:

        if (deg < 0)
           ch = 'S';
        else
           ch = 'N';
        break;

      case LL_LONGITUDE:

        if (deg < 0 /* && c.born.longitude_minutes < 0 */)
           ch = 'W';
        else
           ch = 'E';
        break;
       
   }

   sprintf(st_ll, "%3i:%2i%c", abs(deg), min, ch);

   return st_ll;


}

int chinese_zodiac_year(int year, int month, int mday)
{
   int r;


   r = (year - 1516) % 12;

   if (month < 3)
   {
      --r;
   }

   r++;


   return r;
}


char *str_to_fn(char *fn)
{
  static char stf[12]; /* don't want to pass a transient variable */
  int i;

  strncpy(stf, fn, 8);

  for (i = 0; i < strlen(stf); i++)
  {
     if (' ' == stf[i])
     {
         stf[i] = '_';
     }

  }

  return stf;

}


int clear_chart(CHART *c)
{
  int y;


  for (y = 0; y < BODIES; y++)
  {
      c->planet[y].sign = c->planet[y].degrees = c->planet[y].minutes = 0;
  }

  c->born.mday = c->born.month = c->born.year = 0;
  c->born.hour = c->born.minutes = c->born.timezone = 0;
  c->born.daylightsavings = c->born.timezone_minutes = 0;
  c->born.longitude = c->born.latitude = 0;
  c->born.longitude_minutes = c->born.latitude_minutes = 0;
  c->born.location[0] = c->name[0] = NUL;

  return TRUE;

}