

/* get a segment of a string w/ a definable seperator */
/* note: if the seperator is a space (' '), double spaces ('  ') will
	 be counted as two.  ?comprende? */
char *get_seg(const char *line, int piece, char seperator)
{
  static char st_str[128]; /* don't want to pass a transient variable */
  char *pstr;
  int i = piece;


  if (line == NULL)
    return NULL;

  strcpy(st_str, line);

  pstr = st_str;

  while (i > 1 && pstr != NULL)
  {
     pstr = strchr(pstr, seperator);
     if (NULL == pstr)
          return NULL;
     pstr++;
     if (pstr[0] != seperator) /* don't allow two in a row to count for more */
          i--;                 /* than one */
  }

  if (strchr(pstr, seperator))
     pstr[strchr(pstr, seperator) - pstr] = NUL;

  return (char *) pstr;
} /* get_seg() */
