/*****************************************************************************/
/* YDAYSEUR.CMD (Version 1.04; __European Date: DD.MM.YYYY__).               */
/*              Program to demonstrate the use of WARPNOTE                   */
/*              in connection with WARPNOTE Command.                         */
/* (C) of YDAYSEUR.CMD: 1999 Bernd Hagebck, Hermann-Hesse-Strasse 15,       */
/*        52353 Dren, Germany, bernd.hageboeck@t-online.de;                 */
/* (C) of PROCEDURES DoW and the part 'cumdays.??' of variable DayNr:        */
/*        1995 Sublime Software;                                             */
/* (C) of WARPNOTE and WARPNOTE Command: 1998 Uwe Schlenther Software,       */
/*        Bebelstrasse 30, 70193 Stuttgart, Germany.                         */
/*****************************************************************************/
/* YDAYSEUR.CMD displays on screen the days of the year of the textfile      */
/* YDAYSEUR.TXT in a window of WARPNOTE. The special effects are:            */
/* 1. it displays not only the days of the current date, but also the days   */
/*    of a changeable range before and after the current date, e.g. 7 days   */
/*    before and 14 days after the current date. The range can vary from 1   */
/*    to 365 days (in leapyears 366 days);                                   */
/* 2. when changing the year, it manages the correct order to display first  */
/*    the days of december and than the days of january, in spite of the     */
/*    fact, that the days in YDAYSEUR.TXT are classified from months 1 to 12;*/
/* 3. the program will compute the anniversary of each date, that has a      */
/*    4-digit-year expression in the year-field of each line in YEARDAYS.TXT,*/
/*    for birthdays etc. (look for the example YDAYSEUR.TXT);                */
/* 4. the program displays the corresponding weekday for each date;          */
/* 5. the program displays the corresponding weeknumber for each date;       */
/* 6. the program stresses the dates of the current date with special lines; */
/* 7. the program changes the hight of the window of WARPNOTE in relation to */
/*    the number of lines, that must be displayed.                           */
/* ------------------------------------------------------------------------- */
/* YDAYSEUR.TXT must be written in a special scheme (formatted) and the      */
/* dates must be already sorted (look for the example).                      */
/* ------------------------------------------------------------------------- */
/*       The program expects _four_ _numeric_ parameters:                    */
/*       MONTHMINUS, MONTHPLUS, DAYMINUS and DAYPLUS.                        */
/*       In addition you have to attend to following rules:                  */
/*       1. MonthMinus+MonthPlus+DayMinus+DayPlus: <= 12 months total,       */
/*       2. DayMinus and DayPlus                 : <= number of days of the  */
/*                                                    correspondig month.    */
/* In any case of incorrect parameters, the program uses                     */
/* DEFAUTS-PARAMETERS: MonthMinus=0, MonthPlus=0, DayMinus=7 and DayPlus=14. */
/* The meanings of the parameters are:                                       */
/* MonthMinus: numbers of months for the range before the current date;      */
/* MonthPlus : numbers of months for the range after the current date;       */
/* DayMinus  : numbers of days for the range before the current date;        */
/* DayPlus   : numbers of days for the range after the current date.         */
/* Example   : the parameters   0 0 7 14   force the program to display only */
/*             dates 7 days before and 14 days after the current date.       */
/* ------------------------------------------------------------------------- */
/* FONT FOR DISPLAY: 5.System VIO. The window of WARPNOTE is created with    */
/* 110 columns and should be _without_ title-bar.                            */
/*****************************************************************************/


/*
  Elemantaries.
*/
InFile="YDAYSEUR.TXT"
Nr=100
OutFile="NOTE"Nr".TXT"
"del "OutFile
"del Note"Nr
"wncomm wait"      /* Wait for WARPNOTE startup */
"wncomm delete "Nr /* Delete a previous instance of the note */
OutLineNr=1        /* Number of lines, displayed in the window of WARPNOTE */
Weekday.0='Mo'     /* German abbreviations for variable 'Weekday.DowIdx' */
Weekday.1='Di'
Weekday.2='Mi'
Weekday.3='Do'
Weekday.4='Fr'
Weekday.5='Sa'
Weekday.6='So'
MonthDays.1=31     /* Days of Month for variable 'Monthdays.Month??' */
MonthDays.2=29
MonthDays.3=31
MonthDays.4=30
MonthDays.5=31
MonthDays.6=30
MonthDays.7=31
MonthDays.8=31
MonthDays.9=30
MonthDays.10=31
MonthDays.11=30
MonthDays.12=31
cumDays.1=0        /* Cummulated days in a year (see procedure 'NoW') */
cumDays.2=31
cumDays.3=59
cumDays.4=90
cumDays.5=120
cumDays.6=151
cumDays.7=181
cumDays.8=212
cumDays.9=243
cumDays.10=273
cumDays.11=304
cumDays.12=334
Remainder.0=0/7    /* Remainders (see procedure 'NoW') */
Remainder.1=1/7
Remainder.2=2/7
Remainder.3=3/7
Remainder.4=4/7
Remainder.5=5/7
Remainder.6=6/7


/*
  Values of current date. Leading 0's of 'Month' and 'Day' are stripped.
*/
Today=DATE("S")
parse var Today Year 5 Month 7 Day
Day=Day+1-1
Month=Month+1-1
call LoopSet Year+1
LastWeekNr=LastWeekNo
Yeardays=365+LeapYear
call LoopSet Year
call DoW Day,Month,YearOfLoop
WeekDay=Weekday.DowIdx
call NoW Day,Month,YearOfLoop,DowIdx,DowIdx0
WeekNr=WeekNo


/*
  Error correction for parameters
*/
ARG MonthMinus Monthplus DayMinus DayPlus
call ErrorCorrection


/*
  Display of leapyear, if month "2" is in range of display.
*/
select
  when yeardays1=366 & month1<=2 then
    YearL="   Februar "Year1" = 29 Tage."
  when yeardays=366 & month1=2 then
    YearL="   Februar "Year" = 29 Tage."
  when yeardays2=366 & month1>=2 then
    YearL="   Februar "Year2" = 29 Tage."
  otherwise
    YearL=""
end


/*
  Title-lines of the window of WARPNOTE.
*/
call LINEOUT OutFile,CENTER("JAHRESTERMINE von "Weekday1", "RIGHT(Day1,2,"0")"."RIGHT(Month1,2,"0")"."Year1" bis "Weekday2", "RIGHT(Day2,2,"0")"."RIGHT(Month2,2,"0")"."Year2"."YearL,110)
call LINEOUT OutFile,CENTER("HEUTE: "WeekDay", "RIGHT(Day,2,"0")"."RIGHT(Month,2,"0")"."Year"; "DATE("D")". Tag, noch "Yeardays-DATE("D")" Tage; "WeekNr". Woche, noch "LastweekNr-WeekNr" Wochen.",110)
call LINEOUT OutFile,COPIES("-",110)
call LINEOUT OutFile,"TAG  DATUM      WOCHE  "LEFT("EREIGNIS",77)"BEZUGSJAHR"
call LINEOUT OutFile,COPIES("=",110)
OutLineNr=OutLineNr+5


/*
  Search for fitting lines in YEARDAYS.TXT.
*/
DayStress=0
call LoopSet Year1
do while LINES(InFile)
  InLine=LINEIN(InFile)
  if SUBSTR(InLine,1,1)<>":" then do
    call InLineHandling
    if InYear<=Year1 then
      select
        when InMonth=Month1 & Month1=Month2 & Year1=Year2 then
          if InDay>=Day1 & InDay<=Day2 then
            call OutLineHandling
        when InMonth=Month1 then 
          if InDay>=Day1 then
            call OutLineHandling
        when InMonth>Month1 & Year1<>Year2 then
          call OutLineHandling
        otherwise
          nop
      end
  end
end
if Month1<>Month2 | Year1<>Year2 then do
  call LoopSet Year2
  do while LINES(InFile)
    InLine=LINEIN(InFile)
    if SUBSTR(InLine,1,1)<>":" then do
      call InLineHandling
      if InMonth>Month2 then leave
      if InYear<=Year2 then
        select
          when InMonth=Month2 then
            if InDay<=Day2 then
              call OutLineHandling
          when InMonth>Month1 | Year1<>Year2 then
            call OutLineHandling
          otherwise
            nop
        end
    end
  end
end


/*
  WINDOW OF WARPNOTE:
  DesktopX and DesktopY are on my system 800x600 video display. With 5.System
  VIO as display-font the values _1.185_ (without vertical scrollbar) or _1.16_
  (with vertical scrollbar) as divisor of DesktopX and the value 42 maximum
  lines as divisor of DesktopY create a WINDOW OF WARPNOTE with 110 columns
  (with or without vertical scrollbar) and that number of lines which are
  counted for the output, with a maximum of 42. You may change these values.
*/
call Stress  /* to stress current day, if it is on last line of OutFile */
LINEIN(OutFile,1,0)
"wncomm create "Nr
"wncomm getdesktopx"
DesktopX=rc
"wncomm getdesktopy"
DesktopY=rc
"wncomm setsizexy "Nr DesktopX%1.16 DesktopY/42*MIN(OutLineNr,42)
"wncomm center "Nr
"wncomm load "Nr" "OutFile
"wncomm show "Nr

EXIT


/*
  PROCEDURE: calculation of LeapYear.
  Returns 1, if date specified is a leapyear, 0 otherwise.
*/
IsLeap:
  ARG YearLeap
  LeapYear=((YearLeap//4=0 & YearLeap//100<>0) | YearLeap//400=0)
return

/*
  PROCEDURE: _D_ay _o_f _W_eek. Integer math algorithm to calculate DoW.
  Returns index of weekday, 0 = Monday.
*/
DoW:
  ARG DayDoW,MonthDoW,YearDoW
  if MonthDoW<3 then do
    MonthDoW=MonthDoW+12
    YearDoW=YearDoW-1
  end
  DowIdx=(DayDoW+(2*MonthDoW)+(3*(MonthDoW+1)%5)+YearDoW+(YearDoW%4)-(YearDoW%100)+(YearDoW%400))//7
return

/*
  PROCEDURE: _N_umber _o_f _W_eek: Integer math algorithm to calculate NoW.
  1. NullDayDiff = interval of index of specific weekday ('DowIdx') and index
     of NullDay ('DowIdx0'; see PROCEDURE LoopSet) to compare remainders (see
     Nr. 3; remainders of each week in a year are constant);
  2. DayNr = interval of specific day ('DayNoW') and 'NullDayDiff' plus
     cummulated days of the specific month ('cumDays.MonthNoW'), e.g.
     Jan 1st = 1, Dec 31th = 365 or 366;
  3. WeekNo = integer divide of 'DayNr' with 7; if remainder of 'WeekNo' is
     bigger than remainder of 'NullDayDiff', 'WeekNo' must be increased with 1;
  4. Correction of 'WeekNo' for determing the first week of a year as the first
     week in the year that contains a Thursday.
*/
NoW:
  ARG DayNoW,MonthNoW,YearNoW,DowIdx,DowIdx0
  NullDayDiff=abs(DowIdx-DowIdx0)
  DayNr=abs(DayNoW-NullDayDiff)+cumDays.MonthNoW
  call IsLeap YearNoW
  if MonthNoW>2 then do
    DayNr=DayNr+LeapYear
  end
  WeekNo=DayNr%7+1
  if DayNr//7 > Remainder.NullDayDiff then
    WeekNo=WeekNo+1
  if DowIdx0<2 & WeekNo=53 then
    WeekNo=1
  if DowIdx0>2 then do
    WeekNo=WeekNo-1
    if WeekNo=0 | (WeekNo=53 & YearOfLoop<>Year) then
      WeekNo=LastWeekNo
  end
  WeekNo=FORMAT(WeekNo,2)
return

/*
  PROCEDURE: preparing of loop.
*/
LoopSet:
  ARG YearOfLoop
  call Stress  /* to stress current day, if it is on last line of month */
  call DoW 31,12,YearOfLoop-1
  DowIdx0=DowIdx  /* Index of NullDay of 01.01. of a year */
  LastWeekNo=52
  call NoW 31,12,YearOfLoop-1,DowIdx,DowIdx0
  LastWeekNo=WeekNo  /* last number of week of preceding year */
  OtherYear="  "
  if YearOfLoop<>Year then
    OtherYear=SUBSTR(YearOfLoop,3)
  LINEIN(InFile,1,0)
return

/*
  PROCEDURE: calculation of date-variables 
  'Year1', 'Month1', 'Day1', 'Year2', 'Month2', 'Day2'.
*/
CalcDates:
  Year1=Year
  Month1=Month-MonthMinus
  Day1=Day-DayMinus
  call Month0
  if Day1<1 then do
    Month1=Month1-1
    call Month0
    Day1=Day1+MonthDays.Month1
    if Day1=29&Month1=2&Yeardays1=365 then
      Day1=Day1-1
  end
  call DoW Day1,Month1,Year1
  Weekday1=Weekday.DowIdx
  Year2=Year
  Month2=Month+MonthPlus
  Day2=Day+DayPlus
  call Month13
  if Day2>MonthDays.Month2 then do
    Month2=Month2+1
    call Month13
    Day2=Day2-MonthDays.Month2
    if Month2=2&((Day2>=29&Yeardays2=365)|(Day2>=30&Yeardays2=366)) then do
      Month2=Month2+1
      Day2=Day2-28
    end
  end
  call DoW Day2,Month2,Year2
  Weekday2=Weekday.DowIdx
return

/*
  PROCEDURE: month<1.
*/
Month0:
  if Month1<1 then do
    Month1=Month1+12
    Year1=Year1-1
  end
  call IsLeap Year1
  Yeardays1=365+LeapYear
return

/*
  PROCEDURE: month>12.
*/
Month13:
  if Month2>12 then do
    Month2=Month2-12
    Year2=Year2+1
  end
  call IsLeap Year2
  Yeardays2=365+LeapYear
return

/* 
  PROCEDURE: Error correction for parameters.
*/
ErrorCorrection:
  if MonthMinus<0 | MonthPlus<0 | DayMinus<0 | DayPlus<0 then
    call Message1
  call CalcDates
  if ((MonthMinus+MonthPlus)*30+Yeardays-360+DayMinus+DayPlus)>Yeardays then
    call Message2
  if DayMinus>Monthdays.Month1 | DayPlus>Monthdays.Month2 then
    call Message3
return

/*
  PROCEDURE: error message1.
*/
Message1:
  call LINEOUT OutFile,COPIES("*",110)
  call LINEOUT OutFile,CENTER(CENTER("You forgot, to define 4 (four) numeric parameters.",90),110,"*")
  call Message4
return

/*
  PROCEDURE: error message2.
*/
Message2:
  call LINEOUT OutFile,COPIES("*",110)
  call LINEOUT OutFile,CENTER(CENTER("The range of all parameters extends "Yeardays" days.",90),110,"*")
  call Message4
return

/*
  PROCEDURE: error message3.
*/
Message3:
  call LINEOUT OutFile,COPIES("*",110)
  call LINEOUT OutFile,CENTER(CENTER("'DayMinus' is bigger than the number of days in month "Month1" or",90),110,"*")
  call LINEOUT OutFile,CENTER(CENTER("'DayPlus' is bigger than the number of days in month "Month2".",90),110,"*")
  OutLineNr=OutLineNr+1
  call Message4
return

/*
  PROCEDURE: error message4.
*/
Message4:
  call LINEOUT OutFile,CENTER(CENTER("Please read the program-description! Default-parameters are:",90),110,"*")
  call LINEOUT OutFile,CENTER(CENTER("MonthMinus, MonthPlus, DayMinus, DayPlus",90),110,"*")
  call LINEOUT OutFile,CENTER(CENTER(' "    0          0         7        14  ".',90),110,"*")
  call LINEOUT OutFile,COPIES("*",110)
  MonthMinus=0
  MonthPlus=0
  DayMinus=7
  DayPlus=14
  OutLineNr=OutLineNr+6
  call ErrorCorrection
return

/*
  PROCEDURE: handling of variable 'InLine'.
*/
InLineHandling:
  parse var InLine InDay","InMonth","InYear","InText","InContinue
  InDay=InDay+1-1
  InMonth=InMonth+1-1
return

/*
  PROCEDURE: handling of variable 'OutLine'.
*/
OutLineHandling:
  if DayStress=0 & InDay=Day & InMonth=Month then do
    call LINEOUT OutFile,COPIES("_",110)
    OutLineNr=OutLineNr+1
    DayStress=1
  end
  if InDay>Day then
    call Stress
  OutLine=""
  if DATATYPE(InYear)='NUM' then
    if (YearOfLoop-InYear)>0 then
      OutLine=RIGHT(YearOfLoop-InYear".",4)" ["InYear"]"
  call DoW InDay,InMonth,YearOfLoop
  call NoW InDay,InMonth,YearOfLoop,DowIdx,DowIdx0
  OutLine=Weekday.DowIdx"   "LEFT(RIGHT(InDay,2,"0")"."RIGHT(InMonth,2,"0")"."OtherYear"   "WeekNo"    "SUBSTR(OutLine,1,5)InText,99)SUBSTR(OutLine,6)
  if InContinue<>"" then
    OutLine=COPIES(" ",18)SUBSTR(OutLine,19)
  call LINEOUT OutFile,OutLine
  OutLineNr=OutLineNr+1
return

/*
  PROCEDURE: last line of stressed current day.
*/
Stress:
  if DayStress=1 then do
    call LINEOUT OutFile,COPIES("~",110)
    OutLineNr=OutLineNr+1
    DayStress=2
  end
return

