/************************************************************
 *** OS2: This file contains additional routines          ***
 ***      only needed in the OS/2-version.                ***
 ***                                                      ***
 ***   last modified: 12/01/92                            ***
 ***   Authors:  Thilo Schuster (term@godot.stgt.sub.org) ***
 ***         Herbert Neugebauer (haen@veces.stgt.sub.org) ***
 ***                                                      ***
 ***  please send bug reports to term@godot or haen@veces ***
 ***                                                      ***
 ***  Remark: the things in os2patch.c are used in every  ***
 ***          executable, os2trn.c only in trn            ***
 ************************************************************/

#define OS2_PATCHES_C

#define EABUF 0L

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <pwd.h>
#include "os2patch.h"


/*****************************************************************
 *****                    global variables                    ****
 *****************************************************************/

INFO uupc_rc_settings;

/*****************************************************************
 *****                        functions                       ****
 *****************************************************************/


/***********************************************
 *** the fopen function of EMX/GCC has some  ***
 *** restrictions, (e.g. you cannot open     ***
 ***  one file two times simultaneously).    ***
 *** So we replace the fopen-calls in the    ***
 *** the source by the fos2open-call so we   ***
 *** can do the enhancements here.           ***
 ***********************************************/

/*FILE *fos2open(const char *filename, const char *mode) */
FILE *fblaopen(const char *filename, const char *mode)
{   char newmode[3+1];
    HFILE   FileHandle;
    ULONG   Action;
    unsigned long  rc;              /* Return code */
    ULONG   openflags, shareflags;
 
    Action = 2;
 
    if (*mode == 'r') {
        if (*(mode+1) == '+') {
            openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
            shareflags = OPEN_ACCESS_READWRITE;
        }
        else {
            openflags = OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
            shareflags = OPEN_ACCESS_READONLY;
        }
    }
    else
    if (*mode == 'w') {
        if (*(mode+1) == '+') {
            openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
            shareflags = OPEN_ACCESS_READWRITE;
        }
        else {
            openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS;
            shareflags = OPEN_ACCESS_WRITEONLY;
        }
    }
    else
    if (*mode == 'a') {
        openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
        shareflags = OPEN_SHARE_DENYNONE;
    }
    else
    return NULL;   /*** Error in mode-flags ***/

    shareflags |= OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE;

    rc = DosOpen(filename,                    /* File path name */
                 &FileHandle,                 /* File handle */
                 &Action,                     /* Action taken */
                 0,                           /* File primary allocation */
                 FILE_NORMAL,                 /* File attribute */
                 openflags,                   /* Open function type */
                 shareflags,                  /* Open mode of the file */
                 EABUF);                      /* No extended attributes */
 
    if (rc != 0) return NULL;

    *newmode = '\0';
    strcpy(newmode,mode);
    strcat(newmode,"b");

    return fdopen(FileHandle,mode);
}

FILE *fos2open(const char *filename, const char *mode)
{   char newmode[3+1];

    *newmode = '\0';
    strcpy(newmode,mode);
    strcat(newmode,"b");

    return fopen(filename,newmode);
}


/****************************************************
 **** This function is used to change all '\'    ****
 **** characters to the '/' character. This must ****
 **** must be done to prevent the translation    ****
 **** when sprintf is used to prepare a filename ****
 ****************************************************/

void change_bsl2sl(char *changeString)
{   char *tmpptr;

    if (changeString == NULL) return;
    if (strlen(changeString) == 0) return;

    tmpptr = &(changeString[0]);
    while(*tmpptr != '\0')
    {   if (*tmpptr == '\\') *tmpptr = '/';
        ++tmpptr;
    }
}


/*****************************************************
 **** This function is used to change all '/'     ****
 **** characters to the '\' character. This must  ****
 **** must be done when using a prepared filename ****
 **** together with the OS/2 shell cmd or 4os2,   ****
 **** because these programs do not accept        **** 
 **** with slashes in all conditions.             **** 
 *****************************************************/

void change_sl2bsl(char *changeString)
{   char *tmpptr;

    if (changeString == NULL) return;
    if (strlen(changeString) == 0) return;

    tmpptr = &changeString[0];
    while(*tmpptr != '\0')
    {   if (*tmpptr == '/') *tmpptr = '\\';
        ++tmpptr;
    }
}


/*******************************************************
 **  this function was picked out of the SNews        **
 **  source written by John McCombs, New Zealand      **
 **   <john@ahuriri.gen.nz>. Since the first version  **
 **  most a lot has been rewritten to meet our        **
 **  requirements. The strategy how the information   **
 **  is extracted, is still the same.                 **
 *******************************************************/

int load_uupc_rc(void)
{
    /*
     *  Trawl the UUPC files to get the stuff we need - return TRUE
     *  if completed ok
     */

    int  res = 0;
    int  i;
    char buf[256];
    char *fn, *p, *v;
    FILE *tmp;
    int  set_mail_server = 0, set_site = 0, set_news_dir = 0,
         set_domain = 0, set_temp_name = 0,
         set_mail_dir = 0, set_config_dir = 0, set_user = 0,
         set_signature = 0, set_name = 0, set_organization = 0,
         set_editor = 0, set_home = 0, set_newsadmin = 0,
#ifdef COMPILING_TRN
         set_trnlib = 0,
#endif
#ifdef COMPILING_MTHREADS
         set_mthreadslib = 0,
#endif
         set_locdist = 0, set_orgdist = 0, set_citydist = 0,
         set_statedist = 0, set_countrydist = 0, set_continentdist = 0;

    memset(uupc_rc_settings.temp_name, '\0', MAXLEN);
    memset(uupc_rc_settings.conf_dir, '\0', MAXLEN);
    memset(uupc_rc_settings.news_dir, '\0', MAXLEN);
    memset(uupc_rc_settings.mail_dir, '\0', MAXLEN);
    memset(uupc_rc_settings.mailsent, '\0', MAXLEN);
    memset(uupc_rc_settings.rmailpath, '\0', MAXLEN);
    memset(uupc_rc_settings.active, '\0', MAXLEN);
    memset(uupc_rc_settings.active_times, '\0', MAXLEN);
    memset(uupc_rc_settings.user, '\0', MAXLEN);
    memset(uupc_rc_settings.mailfile, '\0', MAXLEN);
    memset(uupc_rc_settings.name, '\0', MAXLEN);
    memset(uupc_rc_settings.domain, '\0', MAXLEN);
    memset(uupc_rc_settings.from_domain, '\0', MAXLEN);
    memset(uupc_rc_settings.site, '\0', MAXLEN);
    memset(uupc_rc_settings.organization, '\0', MAXLEN);
    memset(uupc_rc_settings.mail_server, '\0', MAXLEN);
    memset(uupc_rc_settings.editor, '\0', MAXLEN);
    memset(uupc_rc_settings.home, '\0', MAXLEN);
    memset(uupc_rc_settings.signature, '\0', MAXLEN);
    memset(uupc_rc_settings.newsadmin, '\0', MAXLEN);
#ifdef COMPILING_TRN
    memset(uupc_rc_settings.trnlib, '\0', MAXLEN);
#endif
#ifdef COMPILING_MTHREADS
    memset(uupc_rc_settings.mthreadslib, '\0', MAXLEN);
#endif
    memset(uupc_rc_settings.prefshell, '\0', MAXLEN);
    memset(uupc_rc_settings.locdist, '\0', MAXLEN);
    memset(uupc_rc_settings.orgdist, '\0', MAXLEN);
    memset(uupc_rc_settings.citydist, '\0', MAXLEN);
    memset(uupc_rc_settings.statedist, '\0', MAXLEN);
    memset(uupc_rc_settings.countrydist, '\0', MAXLEN);
    memset(uupc_rc_settings.continentdist, '\0', MAXLEN);

    if ((fn = getenv("COMSPEC")) == NULL) {
        fprintf(stderr, "COMSPEC environment variable undefined\n");
        return(0);
    }
    strcpy(uupc_rc_settings.prefshell, fn);
    change_sl2bsl(uupc_rc_settings.prefshell);


    /* read the system file first */
    for (i = 0; i < 3; i++) {

        /* choose the file to open */
        if (i == 0) {
            fn = getenv("UUPCSYSRC");
            if (fn == NULL) {
                fprintf(stderr, "Enviroment variable UUPCSYSRC not defined\n");
            }
        } else {
            if (i == 1) {
               fn = getenv("UUPCUSRRC");
               if (fn == NULL) {
                   fprintf(stderr, "Enviroment variable UUPCUSRRC not defined\n");
               }
            }
            else {
               fn = getenv("UUPCTRNRC");
               if (fn == NULL) {
                   fprintf(stderr, "Enviroment variable UUPCTRNRC not defined\n");
               }
            }
        }

        if (((fn != NULL) && (strlen(fn) > 1)) &&
            ((tmp = fopen(fn, "rt")) != NULL))
        {   while (fgets(buf, 83, tmp))
            {   p = strtok(buf, " =\r\n");
                if ((p == NULL) ? 0 : *p != '#')
                {   v = strtok(NULL, " =\r\n");
                    if (stricmp(p, "MailServ") == 0)
                    {
                        if (!set_mail_server)
                            res++;
                        set_mail_server = 1;
                        strcpy(uupc_rc_settings.mail_server, v);
                        change_bsl2sl(uupc_rc_settings.mail_server);
                    }
                    if (stricmp(p, "FileSent") == 0)
                    {
                        /** This setting is not required, but optional **/
                        strcpy(uupc_rc_settings.mailsent, v);
                        change_bsl2sl(uupc_rc_settings.mailsent);
                    }
                    if (stricmp(p, "NodeName") == 0)
                    {
                        if (!set_site)
                            res++;
                        set_site = 1;
                        strcpy(uupc_rc_settings.site, v);
                        change_bsl2sl(uupc_rc_settings.site);
                    }
                    if (stricmp(p, "NewsDir") == 0)
                    {
                        if (!set_news_dir)
                            res++;
                        set_news_dir = 1;
                        strcpy(uupc_rc_settings.news_dir, v);
                        change_bsl2sl(uupc_rc_settings.news_dir);
                    }
                    if (stricmp(p, "ConfDir") == 0)
                    {
                         if (!set_config_dir)
                             res++;
                         set_config_dir = 1;
                         strcpy(uupc_rc_settings.conf_dir, v);
                         change_bsl2sl(uupc_rc_settings.conf_dir);
                         strcpy(uupc_rc_settings.active,v);
                         strcat(uupc_rc_settings.active,"/active");
                         strcpy(uupc_rc_settings.active_times,v);
                         strcat(uupc_rc_settings.active_times,"/active.times");
                         change_bsl2sl(uupc_rc_settings.active);
                         change_bsl2sl(uupc_rc_settings.active_times);
		    }
                    if (stricmp(p, "Domain") == 0)
                    {
                        if (!set_domain)
                            res++;
                        set_domain = 1;
                        strcpy(uupc_rc_settings.domain, v);
                    }
                    if (stricmp(p, "FromDomain") == 0)
                    {
                        strcpy(uupc_rc_settings.from_domain, v);
                    }
                    if (stricmp(p, "TempDir") == 0)
                    {
                        if (!set_temp_name)
                            res++;
                        set_temp_name = 1;
                        strcpy(uupc_rc_settings.temp_name, v);
                        change_bsl2sl(uupc_rc_settings.temp_name);
                    }
                    if (stricmp(p, "MailDir") == 0)
                    {
                        if (!set_mail_dir)
                            res++;
                        set_mail_dir = 1;
                        strcpy(uupc_rc_settings.mail_dir, v);
                        change_bsl2sl(uupc_rc_settings.mail_dir);
                    }
                    if (stricmp(p, "Rmail") == 0)
                    {
                        strcpy(uupc_rc_settings.rmailpath, v);
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.rmailpath, " ");
                            strcat(uupc_rc_settings.rmailpath, v);
                            v = strtok(NULL, " =\r\n");
                        }
                    }
                    if (stricmp(p, "Mailbox") == 0)
                    {
                        if (!set_user)
                            res++;
                        set_user = 1;
                        strcpy(uupc_rc_settings.user, v);
                    }
                    if (stricmp(p, "Signature") == 0)
                    {
                        if (!set_signature)
                            res++;
                        set_signature = 1;
                        strcpy(uupc_rc_settings.signature, v);
                        change_bsl2sl(uupc_rc_settings.signature);
                    }
                    if (stricmp(p, "Name") == 0)
                    {
                        if (!set_name)
                            res++;
                        set_name = 1;
                        strcpy(uupc_rc_settings.name, v);
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.name, " ");
                            strcat(uupc_rc_settings.name, v);
                            v = strtok(NULL, " =\r\n");
                        }
                    }
                    if ((stricmp(p, "Organization") == 0) ||
                        (stricmp(p, "Organisation") == 0)    )
                    {
                        if (!set_organization)
                            res++;
                        set_organization = 1;
                        strcpy(uupc_rc_settings.organization, v);
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.organization, " ");
                            strcat(uupc_rc_settings.organization, v);
                            v = strtok(NULL, " =\r\n");
                        }
                    }
                    if (stricmp(p, "Editor") == 0)
                    {
                        if (!set_editor)
                            res++;
                        set_editor = 1;
                        strcpy(uupc_rc_settings.editor, v);
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.editor, " ");
                            strcat(uupc_rc_settings.editor, v);
                            v = strtok(NULL, " =\r\n");
                        }
                        change_bsl2sl(uupc_rc_settings.editor);
                    }
                    if (stricmp(p, "Home") == 0)
                    {
                        if (!set_home)
                            res++;
                        set_home = 1;
                        strcpy(uupc_rc_settings.home, v);
                        change_bsl2sl(uupc_rc_settings.home);
                    }
                    if (stricmp(p, "Newsadmin") == 0)
                    {
                        if (!set_newsadmin)
                            res++;
                        set_newsadmin = 1;
                        strcpy(uupc_rc_settings.newsadmin, v);
                    }
#ifdef COMPILING_TRN
                    if (stricmp(p, "TrnLib") == 0)
                    {
                        if (!set_trnlib)
                            res++;
                        set_trnlib = 1;
                        strcpy(uupc_rc_settings.trnlib, v);
                        change_bsl2sl(uupc_rc_settings.trnlib);
                    }
#endif
#ifdef COMPILING_MTHREADS
                    if (stricmp(p, "MthreadsLib") == 0)
                    {
                        if (!set_mthreadslib)
                            res++;
                        set_mthreadslib = 1;
                        strcpy(uupc_rc_settings.mthreadslib, v);
                        change_bsl2sl(uupc_rc_settings.mthreadslib);
                    }
#endif
                    if (stricmp(p, "LocalDist") == 0)
                    {
                        if (!set_locdist)
                            res++;
                        set_locdist = 1;
                        strcpy(uupc_rc_settings.locdist, v);
                    }
                    if (stricmp(p, "OrganizationDist") == 0)
                    {
                        if (!set_orgdist)
                            res++;
                        set_orgdist = 1;
                        strcpy(uupc_rc_settings.orgdist, v);
                    }
                    if (stricmp(p, "CityDist") == 0)
                    {
                        if (!set_citydist)
                            res++;
                        set_citydist = 1;
                        strcpy(uupc_rc_settings.citydist, v);
                    }
                    if (stricmp(p, "StateDist") == 0)
                    {
                        if (!set_statedist)
                            res++;
                        set_statedist = 1;
                        strcpy(uupc_rc_settings.statedist, v);
                    }
                    if (stricmp(p, "CountryDist") == 0)
                    {
                        if (!set_countrydist)
                            res++;
                        set_countrydist = 1;
                        strcpy(uupc_rc_settings.countrydist, v);
                    }
                    if (stricmp(p, "ContinentDist") == 0)
                    {
                        if (!set_continentdist)
                            res++;
                        set_continentdist = 1;
                        strcpy(uupc_rc_settings.continentdist, v);
                    }
                }
            }
            fclose (tmp);
        }
    }
    
    if (strlen(uupc_rc_settings.rmailpath) < 2)
        strcpy(uupc_rc_settings.rmailpath, "rmail.exe");    

    if ((p = getenv("LOGNAME")) != NULL)
    {
        struct passwd *pw = getpwnam(p);
	if (pw)
	{
	    strcpy(uupc_rc_settings.user, pw -> pw_name);
	    strcpy(uupc_rc_settings.name, pw -> pw_gecos);
	    strcpy(uupc_rc_settings.home, pw -> pw_dir);
        }
    }

    if (strlen(uupc_rc_settings.mail_server) < 1)
    {   fprintf(stderr, "Missing setting <MailServ>!\n");
        res--;
    }
    if (strlen(uupc_rc_settings.site) < 1)
    {   fprintf(stderr, "Missing setting <NodeName>!\n");
        res--;
    }
    if (strlen(uupc_rc_settings.conf_dir) < 1)
    {   fprintf(stderr, "Missing setting <ConfDir>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.news_dir) < 1)
    {   fprintf(stderr, "Missing setting <NewsDir>!\n");
        res--;
    }
    if (strlen(uupc_rc_settings.domain) < 1)
    {   fprintf(stderr, "Missing setting <Domain>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.temp_name) < 1)
    {   fprintf(stderr, "Missing setting <TempDir>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.mail_dir) < 1)
    {   fprintf(stderr, "Missing setting <MailDir>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.user) < 1)
    {   fprintf(stderr, "Missing setting <Mailbox>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.signature) < 1)
    {   fprintf(stderr, "Missing setting <Signature>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.name) < 1)
    {   fprintf(stderr, "Missing setting <Name>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.organization) < 1)
    {   fprintf(stderr, "Missing setting <Organization>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.editor) < 1)
    {   fprintf(stderr, "Missing setting <Editor>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.home) < 1)
    {   fprintf(stderr, "Missing setting <Home>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.newsadmin) < 1)
    {   fprintf(stderr, "Missing setting <Newsadmin>\n");
        res--;
    }
#ifdef COMPILING_TRN
    if (strlen(uupc_rc_settings.trnlib) < 1)
    {   fprintf(stderr, "Missing setting <TrnLib>\n");
        res--;
    }
#endif
#ifdef COMPILING_MTHREADS
    if (strlen(uupc_rc_settings.mthreadslib) < 1)
    {   fprintf(stderr, "Missing setting <MthreadsLib>\n");
        res--;
    }
#endif
    if (strlen(uupc_rc_settings.locdist) < 1)
    {   fprintf(stderr, "Missing setting <LocalDist>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.orgdist) < 1)
    {   fprintf(stderr, "Missing setting <OrganizationDist>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.citydist) < 1)
    {   fprintf(stderr, "Missing setting <CityDist>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.statedist) < 1)
    {   fprintf(stderr, "Missing setting <StateDist>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.countrydist) < 1)
    {   fprintf(stderr, "Missing setting <CountryDist>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.continentdist) < 1)
    {   fprintf(stderr, "Missing setting <ContinentDist>\n");
        res--;
    }
    if (strlen(uupc_rc_settings.from_domain) < 1)
       strcpy(uupc_rc_settings.from_domain, uupc_rc_settings.domain);

    strcpy(uupc_rc_settings.mailfile, uupc_rc_settings.mail_dir);
    strcat(uupc_rc_settings.mailfile, "/");
    strcat(uupc_rc_settings.mailfile, uupc_rc_settings.user);

    return(res == 21);
}

struct passwd *getpwnam(const char *name)
{
  static struct passwd pw;
  static char buffer[256];
  char *ptr, *logname, *fullname, *homedir;
  FILE *passwd;
  int i, found = 0;

  strcpy(buffer, uupc_rc_settings.conf_dir);
  strcat(buffer, "/passwd");

  pw.pw_name  = uupc_rc_settings.user;
  pw.pw_dir   = uupc_rc_settings.home;
  pw.pw_gecos = uupc_rc_settings.name;

  if ( (passwd = fopen(buffer, "r")) == NULL )
    if ( strcmp(name, uupc_rc_settings.user) == 0 )
      return &pw;
    else
      return NULL;

  while ( fgets(buffer, sizeof(buffer), passwd) != NULL )
  {
    buffer[strlen(buffer) - 1] = 0;

    if ( buffer[0] == '#' )
      continue;

    if ( (ptr = strchr(buffer, ':')) != NULL )
      *ptr++ = 0;
    else
      continue;

    if ( strcmp(name, buffer) == 0 )
    {
      logname = buffer;

      for ( i = 0; i < 3; i++ )
        if ( (ptr = strchr(ptr, ':')) != NULL )
          *ptr++ = 0;
        else
          continue;

      fullname = ptr;

      if ( (ptr = strchr(ptr, ':')) != NULL )
        *ptr++ = 0;
      else
        continue;

      homedir = ptr;

      if ( ptr[0] && ptr[1] && (ptr = strchr(ptr + 2, ':')) != NULL )
        *ptr++ = 0;   /* skip drive: */

      pw.pw_name  = logname;
      pw.pw_dir   = homedir;
      pw.pw_gecos = fullname;
      found = 1;

      break;
    }
  }

  fclose(passwd);

  if ( !found && strcmp(name, uupc_rc_settings.user) != 0 )
    return NULL;

  return &pw;
}
