/* MakeList.cmd */

  '@echo off'
  Version = '1.90'

/*----------------------------------------------------------------------------*
 * process commandline parameters                                             *
 *----------------------------------------------------------------------------*/
  PARSE ARG Server

/* draw the cool ansi screen on the local console */

  Rc=DRAWBOARDER(Version)

  LogFilename='MakeList.log'

  '@del 'LogFilename' 1>nul 2>nul'

  if (Server = "") then do
    Rc=ERRORSOUND(1)
    Text="Expecting a news server name to be passed as a parameter."
    Rc = SysCurPos(12,3)
    SAY Text
    Rc=LOG(Logfilename,Text)
    exit 1
    end /* if */

  Text=Version' - Starting...'
  '@icontalk MakeList - 'Text
  Rc = SysCurPos(3,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

/*----------------------------------------------------------------------------*
 * load add-on function libraries and assume it all went well...              *
 *----------------------------------------------------------------------------*/

  Rc=LOADLIBRARIES()

/*----------------------------------------------------------------------------*
 * Read BinSuk.cnf file and parse out UserID and Password                     *
 *----------------------------------------------------------------------------*/

  Rc=readconfig()

/*----------------------------------------------------------------------------*
 * determine if user specified server parameter is a named server or a        *
 * dotted named server                                                        *
 *----------------------------------------------------------------------------*/

  PARSE VAR Server Bit0 '.' Bit1 '.' Bit2 '.' Bit3

  Servertype=(DATATYPE(Bit0)='NUM' & DATATYPE(Bit1)='NUM' & DATATYPE(Bit2)='NUM' & DATATYPE(Bit3)='NUM')

  IF Servertype=0 THEN DO     /* is a named server */
    Nameserver=Server
    Rc=BSGETHOSTBYNAME(Server)
    Server=Rc
  END /* if serverType */

  IF Servertype=1 THEN DO     /* is a dotted server */
    Rc=BSGETHOSTBYADDR(Server)
    Nameserver=Rc
  END /* if serverType */

/*----------------------------------------------------------------------------*
 * If rc returns a zero, then an error occured and terminate the BS process   *
 * Gotta' clean this one up some day to terminate cleanly!@                   *
 *----------------------------------------------------------------------------*/

  IF (Rc = 0) THEN DO
    Rc=ERRORSOUND(1)
    Text="Unable to resolve server name: "Server
    SAY Text
    Rc=LOG(Logfilename,Text)
    EXIT
  END /* if rc */

/*----------------------------------------------------------------------------*
 * Open socket and return the actual socket numnber.                          *
 *----------------------------------------------------------------------------*/

  Rc=BSSOCKSOCKET()

  IF (Rc = -1) THEN DO
    Rc=ERRORSOUND(1)
    Text="Error opening socket: "Errno
    SAY Text
    Rc=LOG(Logfilename,Text)
    EXIT
  END /* if rc */

  Sock=Rc

/* configure the socket we just opened */

  Rc=BSSOCKSETSOCKOPT(Sock)

  IF (Rc = 0) THEN DO
    Rc=TICKSOUND(1)
  END /* if rc */

/* connect the socket and start the "conversation" */

  Rc=BSSOCKCONNECT(Sock,Server)

  IF (Rc = -1) THEN DO
    Rc=ERRORSOUND(1)
    Text='Error connecting socket:' Errno
    SAY Text
    Rc=LOG(Logfilename,Text)
    EXIT
  END

  Rc=GETRESPONSE(Sock)

  Text='Connected to server: 'Nameserver' ('Server')'
  '@icontalk MakeList - '||Text
  Rc = SysCurPos(4,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

  Rc = SysCurPos(3,71)
  SAY'(   )'

/*----------------------------------------------------------------------------*
 * Ask for group list from server                                             *
 *----------------------------------------------------------------------------*/

  Text='Fetching complete group list...'
  '@icontalk MakeList - '||Text
  Rc = SysCurPos(5,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

  Rc=SENDMESSAGE(Sock,'List')
  ReadingMessage=1
  Rc=GETRESPONSE(Sock)
  ReadingMessage=0

  parse var line.1 code .

/*----------------------------------------------------------------------------*
 * Code 480 reponse indicates that this session is password/userID protected  *
 *----------------------------------------------------------------------------*/

  if Code=480 then do
    Rc=log(Logfilename,'The news server >'||Nameserver||'< requires authentication!')
    Rc=log(Logfilename,'Sending userID >'||Bsuser||'< to >'||Nameserver||'<!')

    Rc=sendmessage(Sock,'AUTHINFO USER '||Bsuser)
    Rc=getresponse(Sock)
    parse var Line.1 Code .

    if Code=482 | Code =502 then do
      Text='The news server >'||Nameserver||'< does not accept UserID >'||Bsuser|'<!'
      say Text
      Rc=log(Logfilename,Text)
      Text='This BinSuk session is terminated!'
      say Text
      Rc=log(Logfilename,Text)
      exit 1
    end /* if code=482 */

    if Code=381 then do
      Rc=log(Logfilename,'Sending Password >'||Bspass||'< to >'||Nameserver||'<!')
      Rc=sendmessage(Sock,'AUTHINFO PASS '||Bspass)
      Rc=getresponse(Sock)
      parse var Line.1 Code .
    end /* if code=381 */

    if Code=482 | Code =502 then do
      Text='The news server >'||Nameserver||'< does not accept your login information!'
      say Text
      Rc=log(Logfilename,Text)
      Text='This BinSuk session is terminated!'
      say Text
      Rc=log(Logfilename,Text)
      exit 1
    end /* if code=482 */

    Rc=log(Logfilename,'The news server >'||Nameserver||'< accepts your login information!')

    Rc=SENDMESSAGE(Sock,'List')
    ReadingMessage=1
    Rc=GETRESPONSE(Sock)
    ReadingMessage=0

  end /* if code=480 */

  Text='Fetch completed!'
  '@icontalk MakeList - '||Text
  Rc = SysCurPos(6,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

  Text='Writing binary list to file: group.list!'
  '@icontalk MakeList - '||Text
  Rc = SysCurPos(7,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

  BinCount=0

  '@del group.list 1>nul 2>nul'
  '@del CompleteGroup.list 1>nul 2>nul'

  do i = 0 to line.0

  call lineout 'CompleteGroup.list', line.i

    if pos('bina', line.i) > 0 then do
      call lineout 'group.list',word(line.i,1)
      BinCount=BinCount + 1
      end /* if */
  end /* do */

  call lineout 'group.list'
  call lineout 'CompleteGroup.list'

  Text='Write completed!'
  '@icontalk MakeList - '||Text
  Rc = SysCurPos(8,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

  Text='Found 'BinCount' binary type groups out of 'line.0' total!'
  '@icontalk MakeList - '||Text
  Rc = SysCurPos(8,3)
  SAY Text
  Rc=LOG(Logfilename,Text)

  EXIT

/*----------------------------------------------------------------------------*
 * get a line from the server                                                 *
 *----------------------------------------------------------------------------*/

Getresponseline: PROCEDURE EXPOSE !.

  Sock = ARG(1)

  Crlf = D2C(13)||D2C(10)

  IF (SYMBOL('!.buff') = "LIT") THEN !.buff = ""

  DO WHILE (POS(Crlf,!.buff) = 0)
    Rc = SOCKRECV(Sock,"data",8192)
    !.buff = !.buff||Data
  END /* do while */

  P = POS(Crlf,!.buff)

  Line = SUBSTR(!.buff,1,P-1)
  !.buff = SUBSTR(!.buff,P+2)

RETURN Line

/*----------------------------------------------------------------------------*
 * get a response from the server                                             *
 *----------------------------------------------------------------------------*/

Getresponse: PROCEDURE EXPOSE !. Line. Readingmessage Linecount

  Sock=ARG(1)

  Moreids = "100 215 220 221 222 223 230 231"

  Line.0 = 1
  Line.1 = GETRESPONSELINE(Sock)

  PARSE VAR Line.1 Rid Msg

  IF Rid = 400 THEN DO
    SAY'The server has closed the connection!'
    EXIT
  END /* if rid */

  IF (WORDPOS(Rid,Moreids) = 0) THEN RETURN ''

  Blink = 0
  O = 0

  DO FOREVER

    O = Line.0 + 1
    Line.o = GETRESPONSELINE(Sock)

    IF (Line.o == ".") THEN RETURN ''

    Line.0 = O

    IF ReadingMessage = 1 THEN DO

      Blink = Blink + 1

        Rc=SysCurPos(3,73)

        if Blink = 20 then say'+'
        if Blink = 40 then say'X'

        if Blink=40 then Blink=0

        Rc=SysCurPos(3,73)

    END /* if readingMessage */

  END /* do forever */

RETURN ''

/*----------------------------------------------------------------------------*
 * send a string to the server, after adding the cr/lf pair                   *
 *----------------------------------------------------------------------------*/

Sendmessage: PROCEDURE

  Sock = ARG(1)
  Data = ARG(2)||D2C(13)||D2C(10)

  Len = LENGTH(Data)

  DO WHILE (Len > 0)

    I = SOCKSEND(Sock,Data);

    IF (Errno <> 0) THEN DO
      Text='Error sending data to server!'
      SAY Text
      Rc=LOG(Logfilename,Text)
      EXIT
    END /* if */

    IF (I <= 0) THEN DO
      Text='Server closed the connection!'
      SAY Text
      Rc=LOG(Logfilename,Text)
      EXIT
    END /* if */

    Data = SUBSTR(Data,Len+1)
    Len  = LENGTH(Data)

  END /* do while */

RETURN 0

Ticksound: PROCEDURE

  Sound=ARG(1)

  IF Sound = 1 THEN DO
    CALL BEEP 1500, 1
    CALL BEEP 1600, 1
  END /* if sound */

RETURN 0

Bloopsound: PROCEDURE

  Sound=ARG(1)

  IF Sound = 1 THEN DO
    CALL BEEP 1400, 1
    CALL BEEP 1500, 1
  END /* if sound */

RETURN 0

Errorsound: PROCEDURE

  Sound=ARG(1)

  IF Sound = 1 THEN DO
    CALL BEEP 400, 25
    CALL BEEP 500, 25
  END /* if sound */

RETURN 0

Donesound: PROCEDURE

  Sound=ARG(1)

  IF Sound = 1 THEN DO
    CALL BEEP 400, 100
    CALL BEEP 500, 100
    CALL BEEP 400, 100
    CALL BEEP 500, 100
    CALL BEEP 400, 100
    CALL BEEP 500, 100
    CALL BEEP 400, 100
    CALL BEEP 500, 100

  END /* if sound */

RETURN 0

Log: PROCEDURE

  Logfilename=ARG(1)
  Text       =ARG(2)

  IF Logfilename = '' THEN RETURN 1

  Handle=SYSCREATEMUTEXSEM('\sem32\Log')
  Rc=SYSOPENMUTEXSEM(Handle)

  DO FOREVER
    Rc=SYSREQUESTMUTEXSEM(Handle,100)
    IF Rc=0 THEN LEAVE
    CALL TICKSOUND(1)
  END /* do forever */

  CALL STREAM  Logfilename,'c','seek <' 0
  CALL LINEOUT Logfilename, DATE()||' '||TIME()||' 'Text
  CALL STREAM  Logfilename,'c','close'

  Rc=SYSRELEASEMUTEXSEM(Handle)

RETURN 0

/*----------------------------------------------------------------------------*
 * The following routine checks for possible waiting key strokes,             *
 * indicating that the user wishes to terminate this run of BinSuk            *
 *----------------------------------------------------------------------------*/

Checkforkey: PROCEDURE

  Rc=0

  IF CHARS() THEN Key = SysGetKey('noecho')
  IF Key = ' ' THEN Rc=1

RETURN Rc

/*----------------------------------------------------------------------------*
 * get address of server : rc=0 error, rc=1 ok                                *
 *----------------------------------------------------------------------------*/

Bsgethostbyname: PROCEDURE

  Server=ARG(1)

  Rc = SOCKGETHOSTBYNAME(Server,"host.!")

/*  server = host.!addr */

  IF Rc = 0 THEN Host.!addr=0

RETURN Host.!addr

/*----------------------------------------------------------------------------*
 * get name of server : rc=0 error, rc=1 ok                                   *
 *----------------------------------------------------------------------------*/

  Bsgethostbyaddr: PROCEDURE

  Server=ARG(1)

  Rc = SOCKGETHOSTBYADDR(Server,"host.!")

/*  server = host.!addr */

  IF Rc = 0 THEN Host.!name=0

RETURN Host.!name

/*----------------------------------------------------------------------------*
 * open socket                                                                *
 *----------------------------------------------------------------------------*/

Bssocksocket: PROCEDURE

  Sock = SOCKSOCKET("AF_INET","SOCK_STREAM",0)

RETURN Sock

/*----------------------------------------------------------------------------*
 * configure socket for large buffers:                                        *
 * on some test machines, buffers larger than 16k caused this setting to be   *
 * ignored.                                                                   *
 *----------------------------------------------------------------------------*/

Bssocksetsockopt: PROCEDURE

  Sock=ARG(1)

  Rc = SOCKSETSOCKOPT(Sock, 'SOL_SOCKET', 'SO_RCVBUF', 16384)

RETURN Rc

/*----------------------------------------------------------------------------*
 * connect socket                                                             *
 *----------------------------------------------------------------------------*/

Bssockconnect: PROCEDURE

  Sock=ARG(1)
  Server=ARG(2)

  Server.!family = "AF_INET"
  Server.!port   = 119
  Server.!addr   = Server

  Rc = SOCKCONNECT(Sock,"server.!")

RETURN Rc

/*----------------------------------------------------------------------------*
 * Load the support libraries if not already in memory                        *
 *----------------------------------------------------------------------------*/

Loadlibraries: PROCEDURE

  IF RXFUNCQUERY('SysLoadFuncs') THEN DO
    Rc=RXFUNCADD('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    Rc=Sysloadfuncs
    SAY'Loaded RexxUtil'
  END /* if */

  IF RXFUNCQUERY('SockLoadFuncs') THEN DO
    Rc=RXFUNCADD('SockLoadFuncs','RxSock','SockLoadFuncs')
    Rc=SOCKLOADFUNCS('Quiet')
    SAY'Loaded RxSock"'
  END /* if */

RETURN 0

Drawboarder: PROCEDURE EXPOSE Version

  Version = ARG(1)

  SAY'[?7h[40m[2J[0;1m<> MakeList 'Version' - mcbrides@pics.com <>Ŀ'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY'[77C'
  SAY''

RETURN 0

/*----------------------------------------------------------------------------*
 * check for BinSuk.cnf and read it's contents                                *
 *----------------------------------------------------------------------------*/

  Readconfig: procedure expose Bsuser Bspass

  Bsuser=''
  Bspass=''

  Binsukconfig='BinSuk.cnf'

  if stream(Binsukconfig,'c','query exists') ='' then return 0

  Handle=syscreatemutexsem('\sem32\ReadConfig')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave
    Rc=debuglog('Waiting for mutex to clear in ReadConfig','No group')
    call ticksound(1)
  end /* do forever */

  do while lines(Binsukconfig)

    Text=strip(linein(Binsukconfig))
    Utext=translate(Text)

    if pos('#',Utext)\=1 then do
      if Utext\='' then do

        if pos('BSUSER ',Utext) > 0 then do
          parse var Text . Bsuser
        end /* if pos( */

        if pos('BSPASS ',Utext) > 0 then do
          parse var Text . Bspass
        end /* if pos( */

      end /* if text */
    end /* if pos( */

  end /* do while */

  call stream  Binsukconfig,'c','close'

  Rc=sysreleasemutexsem(Handle)

return 0



