/* REXX PROGRAM */
/* CHECKING INSTALLATION PROGRAM */
SAY "INSTALLATION PROGRAM FOR CHECK+ DEMO"
SAY ""
/* You may optionally specify the destination path for the program as an argument. */
/* If you do not specify the destination path you will be prompted to enter a path. */
PARSE SOURCE os processor cmd
srcdrive = FILESPEC("drive",cmd)
srcpath = FILESPEC("path",cmd)
src = srcdrive||srcpath
minHardDiskSize = 2800000

arg destpath
"@echo off"

call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'
driveInfo = SysDriveInfo(srcdrive)
driveSize = SUBWORD(driveInfo, 3, 1)
DO FOREVER
	IF destpath = "" THEN DO
		IF driveSize > minHardDiskSize THEN DO
			tempsrc = STRIP(src, 'T', '\')
			SAY "If you would like to run the demonstration from "tempsrc
			SAY "without copying the files to a new directory simply press Enter without"
			SAY "typing anything.  Otherwise enter the full directory path (including drive)"
			SAY "where you would like the demonstration program to be installed."
			SAY '(We suggest "C:\CPDEMO").'
			END
		ELSE DO
			SAY "Enter the full directory path (including drive) where you would like the"
			SAY "demonstration program installed.  If you press Enter without typing anything"
			SAY 'it will be installed in the "C:\CPDEMO" directory.'
			END
		SAY "If you would like to abort this installation type QUIT and press Enter."
		PULL destpath
		IF destpath = "QUIT" THEN EXIT
		IF driveSize > minHardDiskSize THEN DO
			IF destpath = "" THEN DO
				destpath = src
				SIGNAL MAKE_ICON
				END
			END
		ELSE DO
			IF destpath = "" THEN destpath = "C:\CPDEMO"
			END
		END
	rc = SysMkDir(destpath)
	IF rc == 0 THEN LEAVE
	SAY ""
	SAY "ERROR: Unable to make the directory "destpath"."
	IF rc == 3 THEN say "The path was not found."
	IF rc == 5 THEN say "Either it already exists or you do not have access to the directory."
	SAY "Enter a new path."
	SAY ""
	destpath = ""
	END

/* Copy the files */
SAY ""
SAY "Now copying files..."
/* If the source drive is not big enough to hold the entire program we assume its on a floppy. */
/* The floppy version expects files to be compressed (using CIC compression) & will ask for disk 2. */
IF driveSize <= minHardDiskSize THEN DO
	/* Floppy version of Install */
	src"decomp "src"checking.exe "destpath"\checking.exe"
	src"decomp "src"checking.hlp "destpath"\checking.hlp"
	src"decomp "src"cicd0115.dll "destpath"\cicd0115.dll"
	src"decomp "src"cicp0115.dll "destpath"\cicp0115.dll"
	/* "copy "src"makeicon.cmd "destpath"\makeicon.cmd" */
	"copy "src"readme.txt "destpath"\readme.txt"
	SAY ""
	SAY "Insert the disk Labeled Disk 2 and press Enter."
	PULL response
	SAY ""
	SAY "Now copying files..."
	src"decomp "src"cicom30.dll "destpath"\cicom30.dll"
	src"decomp "src"cicoob3.dll "destpath"\cicoob3.dll"
	src"decomp "src"cicoor3u.dll "destpath"\cicoor3u.dll"
	src"decomp "src"cicoou3.dll "destpath"\cicoou3.dll"
	"copy "src"mymIn.cmd "destpath"/v"
	"copy "src"sample* "destpath"/v"
	"copy "src"*.db* "destpath"/v"
	END
ELSE DO
	/* Hard Disk version of Install - i.e. zipped files were downloaded then unzipped. */
	"copy "src"checking.exe "destpath"/v"
	"copy "src"checking.hlp "destpath"/v"
	"copy "src"cic*.dll "destpath"/v"
	"copy "src"mymIn.cmd "destpath"/v"
	"copy "src"sample* "destpath"/v"
	"copy "src"*.db* "destpath"/v"
	"copy "src"readme.txt "destpath"/v"
	SAY ""
	END

MAKE_ICON:
/* Create the Check+ Icon. */
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
if SysCreateObject('WPProgram', 'Check+ Demo', '<WP_DESKTOP>', 'EXENAME='destpath'\checking.exe;STARTUPDIR='destpath, 'replace') == 0 then SAY 'Unable to create the Check+ icon.  You should add it manually after the installation program finishes.'

SAY ""
SAY "DONE INSTALLING THE CHECK+ DEMO."
SAY "To use the program double click on the 'Check+ Demo' icon on your desktop."
SAY ""
EXIT
