/* New Rexx-Install for SoundBlaster 16/AWE32/AWE64 drivers         */
/*  drivers provided by Daniel Jorge Caetano (dcaetano@sti.com.br)  */
/*  Rexx-Installer done by Martin Kiewitz (martin@kiewitz.de)       */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

Say ""
Say "  Sound Blaster 16/32/64/AWE32/AWE64/AWE64Gold Install v1.9rexx"
Say "    Original Corrections by Daniel Jorge Caetano, 1998"
Say "    Rexx-Installer by Martin Kiewitz, 2001"
Say ""

mmos2  = "\MMOS2"
sbdir  = "\MMOS2\SB"
sbtmp  = "\SBTMP"
sbicf  = "\SBTMP\CONTROL.icf"
config = "CONFIG.sys"
configbackupfile = "CONFIG.sb$"

/* Get Boot-Drive */
Bootdrive = FileSpec("drive", SysSearchPath("PATH", "OS2"))

If Bootdrive=="" Then Do
   Say "  Could not get Boot-Drive, you are probably not using OS/2 Warp"
   Say ""
   Exit
End
If Stream(Bootdrive||mmos2||"\mmpm2.ini", "c", "query exists")=="" Then Do
   Say "  Could not find MM-OS/2. This is required for installation."
   Say ""
   Exit
End

/* Get Temporary Path */
env = "OS2ENVIRONMENT"
temppath = value("temp",,env)
If temppath=="" Then temppath = Value("tmp",,env)

rc = SysMkDir(temppath||sbtmp)
If rc<>0 Then If rc<>5 Then Do
   Say "  No temporary path available. Please check environment variable TEMP/TMP."
   Say ""
   Exit
End

config       = Bootdrive"\"config
configbackup = Bootdrive"\"configbackupfile

/* Now installing driver first... */

call CharOut ,"  Unzipping driver-archive..."
'@unzip -o driver.zip -d 'temppath||sbtmp' >nul'
call LineOut ,"ok"

/* Generating CONTROL.ICF */

call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "; File      : CONTROL.ICF"
call LineOut temppath||sbicf, "; Date      : 24-02-1998"
call LineOut temppath||sbicf, "; Author    : Daniel Jorge Caetano (Hariharan Mahadevan)"
call LineOut temppath||sbicf, "; Purpose   : Installation control file for installing audio driver for"
call LineOut temppath||sbicf, ";             SBAWE32, AWE64 and SB16"
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "[System]"
call LineOut temppath||sbicf, "Title=Sound Blaster Drivers v2.30.0 Installation"
call LineOut temppath||sbicf, "BaseDirVar="
/* Here, we insert our Bootdrive and the soundblaster installation dir */
call LineOut temppath||sbicf, "Basedir="Bootdrive||sbdir
call LineOut temppath||sbicf, "; total number of installable components"
call LineOut temppath||sbicf, "groups=2"
call LineOut temppath||sbicf, "; each component's section name"
call LineOut temppath||sbicf, "group_1=%AWEDrivers%"
call LineOut temppath||sbicf, "group_2=%SB16Drivers%"
call LineOut temppath||sbicf, "; total number of installation diss"
call LineOut temppath||sbicf, "disks=1"
call LineOut temppath||sbicf, "; volume label of each installation disk"
call LineOut temppath||sbicf, "; relevant only for multiple volume installation disk"
call LineOut temppath||sbicf, "diskname_1=DISK_1"
call LineOut temppath||sbicf, "; readme"
call LineOut temppath||sbicf, "readme=$(SPATH)\README\READMEDR.TXT,BEFORE"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "; [Default] group is always installed first"
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "[Default]"
call LineOut temppath||sbicf, "size=0"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "; Audio drivers - AWE32"
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "[AWEDrivers]"
call LineOut temppath||sbicf, "Name=Sound Blaster AWE32/AWE64 Driver"
call LineOut temppath||sbicf, "; total size 1158KB"
call LineOut temppath||sbicf, "Size=1158"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\SBAWE32\DRIVER,$(SPATH)\SBAWE32\DLL,$(SPATH)\README"
call LineOut temppath||sbicf, "TargetDir=$(TPATH),$(MMBASE)\DLL,$(TPATH)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "DLLName=$(SPATH)\SBINSTAL.DLL"
call LineOut temppath||sbicf, "DLLEntryPoint=SBAWEInstall"
call LineOut temppath||sbicf, "WPObject=%AWEFolder,AWECPIcon,AWEReadMe%"
call LineOut temppath||sbicf, "Exclude=%SB16Drivers%"
call LineOut temppath||sbicf, "Include="
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "; Audio drivers - SB16"
call LineOut temppath||sbicf, "; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "[SB16Drivers]"
call LineOut temppath||sbicf, "Name=Sound Blaster 16 Driver"
call LineOut temppath||sbicf, "; total size 90KB"
call LineOut temppath||sbicf, "Size=90"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\SB16\DRIVER,$(SPATH)\SB16\DLL,$(SPATH)\README"
call LineOut temppath||sbicf, "TargetDir=$(TPATH),$(MMBASE)\DLL,$(TPATH)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "DLLName=$(SPATH)\SBINSTAL.DLL"
call LineOut temppath||sbicf, "DLLEntryPoint=SB16Install"
call LineOut temppath||sbicf, "WPObject=%SB16Folder,SB16ReadMe%"
call LineOut temppath||sbicf, "Exclude=%AWEDrivers%"
call LineOut temppath||sbicf, "Include="
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "; W O R K P L A C E   O B J E C T   D E F I N I T I O N S"
call LineOut temppath||sbicf, ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
call LineOut temppath||sbicf, "[AWEFolder]"
call LineOut temppath||sbicf, "WPClassName=WPFolder"
call LineOut temppath||sbicf, "WPTitle=Sound Blaster for OS/2"
call LineOut temppath||sbicf, "WPSetupString=OBJECTID=<WP_BLASTER>"
call LineOut temppath||sbicf, "WPLocation=<WP_DESKTOP>"
call LineOut temppath||sbicf, "WPFlags=1"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; SB AWE32 Control Panel Icon"
call LineOut temppath||sbicf, "[AWECPIcon]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=AWE Control Panel"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\AWECP.EXE;ICON=$(TPATH)\AWECP.ICO"
call LineOut temppath||sbicf, "WPLocation=<WP_BLASTER>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; SB AWE32 README.TXT file"
call LineOut temppath||sbicf, "[AWEReadMe]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=Read Me"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=E.EXE;PARAMETERS=$(TPATH)\READMEDR.TXT"
call LineOut temppath||sbicf, "WPLocation=<WP_BLASTER>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; SB16 Folder"
call LineOut temppath||sbicf, "[SB16Folder]"
call LineOut temppath||sbicf, "WPClassName=WPFolder"
call LineOut temppath||sbicf, "WPTitle=Sound Blaster 16"
call LineOut temppath||sbicf, "WPSetupString=OBJECTID=<WP_BLASTER>"
call LineOut temppath||sbicf, "WPLocation=<WP_DESKTOP>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; SB16 README.TXT"
call LineOut temppath||sbicf, "[SB16ReadMe]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=Read Me"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=E.EXE;PARAMETERS=$(TPATH)\READMEDR.TXT"
call LineOut temppath||sbicf, "WPLocation=<WP_BLASTER>"
call LineOut temppath||sbicf, "WPFlags=2"
/* Closing file */
call LineOut temppath||sbicf

/* Kill X:\CONFIG.$$$, to detect if Selective Install modified CONFIG.SYS */
If Stream(Bootdrive||"\CONFIG.$$$", "c", "query exists")\="" Then Do
   '@del 'Bootdrive||'\CONFIG.$$$'
End

/* Got it... now tell the user and run installation */

Say "  Now installing drivers."
Say "    Choose correct model and if possible, do not change installation directory."
call CharOut, "    Please press any key to continue..."
call SysGetKey('NOECHO')
Say "ok"
call LineOut, ""
call CharOut, "  Running installation..."
call SetLocal
'@'Bootdrive
'@cd 'temppath||sbtmp

/* FileSpec("drive","...",FileSpec("path","...",FileSpec("name","..." */
'@install.exe'
call EndLocal
Say "ok"

/* Check, if Selective Install modified CONFIG.SYS */
If Stream(Bootdrive||"\CONFIG.$$$", "c", "query exists")\="" Then Do
   /* Fix CONFIG.SYS messing of Soundblaster Installation */
   call CharOut, "  Fixing Driver Parameters..."
   If Stream(config, "c", "query exists")\="" then Do
      call SysFileDelete configbackup
      '@ren 'config' 'configbackupfile
      If Stream(configbackup, "c", "open read")="READY:" Then Do
         If Stream(config, "c", "open write")="READY:" Then Do
            Do Forever
               CurLine = LineIn(configbackup)
               if CurLine="" & Stream(configbackup, "s")\="READY" then leave
               if Translate(Left(Space(CurLine, 0), 7))="DEVICE=" & Pos("\SBAWED2.SYS",CurLine)>0 Then Do
                  /* Insert fixed options... */
                  call LineOut config, CurLine||" /P /G"
               End
               else call LineOut config, CurLine
            end
         end
      end
   end
   /* Close both files */
   call LineOut config
   call LineOut configbackup
   call SysFileDelete configbackup
   Say "ok"
End
Else call LineOut, "  Selective Install did not modify CONFIG.SYS ?!?!"

/* Killing Files of ZIP-Archive */
call CharOut, "  Removing temporary directory..."
'@del 'temppath||sbtmp||"\README\*.* /n"
call SysRmDir temppath||sbtmp||"\README"
'@del 'temppath||sbtmp||"\SB16\DLL\*.* /n"
call SysRmDir temppath||sbtmp||"\SB16\DLL"
'@del 'temppath||sbtmp||"\SB16\DRIVER\*.* /n"
call SysRmDir temppath||sbtmp||"\SB16\DRIVER"
call SysRmDir temppath||sbtmp||"\SB16"
'@del 'temppath||sbtmp||"\SBAWE32\DLL\*.* /n"
call SysRmDir temppath||sbtmp||"\SBAWE32\DLL"
'@del 'temppath||sbtmp||"\SBAWE32\DRIVER\SBK\*.* /n"
call SysRmDir temppath||sbtmp||"\SBAWE32\DRIVER\SBK"
'@del 'temppath||sbtmp||"\SBAWE32\DRIVER\*.* /n"
call SysRmDir temppath||sbtmp||"\SBAWE32\DRIVER"
call SysRmDir temppath||sbtmp||"\SBAWE32"
'@del 'temppath||sbtmp||"\*.* /n"
Say "ok"

Say "  *** Installation of Drivers Complete. ***"
Say ""

/* Now installing utils first... */

call CharOut ,"  Unzipping utils-archive..."
'@unzip -o utils.zip -d 'temppath||sbtmp' >nul'
call LineOut ,"ok"

/* Generating another CONTROL.ICF */

call LineOut temppath||sbicf, ";***********************************************************************"
call LineOut temppath||sbicf, "; File 	   : CONTROL.ICF"
call LineOut temppath||sbicf, "; Date     : 24 Feb 1998"
call LineOut temppath||sbicf, "; Author   : Daniel Jorge Caetano (Wong Nyet Ngoh/Haraiharan Mahadevan)"
call LineOut temppath||sbicf, "; Purpose  : Installation control script file for Several Apps for OS/2."
call LineOut temppath||sbicf, ";***********************************************************************"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, ";"
call LineOut temppath||sbicf, "; Default"
call LineOut temppath||sbicf, ";"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "[System]"
call LineOut temppath||sbicf, "title=Creative Multimedia Installation"
call LineOut temppath||sbicf, "; progress=none"
call LineOut temppath||sbicf, "; logo=none"
/* Here, we insert our Bootdrive and the soundblaster installation dir */
call LineOut temppath||sbicf, "Basedir="Bootdrive||sbdir
call LineOut temppath||sbicf, "; total number of installable components"
call LineOut temppath||sbicf, "groups=8"
call LineOut temppath||sbicf, "; each component's section name"
call LineOut temppath||sbicf, "group_1=%CreativeCD%"
call LineOut temppath||sbicf, "group_2=%CreativeWave%"
call LineOut temppath||sbicf, "group_3=%CreativeMidi%"
call LineOut temppath||sbicf, "group_4=%CreativeMovie%"
call LineOut temppath||sbicf, "group_5=%CreativeOverlay%"
call LineOut temppath||sbicf, "group_6=%CreativeMixer%"
call LineOut temppath||sbicf, "group_7=%CreativeMosaic%"
call LineOut temppath||sbicf, "group_8=%CreativeWaveBrowser%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; total number of installation disk"
call LineOut temppath||sbicf, "disks=1"
call LineOut temppath||sbicf, "; volume label of each installation disk"
call LineOut temppath||sbicf, "diskname_1=DISK_1"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Default group is installed before any of the groups are installed"
call LineOut temppath||sbicf, "[Default]"
call LineOut temppath||sbicf, "; size in KB"
call LineOut temppath||sbicf, "Size=356"
call LineOut temppath||sbicf, "; Source directory from where the files are to be read"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\TEXT,$(SPATH)\DLL,$(SPATH)\ICON"
call LineOut temppath||sbicf, "; Target directory where the files to be copied"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR),$(MMBASE)\DLL"
call LineOut temppath||sbicf, "; Disk number where the files of this group can be found"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "; Definition of workplace object to be created"
call LineOut temppath||sbicf, "WPObject=%WPDefault,WPReadme,WPFolder%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; CD Player"
call LineOut temppath||sbicf, "[CreativeCD]"
call LineOut temppath||sbicf, "Name=CreativeCD"
call LineOut temppath||sbicf, "Size=150"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\CTCD"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPCD%"
call LineOut temppath||sbicf, "Minstall=FALSE"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Wave Player"
call LineOut temppath||sbicf, "[CreativeWave]"
call LineOut temppath||sbicf, "Name=CreativeWave"
call LineOut temppath||sbicf, "Size=200"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\CTWAV"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPWave%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Midi Player"
call LineOut temppath||sbicf, "[CreativeMidi]"
call LineOut temppath||sbicf, "Name=CreativeMidi"
call LineOut temppath||sbicf, "Size=150"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\CTMIDI"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPMidi%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Movie Player"
call LineOut temppath||sbicf, "[CreativeMovie]"
call LineOut temppath||sbicf, "Name=CreativeMovie"
call LineOut temppath||sbicf, "Size=150"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\CTMOVIE"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPMovie%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Overlay Player"
call LineOut temppath||sbicf, "[CreativeOverlay]"
call LineOut temppath||sbicf, "Name=CreativeOverlay"
call LineOut temppath||sbicf, "Size=160"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\CTOVLY"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPOverlay%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Creative Mixer for OS/2"
call LineOut temppath||sbicf, "[CreativeMixer]"
call LineOut temppath||sbicf, "Name=CreativeMixer"
call LineOut temppath||sbicf, "Size=78"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\MIXER"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPMixer%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Creative Mosaic for OS/2"
call LineOut temppath||sbicf, "[CreativeMosaic]"
call LineOut temppath||sbicf, "Name=CreativeMosaic"
call LineOut temppath||sbicf, "Size=189"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\MOSAIC"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WPObject=%WPMosaic%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Creative Wave Browser for OS/2"
call LineOut temppath||sbicf, "[CreativeWaveBrowser]"
call LineOut temppath||sbicf, "Name=CreativeWaveBrowser"
call LineOut temppath||sbicf, "Size=76"
call LineOut temppath||sbicf, "SourceDir=$(SPATH)\BROWSER"
call LineOut temppath||sbicf, "TargetDir=$(BASEDIR)"
call LineOut temppath||sbicf, "DiskNumber=1"
call LineOut temppath||sbicf, "WpObject=%WPBrowser%"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Definition for the Creative folder"
call LineOut temppath||sbicf, "[WPDefault]"
call LineOut temppath||sbicf, "; The class name of the object to be created"
call LineOut temppath||sbicf, "WPClassName=WPFolder"
call LineOut temppath||sbicf, "; Title for the object, displayed below the object icon"
call LineOut temppath||sbicf, "WPTitle=Sound Blaster for OS/2"
call LineOut temppath||sbicf, "; Setup string for the object to be created"
call LineOut temppath||sbicf, "WPSetupString=OBJECTID=<CTAV>"
call LineOut temppath||sbicf, "; Location of the object"
call LineOut temppath||sbicf, "WPLocation=<WP_DESKTOP>"
call LineOut temppath||sbicf, "; Creation flags, valid values are"
call LineOut temppath||sbicf, "; 	0 - FAIL IF THE OBJECT EXISTS"
call LineOut temppath||sbicf, ";	1 - REPLACE IF THE OBJECT EXISTS"
call LineOut temppath||sbicf, ";	2 - UPDATE IF THE OBJECT EXISTS"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; For creating Readme file in the above folder"
call LineOut temppath||sbicf, "[WPReadme]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=Readme.txt"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=E.EXE;PARAMETERS=$(BASEDIR)\README.TXT"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; For creating the Icon for CD Player in the above folder"
call LineOut temppath||sbicf, "[WPCD]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeCD"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\CTCD.EXE;ICONFILE=$(TPATH)\CTCD.ICO;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; For creating the Icon for Wave Player in the above folder"
call LineOut temppath||sbicf, "[WPWave]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeWave"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\CTWAV.EXE;ICONFILE=$(TPATH)\CTWAV.ICO;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; For creating the Icon for Midi Player in the above folder"
call LineOut temppath||sbicf, "[WPMidi]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeMidi"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\CTMIDI.EXE;ICONFILE=$(TPATH)\CTMIDI.ICO;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; For creating the Icon for Movie Player in the above folder"
call LineOut temppath||sbicf, "[WPMovie]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeMovie"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\CTMOVIE.EXE;ICONFILE=$(TPATH)\CTMOVIE.ICO;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; For creating the Icon for Overlay Player in the above folder"
call LineOut temppath||sbicf, "[WPOverlay]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeOverlay"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\CTOVLY.EXE;ICONFILE=$(TPATH)\CTOVLY.ICO;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Mixer icon"
call LineOut temppath||sbicf, "[WPMixer]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeMixer"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\CTMIXER.EXE;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Mosaic Icon"
call LineOut temppath||sbicf, "[WPMosaic]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeMosaic"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\MOSAIC.EXE;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
call LineOut temppath||sbicf, ""
call LineOut temppath||sbicf, "; Browser Icon"
call LineOut temppath||sbicf, "[WPBrowser]"
call LineOut temppath||sbicf, "WPClassName=WPProgram"
call LineOut temppath||sbicf, "WPTitle=CreativeWaveBrowser"
call LineOut temppath||sbicf, "WPSetupString=EXENAME=$(TPATH)\BROWSER.EXE;STARTUPDIR=$(BASEDIR)"
call LineOut temppath||sbicf, "WPLocation=<CTAV>"
call LineOut temppath||sbicf, "WPFlags=2"
/* Closing file */
call LineOut temppath||sbicf

/* Got it... now tell the user and run installation */

Say "  Now installing utilities."
call CharOut, "    Please press any key to continue..."
call SysGetKey('NOECHO')
Say "ok"
call LineOut, ""
call CharOut, "  Running installation..."
call SetLocal
'@'Bootdrive
'@cd 'temppath||sbtmp

/* FileSpec("drive","...",FileSpec("path","...",FileSpec("name","..." */
'@install.exe'
/* Change to root, otherwise we can not delete SBTMP */
'@cd \'
call EndLocal
Say "ok"

/* Killing Files of ZIP-Archive */
call CharOut, "  Removing temporary directory..."
'@del 'temppath||sbtmp||"\BROWSER\*.* /n"
call SysRmDir temppath||sbtmp||"\BROWSER"
'@del 'temppath||sbtmp||"\CTCD\*.* /n"
call SysRmDir temppath||sbtmp||"\CTCD"
'@del 'temppath||sbtmp||"\CTMIDI\*.* /n"
call SysRmDir temppath||sbtmp||"\CTMIDI"
'@del 'temppath||sbtmp||"\CTMOVIE\*.* /n"
call SysRmDir temppath||sbtmp||"\CTMOVIE"
'@del 'temppath||sbtmp||"\CTOVLY\*.* /n"
call SysRmDir temppath||sbtmp||"\CTOVLY"
'@del 'temppath||sbtmp||"\CTWAV\*.* /n"
call SysRmDir temppath||sbtmp||"\CTWAV"
'@del 'temppath||sbtmp||"\DLL\*.* /n"
call SysRmDir temppath||sbtmp||"\DLL"
'@del 'temppath||sbtmp||"\MIXER\*.* /n"
call SysRmDir temppath||sbtmp||"\MIXER"
'@del 'temppath||sbtmp||"\MOSAIC\*.* /n"
call SysRmDir temppath||sbtmp||"\MOSAIC"
'@del 'temppath||sbtmp||"\TEXT\*.* /n"
call SysRmDir temppath||sbtmp||"\TEXT"
'@del 'temppath||sbtmp||"\*.* /n"
/* Removing SBTMP directory */
call SysRmDir temppath||sbtmp
Say "ok"

Say "  *** Installation of Utilities Complete. ***"
Say ""

/* Finally installing DSP stuff */
Say "  Now installing utilities..."
rc = SysMkDir(Bootdrive||mmos2||"\DSP")
If rc<>0 Then If rc<>5 Then Do
   Say "  Error generating DSP-directory in MMOS2-path."
   Say ""
   Exit
End
If rc==5 Then '@del 'Bootdrive||mmos2||"\DSP\*.* /n"

call CharOut ,"  Unzipping dsp-archive..."
'@unzip -o csps.zip -d 'Bootdrive||mmos2||'\DSP >nul'
call LineOut ,"ok"

Say "  *** Installation of DSP Complete. ***"
Say ""
Say "  You may reboot now."
call LineOut, "    Please press any key to exit..."
call SysGetKey('NOECHO')
