/* install.cmd - installer for FFTPM */

'@Echo Off'

/* REXXUTIL laden */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Default Install Directory */

DefaultDir = 'C:\FFTPM'


Call SysCls
Say '   Installation of FFTPM'
Say ''


/* Which language */

Say 'Install (E)nglish or (G)erman language version?'
Pull YesNo
If YesNo = "G" Then
   Do
     Language = 'DEUTSCH'
   End
Else
   Do
     Language = 'ENGLISH'
   End
Say ''


/* Check for the files */

Result = SysFileTree( 'FFTPM.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: FFTPM.EXE not found!'
  exit
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: 'Language'.DLL not found!'
  exit
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: 'Language'.HLP not found!'
  exit
  End

/* Get target directory */

If Language = 'DEUTSCH' Then
  Do
    Say 'Bitte geben Sie den vollen Verzeichnisnamen ein, wohin'
    Say 'FFTPM installiert werden soll (Standard: 'DefaultDir'): '
  End
Else
  Do
    Say 'Please enter the full name of the directory to which you want'
    Say 'to install FFTPM (default 'DefaultDir'): '
  End

Pull Directory
If Directory = "" Then Directory = DefaultDir
Say ''

/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEHLER: Kann das Zielverzeichnis nicht anlegen.'
    Say 'ERROR: Unable to create target directory.'
    exit
    End
  End
Say '';


/* Do the installation */

Say 'Installing FFTPM to ' Directory '...'
Copy FFTPM.EXE Directory '1>NUL'
Copy Language".DLL" Directory"\FFTPM.DLL" '1>NUL'
Copy Language".HLP" Directory"\FFTPM.HLP" '1>NUL'


if SysCreateObject('WPProgram','FFTPM','<WP_DESKTOP>','EXENAME='Directory'\FFTPM.EXE;STARTUPDIR='Directory';PROGTYPE=PM;CCVIEW=YES;OBJECTID=<FFTPM>','r') then
   do
   say 'The program object was successfully created.'
   say 'Das Programmobjekt wurde erstellt.'
   end
else
   do
   say 'Error: Cannot create object.'
   say 'Fehler: Objekt konnte nicht erstellt werden!'
   end
Say ''

Exit
