/* FADEOUT */
signal on error name fineko
signal on failure name fineko
signal on halt name fineko

parse value init() with rcy
if rcy \= 0 then signal fineko

parse arg filein offset durata

if (filein == "") | (offset == "") then do
  say "FADEOUT:"
  say "Taglia la parte finale di un file audio WAV da un offset specificato in poi,"
  say "eventualmente sfumando la fine per la durata indicata"
  say ""
  say "Uso:"
  say "      FADEOUT nome_file offset [durata]"
  say ""
  say "Parametri:"
  say "      nome_file    il nome di un file WAV (con estenzione)"
  say "      offset       il punto fino a cui copia (secondi)"
  say "      durata       la durata della transizione al silenzio (secondi)"
  return 1
  end

if durata == "" then durata=0
fc=44100


call SysCls
t=time(R)
c = chkwav(filein)
say "FADEOUT:"
say ""
say "   filein      :" filein
say "   offset (sec):" offset
say "   durata (sec):" durata
say ""

if ((offset * fc) + (durata * fc))> c then do
   say "Segmento oltre la fine del file"
   signal fineko
   end

tr1 = WavAllocTrac(c)
tr2 = WavAllocTrac(c)
say time(E) ":" c*4 "bytes memoria allocata"
rcy = WavReadStereo(filein, tr1, tr2)
say time(E) ":" filein "caricato in memoria"

if durata>0 then do
   tro1 = tr1 + (offset * fc)
   rcy = WavCopyTrac(tro1, tro1, (durata*fc), 1, 0, 'LOG', 'NOMIX')
   tro2 = tr2 + (offset * fc)
   rcy = WavCopyTrac(tro2, tro2, (durata*fc), 1, 0, 'LOG', 'NOMIX')
   say time(E) ": traccia copiata (fadeout)"
   end

c = (offset*fc)+(durata*fc)
rcy = WavWriteStereo(filein, tr1, tr2, c)
say time(E) ":" c*4 "bytes scritti in" filein


fine:
rcy = WavDropTrac(tr1)
rcy = WavDropTrac(tr2)
say time(E) ": memoria rilasciata"
return 0



fineko:
say "fine ko !!!"
pull k
"exit"
/**********************************************************************/


