.*********************************************************************/
.* PC MidiLab - MIDI Sequencer/Editor for OS/2 Presentation Manager  */
.*                                                                   */
.*     MAINCTLP.IPF - *** Main Control Panel Help ***                */
.*                                                                   */
.*       Copyright  J. L. Bell         Jan 1993                      */
.*********************************************************************/
:p.All of the main MidiLab/2 control functions are located on this panel.
Select from the following list for a detailed description of each control:
:ul compact.
:li.:link refid=XCTL     reftype=hd.External Control:elink.
:li.:link refid=VEL_LVL  reftype=hd.Velocity Leveling:elink.
:li.:link refid=METRO    reftype=hd.Metronome:elink.
:li.:link refid=8TH_CLK  reftype=hd.Eighth-note click:elink.
:li.:link refid=TBASE    reftype=hd.Time Base:elink.
:li.:link refid=QTIZE    reftype=hd.Quantize:elink.
:li.:link refid=METER    reftype=hd.Meter:elink.
:li.:link refid=VELOC    reftype=hd.Velocity Adjustment:elink.
:li.:link refid=XPOSE    reftype=hd.Transpose:elink.
:li.:link refid=TEMPO    reftype=hd.Tempo:elink.
:li.:link refid=FILTER   reftype=hd.Filter:elink.
:li.:link refid=PLAYTRKS reftype=hd.Play Tracks:elink.
:li.:link refid=STRTBAR  reftype=hd.Starting Measure:elink.
:li.:link refid=PLAYBARS reftype=hd.Measures to play:elink.
:li.:link refid=PLAYLOOP reftype=hd.Loop Sequence:elink.
:li.:link refid=AUXBUTTS reftype=hd.Auxiliary Control Buttons:elink.
:eul.
.*
:h1 id=VEL_LVL nosearch.Velocity Leveling
:p.This command toggles the Velocity Leveling function.  Velocity leveling is
the "smoothing out" of the note-on velocity in a musical sequence.
:ul.
:li.During recording:
:p.If Velocity Leveling is active, the velocity value for all
notes is forced, or leveled, to a uniform value.  This leveled value is equal to
64 plus or minus the velocity adjustment setting.  For example, if the velocity
adjustment is set to -1, the resultant velocity for every note will be 63.
:li.During playback:
:p.Velocity Leveling can be used to force a uniform velocity even though the
track was recorded with varying velocity.  As in recording operations, the
velocity adjustment facility can be used to add or subtract from the base value
of 64.  The original track data is unchanged.  If a permanent change is
required, the EDIT 'Modify' command can be used.
:hp1.Note that only those tracks that are ENABLED are affected.:ehp1.
:eul.
.*
:h1 id=XCTL nosearch.External Control
:i1.External control
:p.MidiLab/2 can control, or be controlled by, external devices (such as drum
machines) which transmit and/or receive the MIDI real-time messages START, STOP,
and CONTINUE.  The chart below shows the real-time messages generated by the
applicable MidiLab/2 functions, while the next chart describes the actions taken by
MidiLab/2 in response to receiving them.
:table cols='12 12 12 12' rules=both frame=box.
:row.
:c.
:c.Start
:c.Stop
:c.Continue
:row.
:c.Start Rcrd/Ovdb
:c.X
:c.
:c.
:row.
:c.Stop Rcrd/Ovdb
:c.
:c.X
:c.
:row.
:c.Start Play
:c.X
:c.
:c.
:row.
:c.Pause Play
:c.
:c.X
:c.
:row.
:c.Resume Play
:c.
:c.
:c.X
:row.
:c.Play Done
:c.
:c.X
:c.
:etable
.*
:table cols='15 15 15 15' rules=both frame=box.
:row.
:c.
:c.Start
:c.Stop
:c.Continue
:row.
:c.Standby
:c.Start Rcrd/Odub
:c.
:c.Start Rcrd/Ovdb
:row.
:c.Rolling
:c.
:c.Stop Rcrd/Ovdb
:c.Stop Rcrd/Ovdb
:row.
:c.Idle
:c.Start Play
:c.
:c.
:row.
:c.Playing
:c.
:c.Stop Play
:c.
:row.
:c.Pause
:c.Start Play
:c.
:c.Continue Play
:etable.
The real-time facility is switched on and off by the External Control checkbox.
This is a three-stage control; when MidiLab/2 is first started, it is normally
in stage one, meaning no external control is active.  Checking the control
advances it to stage two.  This second stage permits external devices to be
started and stopped according to the above tables. (Insure that this device is
connected to your MIDI-IN port. An argument (/X) can be passed to MidiLab/2
at start-up time to force stage two to become active.)
The setting of the external control (on/off) is stored in the song profile.
:note.The MidiLab/2 metronome adjustment is disabled when an external sync
mode is in effect, since the metronome is under control of an external device.

:p.MidiLab/2 also provides capability to synchronize itself with an external
clock.  The third stage of the checkbox control is used for this option.
The MIDI Song Position Pointer message is sent when playback is started
at a point beyond the beginning of a song, to allow other devices to set
themselves to the corresponding point.  MidiLab/2 also responds to incoming
Song Position Pointers from other sources.
.*
:h1 id=METRO nosearch.Metronome
:p.The audible metronome is turned on or off by this control.
.*
:h1 id=8TH_CLK nosearch.Eighth-note click
:p.The metronome is toggled between sounding quarter or eighth notes.
Internal timing values, including the track data timing bytes, are not
affected.
.*
:h1 id=TBASE nosearch.Time Base
:p.The MPU time base is set by this function.  The number represents PPQ's
(pulses per quarter note), and as such determines the resolution of the
musical notes and other events.
.*
:h1 id=QTIZE nosearch.Quantize
:p.The MidiLab/2 quantization function corrects imprecise note timings you may
play while recording a track.  In other words, if you play a quarter note a
small amount ahead of or behind the exact beat, the timing can be adjusted to
force the note to fall exactly on the beat.  Quantization takes place after a
track is recorded.  It can be employed during playback; in this case the notes
are quantized "on the fly", and the original track data remains unchanged.
The Edit 'MODIFY' command provides a means of permanently altering the
quantization of a track.
:p.You may select several quantize values, each of which represents the
fastest note you will be playing.  For instance, if quantization is set to
1/8, you can play any notes up to and including eighth notes.  If you try to
play sixteenth notes, they will not be recorded properly.  The available
values are 1/4, 1/6, 1/8, 1/12, 1/16, 1/24, and 1/32, with the one selected
shown highlighted in the list.
:p.Use the metronome and play as accurately as possible.  Gross errors in
timing can not be corrected, and will produce an error message.  Quantization
should be used with discretion; certain patterns of music tend to sound
"mechanical" if everything is perfectly timed.
.*
:h1 id=METER  nosearch.Meter
:p.This control sets the time signature as number of beats per quarter note.
.*
:h1 id=VELOC nosearch.Velocity Adjustment
:p.This adjustment provides for varying the velocity factor associated with
all notes in a song.  During playback, it effectively increases or decreases
the force with which a key was originally struck.  During recording, if
velocity leveling is active, it is used to add or subtract from the base value
of 64 to force a uniform velocity for all notes.
.*
:h1 id=XPOSE  nosearch.Transpose
:p.This is a numeric value which in effect transposes the key of the song
during playback.  As an example, if a song were in the key of C, a
transposition value of -2 would take it down two half-steps to the key of
B-flat.  See the section on recording operations for special use of this
facility.
.*
:h1 id=TEMPO  nosearch.Tempo
:p.The tempo can be changed during playback or recording and will be set
according to the song profile if a song is loaded from disk.  The
transposition and velocity adjustments may also be set or reset in the same
way.
.*
:h1 id=FILTER  nosearch.Filter
:p.Permits selective filtering of MIDI control information.  There are three
settings:  the first two (ALL and NONE) apply to continuous controls
during recording operations, and the last (PGM) applies to program/voice changes
during playback.  "Continuous" controls are those MIDI messages such as
Pitch-bend, Modulation, and Channel after-touch.
:p.When MidiLab/2 is first started, all continuous controls are filtered, or
disabled (ALL).  Program changes are :hp1.not:ehp1.  filtered in this state.
NONE means that nothing is filtered (NONE).
PGM will filter program/voice changes, as well as
all continuous controls.  ALL will return things to their initial state, i.e.,
everything is filtered except for program changes.
:note.ALL and NONE apply only to the track being recorded, while PGM
applies to all tracks being played.
.*
:h1 id=PLAYTRKS nosearch.Play Tracks
:p.These controls permit switching of the following functions on individual
tracks:
:ul.
:li.Solo
:p.Allows one or more tracks to be solo'ed during playback. A :hp2.Mute:ehp2. can
be achieved by checking all solo boxes with the :hp2.ALL:ehp2. button, then
un-checking the individual track or tracks you wish to mute.
:li.Activate Track(s)
:p.Allows which tracks are selected for Playback.
:li.Enabled Tracks
:p.The tracks affected by the Transposition, Velocity, and Quantization
adjustments during playback are controlled by the Enable/Disable function.  You
may allow (Enable) any combination of tracks to be affected by these
adjustments, and the combination will be saved in the Song Profile.
:eul.
:p.The :hp2.ALL:ehp2. buttons for each of the above are used to save time by
quickly setting all tracks on or off.
:h1 id=STRTBAR  nosearch.Starting Measure
:p.You may choose to start the playback process at some point other than the
beginning of the song.  This is done by specifying the number of the measure at
which you wish to begin.  The tracks are then positioned to this measure and
playback proceeds normally.
.*
:h1 id=PLAYBARS nosearch.Measures to play
:p.You may choose the number of measures to play. This number is offset from
the :link refid=STRTBAR reftype=hd.Starting Measure:elink. value. Playback will
be paused when the specified number of measures has been played.
:p.The default value is :hp2.9999:ehp2., the highest possible option.
.*
:h1 id=PLAYLOOP nosearch.Loop Sequence
:p.The sequence defined by
:link refid=STRTBAR reftype=hd.Starting measure:elink. and
:link refid=PLAYBARS reftype=hd.Measures to play:elink. will be repeated
indefinitely if this box is checked. :note.If an extremely short sequence is looped, it may be necessary to un-check
the :hp2.Loop Sequence:ehp2. control as the only means of stopping Play.
:p.The setting of this option is saved in the initialization file.
.*
:h1 id=AUXBUTTS nosearch.Auxiliary Control Buttons
:p.These four buttons, along with Sys Reset, are duplicates of the corresponding
buttons on the MidiLab main window, and are placed here for convenience.
