/**********************************************************/
/*            MIDI Station Sequencer for OS/2             */
/*                    Version 3.0                         */
/*                 Installation Program                   */
/*         (C) Copyright 2000 Christopher Hodges          */
/**********************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

InstallDir = ''
DLLDir = ''
StartupDir = Directory()

/* Product Information */
'@cls'
Say '       MIDI Station Sequencer for OS/2 Version 3.0'
Say '        (C) Copyright 2001 Christopher Hodges'
Say '                 All rights reserved'
/* Query installation directory. */

Call GetMStationInstallDir
Call Install
Call SetupFileAssocations

Exit


GetMStationInstallDir:

    If InstallDir = '' Then Do
        Say
        Say 'Please enter the directory you wish to install to:  (Ex: C:\SEQUENCE)'
        Call CharOut, '=> '
        Parse Pull InstallDir
        Say
    End
    If InstallDir = '' Then Do
        Say 'Error: Could not find installation dir.'
        Exit
    End

    /* Check if dir exists. */
    If Stream( InstallDir, 'c', 'query exists' ) = '' Then Do
        rc = SysMkDir( InstallDir )
        If rc <> 0 & rc <> 5 Then Do
            Say 'Error: Could not make directory ('InstallDir'), error code = ('rc')'
            Exit
        End
        Else If rc = 0 Then Do
               Say 'Directory ('InstallDir') created...'
             End
    End

    /* Write installation directory. */
    Say 'Installation directory is ('InstallDir')'
    return

Install:

    /* Unpack files. */

        /* Unpack file to installation directory. */
        Call ChangeDriveAndPath InstallDir
        Say 'In install directory'
        Copy StartupDir'\MSEQUNCE.EXE' '"'InstallDir'"'
        Copy StartupDir'\MSTATSEQ.HLP' '"'InstallDir'"'
        Copy StartupDir'\METNOME.WAV'  '"'InstallDir'"'
        Copy StartupDir'\PATCHES.INI'  '"'InstallDir'"'
        Copy StartupDir'\DRUMS.INI'    '"'InstallDir'"'
        Copy StartupDir'\BMTMICRO.TXT' '"'InstallDir'"'
        Copy StartupDir'\README.1ST'   '"'InstallDir'"'
        Copy StartupDir'\UPDATES.TXT'   '"'InstallDir'"'
        Say
        /* Change back to startup directory. */
        Call ChangeDriveAndPath StartupDir
        If FileSpec( Drive, StartupDir ) <> FileSpec( Drive, InstallDir ) Then
            '@cd 'FileSpec( Drive, InstallDir )'\'


    /* Create the object. */

        Say
        Say 'Creating objects.'

        /* Create folder. */
        rc = SysCreateObject(   'WPFolder',,
                                'MIDI Station Sequencer',,
                                '<WP_DESKTOP>',,
                                'OBJECTID=<MIDI_Station_Sequencer>;',
                                ';ICONVIEWPOS=33,33,34,34;ALWAYSSORT=YES;',
                                ,,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create the MIDI Station Sequencer Folder Object.'

        /* Create program. */
        rc = SysCreateObject(   'WPProgram',,
                                'MIDI Station Sequencer 3.0',,
                                '<MIDI_Station_Sequencer>',,
                                'EXENAME='InstallDir'\MSEQUNCE.EXE;STARTUPDIR='InstallDir';OBJECTID=<MStation_Seq>;',,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create MIDI Station Sequencer object.'

        setting="OBJECTID=<MSTATION_DOCS>;"||,
                 "EXENAME=VIEW.EXE;"||,
                 "PARAMETERS=MSTATSEQ.HLP;"||,
                 "STARTUPDIR="InstallDir";"||,
                 "PROGTYPE=PM;"
        rc = SysCreateObject("WPProgram", "MIDI Station Sequencer 3.0 Info", "<MIDI_Station_Sequencer>", setting, "R")

        If rc <> 1 Then Say  'Error: could not create MIDI Station Sequencer Information object.'

        Call SysSetObjectData '<MIDI_Station_Sequencer>', 'OPEN=DEFAULT;'

        say
        say 'MIDI Station Sequencer successfully installed...'

    return

SetupFileAssocations:

       call SysSetObjectData "<MStation_Seq>" , "ASSOCFILTER=*.MID;"
       call SysSetObjectData "<MStation_Seq>" , "ASSOCFILTER=*.MSQ;"
       call SysSetObjectData "<MStation_Seq>" , "ASSOCFILTER=*.MAU;"

    return


ChangeDriveAndPath:
    Parse Arg DriveAndPath

    /* Get drive and path */
    Say
    Say 'Changing to 'DriveAndPath
    ChangeToDrive = FileSpec( Drive, DriveAndPath )
    ChangeToPath = FileSpec( Path, DriveAndPath )
    ChangeToPath = Left( ChangeToPath, Length( ChangeToPath ) - 1 )

    /* Change drive and path. */
    Say 'Changing drive to 'ChangeToDrive
    '@'ChangeToDrive
    If rc <> 0 Then Do
        Say 'Error: could not change drive.'
        Exit
    End
    Say 'Changing directory to 'ChangeToPath
    '@cd 'ChangeToPath
    If rc <> 0 Then Do
        Say 'Error: could not change directory.'
        Exit
    End

    return

