/* REXX installation script for WarpTuner
 * Copyright (C) 1998 by Dmitry Malenok
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

installdir = directory()"\"
installlog = installdir"install.log"

if GetYesNo( "Install WarpTuner in "installdir ) == 0 then
   exit

/*------------------------------------------------------------------
 * Create WarpTuner folder
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPFolder","WarpTuner","<WP_DESKTOP>",,
                      "OBJECTID=<WTFolder>;ALWAYSSORT=Yes" ,"REPLACE" )

if rc then
   call log "WarpTuner folder successfully created on desktop..."
else
   call log "ERROR:WarpTuner folder creating failed!"

/*------------------------------------------------------------------
 * Create MiniTuner object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", "MiniTuner", "<WTFolder>",,
                      "OBJECTID=<MINITUN>;EXENAME="installdir"minitun.EXE;STARTUPDIR="installdir,
                      "REPLACE" )

if rc then
   call log "MiniTuner object successfully created..."
else 
   call log "ERROR: MiniTuner object creating failed!"

rc = SysCreateObject( "WPShadow", "MiniTuner", "<WP_START>",,
                      "SHADOWID=<MINITUN>",,
                      "REPLACE" )

if rc then
   call log "MiniTuner object added in Startup folder..."
else 
   call log "ERROR: MiniTuner object adding in Startup folder failed!"

/*------------------------------------------------------------------
 * Create WarpTuner object
 *------------------------------------------------------------------*/

rc = SysSetIcon(installdir"warptun.EXE",installdir"radio.ico")
rc = SysCreateObject( "WPProgram", "WarpTuner", "<WTFolder>",,
                      "EXENAME="installdir"warptun.EXE;STARTUPDIR="installdir,,
                      "REPLACE" )

if rc then
   call log "WarpTuner object successfully created..."
else 
   call log "ERROR: WarpTuner object creating failed!"

/*------------------------------------------------------------------
 * Create WarpTuner Uninstall object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", "Uninstall WarpTuner", "<WTFolder>",,
                      "ICONFILE="installdir"UNINSTL.ICO;EXENAME=*;PROGTYPE=PM;PARAMETERS=/C "installdir"UNINSTL.CMD;STARTUPDIR="installdir,,
                      "REPLACE" )

if rc then
   call log "Uninstall object successfully created..."
else 
   call log "ERROR: Uninstall object creating failed!"


/*------------------------------------------------------------------
 * Install Driver
 *------------------------------------------------------------------*/

SAY "Enter tuner port in hex:"
PULL TunerPort
SAY "Enter sound blaster port in hex:"
PULL SBPort

rc = SysIni( "BOTH", "FolderWorkareaRunningObjects", "ALL:", "objects" );
configsys = left( objects.1, 2 )"\CONFIG.SYS"
call log "CONFIG.SYS found as: "configsys"..."

configbak = SysTempFileName( left( objects.1, 2 )"\CONFIG.???" )
"@copy "configsys" "configbak" 1>NUL 2>NUL"

if rc == 0 then
   call log "Backup copy of "configsys" is placed in "configbak"..."
else 
   call log "ERROR: Creating backup copy of "configsys" failed!"

i = 1
do while lines(configsys)
   config.i = linein(configsys)
   parse value translate(config.i) with  command "=" devpath
   
   if command \= "DEVICE" | lastpos( "TURNON.SYS", devpath ) == 0 then
      i = i + 1
end
config.0 = i - 1
rc = stream( configsys, 'c', 'close' )
'@del 'configsys

rc = lineout( configsys,,1 )
do i = 1 to config.0
   rc = lineout( configsys, config.i )
end
rc = lineout( configsys, "device="installdir"turnon.sys "SBPort" "TunerPort )
rc = stream( configsys, 'c', 'close' )

call log "Driver added in "configsys"..."
call log "------------------ Done! -----------------------"
exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "INSTALL: "msg

return
