/* Write CDMagic.log into an archive-zip	

   The current cdmagic-logfile is copied under a new name reflecting its times-stamp,
   then packed into a zip-archive.

   The logs in the archive can be viewed with new program GetLog.exe,
   or from the CDMagic-main-menu -> file -> view logfiles

*/

parse arg LogFile ArchName;	/* YGlob.YLogFile (full path)	*/

say "Archiving logFile="LogFile"...";

cdm_path = filespec("drive",LogFile) || filespec("path",LogFile);

Archive = cdm_path || ArchName;	/* "cdma_log.zip"		*/

time = time();
parse value time with hh ":" mm ":" ss;

date = date("S");
date = left(date,4) ||"-"|| substr(date,5,2) ||"-"|| right(date,2);

TS = date ||"#"|| hh ||"-"|| mm ||"-"|| ss ;


Tempfile = TS || ".log";

"copy "LogFile Tempfile;

"zip" Archive Tempfile;

"del "Tempfile;

if(0) then do
	say "press any key..."; pull;
end;

exit;
