/* Port of showone.bat from standard FIGlet distribution to */
/* a REXX batch file for OS/2                               */
/*                                                          */
/* Original version written by                              */
/* Ben Kleinman March 6,1996                                */
/*                                                          */
/* Changes made by Jim Northrup <northrup@bright.net> on    */
/*    5/31/97 - added "Usage" statement                     */
/*    5/31/97 - added checking for presence of test.txt     */
/*                                                          */
/* font1 is the font that the user wishes to see displayed  */
/*                                                          */

call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

echo off
call syscls

SHOWONE:
arg font1

if font1 = "" then
   do
   say ""
   say ""
   say "Usage:  showone fontname"
   say ""
   say "where fontname is the name of the font to display"
   say ""
   end
else
   do
   if stream( "test.txt", "c", "QUERY EXIST" ) <> "" then
      do
      figlet "-f" font1 "< test.txt"
      say "This is" font1
      end
   else
      do
      say ""
      say ""
      say "You need to create a file named test.txt whose contents"
      say "will be used to display the FIGfont specified."
      say ""
      end
   end
return