# include "TempScal.h"
# include "yyTScala.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 26 "TempScalars.puma"

# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "Transfor.h"  /* AppendDECLS, CombineACF */
# include "Types.h"      /* ArrayCompType */

static tTree new_decls;          /* global used for new declarations */
static tTree new_stmts;          /* global used when creating the local */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempScalars, routine %s failed\n", yyFunction);
 exit (1);
}

void TempScalarsInitBody ARGS((tTree t));
void TempScalarsDoneBody ARGS((tTree t));
tTree ExtractScalarMovements ARGS((tTree exp, tTree * new_assigns));
static tTree DoIt ARGS((tTree exp));
static tTree MakeScalarTemporary ARGS((tTree var));
static tTree NewTempScalarVar ARGS((tDefinitions Obj, int no));
static tDefinitions MakeNewScalarObject ARGS((tDefinitions Obj, tIdent new_name));
static int NextNumber ARGS((tIdent name, tTree assignments));
static bool IsUsed ARGS((tIdent name, tTree assignment));
tTree MakeNewLoopVar ARGS((int n));
static tDefinitions MakeNewLoopVarObj ARGS((tIdent id));

void TempScalarsInitBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBODY_NODE) {
# line 48 "TempScalars.puma"
  {
# line 49 "TempScalars.puma"
   new_decls = mDECL_EMPTY ();
  }
   return;

  }
# line 52 "TempScalars.puma"
  {
# line 53 "TempScalars.puma"
   printf ("Illegal Call of TempScalarsInitBody");
# line 54 "TempScalars.puma"
   kill_in_protocol ();
  }
   return;

;
}

void TempScalarsDoneBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBODY_NODE) {
# line 65 "TempScalars.puma"
  {
# line 67 "TempScalars.puma"
   tree_protocol ("This are new created scalar temporaries : \n", new_decls);
# line 68 "TempScalars.puma"
 t->BODY_NODE.DECLS = AppendDECLS (t->BODY_NODE.DECLS, new_decls);
  }
   return;

  }
# line 71 "TempScalars.puma"
  {
# line 72 "TempScalars.puma"
   printf ("Illegal Call of TempScalarsDoneBody");
# line 73 "TempScalars.puma"
   kill_in_protocol ();
  }
   return;

;
}

tTree ExtractScalarMovements
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * new_assigns)
# else
(exp, new_assigns)
 register tTree exp;
 register tTree * new_assigns;
# endif
{
# line 96 "TempScalars.puma"
 {
  tTree result;
  tTree e;
  {
# line 98 "TempScalars.puma"

# line 99 "TempScalars.puma"

# line 101 "TempScalars.puma"
 new_stmts = NoTree;
   e = DoIt (exp);
   result = new_stmts;

  }
   * new_assigns = result;
  {
   return e;
  }
 }

}

static tTree DoIt
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kBTE_LIST:
# line 119 "TempScalars.puma"
  {
# line 120 "TempScalars.puma"
 exp->BTE_LIST.Elem = DoIt (exp->BTE_LIST.Elem);
     exp->BTE_LIST.Next = DoIt (exp->BTE_LIST.Next);

  }
   return exp;

  case kBTE_EMPTY:
# line 126 "TempScalars.puma"
   return exp;

  case kBTV_LIST:
# line 130 "TempScalars.puma"
  {
# line 131 "TempScalars.puma"
 exp->BTV_LIST.Elem = DoIt (exp->BTV_LIST.Elem);
     exp->BTV_LIST.Next = DoIt (exp->BTV_LIST.Next);

  }
   return exp;

  case kBTV_EMPTY:
# line 137 "TempScalars.puma"
   return exp;

  case kBTP_LIST:
# line 141 "TempScalars.puma"
  {
# line 142 "TempScalars.puma"
 exp->BTP_LIST.Elem = DoIt (exp->BTP_LIST.Elem);
     exp->BTP_LIST.Next = DoIt (exp->BTP_LIST.Next);

  }
   return exp;

  case kBTP_EMPTY:
# line 148 "TempScalars.puma"
   return exp;

  case kVAR_PARAM:
# line 152 "TempScalars.puma"
  {
# line 153 "TempScalars.puma"
 exp->VAR_PARAM.V = DoIt (exp->VAR_PARAM.V);

  }
   return exp;

  case kADDR:
# line 158 "TempScalars.puma"
  {
# line 159 "TempScalars.puma"
 exp->ADDR.E = DoIt (exp->ADDR.E);

  }
   return exp;

  case kDUMMY_EXP:
# line 164 "TempScalars.puma"
   return exp;

  case kSLICE_EXP:
# line 168 "TempScalars.puma"
  {
# line 169 "TempScalars.puma"
 exp->SLICE_EXP.START = DoIt (exp->SLICE_EXP.START);
     exp->SLICE_EXP.STOP  = DoIt (exp->SLICE_EXP.STOP);
     exp->SLICE_EXP.INC   = DoIt (exp->SLICE_EXP.INC);

  }
   return exp;

  case kOP_EXP:
# line 176 "TempScalars.puma"
  {
# line 178 "TempScalars.puma"
 exp->OP_EXP.OPND1 = DoIt (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = DoIt (exp->OP_EXP.OPND2);

  }
   return exp;

  case kOP1_EXP:
# line 184 "TempScalars.puma"
  {
# line 185 "TempScalars.puma"
 exp->OP1_EXP.OPND = DoIt (exp->OP1_EXP.OPND);
  }
   return exp;

  case kFUNC_CALL_EXP:
  if (Definitions_IsType (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object, kObject)) {
# line 189 "TempScalars.puma"
  {
# line 190 "TempScalars.puma"
 exp->FUNC_CALL_EXP.FUNC_PARAMS = DoIt (exp->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return exp;

  }
  break;
  case kVAR_EXP:
# line 194 "TempScalars.puma"
  {
# line 195 "TempScalars.puma"
 exp->VAR_EXP.V = DoIt (exp->VAR_EXP.V);
  }
   return exp;

  case kCONST_EXP:
# line 199 "TempScalars.puma"
   return exp;

  case kARRAY_EXP:
# line 203 "TempScalars.puma"
  {
# line 204 "TempScalars.puma"
 exp->ARRAY_EXP.ELEMENTS = DoIt (exp->ARRAY_EXP.ELEMENTS);
  }
   return exp;

  case kUSED_VAR:
# line 208 "TempScalars.puma"
   return exp;

  case kLOOP_VAR:
# line 212 "TempScalars.puma"
   return exp;

  case kINDEXED_VAR:
  if (exp->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 216 "TempScalars.puma"
  {
# line 218 "TempScalars.puma"
   if (! (TreeRank (exp) == 0)) goto yyL19;
  {
# line 219 "TempScalars.puma"
   if (! (TreeDistribution (exp->INDEXED_VAR.IND_VAR) != 0)) goto yyL19;
  {
# line 223 "TempScalars.puma"
 exp->INDEXED_VAR.IND_EXPS = DoIt (exp->INDEXED_VAR.IND_EXPS);
  }
  }
  }
   return MakeScalarTemporary (exp);
yyL19:;

# line 228 "TempScalars.puma"
  {
# line 229 "TempScalars.puma"
 exp->INDEXED_VAR.IND_EXPS = DoIt (exp->INDEXED_VAR.IND_EXPS);
  }
   return exp;

  }
  break;
  case kSUBSTRING_VAR:
# line 233 "TempScalars.puma"
  {
# line 234 "TempScalars.puma"
 exp->SUBSTRING_VAR.IND_EXP = DoIt (exp->SUBSTRING_VAR.IND_EXP);
  }
   return exp;

  case kDO_EXP:
# line 238 "TempScalars.puma"
  {
# line 239 "TempScalars.puma"
 exp->DO_EXP.RANGE = DoIt (exp->DO_EXP.RANGE);
     exp->DO_EXP.BODY  = DoIt (exp->DO_EXP.BODY);

  }
   return exp;

  case kDO_VAR:
# line 245 "TempScalars.puma"
  {
# line 246 "TempScalars.puma"
 exp->DO_VAR.RANGE = DoIt (exp->DO_VAR.RANGE);
     exp->DO_VAR.BODY  = DoIt (exp->DO_VAR.BODY);

  }
   return exp;

  }

# line 252 "TempScalars.puma"
  {
# line 253 "TempScalars.puma"
   failure_protocol ("TempScalars", "DoIt", exp);
  }
   return exp;

}

static tTree MakeScalarTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 270 "TempScalars.puma"
 {
  int number;
  tTree scvar;
  tTree stmt;
  {
# line 272 "TempScalars.puma"

# line 274 "TempScalars.puma"

# line 275 "TempScalars.puma"

# line 277 "TempScalars.puma"
 number = NextNumber (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, new_stmts);

     scvar = NewTempScalarVar (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object, number);
     scvar = mUSED_VAR (scvar);

     stmt = mASSIGN_STMT (scvar, mVAR_EXP (var));
     stmt = mACF_BASIC (stmt);
     new_stmts = CombineACF (new_stmts, mACF_LIST (stmt, NoTree));


  }
  {
   return CopyTree (scvar);
  }
 }

  }
  }
 yyAbort ("MakeScalarTemporary");
}

static tTree NewTempScalarVar
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register int no)
# else
(Obj, no)
 register tDefinitions Obj;
 register int no;
# endif
{
# line 304 "TempScalars.puma"

char string1[MAXID_LENGTH], string2[MAXID_LENGTH];
tIdent newname;
tObject scalar_obj;
tTree t;

  if (Obj->Kind == kVarObject) {
# line 311 "TempScalars.puma"
  {
# line 313 "TempScalars.puma"
 GetString (Obj->VarObject.ident, string1);
     sprintf (string2, "%s_SC%d", string1, no);
     newname = MakeIdent (string2, strlen (string2));

     scalar_obj = GetLocalDecl (newname);
     if (scalar_obj == NoObject)
       scalar_obj = MakeNewScalarObject (Obj, newname);

     t = mVAR_OBJ (0, newname);
     t->VAR_OBJ.Object = scalar_obj;

  }
   return t;

  }
 yyAbort ("NewTempScalarVar");
}

static tDefinitions MakeNewScalarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register tIdent new_name)
# else
(Obj, new_name)
 register tDefinitions Obj;
 register tIdent new_name;
# endif
{
# line 337 "TempScalars.puma"
 {
  tTree new_decl;
  tDefinitions new_obj;
  {
# line 339 "TempScalars.puma"

# line 340 "TempScalars.puma"

# line 342 "TempScalars.puma"
 new_decl  = mVAR_DECL (new_name, 0, CopyTree (ArrayCompType (Obj)));

    new_decls = mDECL_LIST (new_decl, new_decls);

    new_obj = mVarObject (new_name, new_decl,
               mVarLocal (0, 0), 0, mSerialDistribution (0, 0));

    InsertEntry (new_obj);

  }
  {
   return new_obj;
  }
 }

}

static int NextNumber
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree assignments)
# else
(name, assignments)
 register tIdent name;
 register tTree assignments;
# endif
{
# line 369 "TempScalars.puma"
  {
# line 370 "TempScalars.puma"
   if (! (assignments == NoTree)) goto yyL1;
  }
   return 1;
yyL1:;

  if (assignments->Kind == kACF_LIST) {
  if (assignments->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (assignments->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 374 "TempScalars.puma"
  {
# line 375 "TempScalars.puma"
   if (! (IsUsed (name, assignments->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP))) goto yyL2;
  }
   return NextNumber (name, assignments->ACF_LIST.Next) + 1;
yyL2:;

  }
  }
# line 379 "TempScalars.puma"
   return NextNumber (name, assignments->ACF_LIST.Next);

  }
 yyAbort ("NextNumber");
}

static bool IsUsed
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree assignment)
# else
(name, assignment)
 register tIdent name;
 register tTree assignment;
# endif
{
  if (assignment == NoTree) return false;
  if (assignment->Kind == kVAR_EXP) {
  if (assignment->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (assignment->VAR_EXP.V->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 385 "TempScalars.puma"
  {
# line 386 "TempScalars.puma"
   if (! (assignment->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident == name)) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  }
  return false;
}

tTree MakeNewLoopVar
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
# line 398 "TempScalars.puma"

char loop_name[10];
tIdent loop_id;
tObject obj;
tTree var;

# line 405 "TempScalars.puma"
  {
# line 406 "TempScalars.puma"
  sprintf (loop_name, "I_%d", n);
      loop_id = MakeIdent (loop_name, strlen (loop_name));

      obj = GetLocalDecl (loop_id);

      if (obj == NoObject)
         {
           obj = MakeNewLoopVarObj (loop_id);
         }

      var = mVAR_OBJ (0, loop_id);
      var->VAR_OBJ.Object = obj;

      var = mLOOP_VAR (var);

  }
   return var;

}

static tDefinitions MakeNewLoopVarObj
# if defined __STDC__ | defined __cplusplus
(register tIdent id)
# else
(id)
 register tIdent id;
# endif
{
# line 426 "TempScalars.puma"

tTree new_decl;
tObject obj;
tIdent name;
char s[10];

# line 433 "TempScalars.puma"
  {
# line 434 "TempScalars.puma"
 new_decl = mVAR_DECL (id, 0, mINTEGER_TYPE(4));

     new_decls = mDECL_LIST (new_decl, new_decls);

     obj  = mVarObject (
                 id, new_decl, mVarLocal (0, 0),
                 0,
                 mSerialDistribution (0, 0) );

     InsertEntry (obj);

  }
   return obj;

}

void BeginTempScalars ()
{
}

void CloseTempScalars ()
{
}
