      program bench
      real*4 dates (:,:), controldates (:,:)
      logical*4 okay (:,:)
      real*4 tstart, tstop

      integer n, size, transfers, sum

      print *, 'Number of nodes : '
      read *, n

      print *, 'Number of dates : '
      read *, size

      print *, 'Number of transfers'
      read *, transfers

      allocate (dates(size,n),controldates(size,n),okay(size,n))
      call cmf_random (dates)
      controldates = dates

      call cm_timer_clear (0)
      call cm_timer_start (0)
      call walltime (tstart)

      do i = 1, transfers
        do j = 1, n
          dates = cshift (dates, 2, 1)
        end do
      end do

      call cm_timer_stop (0)
      call walltime (tstop)
      call cm_timer_print (0)

C     compare the results
      okay = (dates .ne. controldates)
      sum = count (okay)
      print *, 'Transfers = ', transfers 
      print *, 'Shifts = ', transfers * n
      print *, 'Size = ', transfers*n*size*4, ' Bytes'
      print *, 'Wrong results : ', sum
      print *, 'Time needed : ', tstop - tstart

      deallocate (okay, controldates, dates)

      end
