# include "Movement.h"
# include "yyAMovem.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 30 "AdaptMovement.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "Types.h"
# include "Transfor.h"   /* ExpToVarParam */
# include "Dalib.h"       /* MakeProcObj, ... */
# include "Shapes.h"      /* MakeFullShape, NormalizeShape, ..  */
# include "Local.h"  /* LocalArrayAssignment            */
# include "Expressi.h" /* MakeConstant, MakeSliceExp, ... */

# include "Globals.h"     /* GenGlobalSend, GenGlobalGet     */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptMovement, routine %s failed\n", yyFunction);
 exit (1);
}

tTree AdaptOverlappedMovement ARGS((tTree assign));
static tTree MakeLocalOverlap ARGS((tTree var, tTree var1));
static tTree MakeCommOverlap ARGS((tTree var, tTree var1));
static tTree MakeOverlapBounds ARGS((tTree formals, tTree params));
tTree AdaptTranspose ARGS((tTree assign));
static tTree MakeLocalTranspose ARGS((tTree var, tTree var1));
static tTree MakeCommTranspose ARGS((tTree var, tTree var1));
tTree AdaptCShift ARGS((tTree assign));
static tTree MakeLocalCShift ARGS((tTree var, tTree var1, tTree dim, tTree pos));
static tTree MakeCommCShift ARGS((tTree var, tTree var1, tTree dim, tTree pos));
static tTree MakeCShiftBounds ARGS((tTree formals, tTree params));
static tTree MakeTransposeBounds ARGS((tTree formals, tTree size, tTree params));
tTree AdaptArrayMovement ARGS((tTree assign, int vardistribution, int expdistribution));
static tTree AdaptHNMovement ARGS((tTree assign));
static tTree MakeHostNodeTransfer ARGS((tTree hostvar, tTree nodevar));
static tTree AdaptNHMovement ARGS((tTree assign));
static tTree MakeNodeHostTransfer ARGS((tTree nodevar, tTree hostvar));
static tTree AdaptRNMovement ARGS((tTree assign));
static tTree MakeAllNodeTransfer ARGS((tTree repvar, tTree nodevar));
static tTree AdaptNNMovement ARGS((tTree assign, int moves));
tTree AdaptNNCopy ARGS((tTree lvar, tTree rvar));
static tTree AdaptHelpFn ARGS((tTree var, tTree slice, tTree params));
static tTree AdaptNNIndirect ARGS((tTree lvar, int d1, tTree rvar, int d2));
static tTree AdaptNNGet ARGS((tTree lvar, tTree rvar));
static tTree AdaptNNSet ARGS((tTree lvar, tTree rvar));
static bool IndexStrides ARGS((tTree t));
static bool NoSliceExp ARGS((tTree t));
static tTree MakeIndexParams ARGS((tTree indexes));
static void CheckMoveArrays ARGS((tTree source, tTree target));

tTree AdaptOverlappedMovement
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 60 "AdaptMovement.puma"
 {
  tTree new;
  int dist;
  {
# line 62 "AdaptMovement.puma"

# line 63 "AdaptMovement.puma"

# line 65 "AdaptMovement.puma"
 CheckMoveArrays (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
     new  = NoTree;
     dist = TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     if (TreeRank (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V) != TreeRank (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))
        error_protocol ("overlapped assign, var = var', var' is illegal");
      else if (!IsWholeVar (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))
        error_protocol ("overlapped assign, var = var', var is sliced");
      else if (!IsWholeVar (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V))
        error_protocol ("overlapped assign, var = var', var' is sliced");
      else if (IsArrayOverlapped(assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V))
        error_protocol ("overlapped assign, right side must not be overlapped");
      else if (dist != TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V))
        error_protocol ("overlapped assign, different distributions");
      else if (dist == 0)
        new = MakeLocalOverlap (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
      else if (dist == -1)
        { if (IsHost)
            new = MakeLocalOverlap (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
           else
            new = NoTree;
        }
      else
        { if (!IsHost)
            new = MakeCommOverlap (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
           else
            new = NoTree;
        }

  }
  {
   return new;
  }
 }

  }
  }
# line 96 "AdaptMovement.puma"
  {
# line 97 "AdaptMovement.puma"
   error_protocol ("overlapped assign, not var = var'");
  }
   return assign;

  }
 yyAbort ("AdaptOverlappedMovement");
}

static tTree MakeLocalOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1)
# else
(var, var1)
 register tTree var;
 register tTree var1;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 109 "AdaptMovement.puma"
   return MakeLocalOverlap (var->INDEXED_VAR.IND_VAR, var1);

  }
  if (var1->Kind == kINDEXED_VAR) {
# line 113 "AdaptMovement.puma"
   return MakeLocalOverlap (var, var1->INDEXED_VAR.IND_VAR);

  }
  if (var->Kind == kUSED_VAR) {
  if (var1->Kind == kUSED_VAR) {
# line 117 "AdaptMovement.puma"
 {
  tTree new;
  tTree params;
  {
# line 118 "AdaptMovement.puma"

# line 119 "AdaptMovement.puma"

# line 120 "AdaptMovement.puma"
 stmt_protocol ("Local Overlap");
     new    = mPROC_OBJ (MakeDalibId1 ("loverlap", VarRank(var->USED_VAR.VARNAME->VAR_OBJ.Object)));
     params = mBTP_EMPTY();
     params = mBTP_LIST (ExpToVarParam (MakeConstant (TreeSize (var))), params);
     params = MakeOverlapBounds (ArrayFormals (var->USED_VAR.VARNAME->VAR_OBJ.Object), params);

     params = mBTP_LIST (mVAR_PARAM(var), mBTP_LIST (mVAR_PARAM(var1), params));
     new    = mACF_BASIC (mCALL_STMT (new, params));
     tree_protocol ("New Dalib Call is : ", new);

  }
  {
   return new;
  }
 }

  }
  }
 yyAbort ("MakeLocalOverlap");
}

static tTree MakeCommOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1)
# else
(var, var1)
 register tTree var;
 register tTree var1;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 141 "AdaptMovement.puma"
   return MakeCommOverlap (var->INDEXED_VAR.IND_VAR, var1);

  }
  if (var1->Kind == kINDEXED_VAR) {
# line 145 "AdaptMovement.puma"
   return MakeCommOverlap (var, var1->INDEXED_VAR.IND_VAR);

  }
  if (var->Kind == kUSED_VAR) {
  if (var1->Kind == kUSED_VAR) {
# line 149 "AdaptMovement.puma"
 {
  tTree new;
  tTree params;
  {
# line 150 "AdaptMovement.puma"

# line 151 "AdaptMovement.puma"

# line 152 "AdaptMovement.puma"
 stmt_protocol ("Communication Overlap");
     new    = mPROC_OBJ (MakeDalibId1 ("coverlap", VarRank(var->USED_VAR.VARNAME->VAR_OBJ.Object)));
     params = mBTP_EMPTY();
     params = mBTP_LIST (ExpToVarParam (MakeConstant (TreeSize (var))), params);
     params = MakeOverlapBounds (ArrayFormals (var->USED_VAR.VARNAME->VAR_OBJ.Object), params);

     params = mBTP_LIST (mVAR_PARAM(var), mBTP_LIST (mVAR_PARAM(var1), params));
     new    = mACF_BASIC (mCALL_STMT (new, params));
     tree_protocol ("New Dalib Call is : ", new);

  }
  {
   return new;
  }
 }

  }
  }
 yyAbort ("MakeCommOverlap");
}

static tTree MakeOverlapBounds
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree params)
# else
(formals, params)
 register tTree formals;
 register tTree params;
# endif
{
  if (formals->Kind == kTYPE_EMPTY) {
# line 173 "AdaptMovement.puma"
   return params;

  }
  if (formals->Kind == kTYPE_LIST) {
  if (formals->TYPE_LIST.Elem->Kind == kINDEX_TYPE) {
# line 177 "AdaptMovement.puma"
 {
  tTree plist;
  {
# line 178 "AdaptMovement.puma"

# line 179 "AdaptMovement.puma"
 plist = MakeOverlapBounds (formals->TYPE_LIST.Next, params);
      plist = mBTP_LIST (ExpToVarParam (MakeConstant (formals->TYPE_LIST.Elem->INDEX_TYPE.right_overlap)), plist);
      plist = mBTP_LIST (ExpToVarParam (MakeConstant (formals->TYPE_LIST.Elem->INDEX_TYPE.left_overlap)), plist);
      plist = mBTP_LIST (ExpToVarParam (MakeSliceExp (formals->TYPE_LIST.Elem->INDEX_TYPE.LOWER, formals->TYPE_LIST.Elem->INDEX_TYPE.UPPER)), plist);

  }
  {
   return plist;
  }
 }

  }
  if (formals->TYPE_LIST.Elem->Kind == kDYNAMIC) {
  if (formals->TYPE_LIST.Elem->DYNAMIC.Shape->Kind == kSLICE_EXP) {
# line 187 "AdaptMovement.puma"
 {
  tTree plist;
  {
# line 188 "AdaptMovement.puma"

# line 189 "AdaptMovement.puma"
 plist = MakeOverlapBounds (formals->TYPE_LIST.Next, params);
      plist = mBTP_LIST (ExpToVarParam (MakeConstant (formals->TYPE_LIST.Elem->DYNAMIC.right_overlap)), plist);
      plist = mBTP_LIST (ExpToVarParam (MakeConstant (formals->TYPE_LIST.Elem->DYNAMIC.left_overlap)), plist);
      plist = mBTP_LIST (ExpToVarParam (MakeSliceExp (formals->TYPE_LIST.Elem->DYNAMIC.Shape->SLICE_EXP.START, formals->TYPE_LIST.Elem->DYNAMIC.Shape->SLICE_EXP.STOP)), plist);

  }
  {
   return plist;
  }
 }

  }
  }
  }
 yyAbort ("MakeOverlapBounds");
}

tTree AdaptTranspose
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 209 "AdaptMovement.puma"
 {
  tTree new;
  int dist;
  {
# line 213 "AdaptMovement.puma"

# line 214 "AdaptMovement.puma"

# line 216 "AdaptMovement.puma"
 CheckMoveArrays (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
     new  = NoTree;
     dist = TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     if (!IsWholeVar (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))
        error_protocol ("var = transpose (var'), var is sliced");
      else if (!IsWholeVar (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V))
        error_protocol ("var = transpose (var'), var' is sliced");
      else if (dist != TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V))
        error_protocol ("transpose, different distributions");
      else if (dist == 0)
        { if (target_language == FORTRAN_90)
             new = assign;
           else
             new = MakeLocalTranspose (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
        }
      else if (dist == -1)
        { if (!IsHost)
             new = NoTree;
           else if (target_language == FORTRAN_90)
             new = assign;
           else
             new = MakeLocalTranspose (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
        }
      else
        { if (!IsHost)
            new = MakeCommTranspose (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
           else
            new = NoTree;
        }

  }
  {
   return new;
  }
 }

  }
  }
  }
  }
  }
# line 249 "AdaptMovement.puma"
  {
# line 250 "AdaptMovement.puma"
   error_protocol ("transpose, illegal use");
  }
   return assign;

  }
 yyAbort ("AdaptTranspose");
}

static tTree MakeLocalTranspose
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1)
# else
(var, var1)
 register tTree var;
 register tTree var1;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 266 "AdaptMovement.puma"
   return MakeLocalTranspose (var->INDEXED_VAR.IND_VAR, var1);

  }
  if (var1->Kind == kINDEXED_VAR) {
# line 270 "AdaptMovement.puma"
   return MakeLocalTranspose (var, var1->INDEXED_VAR.IND_VAR);

  }
  if (var->Kind == kUSED_VAR) {
  if (var1->Kind == kUSED_VAR) {
# line 274 "AdaptMovement.puma"
 {
  tTree new;
  tTree params;
  {
# line 276 "AdaptMovement.puma"

# line 277 "AdaptMovement.puma"

# line 278 "AdaptMovement.puma"
 stmt_protocol ("Local Transpose");
     new    = mPROC_OBJ (MakeDalibId ("ltranspose"));
     params = mBTP_EMPTY();
     params = MakeTransposeBounds (ArrayFormals (var->USED_VAR.VARNAME->VAR_OBJ.Object),
                                   MakeConstant (TreeSize (var)),
                                   params);
     params = mBTP_LIST (mVAR_PARAM (var1),params);
     params = mBTP_LIST (mVAR_PARAM (var), params);
     new    = mACF_BASIC (mCALL_STMT (new, params));
     tree_protocol ("New Dalib Call is : ", new);

  }
  {
   return new;
  }
 }

  }
  }
 yyAbort ("MakeLocalTranspose");
}

static tTree MakeCommTranspose
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1)
# else
(var, var1)
 register tTree var;
 register tTree var1;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 304 "AdaptMovement.puma"
   return MakeCommTranspose (var->INDEXED_VAR.IND_VAR, var1);

  }
  if (var1->Kind == kINDEXED_VAR) {
# line 308 "AdaptMovement.puma"
   return MakeCommTranspose (var, var1->INDEXED_VAR.IND_VAR);

  }
  if (var->Kind == kUSED_VAR) {
  if (var1->Kind == kUSED_VAR) {
# line 312 "AdaptMovement.puma"
 {
  tTree new;
  tTree params;
  {
# line 314 "AdaptMovement.puma"

# line 315 "AdaptMovement.puma"

# line 316 "AdaptMovement.puma"
 stmt_protocol ("Communication Transpose");
     new    = mPROC_OBJ (MakeDalibId ("transpose"));
     params = mBTP_EMPTY();
     params = MakeTransposeBounds (ArrayFormals (var->USED_VAR.VARNAME->VAR_OBJ.Object),
                                   MakeConstant (TreeSize (var)),
                                   params);
     params = mBTP_LIST (mVAR_PARAM (var1),params);
     params = mBTP_LIST (mVAR_PARAM (var), params);
     new    = mACF_BASIC (mCALL_STMT (new, params));
     tree_protocol ("New Dalib Call is : ", new);

  }
  {
   return new;
  }
 }

  }
  }
 yyAbort ("MakeCommTranspose");
}

tTree AdaptCShift
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 342 "AdaptMovement.puma"
 {
  tTree new;
  int dist;
  {
# line 348 "AdaptMovement.puma"

# line 349 "AdaptMovement.puma"

# line 351 "AdaptMovement.puma"
 CheckMoveArrays (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
     new  = NoTree;
     dist = TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     if (!IsWholeVar (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))
        error_protocol ("cshift var = cshift (var',...), var is sliced");
      else if (!IsWholeVar (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V))
        error_protocol ("cshift var = cshift (var',...), var' is sliced");
      else if (dist != TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V))
        error_protocol ("cshift, different distributions");
      else if (dist == 0)
        { if (target_language == FORTRAN_90)
             new = assign;
           else
             new = MakeLocalCShift (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->
FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
        }
      else if (dist == -1)
        { if (!IsHost)
             new = NoTree;
           else if (target_language == FORTRAN_90)
             new = assign;
           else
             new = MakeLocalCShift (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->
FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
        }
      else
        { if (!IsHost)
            new = MakeCommCShift (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->
FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
           else
            new = NoTree;
        }

  }
  {
   return new;
  }
 }

  }
  }
  }
  }
  }
  }
  }
# line 384 "AdaptMovement.puma"
  {
# line 385 "AdaptMovement.puma"
   error_protocol ("cshift, illegal use");
  }
   return assign;

  }
 yyAbort ("AdaptCShift");
}

static tTree MakeLocalCShift
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1, register tTree dim, register tTree pos)
# else
(var, var1, dim, pos)
 register tTree var;
 register tTree var1;
 register tTree dim;
 register tTree pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 397 "AdaptMovement.puma"
   return MakeLocalCShift (var->INDEXED_VAR.IND_VAR, var1, dim, pos);

  }
  if (var1->Kind == kINDEXED_VAR) {
# line 401 "AdaptMovement.puma"
   return MakeLocalCShift (var, var1->INDEXED_VAR.IND_VAR, dim, pos);

  }
  if (var->Kind == kUSED_VAR) {
  if (var1->Kind == kUSED_VAR) {
# line 405 "AdaptMovement.puma"
 {
  tTree new;
  tTree params;
  {
# line 407 "AdaptMovement.puma"

# line 408 "AdaptMovement.puma"

# line 409 "AdaptMovement.puma"
 stmt_protocol ("Local CShift");
     new    = mPROC_OBJ (MakeDalibId1 ("lcshift", VarRank(var->USED_VAR.VARNAME->VAR_OBJ.Object)));
     params = mBTP_EMPTY();
     params = mBTP_LIST (pos, params);
     params = mBTP_LIST (dim, params);
     params = MakeCShiftBounds (ArrayFormals (var->USED_VAR.VARNAME->VAR_OBJ.Object), params);
     params = mBTP_LIST (ExpToVarParam (MakeConstant (TreeSize (var))), params);
     params = mBTP_LIST (mVAR_PARAM (var1),params);
     params = mBTP_LIST (mVAR_PARAM (var), params);
     new    = mACF_BASIC (mCALL_STMT (new, params));
     tree_protocol ("New Dalib Call is : ", new);

  }
  {
   return new;
  }
 }

  }
  }
 yyAbort ("MakeLocalCShift");
}

static tTree MakeCommCShift
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1, register tTree dim, register tTree pos)
# else
(var, var1, dim, pos)
 register tTree var;
 register tTree var1;
 register tTree dim;
 register tTree pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 434 "AdaptMovement.puma"
   return MakeCommCShift (var->INDEXED_VAR.IND_VAR, var1, dim, pos);

  }
  if (var1->Kind == kINDEXED_VAR) {
# line 438 "AdaptMovement.puma"
   return MakeCommCShift (var, var1->INDEXED_VAR.IND_VAR, dim, pos);

  }
  if (var->Kind == kUSED_VAR) {
  if (var1->Kind == kUSED_VAR) {
# line 442 "AdaptMovement.puma"
 {
  tTree new;
  tTree params;
  {
# line 444 "AdaptMovement.puma"

# line 445 "AdaptMovement.puma"

# line 446 "AdaptMovement.puma"
 stmt_protocol ("Communication CShift");
     new    = mPROC_OBJ (MakeDalibId1 ("cshift", VarRank(var->USED_VAR.VARNAME->VAR_OBJ.Object)));
     params = mBTP_EMPTY();
     params = mBTP_LIST (pos, params);
     params = mBTP_LIST (dim, params);
     params = MakeCShiftBounds (ArrayFormals (var->USED_VAR.VARNAME->VAR_OBJ.Object), params);
     params = mBTP_LIST (ExpToVarParam (MakeConstant (TreeSize (var))), params);
     params = mBTP_LIST (mVAR_PARAM (var1),params);
     params = mBTP_LIST (mVAR_PARAM (var), params);
     new    = mACF_BASIC (mCALL_STMT (new, params));
     tree_protocol ("New Dalib Call is : ", new);

  }
  {
   return new;
  }
 }

  }
  }
 yyAbort ("MakeCommCShift");
}

static tTree MakeCShiftBounds
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree params)
# else
(formals, params)
 register tTree formals;
 register tTree params;
# endif
{
  if (formals->Kind == kTYPE_EMPTY) {
# line 471 "AdaptMovement.puma"
   return params;

  }
  if (formals->Kind == kTYPE_LIST) {
  if (formals->TYPE_LIST.Elem->Kind == kINDEX_TYPE) {
# line 475 "AdaptMovement.puma"
 {
  tTree plist;
  {
# line 476 "AdaptMovement.puma"

# line 477 "AdaptMovement.puma"
 plist = MakeCShiftBounds (formals->TYPE_LIST.Next, params);
      plist = mBTP_LIST (ExpToVarParam (MakeSliceExp (formals->TYPE_LIST.Elem->INDEX_TYPE.LOWER, formals->TYPE_LIST.Elem->INDEX_TYPE.UPPER)), plist);

  }
  {
   return plist;
  }
 }

  }
  if (formals->TYPE_LIST.Elem->Kind == kDYNAMIC) {
  if (formals->TYPE_LIST.Elem->DYNAMIC.Shape->Kind == kSLICE_EXP) {
# line 483 "AdaptMovement.puma"
 {
  tTree plist;
  {
# line 484 "AdaptMovement.puma"

# line 485 "AdaptMovement.puma"
 plist = MakeCShiftBounds (formals->TYPE_LIST.Next, params);
      plist = mBTP_LIST (ExpToVarParam (MakeSliceExp (formals->TYPE_LIST.Elem->DYNAMIC.Shape->SLICE_EXP.START, formals->TYPE_LIST.Elem->DYNAMIC.Shape->SLICE_EXP.STOP)), plist);

  }
  {
   return plist;
  }
 }

  }
  }
  }
 yyAbort ("MakeCShiftBounds");
}

static tTree MakeTransposeBounds
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree size, register tTree params)
# else
(formals, size, params)
 register tTree formals;
 register tTree size;
 register tTree params;
# endif
{
# line 501 "AdaptMovement.puma"
 {
  tTree plist;
  {
# line 503 "AdaptMovement.puma"
   if (! ((TreeListLength (formals) <= 2))) goto yyL1;
  {
# line 504 "AdaptMovement.puma"

# line 505 "AdaptMovement.puma"
 plist = mBTP_LIST (ExpToVarParam (size), params);
      plist = MakeCShiftBounds (formals, plist);

  }
  }
  {
   return plist;
  }
 }
yyL1:;

  if (formals->Kind == kTYPE_LIST) {
  if (formals->TYPE_LIST.Elem->Kind == kDYNAMIC) {
  if (formals->TYPE_LIST.Elem->DYNAMIC.Shape->Kind == kSLICE_EXP) {
# line 511 "AdaptMovement.puma"
 {
  tTree newsize;
  {
# line 513 "AdaptMovement.puma"

# line 514 "AdaptMovement.puma"
 newsize = mOP_EXP (mOP_TIMES(), MakeSliceExp (formals->TYPE_LIST.Elem->DYNAMIC.Shape->SLICE_EXP.START, formals->TYPE_LIST.Elem->DYNAMIC.Shape->SLICE_EXP.STOP), size);
  }
  {
   return MakeTransposeBounds (formals->TYPE_LIST.Next, newsize, params);
  }
 }

  }
  }
  if (formals->TYPE_LIST.Elem->Kind == kINDEX_TYPE) {
# line 518 "AdaptMovement.puma"
 {
  tTree newsize;
  {
# line 520 "AdaptMovement.puma"

# line 521 "AdaptMovement.puma"
 newsize = mOP_EXP (mOP_TIMES(), MakeSliceExp (formals->TYPE_LIST.Elem->INDEX_TYPE.LOWER, formals->TYPE_LIST.Elem->INDEX_TYPE.UPPER), size);
  }
  {
   return MakeTransposeBounds (formals->TYPE_LIST.Next, newsize, params);
  }
 }

  }
  }
 yyAbort ("MakeTransposeBounds");
}

tTree AdaptArrayMovement
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int vardistribution, register int expdistribution)
# else
(assign, vardistribution, expdistribution)
 register tTree assign;
 register int vardistribution;
 register int expdistribution;
# endif
{
# line 538 "AdaptMovement.puma"

tTree t, params;
int count;
char string[200];

  if (equalint (vardistribution, 0)) {
  if (equalint (expdistribution, 0)) {
# line 548 "AdaptMovement.puma"
   return assign;

  }
  }
  if (equalint (vardistribution, - 1)) {
  if (equalint (expdistribution, 1)) {
# line 557 "AdaptMovement.puma"
   return AdaptHNMovement (assign);

  }
  }
  if (equalint (vardistribution, 1)) {
  if (equalint (expdistribution, - 1)) {
# line 565 "AdaptMovement.puma"
   return AdaptNHMovement (assign);

  }
  }
  if (equalint (vardistribution, 1)) {
  if (equalint (expdistribution, 0)) {
# line 573 "AdaptMovement.puma"
  {
# line 574 "AdaptMovement.puma"
 if (IsHost)
         t = NoTree;
       else
         t = LocalArrayAssignment (assign);

  }
   return t;

  }
  }
  if (equalint (vardistribution, 0)) {
  if (equalint (expdistribution, 1)) {
# line 586 "AdaptMovement.puma"
   return AdaptRNMovement (assign);

  }
  }
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (equalint (vardistribution, 1)) {
  if (equalint (expdistribution, 1)) {
# line 594 "AdaptMovement.puma"
   return AdaptNNMovement (assign, CountMovements (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP));

  }
  }
  }
  }
# line 598 "AdaptMovement.puma"
  {
# line 599 "AdaptMovement.puma"
   sprintf (string, "AdaptArrayMovement fails, vardist= %d, expdist= %d", vardistribution, expdistribution);
# line 601 "AdaptMovement.puma"
   error_protocol (string);
  }
   return assign;

}

static tTree AdaptHNMovement
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 619 "AdaptMovement.puma"
  {
# line 621 "AdaptMovement.puma"
   if (! (IsContiguousSection (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) != true)) goto yyL1;
  {
# line 622 "AdaptMovement.puma"
   error_protocol ("Transfer HOST <- NODES : host var not continguous");
  }
  }
   return NoTree;
yyL1:;

# line 626 "AdaptMovement.puma"
 {
  tTree nv;
  {
# line 628 "AdaptMovement.puma"

# line 629 "AdaptMovement.puma"
   nv = MakeFullShape (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
# line 631 "AdaptMovement.puma"
   CheckMoveArrays (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
  {
   return MakeHostNodeTransfer (FirstArrayElement (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), nv);
  }
 }

  }
  }
  }
# line 635 "AdaptMovement.puma"
  {
# line 636 "AdaptMovement.puma"
   error_protocol ("Adapting Host<-Node Movement failed");
  }
   return assign;

}

static tTree MakeHostNodeTransfer
# if defined __STDC__ | defined __cplusplus
(register tTree hostvar, register tTree nodevar)
# else
(hostvar, nodevar)
 register tTree hostvar;
 register tTree nodevar;
# endif
{
# line 642 "AdaptMovement.puma"

char string[50];
tTree t, params;

  if (nodevar->Kind == kINDEXED_VAR) {
  if (nodevar->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 647 "AdaptMovement.puma"
  {
# line 648 "AdaptMovement.puma"
   if (! (IndexStrides (nodevar->INDEXED_VAR.IND_EXPS))) goto yyL1;
  {
# line 649 "AdaptMovement.puma"
   error_protocol ("HOSTVAR = DIST_VAR : strides for distributed variable");
# line 650 "AdaptMovement.puma"
   tree_protocol ("Distributed Variable (full shape) is : ", nodevar);
  }
  }
   return NoTree;
yyL1:;

# line 654 "AdaptMovement.puma"
  {
# line 658 "AdaptMovement.puma"
 stmt_protocol ("Transfer HOST <- NODES");
    t = mPROC_OBJ (MakeDalibId1 ("host_node", VarRank(nodevar->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)));
    params = DalibRangeParams (nodevar, mBTP_EMPTY ());
    if (IsHost)
       params = mBTP_LIST (mVAR_PARAM (hostvar), params);
     else
       params = mBTP_LIST (mVAR_PARAM (nodevar->INDEXED_VAR.IND_VAR), params);
    t = mACF_BASIC (mCALL_STMT (t, params));
    tree_protocol ("New DALIB Call is : ", t);

  }
   return t;

  }
  }
 yyAbort ("MakeHostNodeTransfer");
}

static tTree AdaptNHMovement
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 687 "AdaptMovement.puma"
  {
# line 689 "AdaptMovement.puma"
   if (! (IsContiguousSection (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V) != true)) goto yyL1;
  {
# line 690 "AdaptMovement.puma"
   error_protocol ("Transfer NODES <- HOST : host var not continguous");
  }
  }
   return NoTree;
yyL1:;

# line 694 "AdaptMovement.puma"
 {
  tTree nv;
  {
# line 696 "AdaptMovement.puma"

# line 697 "AdaptMovement.puma"
   nv = MakeFullShape (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
# line 699 "AdaptMovement.puma"
   CheckMoveArrays (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
  {
   return MakeNodeHostTransfer (nv, FirstArrayElement (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V));
  }
 }

  }
  }
  }
# line 703 "AdaptMovement.puma"
  {
# line 704 "AdaptMovement.puma"
   error_protocol ("Adapting NODE<-HOST Movement failed");
  }
   return assign;

}

static tTree MakeNodeHostTransfer
# if defined __STDC__ | defined __cplusplus
(register tTree nodevar, register tTree hostvar)
# else
(nodevar, hostvar)
 register tTree nodevar;
 register tTree hostvar;
# endif
{
# line 710 "AdaptMovement.puma"

char string[50];
tTree t, params;

  if (nodevar->Kind == kINDEXED_VAR) {
  if (nodevar->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 715 "AdaptMovement.puma"
  {
# line 716 "AdaptMovement.puma"
   if (! (IndexStrides (nodevar->INDEXED_VAR.IND_EXPS))) goto yyL1;
  {
# line 717 "AdaptMovement.puma"
   error_protocol ("DIST_VAR = HOSTVAR : strides for distributed variable");
# line 718 "AdaptMovement.puma"
   tree_protocol ("Distributed Variable (full shape) is : ", nodevar);
  }
  }
   return NoTree;
yyL1:;

# line 722 "AdaptMovement.puma"
  {
# line 726 "AdaptMovement.puma"
 stmt_protocol ("Transfer NODES <- HOST");
    t = mPROC_OBJ (MakeDalibId1 ("node_host", VarRank(nodevar->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)));
    params = DalibRangeParams (nodevar, mBTP_EMPTY ());
    if (IsHost)
       params = mBTP_LIST (mVAR_PARAM (hostvar), params);
     else
       params = mBTP_LIST (mVAR_PARAM (nodevar->INDEXED_VAR.IND_VAR), params);
    t = mACF_BASIC (mCALL_STMT (t, params));
    tree_protocol ("New DALIB Call is : ", t);

  }
   return t;

  }
  }
 yyAbort ("MakeNodeHostTransfer");
}

static tTree AdaptRNMovement
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 755 "AdaptMovement.puma"
  {
# line 757 "AdaptMovement.puma"
   if (! (IsContiguousSection (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) != true)) goto yyL1;
  {
# line 758 "AdaptMovement.puma"
   error_protocol ("Transfer ALL <- NODES : replicated var not continguous");
  }
  }
   return NoTree;
yyL1:;

# line 762 "AdaptMovement.puma"
 {
  tTree nv;
  {
# line 764 "AdaptMovement.puma"

# line 765 "AdaptMovement.puma"
   nv = MakeFullShape (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
# line 767 "AdaptMovement.puma"
   CheckMoveArrays (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
  {
   return MakeAllNodeTransfer (FirstArrayElement (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), nv);
  }
 }

  }
  }
  }
# line 771 "AdaptMovement.puma"
  {
# line 772 "AdaptMovement.puma"
   error_protocol ("Adapting All <- Node Movement failed");
  }
   return assign;

}

static tTree MakeAllNodeTransfer
# if defined __STDC__ | defined __cplusplus
(register tTree repvar, register tTree nodevar)
# else
(repvar, nodevar)
 register tTree repvar;
 register tTree nodevar;
# endif
{
# line 778 "AdaptMovement.puma"

char string[50];
tTree t, params;

  if (nodevar->Kind == kINDEXED_VAR) {
  if (nodevar->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 783 "AdaptMovement.puma"
  {
# line 784 "AdaptMovement.puma"
   if (! (IndexStrides (nodevar->INDEXED_VAR.IND_EXPS))) goto yyL1;
  {
# line 785 "AdaptMovement.puma"
   error_protocol ("REP_VAR = DIST_VAR : strides for distributed variable");
# line 786 "AdaptMovement.puma"
   tree_protocol ("Distributed Variable (full shape) is : ", nodevar);
  }
  }
   return NoTree;
yyL1:;

# line 790 "AdaptMovement.puma"
  {
# line 794 "AdaptMovement.puma"
 stmt_protocol ("Transfer ALL <- NODES");
    t = mPROC_OBJ (MakeDalibId1 ("replicate", VarRank(nodevar->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)));
    params = DalibRangeParams (nodevar, mBTP_EMPTY());
    if (IsHost)
       params = mBTP_LIST (mVAR_PARAM (repvar), params);
     else
       params = mBTP_LIST (mVAR_PARAM (nodevar->INDEXED_VAR.IND_VAR), params);
    params = mBTP_LIST (mVAR_PARAM (repvar), params);
    t = mACF_BASIC (mCALL_STMT (t, params));
    tree_protocol ("New DALIB Call is : ", t);

  }
   return t;

  }
  }
 yyAbort ("MakeAllNodeTransfer");
}

static tTree AdaptNNMovement
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int moves)
# else
(assign, moves)
 register tTree assign;
 register int moves;
# endif
{
# line 816 "AdaptMovement.puma"

tTree t;

  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->Kind == kINDEXED_VAR) {
  if (equalint (moves, 0)) {
# line 826 "AdaptMovement.puma"
  {
# line 828 "AdaptMovement.puma"
 if (IsHost)
         t = NoTree;
       else
         t = LocalArrayAssignment (assign);

  }
   return t;

  }
  }
  if (equalint (moves, 0)) {
# line 836 "AdaptMovement.puma"
  {
# line 838 "AdaptMovement.puma"
   stmt_protocol ("Local : ");
# line 839 "AdaptMovement.puma"
 if (IsHost)
        t = NoTree;
       else
        t = assign;

  }
   return t;

  }
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 847 "AdaptMovement.puma"
  {
# line 849 "AdaptMovement.puma"
   stmt_protocol ("Copy Node Arrays with moves");
# line 850 "AdaptMovement.puma"
 if (IsHost)
        { t = NoTree;
          print_protocol ("is removed in host program");
        }
       else
        { t = AdaptNNCopy (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
          if (t == NoTree)
            error_protocol ("could not be adapted");
           else
            tree_protocol ("becomes :\n", t);
        }

  }
   return t;

  }
  }
  }
# line 865 "AdaptMovement.puma"
  {
# line 866 "AdaptMovement.puma"
   error_protocol ("*** not handled *** : Node<-Node : ");
# line 867 "AdaptMovement.puma"
 if (IsHost)
        t = NoTree;
       else
        t = assign;

  }
   return assign;

}

tTree AdaptNNCopy
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register tTree rvar)
# else
(lvar, rvar)
 register tTree lvar;
 register tTree rvar;
# endif
{
# line 883 "AdaptMovement.puma"

tTree last1, last2, t, params, stmt;
int index_dist1, index_dist2;
tIdent pname;
char procname[30];
int k;

  if (lvar->Kind == kINDEXED_VAR) {
  if (lvar->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
  if (rvar->Kind == kINDEXED_VAR) {
  if (rvar->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 897 "AdaptMovement.puma"
  {
# line 899 "AdaptMovement.puma"
   CheckMoveArrays (rvar->INDEXED_VAR.IND_VAR, lvar->INDEXED_VAR.IND_VAR);
# line 900 "AdaptMovement.puma"
 last1 = LastIndex (lvar->INDEXED_VAR.IND_EXPS);
     last2 = LastIndex (rvar->INDEXED_VAR.IND_EXPS);
     index_dist1 = TreeDistribution (lvar->INDEXED_VAR.IND_EXPS);
     index_dist2 = TreeDistribution (rvar->INDEXED_VAR.IND_EXPS);
     if ((index_dist1 != 0) || (index_dist2 != 0))
       { t = AdaptNNIndirect (lvar, index_dist1, rvar, index_dist2); }
      else if (IndexStrides (lvar->INDEXED_VAR.IND_EXPS))
       { tree_protocol ("increments in indexes of lhs variable: ", lvar);
         t = NoTree;
       }
      else if (IndexStrides (rvar->INDEXED_VAR.IND_EXPS))
       { tree_protocol ("increments in indexes of rhs variable: ", rvar);
         t = NoTree;
       }
      else

       {



         params = mBTP_EMPTY();
         params = DalibRangeParams (lvar, params);
         params = mBTP_LIST (mVAR_PARAM (lvar->INDEXED_VAR.IND_VAR), params);
         k      = TreeListLength (lvar->INDEXED_VAR.IND_EXPS);
         stmt   = mPROC_OBJ (MakeDalibId1 ("move_target", k));
         stmt   = mACF_BASIC (mCALL_STMT (stmt, params));
         t      = mACF_LIST (stmt, NoTree);



         params = mBTP_EMPTY();
         params = DalibRangeParams (rvar, params);
         params = mBTP_LIST (mVAR_PARAM (rvar->INDEXED_VAR.IND_VAR), params);
         k      = TreeListLength (rvar->INDEXED_VAR.IND_EXPS);
         stmt   = mPROC_OBJ (MakeDalibId1 ("move_source", k));
         stmt   = mACF_BASIC (mCALL_STMT (stmt, params));
         t      = mACF_LIST (stmt, t);



         params = mBTP_EMPTY ();
         params = AdaptHelpFn (rvar->INDEXED_VAR.IND_VAR, last2, params);
         params = AdaptHelpFn (lvar->INDEXED_VAR.IND_VAR, last1, params);
         stmt   = mPROC_OBJ (MakeDalibId ("move_define"));
         stmt   = mACF_BASIC (mCALL_STMT (stmt, params));
         t      = mACF_LIST (stmt, t);
       }

  }
   return t;

  }
  }
  }
  if (rvar->Kind == kUSED_VAR) {
# line 967 "AdaptMovement.puma"
   return AdaptNNIndirect (lvar, TreeDistribution (lvar->INDEXED_VAR.IND_EXPS), rvar, 0);

  }
  }
  if (lvar->Kind == kUSED_VAR) {
  if (rvar->Kind == kINDEXED_VAR) {
# line 957 "AdaptMovement.puma"
   return AdaptNNIndirect (lvar, 0, rvar, TreeDistribution (rvar->INDEXED_VAR.IND_EXPS));

  }
  }
# line 971 "AdaptMovement.puma"
  {
# line 972 "AdaptMovement.puma"
   error_protocol ("*** not handled *** : AdaptNNCopy :");
  }
   return NoTree;

}

static tTree AdaptHelpFn
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree slice, register tTree params)
# else
(var, slice, params)
 register tTree var;
 register tTree slice;
 register tTree params;
# endif
{
# line 980 "AdaptMovement.puma"

tTree newparams;

  if (slice->Kind == kSLICE_EXP) {
# line 984 "AdaptMovement.puma"
  {
# line 985 "AdaptMovement.puma"
 newparams = params;
     newparams = mBTP_LIST (ExpToVarParam (slice->SLICE_EXP.STOP), newparams);
     newparams = mBTP_LIST (ExpToVarParam (slice->SLICE_EXP.START), newparams);
     newparams = DalibLastFormalParam (var, newparams);

  }
   return newparams;

  }
# line 993 "AdaptMovement.puma"
  {
# line 994 "AdaptMovement.puma"
 newparams = params;
     newparams = mBTP_LIST (ExpToVarParam (slice), newparams);
     newparams = mBTP_LIST (ExpToVarParam (slice), newparams);
     newparams = DalibLastFormalParam (var, newparams);

  }
   return newparams;

}

static tTree AdaptNNIndirect
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register int d1, register tTree rvar, register int d2)
# else
(lvar, d1, rvar, d2)
 register tTree lvar;
 register int d1;
 register tTree rvar;
 register int d2;
# endif
{
  if (equalint (d1, 0)) {
  if (equalint (d2, 1)) {
# line 1012 "AdaptMovement.puma"
   return AdaptNNGet (lvar, rvar);

  }
  }
  if (equalint (d1, 1)) {
  if (equalint (d2, 0)) {
# line 1017 "AdaptMovement.puma"
   return AdaptNNSet (lvar, rvar);

  }
  }
  if (equalint (d1, 0)) {
  if (equalint (d2, 0)) {
# line 1022 "AdaptMovement.puma"
  {
# line 1024 "AdaptMovement.puma"
 tree_protocol ("NNIndirect: index of lhs is replicated : ", lvar );
     tree_protocol ("NNIndirect: also index of rhs is replicated : ", rvar );

  }
   return NoTree;

  }
  }
  if (equalint (d1, 1)) {
  if (equalint (d2, 1)) {
# line 1030 "AdaptMovement.puma"
  {
# line 1031 "AdaptMovement.puma"
 tree_protocol ("NNIndirect: index on lhs is already distributed: ", lvar );
     tree_protocol ("NNIndirect: index of rhs must not distributed: ", rvar );

  }
   return NoTree;

  }
  }
# line 1037 "AdaptMovement.puma"
  {
# line 1038 "AdaptMovement.puma"
 tree_protocol ("NNIndirect: illegal distribution in lhs ? ", lvar);
     tree_protocol ("NNIndirect: illegal distribution in rhs ? ", rvar);

  }
   return NoTree;

}

static tTree AdaptNNGet
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register tTree rvar)
# else
(lvar, rvar)
 register tTree lvar;
 register tTree rvar;
# endif
{
# line 1052 "AdaptMovement.puma"

tIdent procname;
tTree t, params;

  if (lvar->Kind == kINDEXED_VAR) {
# line 1059 "AdaptMovement.puma"
  {
# line 1060 "AdaptMovement.puma"
   if (! ((IsWholeVar (lvar) == true))) goto yyL1;
  }
   return AdaptNNGet (lvar->INDEXED_VAR.IND_VAR, rvar);
yyL1:;

# line 1064 "AdaptMovement.puma"
  {
# line 1065 "AdaptMovement.puma"
 tree_protocol ("global_get, gather : lhs not full array", lvar);
  }
   return NoTree;

  }
  if (lvar->Kind == kUSED_VAR) {
  if (rvar->Kind == kINDEXED_VAR) {
  if (rvar->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (rvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (rvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 1077 "AdaptMovement.puma"
  {
# line 1078 "AdaptMovement.puma"
   if (! ((IsWholeVar (rvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->VAR_EXP.V) == true))) goto yyL3;
  {
# line 1079 "AdaptMovement.puma"

    rvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->VAR_EXP.V = NormalizeShape (rvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->VAR_EXP.V);
    params = mBTP_EMPTY();
    params = mBTP_LIST (ExpToVarParam (rvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem), params);
    params = mBTP_LIST (mVAR_PARAM (rvar->INDEXED_VAR.IND_VAR), params);
    params = mBTP_LIST (mVAR_PARAM (lvar), params);
    t = GenGlobalGet (params);

  }
  }
   return t;
yyL3:;

  }
  }
  }
  }
  }
# line 1096 "AdaptMovement.puma"
  {
# line 1097 "AdaptMovement.puma"
   error_protocol ("AdaptNNGet : *** not handled *** ");
  }
   return NoTree;

}

static tTree AdaptNNSet
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register tTree rvar)
# else
(lvar, rvar)
 register tTree lvar;
 register tTree rvar;
# endif
{
# line 1109 "AdaptMovement.puma"

tIdent procname;
tTree t, params;

  if (rvar->Kind == kINDEXED_VAR) {
# line 1118 "AdaptMovement.puma"
  {
# line 1119 "AdaptMovement.puma"
   if (! ((IsWholeVar (rvar) == true))) goto yyL1;
  }
   return AdaptNNSet (lvar, rvar->INDEXED_VAR.IND_VAR);
yyL1:;

# line 1123 "AdaptMovement.puma"
  {
# line 1124 "AdaptMovement.puma"
 tree_protocol ("global_set, scatter : rhs not full array", rvar);
  }
   return NoTree;

  }
  if (lvar->Kind == kINDEXED_VAR) {
  if (lvar->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (lvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (lvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
  if (rvar->Kind == kUSED_VAR) {
# line 1134 "AdaptMovement.puma"
  {
# line 1135 "AdaptMovement.puma"
   if (! ((IsWholeVar (lvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->VAR_EXP.V) == true))) goto yyL3;
  {
# line 1136 "AdaptMovement.puma"

    lvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->VAR_EXP.V = NormalizeShape (lvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->VAR_EXP.V);
    params = mBTP_EMPTY();
    params = mBTP_LIST (mVAR_PARAM (rvar), params);
    params = mBTP_LIST (ExpToVarParam (lvar->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem), params);
    params = mBTP_LIST (mVAR_PARAM (lvar->INDEXED_VAR.IND_VAR), params);
    t = GenGlobalSend (params);

  }
  }
   return t;
yyL3:;

  }
  }
  }
  }
  }
# line 1153 "AdaptMovement.puma"
  {
# line 1154 "AdaptMovement.puma"
   error_protocol ("AdaptNNSet: *** not handled *** ");
  }
   return NoTree;

}

static bool IndexStrides
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1166 "AdaptMovement.puma"

bool found;
int val;

  if (t == NoTree) return false;
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 1171 "AdaptMovement.puma"
  {
# line 1172 "AdaptMovement.puma"
 SliceIncrement (t->BTE_LIST.Elem, &found, &val);
     if (!found) val = 0;

# line 1175 "AdaptMovement.puma"
   if (! (val != 1)) goto yyL1;
  }
   return true;
yyL1:;

  }
# line 1178 "AdaptMovement.puma"
  {
# line 1180 "AdaptMovement.puma"
   if (! (NoSliceExp (t->BTE_LIST.Elem))) goto yyL2;
  {
# line 1181 "AdaptMovement.puma"
   if (! (TreeRank (t->BTE_LIST.Elem) > 0)) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 1184 "AdaptMovement.puma"
  {
# line 1185 "AdaptMovement.puma"
   if (! (IndexStrides (t->BTE_LIST.Next))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool NoSliceExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kSLICE_EXP) {
# line 1190 "AdaptMovement.puma"
  {
# line 1191 "AdaptMovement.puma"
   return false;
  }

  }
# line 1194 "AdaptMovement.puma"
   return true;

}

static tTree MakeIndexParams
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
# line 1199 "AdaptMovement.puma"

tTree param;

  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 1203 "AdaptMovement.puma"
  {
# line 1207 "AdaptMovement.puma"
 param = MakeIndexParams (indexes->BTE_LIST.Next);
       param = mBTP_LIST (ExpToVarParam (indexes->BTE_LIST.Elem->SLICE_EXP.STOP), param);
       param = mBTP_LIST (ExpToVarParam (indexes->BTE_LIST.Elem->SLICE_EXP.START), param);

  }
   return param;

  }
# line 1214 "AdaptMovement.puma"
  {
# line 1215 "AdaptMovement.puma"
 param = MakeIndexParams (indexes->BTE_LIST.Next);
       param = mBTP_LIST (ExpToVarParam (indexes->BTE_LIST.Elem), param);
       param = mBTP_LIST (ExpToVarParam (indexes->BTE_LIST.Elem), param);

  }
   return param;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 1222 "AdaptMovement.puma"
   return mBTP_EMPTY ();

  }
 yyAbort ("MakeIndexParams");
}

static void CheckMoveArrays
# if defined __STDC__ | defined __cplusplus
(register tTree source, register tTree target)
# else
(source, target)
 register tTree source;
 register tTree target;
# endif
{
  if (source == NoTree) return;
  if (target == NoTree) return;
# line 1234 "AdaptMovement.puma"
 {
  tTree type1;
  tTree type2;
  {
# line 1236 "AdaptMovement.puma"

# line 1238 "AdaptMovement.puma"
 type1 = TreeType (source);
      type2 = TreeType (target);

      if ( (type1->Kind != type2->Kind) ||
           (TreeSize (source) != TreeSize (target)) )
         { error_protocol ("Movement requires same type");
           tree_protocol ("Source type is ", type1);
           tree_protocol ("Target type is ", type2);
         }

  }
   return;
 }

;
}

void BeginAdaptMovement ()
{
}

void CloseAdaptMovement ()
{
}
