# include "Expressi.h"
# include "yyExpres.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "Expressions.puma"

# include "Tree.h"
# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "Definiti.h"

int power (base, n)
int base, n;
{ int i, p;

  p = 1;
  for (i=1; i<=n; ++i)
     p = p * base;
  return p;
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Expressions, routine %s failed\n", yyFunction);
 exit (1);
}

void GetIntConstValue ARGS((tTree exp, bool * found, int * val));
void GetConstDifference ARGS((tTree exp1, tTree exp2, bool * found, int * val));
void ResolveExpression ARGS((tTree exp, bool * found, int * a, int * b, tTree * var));
static void MergeVars ARGS((int a1, tTree v1, int a2, tTree v2, bool * ok, tTree * var));
bool EqualExpression ARGS((tTree e1, tTree e2));
int IsVarInExp ARGS((tIdent name, tTree exp));
tTree MakeNotExp ARGS((tTree e));
void SliceIncrement ARGS((tTree yyP1, bool * yyP3, int * yyP2));
tTree MakeSliceExp ARGS((tTree start, tTree stop));
tTree AddConstant ARGS((tTree exp, int c));
tTree MakeConstant ARGS((int n));

void GetIntConstValue
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * found, register int * val)
# else
(exp, found, val)
 register tTree exp;
 register bool * found;
 register int * val;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 69 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 70 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 71 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 + yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 74 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 75 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 76 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 - yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 79 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 80 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 81 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 * yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
# line 84 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 85 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 86 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
# line 87 "Expressions.puma"
 if (yyV4 == 0)
        { yyV3 = false;
          yyV4   = 1;
        }

  }
   * found = yyV1 && yyV3;
   * val = yyV2 / yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_EXPO) {
# line 94 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 95 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 96 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
# line 97 "Expressions.puma"
 if (yyV4 < 0) yyV3 = false;
  }
   * found = yyV1 && yyV3;
   * val = power (yyV2, yyV4);
   return;
 }

  }
  break;
  case kOP1_EXP:
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 100 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 101 "Expressions.puma"
   GetIntConstValue (exp->OP1_EXP.OPND, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = - yyV2;
   return;
 }

  }
  break;
  case kVAR_EXP:
# line 104 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 105 "Expressions.puma"
   GetIntConstValue (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kUSED_VAR:
# line 108 "Expressions.puma"
  {
# line 111 "Expressions.puma"
   if (! (exp->USED_VAR.VARNAME->VAR_OBJ.Object == NoObject)) goto yyL8;
  }
   * found = false;
   * val = 0;
   return;
yyL8:;

  if (exp->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
  if (exp->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->Kind == kVarConstant) {
# line 114 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 116 "Expressions.puma"
   GetIntConstValue (exp->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->VarConstant.Val, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  }
  }
  break;
  case kVAR_PARAM:
# line 119 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 120 "Expressions.puma"
   GetIntConstValue (exp->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kADDR:
# line 123 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 124 "Expressions.puma"
   GetIntConstValue (exp->ADDR.E, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kCONST_EXP:
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 127 "Expressions.puma"
   * found = true;
   * val = exp->CONST_EXP.C->INT_CONSTANT.value;
   return;

  }
  break;
  }

# line 130 "Expressions.puma"
   * found = false;
   * val = 0;
   return;

;
}

void GetConstDifference
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2, register bool * found, register int * val)
# else
(exp1, exp2, found, val)
 register tTree exp1;
 register tTree exp2;
 register bool * found;
 register int * val;
# endif
{
# line 147 "Expressions.puma"
  {
# line 148 "Expressions.puma"
   if (! (((exp1 == NoTree) || (exp2 == NoTree)))) goto yyL1;
  {
# line 149 "Expressions.puma"
   printf ("Illegal Call of GetConstDifference with NoTree\n");
# line 150 "Expressions.puma"
   kill_in_protocol ();
  }
  }
   * found = false;
   * val = 0;
   return;
yyL1:;

# line 153 "Expressions.puma"
  {
# line 155 "Expressions.puma"
   if (! ( EqualExpression (exp1, exp2 )  == true)) goto yyL2;
  }
   * found = true;
   * val = 0;
   return;
yyL2:;

# line 158 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  bool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  bool yyV9;
  tTree yyV10;
  {
# line 159 "Expressions.puma"
   ResolveExpression (exp1, & yyV1, & yyV2, & yyV3, & yyV4);
# line 160 "Expressions.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 161 "Expressions.puma"
   ResolveExpression (exp2, & yyV5, & yyV6, & yyV7, & yyV8);
# line 162 "Expressions.puma"
   if (! ((yyV5))) goto yyL3;
  {
# line 163 "Expressions.puma"
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
# line 164 "Expressions.puma"
   if (! ((yyV9 == true))) goto yyL3;
  {
# line 165 "Expressions.puma"
   if (! ((yyV2 == yyV6))) goto yyL3;
  }
  }
  }
  }
   * found = true;
   * val = yyV3 - yyV7;
   return;
 }
yyL3:;

  if (exp1->Kind == kSLICE_EXP) {
  if (exp2->Kind == kSLICE_EXP) {
# line 168 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 170 "Expressions.puma"
   GetConstDifference (exp1->SLICE_EXP.START, exp2->SLICE_EXP.START, & yyV1, & yyV2);
# line 171 "Expressions.puma"
   if (! ((yyV1 == true))) goto yyL4;
  {
# line 172 "Expressions.puma"
   GetConstDifference (exp1->SLICE_EXP.STOP, exp2->SLICE_EXP.STOP, & yyV3, & yyV4);
# line 173 "Expressions.puma"
   if (! ((yyV3 == true))) goto yyL4;
  {
# line 174 "Expressions.puma"
   if (! ((yyV2 == yyV4))) goto yyL4;
  {
# line 175 "Expressions.puma"
   if (! (EqualExpression (exp1->SLICE_EXP.INC, exp2->SLICE_EXP.INC))) goto yyL4;
  }
  }
  }
  }
   * found = true;
   * val = yyV2;
   return;
 }
yyL4:;

  }
  }
# line 178 "Expressions.puma"
   * found = false;
   * val = 0;
   return;

;
}

void ResolveExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * found, register int * a, register int * b, register tTree * var)
# else
(exp, found, a, b, var)
 register tTree exp;
 register bool * found;
 register int * a;
 register int * b;
 register tTree * var;
# endif
{
# line 203 "Expressions.puma"
  {
# line 204 "Expressions.puma"
   if (! ((exp == NoTree))) goto yyL1;
  {
# line 205 "Expressions.puma"
   printf ("Call of ResolveExpression with NoTree\n");
# line 206 "Expressions.puma"
   kill_in_protocol ();
  }
  }
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;
yyL1:;

# line 209 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 210 "Expressions.puma"
   GetIntConstValue (exp, & yyV1, & yyV2);
# line 211 "Expressions.puma"
   if (! ((yyV1))) goto yyL2;
  }
   * found = true;
   * a = 0;
   * b = yyV2;
   * var = NoTree;
   return;
 }
yyL2:;


  switch (exp->Kind) {
  case kOP_EXP:
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 214 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  bool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  bool yyV9;
  tTree yyV10;
  {
# line 215 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3, & yyV4);
# line 216 "Expressions.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 217 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND2, & yyV5, & yyV6, & yyV7, & yyV8);
# line 218 "Expressions.puma"
   if (! ((yyV5))) goto yyL3;
  {
# line 219 "Expressions.puma"
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
# line 220 "Expressions.puma"
   if (! ((yyV9))) goto yyL3;
  }
  }
  }
   * found = true;
   * a = yyV2 + yyV6;
   * b = yyV3 + yyV7;
   * var = yyV10;
   return;
 }
yyL3:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 223 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  bool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  bool yyV9;
  tTree yyV10;
  {
# line 224 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3, & yyV4);
# line 225 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND2, & yyV5, & yyV6, & yyV7, & yyV8);
# line 226 "Expressions.puma"
   if (! ((yyV1 && yyV5))) goto yyL4;
  {
# line 227 "Expressions.puma"
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
# line 228 "Expressions.puma"
   if (! ((yyV9))) goto yyL4;
  }
  }
   * found = true;
   * a = yyV2 - yyV6;
   * b = yyV3 - yyV7;
   * var = yyV10;
   return;
 }
yyL4:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 231 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  {
# line 232 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 233 "Expressions.puma"
   if (! ((yyV1))) goto yyL5;
  {
# line 234 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND2, & yyV3, & yyV4, & yyV5, & yyV6);
# line 235 "Expressions.puma"
   if (! ((yyV3))) goto yyL5;
  }
  }
   * found = true;
   * a = yyV2 * yyV4;
   * b = yyV2 * yyV5;
   * var = yyV6;
   return;
 }
yyL5:;

# line 238 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  {
# line 239 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 240 "Expressions.puma"
   if (! ((yyV1))) goto yyL6;
  {
# line 241 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND1, & yyV3, & yyV4, & yyV5, & yyV6);
# line 242 "Expressions.puma"
   if (! ((yyV3))) goto yyL6;
  }
  }
   * found = yyV3 && yyV1;
   * a = yyV2 * yyV4;
   * b = yyV2 * yyV5;
   * var = yyV6;
   return;
 }
yyL6:;

  }
  break;
  case kOP1_EXP:
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 245 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  {
# line 246 "Expressions.puma"
   ResolveExpression (exp->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3, & yyV4);
# line 247 "Expressions.puma"
   if (! ((yyV1))) goto yyL7;
  }
   * found = yyV1;
   * a = - yyV2;
   * b = - yyV3;
   * var = yyV4;
   return;
 }
yyL7:;

  }
  break;
  case kVAR_EXP:
# line 250 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp->VAR_EXP.V;
   return;

  case kVAR_PARAM:
# line 253 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp->VAR_PARAM.V;
   return;

  case kUSED_VAR:
# line 256 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kINDEXED_VAR:
# line 259 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kLOOP_VAR:
# line 262 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  }

# line 265 "Expressions.puma"
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

;
}

static void MergeVars
# if defined __STDC__ | defined __cplusplus
(register int a1, register tTree v1, register int a2, register tTree v2, register bool * ok, register tTree * var)
# else
(a1, v1, a2, v2, ok, var)
 register int a1;
 register tTree v1;
 register int a2;
 register tTree v2;
 register bool * ok;
 register tTree * var;
# endif
{
  if (equalint (a1, 0)) {
# line 271 "Expressions.puma"
   * ok = true;
   * var = v2;
   return;

  }
  if (equalint (a2, 0)) {
# line 274 "Expressions.puma"
   * ok = true;
   * var = v1;
   return;

  }
# line 277 "Expressions.puma"
  {
# line 278 "Expressions.puma"
   if (! ( EqualExpression (v1, v2)  == true)) goto yyL3;
  }
   * ok = true;
   * var = v1;
   return;
yyL3:;

# line 281 "Expressions.puma"
   * ok = false;
   * var = NoTree;
   return;

;
}

bool EqualExpression
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2)
# else
(e1, e2)
 register tTree e1;
 register tTree e2;
# endif
{
# line 293 "Expressions.puma"
 {
  bool found;
  int val1;
  int val2;
  {
# line 295 "Expressions.puma"

# line 296 "Expressions.puma"

# line 297 "Expressions.puma"

# line 299 "Expressions.puma"
 GetIntConstValue (e1, &found, &val1);
# line 300 "Expressions.puma"
   if (! ((found))) goto yyL1;
  {
# line 301 "Expressions.puma"
 GetIntConstValue (e2, &found, &val2);
# line 302 "Expressions.puma"
   if (! ((found))) goto yyL1;
  {
# line 303 "Expressions.puma"
   if (! ((val1 == val2))) goto yyL1;
  }
  }
  }
   return true;
 }
yyL1:;


  switch (e1->Kind) {
  case kSLICE_EXP:
  if (e2->Kind == kSLICE_EXP) {
# line 306 "Expressions.puma"
  {
# line 307 "Expressions.puma"
   if (! (EqualExpression (e1->SLICE_EXP.START, e2->SLICE_EXP.START))) goto yyL2;
  {
# line 308 "Expressions.puma"
   if (! (EqualExpression (e1->SLICE_EXP.STOP, e2->SLICE_EXP.STOP))) goto yyL2;
  {
# line 309 "Expressions.puma"
   if (! (EqualExpression (e1->SLICE_EXP.INC, e2->SLICE_EXP.INC))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  }
  break;
  case kDUMMY_EXP:
  if (e2->Kind == kDUMMY_EXP) {
# line 312 "Expressions.puma"
   return true;

  }
  break;
  case kVAR_EXP:
  if (e2->Kind == kVAR_EXP) {
# line 315 "Expressions.puma"
  {
# line 316 "Expressions.puma"
   if (! (EqualExpression (e1->VAR_EXP.V, e2->VAR_EXP.V))) goto yyL4;
  }
   return true;
yyL4:;

  }
  break;
  case kUSED_VAR:
  if (e2->Kind == kUSED_VAR) {
# line 319 "Expressions.puma"
  {
# line 320 "Expressions.puma"
   if (! (EqualExpression (e1->USED_VAR.VARNAME, e2->USED_VAR.VARNAME))) goto yyL5;
  }
   return true;
yyL5:;

  }
  break;
  case kLOOP_VAR:
  if (e2->Kind == kLOOP_VAR) {
# line 323 "Expressions.puma"
  {
# line 324 "Expressions.puma"
   if (! (EqualExpression (e1->LOOP_VAR.LOOP_VARNAME, e2->LOOP_VAR.LOOP_VARNAME))) goto yyL6;
  }
   return true;
yyL6:;

  }
  break;
  case kVAR_OBJ:
  if (e2->Kind == kVAR_OBJ) {
# line 327 "Expressions.puma"
  {
# line 329 "Expressions.puma"
   if (! (e1->VAR_OBJ.Ident == e2->VAR_OBJ.Ident)) goto yyL7;
  }
   return true;
yyL7:;

  }
  break;
  case kOP_EXP:
  if (e2->Kind == kOP_EXP) {
# line 332 "Expressions.puma"
  {
# line 334 "Expressions.puma"
   if (! (e1->OP_EXP.EXP_OP -> Kind == e2->OP_EXP.EXP_OP -> Kind)) goto yyL8;
  {
# line 335 "Expressions.puma"
   if (! (EqualExpression (e1->OP_EXP.OPND1, e2->OP_EXP.OPND1))) goto yyL8;
  {
# line 336 "Expressions.puma"
   if (! (EqualExpression (e1->OP_EXP.OPND2, e2->OP_EXP.OPND2))) goto yyL8;
  }
  }
  }
   return true;
yyL8:;

  }
  break;
  case kOP1_EXP:
  if (e2->Kind == kOP1_EXP) {
# line 339 "Expressions.puma"
  {
# line 341 "Expressions.puma"
   if (! (e1->OP1_EXP.EXP_OP1 -> Kind == e2->OP1_EXP.EXP_OP1 -> Kind)) goto yyL9;
  {
# line 342 "Expressions.puma"
   if (! (EqualExpression (e1->OP1_EXP.OPND, e2->OP1_EXP.OPND))) goto yyL9;
  }
  }
   return true;
yyL9:;

  }
  break;
  }

  return false;
}

int IsVarInExp
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree exp)
# else
(name, exp)
 register tIdent name;
 register tTree exp;
# endif
{
# line 353 "Expressions.puma"

int c;


  switch (exp->Kind) {
  case kVAR_OBJ:
# line 357 "Expressions.puma"
  {
# line 358 "Expressions.puma"
   if (! (name == exp->VAR_OBJ.Ident)) goto yyL1;
  }
   return 1;
yyL1:;

# line 362 "Expressions.puma"
   return 0;

  case kUSED_VAR:
# line 366 "Expressions.puma"
   return IsVarInExp (name, exp->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 370 "Expressions.puma"
   return IsVarInExp (name, exp->LOOP_VAR.LOOP_VARNAME);

  case kINDEXED_VAR:
# line 374 "Expressions.puma"
   return (IsVarInExp (name, exp->INDEXED_VAR.IND_VAR) + IsVarInExp (name, exp->INDEXED_VAR.IND_EXPS));

  case kVAR_EXP:
# line 378 "Expressions.puma"
   return IsVarInExp (name, exp->VAR_EXP.V);

  case kBTE_LIST:
# line 382 "Expressions.puma"
   return (IsVarInExp (name, exp->BTE_LIST.Elem) + IsVarInExp (name, exp->BTE_LIST.Next));

  case kBTE_EMPTY:
# line 386 "Expressions.puma"
   return 0;

  case kSLICE_EXP:
# line 390 "Expressions.puma"
   return (IsVarInExp (name, exp->SLICE_EXP.START) + IsVarInExp (name, exp->SLICE_EXP.STOP) + IsVarInExp (name, exp->SLICE_EXP.INC));

  case kDUMMY_EXP:
# line 395 "Expressions.puma"
   return 0;

  case kCONST_EXP:
# line 399 "Expressions.puma"
   return 0;

  case kADDR:
# line 403 "Expressions.puma"
   return (IsVarInExp (name, exp->ADDR.E));

  case kOP_EXP:
# line 407 "Expressions.puma"
   return (IsVarInExp (name, exp->OP_EXP.OPND1) + IsVarInExp (name, exp->OP_EXP.OPND2));

  case kOP1_EXP:
# line 411 "Expressions.puma"
   return (IsVarInExp (name, exp->OP1_EXP.OPND));

  case kARRAY_EXP:
# line 415 "Expressions.puma"
   return IsVarInExp (name, exp->ARRAY_EXP.ELEMENTS);

  case kFUNC_CALL_EXP:
# line 419 "Expressions.puma"
   return IsVarInExp (name, exp->FUNC_CALL_EXP.FUNC_PARAMS);

  case kBTP_LIST:
# line 423 "Expressions.puma"
   return (IsVarInExp (name, exp->BTP_LIST.Elem) + IsVarInExp (name, exp->BTP_LIST.Next));

  case kBTP_EMPTY:
# line 427 "Expressions.puma"
   return 0;

  case kVAR_PARAM:
# line 431 "Expressions.puma"
   return (IsVarInExp (name, exp->VAR_PARAM.V));

  }

# line 435 "Expressions.puma"
  {
# line 436 "Expressions.puma"
   printf ("Determination of IsVarInExp fails\n");
# line 437 "Expressions.puma"
   FileUnparse (stdout, exp);
# line 438 "Expressions.puma"
   WriteTree (stdout, exp);
# line 439 "Expressions.puma"
   exit (- 1);
  }
   return 0;

}

tTree MakeNotExp
# if defined __STDC__ | defined __cplusplus
(register tTree e)
# else
(e)
 register tTree e;
# endif
{
  if (e->Kind == kOP1_EXP) {
  if (e->OP1_EXP.EXP_OP1->Kind == kOP1_NOT) {
# line 451 "Expressions.puma"
   return e->OP1_EXP.OPND;

  }
  }
  if (e->Kind == kOP_EXP) {
  if (e->OP_EXP.EXP_OP->Kind == kOP_LT) {
# line 455 "Expressions.puma"
  {
# line 456 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_GE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_LE) {
# line 460 "Expressions.puma"
  {
# line 461 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_GT ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_GT) {
# line 465 "Expressions.puma"
  {
# line 466 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_LE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_GE) {
# line 470 "Expressions.puma"
  {
# line 471 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_LT ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_EQ) {
# line 475 "Expressions.puma"
  {
# line 476 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_NE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_NE) {
# line 480 "Expressions.puma"
  {
# line 481 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_NE ();
  }
   return e;

  }
  }
# line 485 "Expressions.puma"
   return mOP1_EXP (mOP1_NOT (), e);

}

void SliceIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree yyP1, register bool * yyP3, register int * yyP2)
# else
(yyP1, yyP3, yyP2)
 register tTree yyP1;
 register bool * yyP3;
 register int * yyP2;
# endif
{
  if (yyP1->Kind == kSLICE_EXP) {
# line 491 "Expressions.puma"
 {
  bool found;
  int val;
  {
# line 492 "Expressions.puma"

# line 493 "Expressions.puma"

# line 494 "Expressions.puma"
 if (yyP1->SLICE_EXP.INC == NoTree)
        { found = true;
          val   = 1;
        }
       else if (yyP1->SLICE_EXP.INC->Kind == kDUMMY_EXP)
        { found = true;
          val   = 1;
        }
       else
        GetIntConstValue (yyP1->SLICE_EXP.INC, &found, &val);

  }
   * yyP3 = found;
   * yyP2 = val;
   return;
 }

  }
;
}

tTree MakeSliceExp
# if defined __STDC__ | defined __cplusplus
(register tTree start, register tTree stop)
# else
(start, stop)
 register tTree start;
 register tTree stop;
# endif
{
# line 517 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  tTree exp;
  {
# line 518 "Expressions.puma"
   GetIntConstValue (start, & yyV1, & yyV2);
# line 519 "Expressions.puma"
   if (! (yyV1)) goto yyL1;
  {
# line 520 "Expressions.puma"
   GetIntConstValue (stop, & yyV3, & yyV4);
# line 522 "Expressions.puma"

# line 524 "Expressions.puma"
 if (yyV3)
        exp = mCONST_EXP (mINT_CONSTANT (yyV4 - yyV2 + 1));
      else if (yyV2 > 1)

        exp = mOP_EXP (mOP_MINUS(), stop, mCONST_EXP (mINT_CONSTANT(yyV2-1)));
      else if (yyV2 < 1)

        exp = mOP_EXP (mOP_PLUS(), stop, mCONST_EXP (mINT_CONSTANT(1-yyV2)));
      else
        exp = stop;

  }
  }
  {
   return exp;
  }
 }
yyL1:;

# line 538 "Expressions.puma"
 {
  tTree exp;
  {
# line 542 "Expressions.puma"

# line 544 "Expressions.puma"
 exp  = mOP_EXP (mOP_MINUS(), stop, start);
     exp  = mOP_EXP (mOP_PLUS (), exp, mCONST_EXP (mINT_CONSTANT(1)));

  }
  {
   return exp;
  }
 }

}

tTree AddConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
  if (equalint (c, 0)) {
# line 562 "Expressions.puma"
   return exp;

  }
# line 566 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 567 "Expressions.puma"
   GetIntConstValue (exp, & yyV1, & yyV2);
# line 568 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL2;
  }
  {
   return MakeConstant (c + yyV2);
  }
 }
yyL2:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 572 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 573 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 574 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL3;
  }
  {
   return AddConstant (exp->OP_EXP.OPND2, c + yyV2);
  }
 }
yyL3:;

# line 578 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 579 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 580 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL4;
  }
  {
   return AddConstant (exp->OP_EXP.OPND1, c + yyV2);
  }
 }
yyL4:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 584 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 585 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 586 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL5;
  }
  {
   return AddConstant (exp->OP_EXP.OPND1, c - yyV2);
  }
 }
yyL5:;

  }
  }
# line 590 "Expressions.puma"
  {
# line 591 "Expressions.puma"
   if (! (c > 0)) goto yyL6;
  }
   return mOP_EXP (mOP_PLUS (), exp, mCONST_EXP (mINT_CONSTANT (c)));
yyL6:;

# line 595 "Expressions.puma"
  {
# line 596 "Expressions.puma"
   if (! (c < 0)) goto yyL7;
  }
   return mOP_EXP (mOP_MINUS (), exp, mCONST_EXP (mINT_CONSTANT (- c)));
yyL7:;

 yyAbort ("AddConstant");
}

tTree MakeConstant
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
# line 602 "Expressions.puma"
  {
# line 603 "Expressions.puma"
   if (! ((n >= 0))) goto yyL1;
  }
   return mCONST_EXP (mINT_CONSTANT (n));
yyL1:;

# line 607 "Expressions.puma"
   return mOP1_EXP (mOP1_SIGN (), mCONST_EXP (mINT_CONSTANT (- n)));

}

void BeginExpressions ()
{
}

void CloseExpressions ()
{
}
