# include "Definiti.h"
# define yyALLOC(ptr, size)	if ((ptr = (tDefinitions) Definitions_PoolFreePtr) >= (tDefinitions) Definitions_PoolMaxPtr) \
  ptr = Definitions_Alloc (); \
  Definitions_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include <stdio.h>
# include "yyDefini.w"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMe.h"
# include "Idents.h"
# include "Sets.h"
}
# else
# include <stdio.h>
# include "yyDefini.w"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMe.h"
# include "Idents.h"
# include "Sets.h"
# endif

/* line 129 "definitions.cg" */

#include "Idents.h"
#include "Tree.h"

#define TRACE_DEF 0    /* 0 : no output, 1 : traces calls */

tScopes ScopeList;
tScopes EmptyScopeList;        /* used for comparison */

tEntries  UnitEntries;         /* tEntries form one Scope */
tEntries  IntrinsicEntries;
tEntries  ExternalEntries;
tEntries  CommonEntries;

/**************************************************************************
*                                                                         *
*    Intrinsic Functions / Subroutines of FORTRAN                         *
*                                                                         *
**************************************************************************/

void MakeIntrProcEntry (Entries, Name, LocalEntries)
tEntries *Entries, LocalEntries;
char * Name;
{ tIdent Id;
  tTree Decl;
  tObject Object;

  Id = MakeIdent (Name, strlen (Name));
  Decl = mINTRINSIC_DECL (Id, 0);
  Object = mProcObject (Id, Decl, 0, LocalEntries);
  *Entries = mENTRY_LIST (Object, *Entries);
}

void MakeIntrFuncEntry (Entries, Name, LocalEntries)
tEntries *Entries, LocalEntries;
char * Name;
{ tIdent Id;
  tTree Decl;
  tObject Object;

  Id = MakeIdent (Name, strlen (Name));
  Decl = mINTRINSIC_DECL (Id, 0);
  Object = mFuncObject (Id, Decl, 0, LocalEntries);
  *Entries = mENTRY_LIST (Object, *Entries);
}

tEntries InitEntries ()
{ tObject Object;
  tEntries Entries;
  tEntries NoOne;
  tTree   Decl;
  char * Word;
  tIdent Id;

  Entries = mENTRY_EMPTY();
  NoOne   = mENTRY_EMPTY();

  MakeIntrFuncEntry (&Entries, "ABS", NoOne);       /* generic */
  MakeIntrFuncEntry (&Entries, "IABS", NoOne);      /* I4 - I */
  MakeIntrFuncEntry (&Entries, "DABS", NoOne);      /* r8 - r8 */
  MakeIntrFuncEntry (&Entries, "CABS", NoOne);      /* c8 - c8 */
  MakeIntrFuncEntry (&Entries, "CDABS", NoOne);     /* c16 - c16 */

  MakeIntrFuncEntry (&Entries, "AIMAG", NoOne);     /* imag(c8)-r4 */
  MakeIntrFuncEntry (&Entries, "DIMAG", NoOne);     /* imag(c16)-r8 */

  MakeIntrFuncEntry (&Entries, "COS", NoOne);
  MakeIntrFuncEntry (&Entries, "DCOS", NoOne);
  MakeIntrFuncEntry (&Entries, "CCOS", NoOne);
  MakeIntrFuncEntry (&Entries, "CDCOS", NoOne);
  MakeIntrFuncEntry (&Entries, "ACOS", NoOne);
  MakeIntrFuncEntry (&Entries, "DACOS", NoOne);

  MakeIntrFuncEntry (&Entries, "COSH", NoOne);
  MakeIntrFuncEntry (&Entries, "DCOSH", NoOne);

  MakeIntrFuncEntry (&Entries, "CMPLX", NoOne);    /* one or two parameters */
  MakeIntrFuncEntry (&Entries, "DCMPLX", NoOne);

  MakeIntrFuncEntry (&Entries, "CONJG", NoOne);

  MakeIntrFuncEntry (&Entries, "EXP", NoOne);
  MakeIntrFuncEntry (&Entries, "DEXP", NoOne);

  MakeIntrFuncEntry (&Entries, "DBLE", NoOne);

  MakeIntrFuncEntry (&Entries, "FLOAT", NoOne);
  MakeIntrFuncEntry (&Entries, "DFLOAT", NoOne);

  MakeIntrFuncEntry (&Entries, "IFIX", NoOne);

  MakeIntrFuncEntry (&Entries, "INT", NoOne);
  MakeIntrFuncEntry (&Entries, "IDINT", NoOne);
  MakeIntrFuncEntry (&Entries, "NINT", NoOne);

  MakeIntrFuncEntry (&Entries, "LOG", NoOne);
  MakeIntrFuncEntry (&Entries, "ALOG", NoOne);
  MakeIntrFuncEntry (&Entries, "CLOG", NoOne);
  MakeIntrFuncEntry (&Entries, "DLOG", NoOne);
  MakeIntrFuncEntry (&Entries, "CDLOG", NoOne);

  MakeIntrFuncEntry (&Entries, "LOG10", NoOne);
  MakeIntrFuncEntry (&Entries, "ALOG10", NoOne);
  MakeIntrFuncEntry (&Entries, "DLOG10", NoOne);

  MakeIntrFuncEntry (&Entries, "MAX", NoOne);
  MakeIntrFuncEntry (&Entries, "MAX0", NoOne);
  MakeIntrFuncEntry (&Entries, "AMAX1", NoOne); /* specific MAX for real*4 */
  MakeIntrFuncEntry (&Entries, "DMAX1", NoOne); /* specific MAX for real*8 */

  MakeIntrFuncEntry (&Entries, "MIN", NoOne);
  MakeIntrFuncEntry (&Entries, "MIN0", NoOne);
  MakeIntrFuncEntry (&Entries, "AMIN1", NoOne); /* specific MIN for real*4 */
  MakeIntrFuncEntry (&Entries, "DMIN1", NoOne); /* specific MIN for real*8 */

  MakeIntrFuncEntry (&Entries, "MOD", NoOne);
  MakeIntrFuncEntry (&Entries, "DMOD", NoOne);
  MakeIntrFuncEntry (&Entries, "AMOD", NoOne);
  MakeIntrFuncEntry (&Entries, "ODD", NoOne);

  MakeIntrFuncEntry (&Entries, "REAL", NoOne);
  MakeIntrFuncEntry (&Entries, "DREAL", NoOne);

  MakeIntrFuncEntry (&Entries, "ROUND", NoOne);

  MakeIntrFuncEntry (&Entries, "SIGN", NoOne);
  MakeIntrFuncEntry (&Entries, "ISIGN", NoOne);
  MakeIntrFuncEntry (&Entries, "DSIGN", NoOne);

  MakeIntrFuncEntry (&Entries, "SIN", NoOne);
  MakeIntrFuncEntry (&Entries, "DSIN", NoOne);
  MakeIntrFuncEntry (&Entries, "CSIN", NoOne);
  MakeIntrFuncEntry (&Entries, "CDSIN", NoOne);
  MakeIntrFuncEntry (&Entries, "ASIN", NoOne);
  MakeIntrFuncEntry (&Entries, "DASIN", NoOne);

  MakeIntrFuncEntry (&Entries, "SINH", NoOne);
  MakeIntrFuncEntry (&Entries, "DSINH", NoOne);

  MakeIntrFuncEntry (&Entries, "SQR", NoOne);
  MakeIntrFuncEntry (&Entries, "SQRT", NoOne);
  MakeIntrFuncEntry (&Entries, "DSQRT", NoOne);

  MakeIntrFuncEntry (&Entries, "TAN", NoOne);     /* tangent */
  MakeIntrFuncEntry (&Entries, "DTAN", NoOne);    /* tangent, real*8 */
  MakeIntrFuncEntry (&Entries, "ATAN", NoOne);    /* arc tangent */
  MakeIntrFuncEntry (&Entries, "DATAN", NoOne);   /* arc tangent, real*8 */
  MakeIntrFuncEntry (&Entries, "ATAN2", NoOne);    /* arc tangent */
  MakeIntrFuncEntry (&Entries, "DATAN2", NoOne);   /* arc tangent, real*8 */

  /* char intrinsics */

  MakeIntrFuncEntry (&Entries, "ICHAR", NoOne);
  MakeIntrFuncEntry (&Entries, "CHAR", NoOne);
  MakeIntrFuncEntry (&Entries, "LEN", NoOne);

  MakeIntrFuncEntry (&Entries, "LGT", NoOne);
  MakeIntrFuncEntry (&Entries, "LGE", NoOne);
  MakeIntrFuncEntry (&Entries, "LLT", NoOne);
  MakeIntrFuncEntry (&Entries, "LLE", NoOne);

  /* bit intrinsics */

  MakeIntrFuncEntry (&Entries, "IBSET", NoOne);
  MakeIntrFuncEntry (&Entries, "IBCLR", NoOne);
  MakeIntrFuncEntry (&Entries, "IAND", NoOne);
  MakeIntrFuncEntry (&Entries, "IOR", NoOne);
  MakeIntrFuncEntry (&Entries, "IEOR", NoOne);
  MakeIntrFuncEntry (&Entries, "NOT", NoOne);
  MakeIntrFuncEntry (&Entries, "ISHFT", NoOne);
  MakeIntrFuncEntry (&Entries, "ISHFTC", NoOne);
  MakeIntrFuncEntry (&Entries, "BTEST", NoOne);

  /* inquiry functions */

  MakeIntrFuncEntry (&Entries, "SIZE", NoOne);
  MakeIntrFuncEntry (&Entries, "SHAPE", NoOne);
  MakeIntrFuncEntry (&Entries, "UBOUND", NoOne);
  MakeIntrFuncEntry (&Entries, "LBOUND", NoOne);

  /* array intrinsics */

  MakeIntrFuncEntry (&Entries, "PACK", NoOne);
  MakeIntrFuncEntry (&Entries, "UNPACK", NoOne);
  MakeIntrFuncEntry (&Entries, "ALL", NoOne);
  MakeIntrFuncEntry (&Entries, "ANY", NoOne);
  MakeIntrFuncEntry (&Entries, "COUNT", NoOne);
  MakeIntrFuncEntry (&Entries, "MAXVAL", NoOne);
  MakeIntrFuncEntry (&Entries, "MINVAL", NoOne);
  MakeIntrFuncEntry (&Entries, "SPREAD", NoOne);
  MakeIntrFuncEntry (&Entries, "CSHIFT", NoOne);
  MakeIntrFuncEntry (&Entries, "SUM", NoOne);
  MakeIntrFuncEntry (&Entries, "PRODUCT", NoOne);
  MakeIntrFuncEntry (&Entries, "DOTPRODUCT", NoOne);
  MakeIntrFuncEntry (&Entries, "MATMUL", NoOne);
  MakeIntrFuncEntry (&Entries, "MERGE", NoOne);

  /* HPF intrinsic functions */

  MakeIntrFuncEntry (&Entries, "IALL", NoOne);
  MakeIntrFuncEntry (&Entries, "IANY", NoOne);
  MakeIntrFuncEntry (&Entries, "IPARITY", NoOne);
  MakeIntrFuncEntry (&Entries, "PARITY", NoOne);

  /* some newer one */

  MakeIntrFuncEntry (&Entries, "TRANSPOSE", NoOne);
  MakeIntrFuncEntry (&Entries, "EOSHIFT", NoOne);
  MakeIntrFuncEntry (&Entries, "MINLOC", NoOne);
  MakeIntrFuncEntry (&Entries, "MAXLOC", NoOne);
  MakeIntrFuncEntry (&Entries, "DIAGONAL", NoOne);
  MakeIntrFuncEntry (&Entries, "REPLICATE", NoOne);
  MakeIntrFuncEntry (&Entries, "RESHAPE", NoOne);

  MakeIntrProcEntry (&Entries, "CMF_RANDOM", NoOne);
  MakeIntrProcEntry (&Entries, "CMF_RANDOMIZE", NoOne);

  MakeIntrProcEntry (&Entries, "GLOBAL_GET", NoOne);
  MakeIntrProcEntry (&Entries, "GLOBAL_SEND", NoOne);

  MakeIntrProcEntry (&Entries, "CM_TIMER_CLEAR", NoOne);
  MakeIntrProcEntry (&Entries, "CM_TIMER_START", NoOne);
  MakeIntrProcEntry (&Entries, "CM_TIMER_STOP", NoOne);
  MakeIntrProcEntry (&Entries, "CM_TIMER_PRINT", NoOne);
  MakeIntrProcEntry (&Entries, "WALLTIME", NoOne);

  return (Entries);
  /* merge, diagonal,
     replicate, reshape, lbound, ubound, rank,
     shape, size, eoshift, transpose,
     firstloc, lastloc, project,
     nil,
     input, output,
  */
}

    /*******************************************************
    *                                                      *
    *     Searching in a local Table                       *
    *                                                      *
    ********************************************************/

tObject GetDeclEntry (Ident,Decls)
  register tIdent Ident;
  register tEntries Decls;
  {
     char Word [256];
     tObject Obj;
     GetString (Ident, Word);
     /* printf ("GetDeclEntry : Searching for %s\\n", Word); */
     while (Decls->Kind != kENTRY_EMPTY)
      { if (Decls->Kind != kENTRY_LIST)
           printf ("Error : GetDeclEntry - Illegal Entry-List\\n");
        Obj = Decls->ENTRY_LIST.Elem;
        if (Obj->Object.ident == Ident)
           { return Obj; }
          else Decls = Decls->ENTRY_LIST.Next;
      }
     return NoObject;
  }

    /*******************************************************
    *                                                      *
    *     Searching in a List of Tables                    *
    *                                                      *
    ********************************************************/

tObject GetDecl (Ident, Scopes)
  register tIdent Ident;
  tScopes Scopes;
  { tObject Obj;
    tEntries Scope;
    char Word [256];

    GetString (Ident, Word);
    Obj = NoObject;
    /* printf ("GetDecl: Searching for %s\\n", Word); */
    while (Scopes->Kind != kSCOPE_EMPTY)
      { if (Scopes->Kind != kSCOPE_LIST)
           printf ("Error : GetDecl - Illegal Scopes-List\\n");
        Scope = Scopes->SCOPE_LIST.Table;
        Obj = GetDeclEntry (Ident, Scope);
        if (Obj != NoObject)
           return Obj;
         else Scopes = Scopes->SCOPE_LIST.Hidden;
       }
    return NoObject;
  }

    /*******************************************************
    *                                                      *
    *  Searching an Entry: LOCAL and GLOBAL                *
    *                                                      *
    ********************************************************/

void CheckOpenScope ()
{ if (ScopeList == EmptyScopeList)
     { printf ("definitions: internal error, no open scope\n");
       exit (-1);
     }
}  /* CheckOpenScope */

tObject GetLocalDecl (Ident)
tIdent Ident;
{ CheckOpenScope ();
  return GetDeclEntry (Ident, ScopeList->SCOPE_LIST.Table);
} /* GetLocalDecl */

tObject GetGlobalDecl (Ident)
tIdent Ident;
{ return GetDecl (Ident, ScopeList);
} /* GetGlobalDecl */

tObject GetOtherDecl (Ident)
tIdent Ident;
{  tObject obj;
   obj = GetDeclEntry (Ident, IntrinsicEntries); /* intrinsics first */
   if (obj == NoObject)
     obj = GetDeclEntry (Ident, UnitEntries);
   if (obj == NoObject)
     obj = GetDeclEntry (Ident, ExternalEntries);
   return (obj);
} /* GetOtherDecl */

    /*******************************************************
    *                                                      *
    *    Insert an Entry in the local unit Table           *
    *                                                      *
    ********************************************************/

void InsertUnitEntry (Obj)
  tObject Obj;
  {  UnitEntries = mENTRY_LIST (Obj, UnitEntries);
  }

void InsertExternalEntry (Obj)
  tObject Obj;
  {  ExternalEntries = mENTRY_LIST (Obj, ExternalEntries);
  }

void InsertCommonEntry (Obj)
  tObject Obj;
  {  CommonEntries = mENTRY_LIST (Obj, CommonEntries);
  }

void InsertEntry (Obj)
  tObject Obj;
  {  CheckOpenScope ();
     ScopeList->SCOPE_LIST.Table =
          mENTRY_LIST (Obj, ScopeList->SCOPE_LIST.Table);
  }

    /*******************************************************
    *                                                      *
    *    Replacing an entry in a Scope                     *
    *                                                      *
    ********************************************************/

void ChangeEntry (Name, Obj)
  tIdent  Name;
  tObject Obj;    /* replaces the old object */

  {  tEntries CurrentScope;
     bool found;
     tObject oldobj;

     CheckOpenScope ();
     CurrentScope = ScopeList->SCOPE_LIST.Table;
     found = false;
     while (!found && (CurrentScope->Kind == kENTRY_LIST))
       { oldobj = CurrentScope->ENTRY_LIST.Elem;
         found = (oldobj->Object.ident == Name);
         if (found)
            CurrentScope->ENTRY_LIST.Elem = Obj;
          else
            CurrentScope = CurrentScope->ENTRY_LIST.Next;
       }
     if (!found)
        { printf ("Internal Error for Change Entry: old object not found\n");
          exit (-1);
        }

  } /* ChangeEntry */

    /*******************************************************
    *                                                      *
    *   Functions/Routines for SCOPE Handling              *
    *                                                      *
    ********************************************************/

void NewScope ()  /* opening new empty scope */
{ ScopeList = mSCOPE_LIST (mENTRY_EMPTY (), ScopeList); }

void OpenScope (Entries)   /* open given scope */
tEntries Entries;
{ if (  (Entries->Kind == kENTRY_LIST)
     || (Entries->Kind == kENTRY_EMPTY))
      ScopeList = mSCOPE_LIST (Entries, ScopeList);
   else
     printf ("Internal Error Definitios - OpenScope\n"); }

void CloseScope () /* close last scope */
{  CheckOpenScope ();
   ScopeList = ScopeList->SCOPE_LIST.Hidden; }

tEntries GetCurrentScope () /* get the current Scope */
{  CheckOpenScope ();
   return (ScopeList->SCOPE_LIST.Table); }

tEntries GetExternalEntries () /* get Scope with Externals */
{ return (ExternalEntries); }

tEntries GetIntrinsicEntries () /* get Scope with Intrinsics */
{ return (IntrinsicEntries); }

tEntries GetUnitEntries () /* get Scope with Units */
{ return (UnitEntries); }

tEntries GetCommonEntries () /* get Scope with Commons */
{ return (CommonEntries); }



# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tDefinitions DefinitionsRoot;
unsigned long Definitions_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoDefinitions;
char * Definitions_PoolFreePtr	= (char *) NoDefinitions;
char * Definitions_PoolMaxPtr	= (char *) NoDefinitions;
static unsigned short yyMaxSize	= 0;
unsigned short Definitions_NodeSize [29 + 1] = { 0,
 sizeof (yScopes),
 sizeof (ySCOPE_LIST),
 sizeof (ySCOPE_EMPTY),
 sizeof (yEntries),
 sizeof (yENTRY_LIST),
 sizeof (yENTRY_EMPTY),
 sizeof (yObject),
 sizeof (yVarObject),
 sizeof (yTemplateObject),
 sizeof (yProcessorsObject),
 sizeof (yTypeObject),
 sizeof (yProcObject),
 sizeof (yFuncObject),
 sizeof (yBlockObject),
 sizeof (yModuleObject),
 sizeof (yCommonObject),
 sizeof (yNameListObject),
 sizeof (yDistribution),
 sizeof (yDefaultDistribution),
 sizeof (yArrayUseDistribution),
 sizeof (ySerialDistribution),
 sizeof (yHostDistribution),
 sizeof (yNodeDistribution),
 sizeof (yAlignDistribution),
 sizeof (yVarDescription),
 sizeof (yVarDummy),
 sizeof (yVarConstant),
 sizeof (yVarLocal),
 sizeof (yVarCommon),
};
char * Definitions_NodeName [29 + 1] = {
 "NoDefinitions",
 "Scopes",
 "SCOPE_LIST",
 "SCOPE_EMPTY",
 "Entries",
 "ENTRY_LIST",
 "ENTRY_EMPTY",
 "Object",
 "VarObject",
 "TemplateObject",
 "ProcessorsObject",
 "TypeObject",
 "ProcObject",
 "FuncObject",
 "BlockObject",
 "ModuleObject",
 "CommonObject",
 "NameListObject",
 "Distribution",
 "DefaultDistribution",
 "ArrayUseDistribution",
 "SerialDistribution",
 "HostDistribution",
 "NodeDistribution",
 "AlignDistribution",
 "VarDescription",
 "VarDummy",
 "VarConstant",
 "VarLocal",
 "VarCommon",
};
static Definitions_tKind yyTypeRange [29 + 1] = { 0,
 kSCOPE_EMPTY,
 kSCOPE_LIST,
 kSCOPE_EMPTY,
 kENTRY_EMPTY,
 kENTRY_LIST,
 kENTRY_EMPTY,
 kNameListObject,
 kVarObject,
 kTemplateObject,
 kProcessorsObject,
 kTypeObject,
 kProcObject,
 kFuncObject,
 kBlockObject,
 kModuleObject,
 kCommonObject,
 kNameListObject,
 kAlignDistribution,
 kDefaultDistribution,
 kArrayUseDistribution,
 kSerialDistribution,
 kHostDistribution,
 kNodeDistribution,
 kAlignDistribution,
 kVarCommon,
 kVarDummy,
 kVarConstant,
 kVarLocal,
 kVarCommon,
};

tDefinitions Definitions_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 29; i ++) {
   Definitions_NodeSize [i] = (Definitions_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (Definitions_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 Definitions_PoolFreePtr = yyBlockList->yyBlock;
 Definitions_PoolMaxPtr = Definitions_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 Definitions_HeapUsed += yyBlockSize;
 return (tDefinitions) Definitions_PoolFreePtr;
}

tDefinitions MakeDefinitions
# if defined __STDC__ | defined __cplusplus
 (Definitions_tKind yyKind)
# else
 (yyKind) Definitions_tKind yyKind;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool Definitions_IsType
# if defined __STDC__ | defined __cplusplus
 (register tDefinitions yyt, register Definitions_tKind yyKind)
# else
 (yyt, yyKind) register tDefinitions yyt; register Definitions_tKind yyKind;
# endif
{
 return yyt != NoDefinitions && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}


tDefinitions mScopes
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kScopes])
 yyt->Kind = kScopes;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tDefinitions mSCOPE_LIST
# if defined __STDC__ | defined __cplusplus
(tDefinitions pTable, tDefinitions pHidden)
# else
(pTable, pHidden)
tDefinitions pTable;
tDefinitions pHidden;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kSCOPE_LIST])
 yyt->Kind = kSCOPE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->SCOPE_LIST.Table = pTable;
 yyt->SCOPE_LIST.Hidden = pHidden;
 return yyt;
}

tDefinitions mSCOPE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kSCOPE_EMPTY])
 yyt->Kind = kSCOPE_EMPTY;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tDefinitions mEntries
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kEntries])
 yyt->Kind = kEntries;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tDefinitions mENTRY_LIST
# if defined __STDC__ | defined __cplusplus
(tDefinitions pElem, tDefinitions pNext)
# else
(pElem, pNext)
tDefinitions pElem;
tDefinitions pNext;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kENTRY_LIST])
 yyt->Kind = kENTRY_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->ENTRY_LIST.Elem = pElem;
 yyt->ENTRY_LIST.Next = pNext;
 return yyt;
}

tDefinitions mENTRY_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kENTRY_EMPTY])
 yyt->Kind = kENTRY_EMPTY;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tDefinitions mObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl)
# else
(pident, pdecl)
tIdent pident;
tTree pdecl;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kObject])
 yyt->Kind = kObject;
 yyt->yyHead.yyMark = 0;
 yyt->Object.ident = pident;
 yyt->Object.decl = pdecl;
 return yyt;
}

tDefinitions mVarObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, tDefinitions pKind, int puses, tDefinitions pDist)
# else
(pident, pdecl, pKind, puses, pDist)
tIdent pident;
tTree pdecl;
tDefinitions pKind;
int puses;
tDefinitions pDist;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kVarObject])
 yyt->Kind = kVarObject;
 yyt->yyHead.yyMark = 0;
 yyt->VarObject.ident = pident;
 yyt->VarObject.decl = pdecl;
 yyt->VarObject.Kind = pKind;
 yyt->VarObject.uses = puses;
 yyt->VarObject.Dist = pDist;
 return yyt;
}

tDefinitions mTemplateObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, tDefinitions pDist)
# else
(pident, pdecl, pDist)
tIdent pident;
tTree pdecl;
tDefinitions pDist;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kTemplateObject])
 yyt->Kind = kTemplateObject;
 yyt->yyHead.yyMark = 0;
 yyt->TemplateObject.ident = pident;
 yyt->TemplateObject.decl = pdecl;
 yyt->TemplateObject.Dist = pDist;
 return yyt;
}

tDefinitions mProcessorsObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl)
# else
(pident, pdecl)
tIdent pident;
tTree pdecl;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kProcessorsObject])
 yyt->Kind = kProcessorsObject;
 yyt->yyHead.yyMark = 0;
 yyt->ProcessorsObject.ident = pident;
 yyt->ProcessorsObject.decl = pdecl;
 return yyt;
}

tDefinitions mTypeObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, tDefinitions pComponents)
# else
(pident, pdecl, pComponents)
tIdent pident;
tTree pdecl;
tDefinitions pComponents;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kTypeObject])
 yyt->Kind = kTypeObject;
 yyt->yyHead.yyMark = 0;
 yyt->TypeObject.ident = pident;
 yyt->TypeObject.decl = pdecl;
 yyt->TypeObject.Components = pComponents;
 return yyt;
}

tDefinitions mProcObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, int pcalls, tDefinitions pDeclarations)
# else
(pident, pdecl, pcalls, pDeclarations)
tIdent pident;
tTree pdecl;
int pcalls;
tDefinitions pDeclarations;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kProcObject])
 yyt->Kind = kProcObject;
 yyt->yyHead.yyMark = 0;
 yyt->ProcObject.ident = pident;
 yyt->ProcObject.decl = pdecl;
 yyt->ProcObject.calls = pcalls;
 yyt->ProcObject.Declarations = pDeclarations;
 return yyt;
}

tDefinitions mFuncObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, int pcalls, tDefinitions pDeclarations)
# else
(pident, pdecl, pcalls, pDeclarations)
tIdent pident;
tTree pdecl;
int pcalls;
tDefinitions pDeclarations;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kFuncObject])
 yyt->Kind = kFuncObject;
 yyt->yyHead.yyMark = 0;
 yyt->FuncObject.ident = pident;
 yyt->FuncObject.decl = pdecl;
 yyt->FuncObject.calls = pcalls;
 yyt->FuncObject.Declarations = pDeclarations;
 return yyt;
}

tDefinitions mBlockObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, tDefinitions pDeclarations)
# else
(pident, pdecl, pDeclarations)
tIdent pident;
tTree pdecl;
tDefinitions pDeclarations;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kBlockObject])
 yyt->Kind = kBlockObject;
 yyt->yyHead.yyMark = 0;
 yyt->BlockObject.ident = pident;
 yyt->BlockObject.decl = pdecl;
 yyt->BlockObject.Declarations = pDeclarations;
 return yyt;
}

tDefinitions mModuleObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, int puses, tDefinitions pDeclarations)
# else
(pident, pdecl, puses, pDeclarations)
tIdent pident;
tTree pdecl;
int puses;
tDefinitions pDeclarations;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kModuleObject])
 yyt->Kind = kModuleObject;
 yyt->yyHead.yyMark = 0;
 yyt->ModuleObject.ident = pident;
 yyt->ModuleObject.decl = pdecl;
 yyt->ModuleObject.uses = puses;
 yyt->ModuleObject.Declarations = pDeclarations;
 return yyt;
}

tDefinitions mCommonObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl, int psize, int pmain, int pdistributed_vars, int psequence)
# else
(pident, pdecl, psize, pmain, pdistributed_vars, psequence)
tIdent pident;
tTree pdecl;
int psize;
int pmain;
int pdistributed_vars;
int psequence;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kCommonObject])
 yyt->Kind = kCommonObject;
 yyt->yyHead.yyMark = 0;
 yyt->CommonObject.ident = pident;
 yyt->CommonObject.decl = pdecl;
 yyt->CommonObject.size = psize;
 yyt->CommonObject.main = pmain;
 yyt->CommonObject.distributed_vars = pdistributed_vars;
 yyt->CommonObject.sequence = psequence;
 return yyt;
}

tDefinitions mNameListObject
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tTree pdecl)
# else
(pident, pdecl)
tIdent pident;
tTree pdecl;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kNameListObject])
 yyt->Kind = kNameListObject;
 yyt->yyHead.yyMark = 0;
 yyt->NameListObject.ident = pident;
 yyt->NameListObject.decl = pdecl;
 return yyt;
}

tDefinitions mDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars)
# else
(psize, phelpvars)
int psize;
int phelpvars;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kDistribution])
 yyt->Kind = kDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->Distribution.size = psize;
 yyt->Distribution.helpvars = phelpvars;
 return yyt;
}

tDefinitions mDefaultDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars)
# else
(psize, phelpvars)
int psize;
int phelpvars;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kDefaultDistribution])
 yyt->Kind = kDefaultDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->DefaultDistribution.size = psize;
 yyt->DefaultDistribution.helpvars = phelpvars;
 return yyt;
}

tDefinitions mArrayUseDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars)
# else
(psize, phelpvars)
int psize;
int phelpvars;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kArrayUseDistribution])
 yyt->Kind = kArrayUseDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->ArrayUseDistribution.size = psize;
 yyt->ArrayUseDistribution.helpvars = phelpvars;
 return yyt;
}

tDefinitions mSerialDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars)
# else
(psize, phelpvars)
int psize;
int phelpvars;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kSerialDistribution])
 yyt->Kind = kSerialDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->SerialDistribution.size = psize;
 yyt->SerialDistribution.helpvars = phelpvars;
 return yyt;
}

tDefinitions mHostDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars, tIdent phostdist_id)
# else
(psize, phelpvars, phostdist_id)
int psize;
int phelpvars;
tIdent phostdist_id;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kHostDistribution])
 yyt->Kind = kHostDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->HostDistribution.size = psize;
 yyt->HostDistribution.helpvars = phelpvars;
 yyt->HostDistribution.hostdist_id = phostdist_id;
 return yyt;
}

tDefinitions mNodeDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars, tIdent pnodedist_id, DistributedDimensions pdims)
# else
(psize, phelpvars, pnodedist_id, pdims)
int psize;
int phelpvars;
tIdent pnodedist_id;
DistributedDimensions pdims;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kNodeDistribution])
 yyt->Kind = kNodeDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->NodeDistribution.size = psize;
 yyt->NodeDistribution.helpvars = phelpvars;
 yyt->NodeDistribution.nodedist_id = pnodedist_id;
 yyt->NodeDistribution.dims = pdims;
 return yyt;
}

tDefinitions mAlignDistribution
# if defined __STDC__ | defined __cplusplus
(int psize, int phelpvars, tObject ptemplate, DistributedDimensions pdims)
# else
(psize, phelpvars, ptemplate, pdims)
int psize;
int phelpvars;
tObject ptemplate;
DistributedDimensions pdims;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kAlignDistribution])
 yyt->Kind = kAlignDistribution;
 yyt->yyHead.yyMark = 0;
 yyt->AlignDistribution.size = psize;
 yyt->AlignDistribution.helpvars = phelpvars;
 yyt->AlignDistribution.template = ptemplate;
 yyt->AlignDistribution.dims = pdims;
 return yyt;
}

tDefinitions mVarDescription
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kVarDescription])
 yyt->Kind = kVarDescription;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tDefinitions mVarDummy
# if defined __STDC__ | defined __cplusplus
(int pIntent, int pdynamic, bool poptional)
# else
(pIntent, pdynamic, poptional)
int pIntent;
int pdynamic;
bool poptional;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kVarDummy])
 yyt->Kind = kVarDummy;
 yyt->yyHead.yyMark = 0;
 yyt->VarDummy.Intent = pIntent;
 yyt->VarDummy.dynamic = pdynamic;
 yyt->VarDummy.optional = poptional;
 return yyt;
}

tDefinitions mVarConstant
# if defined __STDC__ | defined __cplusplus
(tTree pVal, tTree pType)
# else
(pVal, pType)
tTree pVal;
tTree pType;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kVarConstant])
 yyt->Kind = kVarConstant;
 yyt->yyHead.yyMark = 0;
 yyt->VarConstant.Val = pVal;
 yyt->VarConstant.Type = pType;
 return yyt;
}

tDefinitions mVarLocal
# if defined __STDC__ | defined __cplusplus
(int pIsSave, int pdynamic)
# else
(pIsSave, pdynamic)
int pIsSave;
int pdynamic;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kVarLocal])
 yyt->Kind = kVarLocal;
 yyt->yyHead.yyMark = 0;
 yyt->VarLocal.IsSave = pIsSave;
 yyt->VarLocal.dynamic = pdynamic;
 return yyt;
}

tDefinitions mVarCommon
# if defined __STDC__ | defined __cplusplus
(tIdent pBlock)
# else
(pBlock)
tIdent pBlock;
# endif
{
 register tDefinitions yyt;
 yyALLOC (yyt, Definitions_NodeSize [kVarCommon])
 yyt->Kind = kVarCommon;
 yyt->yyHead.yyMark = 0;
 yyt->VarCommon.Block = pBlock;
 return yyt;
}

typedef tDefinitions * yyPtrtTree;

static FILE * yyf;

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

void BeginDefinitions ()
{
/* line 552 "definitions.cg" */


if (TRACE_DEF)
   printf ("Initialization Declaration Table \\n");

UnitEntries      = mENTRY_EMPTY();

# ifdef FORTRAN
  IntrinsicEntries = InitEntries ();
# endif

# ifdef C
  IntrinsicEntries = mENTRY_EMPTY();
# endif

ExternalEntries  = mENTRY_EMPTY();
CommonEntries    = mENTRY_EMPTY();

ScopeList = mSCOPE_EMPTY ();
EmptyScopeList = ScopeList;    /* used for comparisons */

}

void CloseDefinitions ()
{
/* line 574 "definitions.cg" */

if (ScopeList != EmptyScopeList)
   { printf ("Scopes not properly closed\n");
     exit (-1);
   }

}
