      program redisttest

      integer I, J, K, M, N

      parameter (N=50, M=70)

      real A(N,M), SA(N,M), B(N,M)
      logical ERRS(N,M)

!hpf$ template T(N,M)
!hpf$ distribute T(*,BLOCK)
!hpf$ align (I,J) with T(I,J) :: A, SA, ERRS
!hpf$ align (J,I) with T(I,J) :: B

      integer ERRORS, NUMBER

      forall (j=1:M, i=1:N)
        A(i,j) = 100*i + j
      end forall

      print *, 'input number of iterations : '

      read *, NUMBER

      SA = A + NUMBER         ! save values of A

      ! transpose A to B

      call cm_timer_clear (0)
      call cm_timer_start (0)

      do k = 1, NUMBER
         B = A
         B = B + 1
         A = B
      end do

      call cm_timer_stop (0)

      ! compare against SA

      ERRS = (A .ne. SA)
      ERRORS = count (ERRS)

      print *, 'Errors = ', ERRORS

      if (ERRORS .gt. 0) then
         do i = 1, N
            do j = 1, M
               print *, I, J, A(I,J), SA(I,J), B(J,I)
            end do
         end do
      end if

      print *, NUMBER, ' * 2 transpose of size ',N,' x ',M,' needs : '
      call cm_timer_print (0)
      end
