#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <malloc.h>
#include <string.h>
#include "oscarsession.h"
#include "sessionmanager.h"
#include "unterminatedString.h"

// Set the debugging options here
//
// A non-developmental release should have these both
//  not defined for a small performance improvement.

// #define MRM_DEBUG_MEMORY
//   This performs memory leak checks and looks for bad allocation and free
//   operations (double frees, freeing unallocated memory, etc.).  This
//   requires MRM_DEBUG_PRINTF to be enabled to report the results.
// #define MRM_DEBUG_HEAPCHECK
//   This performs heap checking in addition to memory checking.
// #define MRM_DEBUG_STRINGS
//   This will track all unterminatedString object operations, in case I
//   start seeing strings get munged for no apparent reason.  This requires
//   MRM_DEBUG_PRINTF to be enabled to be useful at all.

#define MRM_DEBUG_PRINTF
// This will enable the "-debug" command line option to create a debug.log
// file.  I leave this on in my releases because it has proven itself to be
// extremely valuable in diagnosing problems, even though it might cause a
// tiny performance hit (1 if statement per debug print statement when it is
// not enabled).

#define MUX_DEBUG_ACQ debugf( "MUTEX ACQUIRED: %s line %d\n", __FILE__, __LINE__ );
#define MUX_DEBUG_REL debugf( "MUTEX RELEASED: %s line %d\n", __FILE__, __LINE__ );

#define SWAP4( theLong ) \
  (unsigned long)                                   \
   ((((unsigned long)theLong & 0xff000000ul)>>24) | \
    (((unsigned long)theLong & 0x00ff0000ul)>>8) |  \
    (((unsigned long)theLong & 0x0000ff00ul)<<8) |  \
    (((unsigned long)theLong & 0x000000fful)<<24))

#define SWAP2( theShort )                      \
  (unsigned short)                             \
   ((((unsigned short)theShort & 0xff00)>>8) | \
    (((unsigned short)theShort & 0x00ff)<<8))

#ifndef MRM_DEBUG_PRINTF
#define debugf()
#else
extern int debugf( char *, ... );
#endif

#ifndef MRM_DEBUG_MEMORY

#define CHECKED_FREE( ptr ) \
  free( ptr )
#define CHECKED_MALLOC( theSize, newPtr ) \
  *((void **)(&(newPtr))) = malloc( theSize )
#define CHECKED_REALLOC( ptr, theSize, newPtr ) \
  *((void **)(&(newPtr))) = realloc( ptr, theSize )
#define CHECKED_CALLOC( theSize, newPtr ) \
  *((void **)(&(newPtr))) = calloc( theSize, 1 )
#define CHECKED_STRDUP( theString, newPtr ) \
  *((char **)(&(newPtr))) = strdup( (const char *)(theString) );

#define CHECKED_NEW
#define CHECKED_DELETE

#define CHECKED_ACCESS( thePtr, theSize )

#define VALIDATE_ACCESS( theSize, thePtr )
#define INVALIDATE_ACCESS( thePtr )

#else

#define MRM_DEBUG_MAX_TRACERS 1048576
// Only keep a history of this many tracers

typedef struct
{
  const void *blockAddr;
  int allocLine;
  const char *allocModule;
  int freeLine;
  const char *freeModule;
  unsigned long timestamp, size, blockType, objRefCount;
} blockHistory;

extern blockHistory *memTracer;
extern int numMemTracers, allocMemTracers;

#define MRM_DEBUG_MEMCHECK_ISREALLOC 1
#define MRM_DEBUG_MEMCHECK_ISCALLOC  2
#define MRM_DEBUG_MEMCHECK_ISOBJECT  4
#define MRM_DEBUG_MEMCHECK_ISSTACK   8

#define MRM_DEBUG_MEMCHECK_BLOCKTYPE_NORMAL 0
#define MRM_DEBUG_MEMCHECK_BLOCKTYPE_STATIC 1

extern void CHECKED_FREE_TRACER( void *ptr, const char *file, int line,
 int flags );
extern void *CHECKED_MALLOC_TRACER( int size, const char *file, int line,
 int flags, void *reallocPtr );
extern void MEM_ACCESS_CHECKER( void *ptr, int size, const char *file,
 int line );

#define CORRUPTION_REPORT( function, beforeAfter ) \
  debugf( "HEAP CORRUPTION DETECTED %s %s.\nFILE: %s\nLINE: %d\n\n", beforeAfter, function, __FILE__, __LINE__ ); \
  exit( 1 );

#ifdef MRM_DEBUG_HEAPCHECK
  #define CHECK_HEAP( function, when ) \
   if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( function, when ); }
#else
  #define CHECK_HEAP( function, when )
#endif

#define CHECKED_FREE( ptr ) \
{ \
  CHECK_HEAP( "FREE", "PRIOR TO" ) \
  CHECKED_FREE_TRACER( (void *)ptr, __FILE__, __LINE__, 0 ); \
  CHECK_HEAP( "FREE", "AFTER" ) \
}
    
#define CHECKED_MALLOC( theSize, newPtr ) \
{ \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "MALLOC", "PRIOR TO" ); } \
  *((void **)(&(newPtr))) = CHECKED_MALLOC_TRACER( theSize, __FILE__, \
   __LINE__, 0, NULL ); \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "MALLOC", "AFTER" ); } \
}

#define CHECKED_REALLOC( ptr, theSize, newPtr ) \
{ \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "REALLOC", "PRIOR TO" ); } \
  if ( ptr ) CHECKED_FREE_TRACER( (void *)ptr, __FILE__, __LINE__, \
   MRM_DEBUG_MEMCHECK_ISREALLOC ); \
  if ( theSize ) *((void **)(&(newPtr))) = CHECKED_MALLOC_TRACER( theSize, __FILE__, \
   __LINE__, MRM_DEBUG_MEMCHECK_ISREALLOC, ptr ); \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "REALLOC", "AFTER" ); } \
}

#define CHECKED_CALLOC( theSize, newPtr ) \
{ \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "CALLOC", "PRIOR TO" ); } \
  *((void **)(&(newPtr))) = CHECKED_MALLOC_TRACER( theSize, __FILE__, \
   __LINE__, MRM_DEBUG_MEMCHECK_ISCALLOC, NULL ); \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "CALLOC", "AFTER" ); } \
}

#define CHECKED_STRDUP( theString, newPtr ) \
{ \
  int theSize = strlen( theString ) + 1; \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "STRDUP", "PRIOR TO" ); } \
  *((void **)(&(newPtr))) = CHECKED_MALLOC_TRACER( theSize, __FILE__, \
   __LINE__, 0, NULL ); \
  if ( newPtr ) \
  { \
    strcpy( newPtr, (const char *)(theString) ); \
  } \
  if ( _heapchk() != _HEAPOK ) { CORRUPTION_REPORT( "STRDUP", "AFTER" ); } \
}

#define CHECKED_NEW \
  CHECKED_MALLOC_TRACER( sizeof( *this ), __FILE__, __LINE__, \
   MRM_DEBUG_MEMCHECK_ISOBJECT, this );

#define CHECKED_DELETE \
  CHECKED_FREE_TRACER( this, __FILE__, __LINE__, \
   MRM_DEBUG_MEMCHECK_ISOBJECT );

#define CHECKED_ACCESS( thePtr, theSize ) \
  MEM_ACCESS_CHECKER( thePtr, theSize, __FILE__, __LINE__ );

#define VALIDATE_ACCESS( theSize, thePtr ) \
  CHECKED_MALLOC_TRACER( theSize, __FILE__, __LINE__, \
   MRM_DEBUG_MEMCHECK_ISSTACK, thePtr );

#define INVALIDATE_ACCESS( thePtr ) \
  CHECKED_FREE_TRACER( thePtr, __FILE__, __LINE__, \
   MRM_DEBUG_MEMCHECK_ISSTACK );

#endif

int initializeCompatibility( int initMMPM );
void deinitializeCompatibility( void );

void registerSessionManager( SessionManager *smgr );

int isMultiMediaCapable( void );
int isRexxCapable( void );

typedef struct
{
  const char *currentUser;
  const char *otherUser;
  UnterminatedString *message;
} eventData;

int handleMrMessageEvent( UI_EventType eventType,
 sessionThreadSettings *specificSettings,
 sessionThreadSettings *globalSettings,
 eventData *theEventData, int noSound );

unsigned long testSettingsFlag( unsigned long theFlag,
 sessionThreadSettings *specificSettings,
 sessionThreadSettings *globalSettings );

unsigned long testEventSettingsFlag( UI_EventType eventType,
 unsigned long theFlag, sessionThreadSettings *specificSettings,
 sessionThreadSettings *globalSettings );

void playMediaFile( const char *fileName );

ULONG getAudioVolume( void );
void setAudioVolume( ULONG volume );

