#include "jabberbox.h"

struct config etc = {NULL, NULL, NULL, "<r ", "</r>", 0};

int main(int argc, char *argv[])
{
	signal(SIGTERM, (void (*)())sig_die);
	signal(SIGKILL, (void (*)())sig_die);
	signal(SIGINT, (void (*)())sig_die);
	signal(SIGPIPE, SIG_IGN); /* let the io loop take care of problems */

	etc.arg = arg2pair(argc,argv);

	if(pair_get(etc.arg,"-D") != NULL)
		etc.debug = 1;

	DBUG("Starting JabberBox","")

	config_init();

	collect_packets(&dispatch);

	return 0;
}

void sig_die()
{
	DBUG("EXITING","")
	longjmp(env_io,1);
}
