#include "jabber.h"

module mod_basic;

struct basic_list
{
	char *id;
	struct basic_list *next;
};

struct basic_group
{
	char *id;
	char *group;
	struct basic_list *members;
	struct basic_group *next;
};

struct basic_group *basic_myusers = NULL;
struct basic_list *basic_otherusers = NULL;

int basic_getlist(char *id, struct basic_list *list)
{
	DBUG("MOD_BASIC: getlist for id ",id)

	if(id == NULL || list == NULL)
		return 0;
	while(list != NULL)
	{
		if(strcmp(id, list->id) == 0)
			return 1;
		list = list->next;
	}
	return 0;
}

struct basic_list *basic_setlist(char *id, struct basic_list *list)
{
	struct basic_list *new;

	DBUG("MOD_BASIC: setlist for id ",id)

	if(id == NULL)
		return NULL;
	if(basic_getlist(id,list) == 0)
	{
		new = malloc(sizeof(struct basic_list));
		new->id = strdup(id);
		new->next = list;
		return new;
	}
	return list;
}

struct basic_list *basic_freelist(char *id, struct basic_list *list)
{
	struct basic_list *prev, *next;
	int special = 0;

	DBUG("MOD_BASIC: freelist for id ",id)

	prev = next = list;

	if(list != NULL && list->next == NULL)
		special = 1;

	if(id == NULL)
		return NULL;
	while(next != NULL)
	{
		if(strcmp(id, next->id) == 0)
		{
			prev->next = next->next;
			free(next->id);
			free(next);
			if(special)
				return NULL;
			return list;
		}
		prev = next;
		next = next->next;
	}
	return list;
}

void basic_groupadd(char *id, char *group, char *newid)
{
	struct basic_group *new, *all = basic_myusers;

	DBUG("MOD_BASIC: groupadd for id ",id)

	if(id == NULL || group == NULL || newid == NULL)
		return;

	while(all != NULL)
	{
		if(strcmp(id, all->id) == 0 && strcmp(group, all->group) == 0)
		{
			all->members = basic_setlist(newid,all->members);
			return;
		}
		all = all->next;
	}
	new = malloc(sizeof(struct basic_group));
	new->id = strdup(id);
	new->group = strdup(group);
	new->members = basic_setlist(newid,NULL);
	new->next = basic_myusers;
	basic_myusers = new;
}

void basic_groupdel(char *id, char *group, char *newid)
{
	struct basic_group *all = basic_myusers;

	DBUG("MOD_BASIC: groupdel for id ",id)

	if(id == NULL || group == NULL || newid == NULL)
		return;

	while(all != NULL)
	{
		if(strcmp(id, all->id) == 0 && strcmp(group, all->group) == 0)
		{
			all->members = basic_freelist(newid,all->members);
			return;
		}
		all = all->next;
	}
}

pair *basic_pairgroup(char *id, char *group)
{
	struct basic_group *all = basic_myusers;
	struct basic_list *next;
	pair *new = NULL, *par = NULL;

	DBUG("MOD_BASIC: create pair from group for id ",id)

	if(id == NULL)
		return NULL;

	if(group == NULL)
	{
		while(all != NULL)
		{
			if(strcmp(id, all->id) == 0)
			{
				new = malloc(sizeof(pair));
				new->key = NULL;
				new->val = strdup(all->group);
				new->next = par;
				par = new;
			}
			all = all->next;
		}
		return par;
	}

	while(all != NULL)
	{
		if(strcmp(id, all->id) == 0 && strcmp(group, all->group) == 0)
		{
			next = all->members;
			while(next != NULL)
			{
				new = malloc(sizeof(pair));
				new->val = strdup(group);
				new->key = strdup(next->id);
				new->next = par;
				par = new;
				next = next->next;
			}
			return par;
		}
		all = all->next;
	}
	return NULL;
}

int basic_authenticate(char *id, char *pass)
{
	DBUG("MOD_BASIC: handler_auth ",id)
	return 2;
}

int basic_notify(char *id, int status)
{
	/* if offline freelist, if online setlist */
	DBUG("MOD_BASIC: handler_notify ",id)
	return 1;
}

pair *basic_status(char *id, int status)
{
	DBUG("MOD_BASIC: handler_status ",id)
	return basic_pairgroup(id,"_all");
}

pair *basic_roster(int type, char *id, char *group, char *newid)
{
	DBUG("MOD_BASIC: handler_roster ",id)
	switch(type)
	{
		case ROSTER_REMOVE:
			basic_groupdel(id, group, newid);
			basic_groupdel(id, "_all", newid);
			break;
		case ROSTER_ADD:
			basic_groupadd(id, group, newid);
			basic_groupadd(id, "_all", newid);
			break;
		case ROSTER_GET:
			return basic_pairgroup(id,group);
			break;
	}
	return NULL;
}

pair *basic_message_put(char *to, pair *p)
{
	DBUG("MOD_BASIC: handler_message_put ",to)
	return NULL;
}

pair *basic_message_get(char *to)
{
	DBUG("MOD_BASIC: handler_message_get ",to)
	return NULL;
}

void basic_init(pair *p)
{
	char *config;

	config = pair_getval(p, "basic");
	DBUG("MOD_BASIC: handler_init ",config)
}

int basic_handle(package *p)
{
	DBUG("MOD_BASIC: handler_handle package for ",p->id)
	return 0;
}

module mod_basic =
{
	0,
	basic_init,
	basic_authenticate,
	basic_notify,
	basic_status,
	basic_roster,
	basic_message_put,
	basic_message_get,
	NULL,
	NULL
};
