#include "jabber.h"

session *sessions = NULL;

void session_add(conn *c, char *id, char *user, int mod, int security)
{
	session *s;

	DBUG("New Session ",id)

	if(session_lookup(c,NULL,NULL) != NULL)
		c->type = CONN_MULTI;

	s = malloc(sizeof(session));
	s->c = c;

	if(user == NULL)
		s->user = NULL;
	else
		s->user = strdup(user);

	if(id == NULL)
		s->id = NULL;
	else
		s->id = strdup(id);

	s->mod = mod;
	s->status = NULL;
	s->say = NULL;
	s->flag_sendstatus = 0;
	s->flag_status = STATUS_OFFLINE;
	s->priority = 0;
	s->security = security;
	s->activity = malloc(sizeof(time_t));
	time(s->activity);
	s->start = malloc(sizeof(time_t));
	time(s->start);
	s->next = NULL;
	s->lookup_next = NULL;

	if(sessions == NULL)
	{
		sessions = s;
	}else{
		s->next = sessions;
		sessions = s;
	}
}

void session_del(session *s)
{
	session *prev, *next, *curr;
	int first_flag = 1;

	DBUG("Removing Session ",s->id)
	curr = prev = sessions;

	while(curr != NULL)
	{
		if(curr == s) /* is this ok? */
		{
			next = curr->next;
			free_session(s);
			if(first_flag)
				sessions = next;
			else
				prev->next = next;
			return;
		}
		first_flag = 0;
		prev = curr;
		curr = curr->next;
	}
}

session *session_lookup(conn *c, char *id, char *user) /* returns multiple sessions */
{
	session *curr, *ret, *ret_end;

	DBUG("Looking up session (id)",id)
	curr = sessions;
	ret = ret_end = NULL;

	while(curr != NULL)
	{
		curr->lookup_next = NULL;
		if(c == NULL)
		{
			if(id != NULL && curr->id != NULL && strcmp(id,curr->id) == 0)
			{
				if(user != NULL && curr->user != NULL && strcmp(user,curr->user) == 0)
					return curr;
				if(ret == NULL) /* if this is the first, start there */
				{
					ret = ret_end = curr;
				}else{
					/* create a secondary linked list within the main one */
					ret_end->lookup_next = curr;
					ret_end = curr;
				}
			}
		}else{
			if(c->id == curr->c->id && c->type != CONN_LOCAL)
			{
				if(id != NULL && curr->id != NULL && strcmp(id,curr->id) == 0)
					return curr;
				if(ret == NULL)
				{
					ret = ret_end = curr;
				}else{
					ret_end->lookup_next = curr;
					ret_end = curr;
				}
			}
		}
		curr = curr->next;
	}
	return ret;
}

void session_print()
{
	session *curr = sessions;

	while(curr != NULL)
	{
		printf("+++ SESSION socket [%d]\n",curr->c->id);
		printf("+++ SESSION socket type [%d]\n",curr->c->type);
		DBUG("SESSION socket name",curr->c->name)
		printf("+++ SESSION module [%d]\n",curr->mod);
		printf("+++ SESSION security [%d]\n",curr->security);
		DBUG("SESSION id ",curr->id)
		DBUG("SESSION nick ",curr->user)
		DBUG("SESSION status ",curr->status)
		DBUG("SESSION say ",curr->say)
		printf("+++ SESSION flag_sendstatus [%d]\n",curr->flag_sendstatus);
		printf("+++ SESSION flag_status [%d]\n",curr->flag_status);
		printf("+++ SESSION priority [%d]\n",curr->priority);
		DBUG("SESSION activity ",ctime(curr->activity))
		DBUG("SESSION start ",ctime(curr->start))
		curr = curr->next;
	}
}

void free_session(session *s)
{
	free(s->id);
	free(s->user);
	free(s->status);
	free(s->say);
	free(s->activity);
	free(s->start);
	free(s);
}


