#include "jabber.h"

conn *dispatch(char *p, conn *c)
{
	static tap tp = {NULL,&handle_packet,0};
	conn *c_new = NULL;
	package pak;
	session *s;
	int sock;

	if(strcmp(p,"REMOVE") == 0)
	{
		DBUG("Removing connection at handler level for ",c->name)

		pak.type = PACK_LOGOUT;
		s = session_lookup(c,NULL,NULL);
		while(s != NULL)
		{
			pak.s = s;
			pak.id = s->id;
			pak.user = s->user;
			handle_package(&pak);
			s = s->lookup_next;
		}
		return c_new;
	}

	if(strcmp(p,"INIT") == 0)
	{
		DBUG("Initialization from IO loop","")

		sock = make_filesocket(pair_getval(etc.vars, "local"), 1);
		h_err(sock, "local file socket");
		c_new = conn_add(NULL, sock);
		c_new->type = CONN_LOCAL;
		c_new->packets = packet_add(c_new->packets,"<r handshake='jabber'></r>",NULL);
		transport = c_new; /* store globally */
		return c_new;
	}

	tag_parse(&tp,p,c);

	return c_new;
}


void handle_packet(tag *t, conn *c)
{
	char *type;
	static tap tp = {NULL,NULL,0};
	static int configured = 0;
	package *p;
	session *s;
	int i = 0;

	DBUG("Handling packet from ",c->name)

	type = pair_getval(t->attributes,"type");
	if(type == NULL) /* not a valid incoming packet */
	{
		return;
	}

	if(strcmp(type,"config") == 0 && c->type == CONN_LOCAL)
	{
		if(configured == 0)
		{
			DBUG("Doing initial configuration","");
			tp.h_tag = &handle_config;
			tag_parse(&tp,t->contents,c);
			do_config();
			configured = 1; /* flag that config has been parsed already */
		}
		return;
	}

	p = package_init(c);

	if(strcmp(type,"connection") == 0)
	{
		tp.h_tag = &handle_connection;
		p->type = PACK_CONNECTION;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"login") == 0)
	{
		tp.h_tag = &handle_login;
		p->type = PACK_LOGIN;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"logout") == 0)
	{
		p->type = PACK_LOGOUT;
	}
	if(strcmp(type,"message") == 0)
	{
		tp.h_tag = &handle_message;
		p->type = PACK_MESSAGE;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"status") == 0)
	{
		tp.h_tag = &handle_status;
		p->type = PACK_STATUS;
		p->flag_type = STATUS_NORMAL;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"roster") == 0)
	{
		tp.h_tag = &handle_roster;
		p->type = PACK_ROSTER;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"debug") == 0)
	{
		session_print();
	}

	/* fill in "from" information if needed */
	if(	p->type == PACK_ROSTER || 
		p->type == PACK_STATUS ||
		p->type == PACK_MESSAGE ||
		p->type == PACK_LOGOUT)
	{
		switch(p->c->type)
		{
			case CONN_LOCAL:
				p->id = pair_getvalnew(t->attributes,"from");
				p->user = pair_getvalnew(t->attributes,"nick");
				break;
			case CONN_MULTI:
				p->id = pair_getvalnew(t->attributes,"from");
				if(p->id == NULL) /* just in case of broken clients */
					break;
				s = session_lookup(c,p->id,NULL);
				if(s != NULL || s->user != NULL)
				{
					p->user = strdup(s->user);
					p->s = s;
				}
				break;
			case CONN_NORMAL:
				s = session_lookup(c,NULL,NULL);
				if(s != NULL)
				{
					if(s->id != NULL)
						p->id = strdup(s->id);
					if(s->user != NULL)
						p->user = strdup(s->user);
					p->s = s;
				}else{ /* anonymous user */
					session_add(c,"anonymous",c->name,MOD_NONE,3);
					p->s = sessions;
					p->id = strdup("anonymous");
					p->user = strdup(c->name);
				}
				break;
		}
	}

	/* for packets we don't know about, maybe the module wants to have a go at it */
	if(p->type == PACK_UNKNOWN)
	{
		p->raw = strdup(t->contents);
		p->raw_type = strdup(type);
	}

	if(i <= 0)
		handle_package(p);

	free_package(p);
}


void handle_package(package *p)
{
	char *buff = NULL;
	pair *par, *par_start;
	static pair *transports = NULL;
	int i = 0;
	module **m;

	if(etc.debug)
		package_print(p);

	switch(p->type)
	{
		case PACK_CONNECTION:
			DBUG("Handling package ","PACK_CONNECTION")
			if(p->c->type == CONN_LOCAL)
			{
				/* only deliver a return connection packet if we haven't already, stops looping */
				if(p->raw != NULL && pair_get(transports, p->raw) == NULL)
					transports = pair_new(transports, p->raw, p->version, 0);
				else
					break;
			}
			deliver_connection(p->c, p->raw);
			break;
		case PACK_LOGIN:
			DBUG("Handling package ","PACK_LOGIN")
			/* if they didnt specify a pass, create an anonymous session */
			for(m = modules; *m != NULL; m++)
			{
				if((*m)->authenticate != NULL)
				{
					i = (*m)->authenticate(p->id,p->pass);
					if(i > 0)
					{
						session_add(p->c,p->id,p->user,(*m)->module,i);
						return;
					}
				}
			}
			if(p->pass == NULL && p->id == NULL)
			{
				session_add(p->c,"anonymous",p->user,MOD_NONE,3);
				break;
			}
			if(p->id != NULL)
			{
				buff = print_message(p->id,NULL,"Authentication Failed","The credentials provided could not be verified at this time.",NULL,"error",0,p->id,NULL,p->c->type);
				p->c->packets = packet_add(p->c->packets,buff,"");
				free(buff);
			}
			break;
		case PACK_STATUS:
			DBUG("Handling package ","PACK_STATUS")
			if(p->c->type == CONN_LOCAL)
			{ /* status is coming from remote server to local user */
				deliver_status(p->id,p->user,p->version,p->say,p->status,p->flag_type);
			}else{ /* new status from local user, deal with it */
				if(p->s == NULL)
					p->s = session_lookup(p->c,p->id,NULL);
				if(p->s == NULL) /* should never happen, but... */
					break;

				if(p->say != NULL)
				{
					free(p->s->say);
					p->s->say = strdup(p->say);
				}
				if(p->status != NULL)
				{
					free(p->s->status);
					p->s->status = strdup(p->status);
				}
				p->s->priority = p->priority;
				if(p->flag_type == STATUS_OFFLINE)
					p->s->flag_status = STATUS_OFFLINE;
				else
					p->s->flag_status = STATUS_NORMAL;
				/* the status module for this user
				 * now has to tell the roster list online */
				par_start = par = NULL;
				if(p->s->mod != MOD_NONE && modules[p->s->mod]->status != NULL)
					par_start = par = modules[p->s->mod]->status(p->id,p->flag_type);
				/* the module returned a list of users to notify */
				while(par != NULL)
				{
					/* don't send to self even if on the list to notify */
					if(par->key != NULL && strcmp(par->key,p->id) != 0)
						deliver_status(p->id,p->user,par->key,p->say,p->status,p->flag_type);
					par = par->next;
				}
				/* make sure we tell our other sessions if there are any */
				deliver_status(p->id,p->user,p->id,p->say,p->status,p->flag_type);
				free_pair(par_start);
				if(p->flag_type == STATUS_ONLINE && p->s->mod != MOD_NONE && modules[p->s->mod]->online_message != NULL)
				{ /* fetching any offline messages */
					while((par = modules[p->s->mod]->online_message(p->id)) != NULL)
					{
						deliver_message(p->id,p->user,pair_getval(par,"from"),NULL,pair_getval(par,"subject"),pair_getval(par,"say"),pair_getval(par,"thread"),pair_getval(par,"ext"),pair_getflag(par,"priority"));
						free_pair(par);
					}
				}
			}
			break;
		case PACK_ROSTER:
			DBUG("Handling package ","PACK_ROSTER")
			if(p->s == NULL)
				p->s = session_lookup(p->c,p->id,NULL);
			if(p->s == NULL) /* should never happen, but... */
				break;
			if(p->s->mod == MOD_NONE)
				break;
			if(p->flag_type == ROSTER_GET)
			{
				if(p->s->flag_sendstatus == 0)
				{
					p->s->flag_sendstatus = 1;
					if(p->s->flag_status != STATUS_OFFLINE)
					{
						/* call the status module again so that all of the remote users get re-notified and re-send their status so that it shows up in the users new roster-list, kind of twisted way of doing this */
						if(modules[p->s->mod]->status != NULL)
							par_start = par = modules[p->s->mod]->status(p->id,STATUS_ONLINE);
						/* the module returned a list of users to notify */
						while(par != NULL)
						{
							deliver_status(p->s->id,p->s->user,par->key,p->s->say,p->s->status,STATUS_ONLINE);
							par = par->next;
						}
						free_pair(par_start);
					}
				}
			}
			par = p->par;
			while(par != NULL)
			{
				if(modules[p->s->mod]->roster != NULL)
					par_start = modules[p->s->mod]->roster(par->flag,p->id,par->val,par->key);
				/* the module returned the roster */
				if(par_start != NULL)
				{
					deliver_roster(p->id,p->user,par_start);
					free_pair(par_start);
					par_start = NULL;
				}
				if(par->flag == ROSTER_ADD)
				{ /* you added someone to your roster, tell that person so that they may add you */
					deliver_message(p->id, NULL, par->key, NULL,"You were added to my Roster","You were just added to my Roster, please feel free to add me to yours.\n\nNote: This message was automatically generated by the server.",NULL,"invite",0);
					if(p->s->flag_status != STATUS_OFFLINE)
						deliver_status(p->s->id,p->s->user,par->key,p->s->say,p->s->status,STATUS_ONLINE);
				}
				par = par->next;
			}
			break;
		case PACK_MESSAGE:
			DBUG("Handling package ","PACK_MESSAGE")
			if(p->c->type != CONN_LOCAL)
			{
				if(p->s == NULL)
					p->s = session_lookup(p->c,p->id,NULL);
				if(p->s == NULL) /* should never happen, but... */
					break;
			}
			par = p->par;
			while(par != NULL)
			{
				deliver_message(p->id,p->user,par->val,par->key,p->subject,p->say,p->thread,p->ext,p->priority);
				par = par->next;
			}
			break;
		case PACK_LOGOUT:
			DBUG("Handling package ","PACK_LOGOUT")
			if(p->s == NULL)
				p->s = session_lookup(p->c,p->id,NULL);
			if(p->s == NULL) /* should never happen, but... */
				break;

			free(p->s->say);
			p->s->say = strdup("Going Offline");
			free(p->s->status);
			p->s->status = strdup("offline");
			p->s->priority = -10;
			p->s->flag_status = STATUS_OFFLINE;
			par_start = par = NULL;
			if(p->s->mod != MOD_NONE && modules[p->s->mod]->status != NULL)
				par_start = par = modules[p->s->mod]->status(p->id,STATUS_OFFLINE);
			/* the module returned a list of users to notify */
			while(par != NULL)
			{
				/* don't send to self even if on the list to notify */
				if(par->key != NULL && strcmp(par->key,p->id) != 0)
					deliver_status(p->id,p->user,par->key,p->s->say,p->s->status,STATUS_OFFLINE);
				par = par->next;
			}
			/* make sure we tell our other sessions if there are any */
			deliver_status(p->id,p->user,p->id,p->s->say,p->s->status,STATUS_OFFLINE);
			free_pair(par_start);
			session_del(p->s);
			p->s = NULL;
			break;
		default:
			DBUG("Handling package ","ERROR - Unknown Package")
			break;
	}
	if(p->s != NULL)
		time(p->s->activity);
}


void handle_connection(tag *t, package *p)
{
	DBUG("Processing Packet","connection")

	if(strcmp(t->name,"name") == 0) /* required only from a transport */
	{
		p->raw = tag_descape(t->contents);
	}
	if(strcmp(t->name,"ver") == 0)
	{
		p->version = tag_descape(t->contents);
	}
	if(strcmp(t->name,"protocol") == 0)
	{
		p->protocol = tag_descape(t->contents);
	}
}

void handle_login(tag *t, package *p)
{
	DBUG("Processing Packet","login")

	if(strcmp(t->name,"user") == 0)
	{
		p->id = tag_descape(t->contents);
	}
	if(strcmp(t->name,"pass") == 0)
	{
		p->pass = tag_descape(t->contents);
	}
	if(strcmp(t->name,"nick") == 0)
	{
		p->user = tag_descape(t->contents);
	}
}


void handle_message(tag *t, package *p)
{
	DBUG("Processing Packet","message")

	if(strcmp(t->name,"to") == 0)
	{
		p->par = pair_add(p->par,pair_getvalnew(t->attributes,"name"),tag_descape(t->contents));
	}
	if(strcmp(t->name,"thread") == 0)
	{
		p->thread = tag_descape(t->contents);
	}
	if(strcmp(t->name,"priority") == 0)
	{
		sscanf(t->contents,"%d",&(p->priority));
	}
	if(strcmp(t->name,"ext") == 0)
	{
		p->ext = strdup(t->contents);
	}
	if(strcmp(t->name,"subject") == 0)
	{
		p->subject = tag_descape(t->contents);
	}
	if(strcmp(t->name,"say") == 0)
	{
		p->say = tag_descape(t->contents);
	}
}



void handle_status(tag *t, package *p)
{
	char *str;

	DBUG("Processing Packet","status")

	if(strcmp(t->name,"say") == 0)
	{
		p->say = tag_descape(t->contents);
		str = pair_getval(t->attributes,"type");
		if(str != NULL)
		{
			if(strcmp(str,"online") == 0)
				p->flag_type = STATUS_ONLINE;
			if(strcmp(str,"offline") == 0)
				p->flag_type = STATUS_OFFLINE;
		}
	}
	if(strcmp(t->name,"priority") == 0)
	{
		sscanf(t->contents,"%d",&(p->priority));
	}
	if(strcmp(t->name,"status") == 0)
	{
		p->status = tag_descape(t->contents);
	}
	if(strcmp(t->name,"to") == 0)
	{
		p->raw = tag_descape(t->contents);
	}
}


void handle_roster(tag *t, package *p)
{
	DBUG("Processing Packet","roster")

	p->par = pair_add(p->par,tag_descape(t->contents),pair_getvalnew(t->attributes,"group"));
	if(strcmp(t->name,"add") == 0)
	{
		p->par->flag = ROSTER_ADD;
	}
	if(strcmp(t->name,"del") == 0)
	{
		p->par->flag = ROSTER_REMOVE;
	}
	if(strcmp(t->name,"get") == 0)
	{
		p->par->flag = ROSTER_GET;
		/* signal that it contains a get */
		p->flag_type = ROSTER_GET;
	}
}


void handle_config(tag *t, conn *c)
{
	pair *p;

	DBUG("Processing Packet","config!")
	p = pair_get(etc.vars, t->name);
	if(p == NULL || strcmp(t->name, "alias") == 0)
	{
		etc.vars = pair_new(etc.vars, t->name, t->contents, 0);
	}else{ /* if we're resetting the config data, replace the existing ones */
		free(p->val);
		p->val = strdup(t->contents);
	}
}

void handle_config_modules(tag *t, pair *p)
{
	DBUG("Processing Packet","config module")
	p->next = pair_new(p->next, t->name, t->contents, 0);
}

