#include "common.h"

pair *pair_add(pair *p, char *key, char *val)
{
	pair *p_new;

	p_new = malloc(sizeof(pair));
	p_new->val = val;
	p_new->key = key;
	p_new->next = NULL;

	if(p == NULL)
		return p_new;
	p_new->next = p;
	return p_new;
}

pair *pair_new(pair *p, char *key, char *val, int flag)
{
	pair *p_new;

	p_new = malloc(sizeof(pair));
	if(key == NULL)
		p_new->key = NULL;
	else
		p_new->key = strdup(key);
	if(val == NULL)
		p_new->val = NULL;
	else
		p_new->val = strdup(val);
	p_new->flag = flag;
	p_new->next = NULL;

	if(p == NULL)
		return p_new;
	p_new->next = p;
	return p_new;
}

void free_pair(pair *p)
{
	pair *next;

	next = p;

	while(next != NULL)
	{
		p = next;
		next = p->next;
		free(p->key);
		free(p->val);
		free(p);
	}
}

pair *pair_dup(pair *p)
{
	pair *new = NULL;

	while(p != NULL)
	{
		new = pair_add(new,NULL,NULL);
		if(p->key == NULL)
			new->key = p->key;
		else
			new->key = strdup(p->key);
		if(p->val == NULL)
			new->val = p->val;
		else
			new->val = strdup(p->val);
		new->flag = p->flag;
		p = p->next;
	}
	return new;
}

pair *pair_get(pair *p, char *key)
{
	while(p != NULL)
	{
		if(p->key != NULL && key != NULL && strcmp(p->key,key) == 0)
			return p;
		p = p->next;
	}
	return NULL;
}

char *pair_getval(pair *p, char *key)
{
	while(p != NULL)
	{
		if(p->key != NULL && key != NULL && strcmp(p->key,key) == 0)
			return p->val;
		p = p->next;
	}
	return NULL;
}

char *pair_getvalnew(pair *p, char *key)
{
	char *val;

	val = pair_getval(p, key);
	if(val != NULL)
		return strdup(val);
	return NULL;
}

int pair_getflag(pair *p, char *key)
{
	while(p != NULL)
	{
		if(p->key != NULL && key != NULL && strcmp(p->key,key) == 0)
			return p->flag;
		p = p->next;
	}
	return 0;
}

pair *arg2pair(int argc, char **argv)
{
	pair *ret = NULL;
	int i;
	int first = 0;

	for(i = 1; i < argc; i++)
	{
		if(*argv[i] == '-')
		{
			ret = pair_add(ret,strdup(argv[i]),NULL);
			first = 1;
		}else{
			if(first)
			{
				first = 0;
				ret->val = strdup(argv[i]);
			}else{
				ret = pair_add(ret,strdup(argv[i]),NULL);
			}
		}
	}
	return ret;
}



pair *str2pair(char *s)
{
	char *eq, *start, *end, *s_tmp;
	char *curr = s;
	pair *ret = NULL;

	while(curr != NULL && strlen(curr) >= 4)
	{
		while(curr[0] == ' ')
			curr++;

		eq = strstr(curr,"=");
		if(eq == NULL)
			break;
		start = strstr(curr,"'");
		if(start == NULL)
			break;
		end = strstr(++start,"'");
		if(end == NULL)
			break;

		s_tmp = subpstr(start,end);
		ret = pair_add(ret, subpstr(curr,eq), tag_descape(s_tmp));
		free(s_tmp);
		curr = end + 1;
	}

	return ret;
}


void pair_print(pair *p)
{
	printf("===PAIR===\n");
	while(p != NULL)
	{
		printf("%s[%s] ",p->key, p->val);
		p = p->next;
	}
	printf("===/PAIR===\n");
}
