#include "jabber.h"

package *package_init(int type)
{
	package *p;

	p = malloc(sizeof(package));
	p->par = NULL;
	p->type = type;
	p->version = NULL;
	p->protocol = NULL;
	p->id = NULL;
	p->pass = NULL;
	p->user = NULL;
	p->thread = NULL;
	p->subject = NULL;
	p->ext = NULL;
	p->say = NULL;
	p->status = NULL;
	p->priority = 0;
	p->flag_type = 0;
	p->flag_misc = 0;

	return p;
}

void free_package(package *p)
{
	free(p->version);
	free(p->protocol);
	free(p->id);
	free(p->pass);
	free(p->user);
	free(p->thread);
	free(p->subject);
	free(p->ext);
	free(p->say);
	free(p->status);
	free_pair(p->par);
	free(p);
}

char *strgrow(char *old, char *new, int old_free, int new_free)
{
	char *ret = old;
	int i,ol,nl,left;

	if(new == NULL)
	{
		new = strdup("(null)");
		new_free = 1;
	}

	nl = strlen(new) + 1;
	if(old != NULL)
	{
		ol = strlen(old);
	}else{
		ol = 0;
	}
	left = 100 - (ol % 100);
	if(left < nl || old == NULL)
	{
		i = (((ol + nl)/100)*100) + 100;
		ret = malloc(i);
		ret[0] = '\0';
		if(old != NULL)
			strcpy(ret,old);
		if(old_free)
			free(old);
	}

	strcat(ret,new);
	if(new_free)
		free(new);
	return ret;
}


