#include "jabber.h"

void handle_connection(tag *t, package *p)
{
	DBUG("Processing Packet","connection")

	if(strcmp(t->name,"ver") == 0)
	{
		p->version = tag_descape(t->contents);
	}
	if(strcmp(t->name,"protocol") == 0)
	{
		p->protocol = tag_descape(t->contents);
	}
}

void handle_message(tag *t, package *p)
{
	DBUG("Processing Packet","message")

	if(strcmp(t->name,"from") == 0)
	{
		p->id = tag_descape(t->contents);
		p->user = get_attribute(t->attributes,"name");
	}
	if(strcmp(t->name,"thread") == 0)
	{
		p->thread = tag_descape(t->contents);
	}
	if(strcmp(t->name,"priority") == 0)
	{
		sscanf(t->contents,"%d",&(p->priority));
	}
	if(strcmp(t->name,"ext") == 0)
	{
		p->ext = strdup(t->contents);
	}
	if(strcmp(t->name,"subject") == 0)
	{
		p->subject = tag_descape(t->contents);
	}
	if(strcmp(t->name,"say") == 0)
	{
		p->say = tag_descape(t->contents);
	}
}



void handle_status(tag *t, package *p)
{
	char *str;

	DBUG("Processing Packet","status")

	if(strcmp(t->name,"from") == 0)
	{
		p->id = tag_descape(t->contents);
		p->user = get_attribute(t->attributes,"name");
	}
	if(strcmp(t->name,"say") == 0)
	{
		p->say = tag_descape(t->contents);
		str = get_attribute(t->attributes,"type");
		if(str != NULL)
		{
			if(strcmp(str,"online") == 0)
				p->flag_type = STATUS_ONLINE;
			if(strcmp(str,"offline") == 0)
				p->flag_type = STATUS_OFFLINE;
		}
		free(str);
	}
	if(strcmp(t->name,"status") == 0)
	{
		p->status = tag_descape(t->contents);
	}
}


void handle_roster(tag *t, package *p)
{
	DBUG("Processing Packet","roster")

	p->par = pair_add(p->par,tag_descape(t->contents),get_attribute(t->attributes,"name"));
}



void handle_package(package *p)
{
	char *buff = NULL;
	char intbuff[20];
	pair *par;

	if(debug)
		package_print(p);

	switch(p->type)
	{
		case PACK_CONNECTION:
			DBUG("Handling package ","PACK_CONNECTION")
			buff = strgrow(NULL,"Connected.\n",0,0);
			if(p->c->name != NULL)
			{
				buff = strgrow(buff,"Server: ",1,0);
				buff = strgrow(buff,p->c->name,1,0);
				buff = strgrow(buff,"\n",1,0);
			}
			if(p->version != NULL)
			{
				buff = strgrow(buff,"Version: ",1,0);
				buff = strgrow(buff,p->version,1,0);
				buff = strgrow(buff,"\n",1,0);
			}
			if(p->protocol != NULL)
			{
				buff = strgrow(buff,"Protocol: ",1,0);
				buff = strgrow(buff,p->protocol,1,0);
				buff = strgrow(buff,"\n",1,0);
			}
			buff = strgrow(buff,"jabber>",1,0);
			cli->packets = packet_add(cli->packets,buff,NULL);
			free(buff);
			mode = MODE_NORMAL;
			break;
		case PACK_STATUS:
			DBUG("Handling package ","PACK_STATUS")
			break;
		case PACK_ROSTER:
			DBUG("Handling package ","PACK_ROSTER")
			par = p->par;
			buff = strgrow(NULL,"Current Roster:\n",0,0);
			while(par != NULL)
			{
				buff = strgrow(buff,"User: ",1,0);
				buff = strgrow(buff,par->key,1,0);
				buff = strgrow(buff,"\tGroup: ",1,0);
				buff = strgrow(buff,par->val,1,0);
				buff = strgrow(buff,"\n",1,0);
				par = par->next;
			}
			buff = strgrow(buff,"jabber>",1,0);
			cli->packets = packet_add(cli->packets,buff,NULL);
			free(buff);
			mode = MODE_NORMAL;
			break;
		case PACK_MESSAGE:
			DBUG("Handling package ","PACK_MESSAGE")
			sprintf(intbuff,"%d",p->priority);
			buff = strgrow(NULL,"\n===== Incoming Message =====\n",0,0);
			buff = strgrow(buff,"From: ",1,0);
			buff = strgrow(buff,p->user,1,0);
			buff = strgrow(buff," <",1,0);
			buff = strgrow(buff,p->id,1,0);
			buff = strgrow(buff,">\nThread: ",1,0);
			buff = strgrow(buff,p->thread,1,0);
			buff = strgrow(buff,"\nPriority: ",1,0);
			buff = strgrow(buff,intbuff,1,0);
			buff = strgrow(buff,"\nSubject: ",1,0);
			buff = strgrow(buff,p->subject,1,0);
			buff = strgrow(buff,"\n\n",1,0);
			buff = strgrow(buff,p->say,1,0);
			buff = strgrow(buff,"\n======= End  Message =======\njabber>",1,0);
			cli->packets = packet_add(cli->packets,buff,NULL);
			free(buff);
			break;
		default:
			DBUG("Handling package ","ERROR - Unknown Package")
			break;
	}
}


void handle_packet(tag *t, conn *c)
{
	char *type;
	tap tp;
	package *p;

	DBUG("Handling packet from ",c->name)

	type = get_attribute(t->attributes,"type");
	if(type == NULL) /* not a valid incoming packet */
	{
		return;
	}

	tp.h_char = NULL;
	tp.whitespace = 0;
	p = package_init(PACK_UNKNOWN);

	if(strcmp(type,"connection") == 0)
	{
		tp.h_tag = &handle_connection;
		p->type = PACK_CONNECTION;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"message") == 0)
	{
		tp.h_tag = &handle_message;
		p->type = PACK_MESSAGE;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"status") == 0)
	{
		tp.h_tag = &handle_status;
		p->type = PACK_STATUS;
		p->flag_type = STATUS_NORMAL;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"roster") == 0)
	{
		tp.h_tag = &handle_roster;
		p->type = PACK_ROSTER;
		tag_parse(&tp,t->contents,p);
	}

	handle_package(p);

	free_package(p);
	free(type);
}



