/* All outgoing commands */

Parse Upper Arg Win winname Us Verb Parm1 Parms
Parse Arg xWin xwinname xUs xVerb xParm1 xParms
Parse Arg ywin ywinname yUs yVerb nickname hostmask actions
Parse Arg zwin zwinname zus zVerb var1 var2 var3
Parse Arg awin awinname aus alltext
Parse Arg bwin bwinname bus bverb allvars

Pool = 'OS2ENVIRONMENT'

/* stuff='WIN '||win||' WINNAME '||winname||' US '||us||' VERB '||verb||' PARM1 '||parm1||' PARMS '||parms
ircrexxdisplay(stuff, 'win') */


/* Log all of my private outgoing messages */

msglog = value('logme',,Pool)
if (msglog = 'on') then do

tome=0
if Verb = "/MSG" then do
	tome = 1
	alltext = '#'subword(alltext, 2)
end
if left(winname, 1) \= "#" & winname \= "!" & left(verb, 1) \= '/' then do
	tome=1
	alltext = '#'winname' 'alltext
end

if tome then do
	n = Value('nummsgs',,Pool) + 1
	Value('nummsgs',n,Pool)
	message = Time()'] 'alltext
	Value('msgbuf.'n,message,Pool)

	
	if(n > value('buffer',,Pool)) then do
		roll=value('rollbuffer',,pool)
		if roll = 'on' then do
			do i = 1 to n
				nextmsg = value('msgbuf.'i+1,,Pool)
				value('msgbuf.'i,nextmsg,Pool)
			end
			value('nummsgs',n-1,Pool)
		end
		else do
			ircrexxdisplay(' ', win)
			ircrexxdisplay('YOUR MESSAGE BUFFER IS FULL', win)
			ircrexxdisplay('TYPE /set nummsgs 0 TO RESET', win)
			value('nummsgs',n-1,Pool)
		end
	end
return "OK"
end
end

/* Speed up Processing */
slash = left(verb, 1)
if slash \= '/' then return "OK"

/* pass something to the speech synthesizer */
if verb='/SAY' then do
	speechparm = value('speechparm',,pool)
	queuename="REXXSPEECH"
	rc = rxqueue('Set', queuename)
        queue speechparm' 'allvars
	return ''
end


/* display something (useful for multi command aliases) */
if verb = '/DISPLAY' then do
	if parm1 = '' then return ''
	ircrexxdisplay(allvars, win)
	return ''
end


/* Evaluate a REXX expression and display the result */
if (Verb = '/CALC') then do
	if allvars = '' then return ''
	ircrexxdisplay(' ', win)
	ircrexxdisplay(allvars' evaluates to:', win)
	interpret 'ircrexxdisplay('allvars', win)'
	return ''
end


/* Evaluate REXX commands */
if (Verb = '/CODE') then do
	if allvars = '' then return ''
	interpret allvars
	return ''
end
		
		


/* Add action item */
if (Verb = '/ADD') then do
	if (parm1 = '') then return ''
	joinactions=value('joinactions',,pool)
	do i = 1 to joinactions
		nick=value(nick.i,,pool)
		if nick=parm1 then do
			value(nick.i, parm1, pool)
			value(host.i, hostmask, pool)
			value(action.i, actions, pool)
			ircrexxdisplay('', win)
			ircrexxdisplay(''nickname' changed.', win)
			return ''
		end

	end

	i=joinactions+1
	value('joinactions', i, pool)
	value(nick.i, parm1, pool)
	value(host.i, hostmask, pool)
	value(action.i, actions, pool)
	ircrexxdisplay('', win)
	ircrexxdisplay(''parm1' added.', win)

return ''
end


/* Change actions on existing action item */
if (Verb = '/CHANGE') then do
	if (parm1 = '') then return ''
	joinactions=value('joinactions',,pool)
	do i = 1 to joinactions
		nick=value(nick.i,,pool)
		if nick=parm1 then do
			value(action.i, xparms, pool)
			ircrexxdisplay(' ', win)
			ircrexxdisplay(''parm1' changed.', win)
			return ''
		end
	end
ircrexxdisplay(' ', win)
ircrexxdisplay(''parm1' does not exist.', win)
return ''
end


/* Remove an action item */
if (Verb = '/REMOVE') then do 
	if (parm1 = '') then return ''
	joinactions=value('joinactions',,pool)
	next = joinactions + 1
	value(nick.next, '', pool)
	value(host.next, '', pool)
	value(action.next, '', pool)
	do i = 1 to joinactions
		nick=value(nick.i,,pool)
		if nick=parm1 then do
			do j = i + 1 to joinactions
				k = j-1
				nextnick = value(nick.j,,pool)
				nextaction = value(action.j,,pool)
				nextmask = value(host.j,,pool)
				value(nick.k, nextnick, pool)
				value(host.k, nextmask, pool)
				value(action.k, nextaction, pool)
			end
			joinactions = joinactions - 1
			value('joinactions', joinactions, pool)
			ircrexxdisplay(''parm1' removed.', win)
			return ''
		end
	end
ircrexxdisplay(' ', win)
ircrexxdisplay(''parm1' does not exist.', win)
return ''
end
	
	


/* List Joinactions */
if (Verb = '/JOINLIST') then do
	joins = value(joinactions,,Pool)
	ircrexxdisplay(' ', win)
	ircrexxdisplay('Join Action List', win)
	ircrexxdisplay('-----------------', win)
	do i = 1 to joins
		output = value(nick.i,,pool)' 'value(host.i,,pool)' 'value(action.i,,Pool)
		ircrexxdisplay(output, win)
	end
return ''
end



/* Set Alias */
if (Verb = '/ALIAS') then do
	aliascount=value(aliases,,Pool)
	if parm1 = '' then do
		ircrexxdisplay(' ', win)
		ircrexxdisplay('Current Alias List:', win)
		ircrexxdisplay('-------------------', win)
		do i=1 to aliascount
			alias = value(alias.i,,Pool)
			command = value(command.i,,Pool)
			ircrexxdisplay(alias' = 'command, win)
		end
	return ''
	end

	do i=1 to aliascount
		alias = value(alias.i,,Pool)
		if alias = parm1 then do
			value(alias.i, parm1, Pool)
			value(command.i, xparms, Pool)
			ircrexxdisplay('Alias for 'xparms' set to 'parm1, win)
			return ''
		end
	end


	Aliascount = Aliascount + 1
	value(aliases, aliascount, Pool)
	value(alias.aliascount, parm1, Pool)
	value(command.aliascount, xparms, Pool)
	ircrexxdisplay('Alias for 'xparms' set to 'parm1, win) 
	return ''
end



/* Remove an Alias */
if (Verb = '/REMOVEALIAS') then do 
	if (parm1 = '') then return ''
	aliascount=value('aliases',,pool)
	next = aliascount+1
	value(alias.next,'',pool)
	value(command.next,'',pool)
	do i=1 to aliascount
		alias = value(alias.i,,Pool)
		if alias = parm1 then do
			do j=i+1 to aliascount
				k = j-1
				nextalias = value(alias.j,,pool)
				nextcommand = value(command.j,,pool)
				value(alias.k, nextalias, Pool)
				value(command.k, nextcommand, Pool)
			end
			ircrexxdisplay(''parm1' removed.', win)
			aliascount = aliascount - 1
			value('aliases', aliascount, Pool)
			return ''
		end
	end
	
	ircrexxdisplay(' ', win)
	ircrexxdisplay(''parm1' does not exist.', win)
	return ''
end




/* Poll for aliases for any command */
aliases=value(aliases,,Pool)
if (aliases > 0) then do
	do i=1 to aliases
		alias=value(alias.i,,Pool)
		if Verb = alias then do
			command=value(command.i,,Pool)
			lines = 1
			output.lines=''
			do j = 1 to words(command)
				piece = subword(command, j, 1)
				nextpiece = subword(command, j+1, 1)
				if piece = '$0' then piece = allvars
				if piece = '$$0' then piece = '$0'
				if piece = '$1' then piece = var1
				if piece = '$2' then piece = var2
				if piece = '$3' then piece = var3
				if piece = '$me' then piece = xUs
				if piece = '$$me' then piece = '$me'
				if piece = '$ch' then piece = xwinname
				if piece = '$$ch' then piece = '$ch'
				if piece = '+' then do
					lines=lines + 1
					piece=''
					output.lines=''
				end
				if bsflag = 1 then bsflag = 0
				if piece = '<<' then do 
					bsflag = 1
					j = j + 1
				end
				if piece = '<<<' then piece = '<<'
				if bsflag=1 then output.lines = output.lines||nextpiece
					else output.lines = output.lines||' '||piece
			end
			
			do j=1 to lines
				l = length(output.j)
				if j = 1 then
					output.j = right(output.j, l-1)
				else output.j = right(output.j, l-2)
				ircrexxcommand(output.j, win)
			end
			return ''
		end
	end
end
	

/* Add Search Phrases */
if (Verb = '/PHRASE') then do
	parse var allvars parm1', 'xparms
	parm1 = translate(parm1)
	phrases=value(phrases,,Pool)
	if parm1 = '' then do
		ircrexxdisplay(' ', win)
		ircrexxdisplay('Current Phrase List:', win)
		ircrexxdisplay('-------------------', win)
		do i=1 to phrases
			phrase = value(phrase.i,,Pool)
			phraction = value(phraction.i,,Pool)
			ircrexxdisplay(phrase' = 'phraction, win)
		end
	return ''
	end

	do i=1 to phrases
		phrase = value(phrase.i,,Pool)
		if phrase = parm1 then do
			value(phrase.i, parm1, Pool)
			value(phraction.i, xparms, Pool)
			ircrexxdisplay(''parm1' trigger changed to 'xparms, win)
			return ''
		end
	end


	phrases = phrases + 1
	value('phrases', phrases, Pool)
	value(phrase.phrases, parm1, Pool)
	value(phraction.phrases, xparms, Pool)
	ircrexxdisplay(''parm1' trigger set to 'xparms, win) 
	return ''
end
	

/* Remove a Phrase */
if (Verb = '/REMOVEPHRASE') then do 
	if (parm1 = '') then return ''
	parm1 = translate(allvars)
	phrases=value('phrases',,pool)
	next = phrases+1
	value(phrase.next,'',pool)
	value(phraction.next,'',pool)
	do i=1 to phrases
		phrase = value(phrase.i,,Pool)
		if phrase = parm1 then do
			do j=i+1 to phrases
				k = j-1
				nextphrase = value(phrase.j,,pool)
				nextphraction = value(phraction.j,,pool)
				value(phrase.k, nextphrase, Pool)
				value(phraction.k, nextphraction, Pool)
			end
			ircrexxdisplay(''parm1' removed.', win)
			phrases = phrases - 1
			value('phrases', phrases, Pool)
			return ''
		end
	end
	
	ircrexxdisplay(' ', win)
	ircrexxdisplay(''parm1' does not exist.', win)
	return ''
end

/* Toggle on|off variables */
if (Verb = '/TOGGLE') then do
	if parm1 = '' then return ''
	current = value(parm1,,pool)
	if current = 'on' then ircrexxcommand('/set '||parm1||' off', win)
		else ircrexxcommand('/set '||parm1||' on', win)
	return ''
end

/* Set or View the current Environment */
if (Verb = '/SET') then do
 	if (Parm1 \= '') then do
		if (Parms <> '') then do
			VALUE(xParm1,xParms,Pool)
			ircrexxdisplay(Parm1 'Set to: ' || xParms, win)
			Return ''
		end
		else do
			TempStr = Value(Parm1,,Pool)
			IrcRexxDisplay(Parm1 '= ' || TempStr, win)
			Return ''
		end
	end
	else do
		ircrexxdisplay(' ', win)
		ircrexxdisplay('CURRENT ENVIRONMENT:', win)
		ircrexxdisplay('--------------------', win)
		configfile = value('configfile',,pool)
		buffer = value('buffer',,pool)
		rollbuffer = value('rollbuffer',, pool)
		msglog = value('log',,pool)
		msgs = value('nummsgs',,pool)
		logme = value('logme',,pool)
		Aliases = value('aliases',,pool)
		joinactions = value('joinactions',,Pool)
		greet = value('greet',,Pool)
		greetmsg = value('greetmsg',,pool)
		autorun = value('autorun',,pool)
		join = value('join',,pool)
		greetscr = value('greetscr',,pool)
		onjoin = value('onjoin',,pool)
		onleave = value('onleave',,pool)
		kickmirc = value('kickmirc',,pool)
		onphrase = value('onphrase',,pool)
		phrases = value('phrases',,pool)
		noidle = value('noidle',,pool)
		idlespeed = value('idlespeed',,pool)
		idlemsg = value('idlemsg',,pool)
		speechjoin = value('speechjoin',,pool)
		speechleave = value('speechleave',,pool)
		speechtext = value('speechtext',,pool)
		ircrexxdisplay('configfile:   '||configfile, win)
		ircrexxdisplay('autorun:      '||autorun, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('buffer:       '||buffer, win)
		ircrexxdisplay('rollbuffer:   '||rollbuffer, win)
		ircrexxdisplay('log:          '||msglog, win)
		ircrexxdisplay('logme:        '||logme, win)
		ircrexxdisplay('nummsgs:      '||msgs, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('noidle:       '||noidle, win)
		ircrexxdisplay('idlespeed:    '||idlespeed, win)
		ircrexxdisplay('idlemsg:      '||idlemsg, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('join:         '||join, win)
		ircrexxdisplay('greet:        '||greet, win)
		ircrexxdisplay('greetscr:     '||greetscr, win)
		ircrexxdisplay('kickmirc:     '||kickmirc, win)
		ircrexxdisplay('onphrase:     '||onphrase, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('speechjoin    '||speechjoin, win)
		ircrexxdisplay('speechleave   '||speechleave, win)
		ircrexxdisplay('speechtext    '||speechtext, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('onjoin:       '||onjoin, win)
		ircrexxdisplay('onleave:      '||onleave, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('joinactions:  '||joinactions, win)
		ircrexxdisplay('aliases:      '||aliases, win)
		ircrexxdisplay('phrases:      '||phrases, win)
		ircrexxdisplay('========================', win)
		ircrexxdisplay('greetmsg:     '||greetmsg, win)
		ircrexxdisplay(' ', win)
		return ''
	end

end


/* Reset an item in the current environment */
if (Verb = '/RESET') then do
	if parm1 = '' then return ''
	value(parm1,'',pool)
	ircrexxdisplay(' ', win)
	ircrexxdisplay(''||parm1||' Has been reset.', win)
	return ''
end
	

/* View the Message Queue */
if (Verb = '/LAST') then do
	msglog = value('log',,Pool)
	msgnum = value('nummsgs',,Pool)

	ircrexxdisplay(" ",win)
	if (msglog \= 'on') then ircrexxdisplay("Message Log DISABLED", Win)	

	if (msgnum = 0) then do 
		ircrexxdisplay("No new Messages",win)
		Return ""
	end

		
	if (Parm1 = "" | Parm1 > msgnum) then msgdisp = msgnum
            else msgdisp = Parm1
	ircrexxdisplay('Displaying last' msgdisp 'Messages to you:',win)

	do i = msgnum - msgdisp + 1 to msgnum
		text = i':  'value('msgbuf.'i,,Pool)
		ircrexxdisplay(text, win)
	end
	Return ""
end


/* Save the message Buffer */

if (Verb = '/SAVEMSGS') then do
	msglog = value('msglog',,Pool)
	msgnum = value('nummsgs',,Pool)
	if (msgnum = 0) then do 
		ircrexxdisplay("No Messages to be saved.",win)
		Return ""
	end
	else do
		if (Parm1 <> '') then do
			ircrexxdisplay('Writing msgs to log file:' Parm1,win)
			LineOut(Parm1, titlline, 1)
			do i = 1 to msgnum
				text = i || ': ' value('msgbuf.'i,,Pool)
				LineOut(Parm1, text)
			end
			LineOut(Parm1)
			IrcRexxDisplay(Parm1 "written.",Win)
			Return ""
		end
		else do
			Parm1 = "msgsave.txt"
			ircrexxdisplay('Writing msgs to log file: msgssave.txt',win)
			LineOut(Parm1, titlline, 1)
			do i = 1 to msgnum
				text = i || ': ' value('msgbuf.'i,,Pool)
				LineOut(Parm1, text)
			end
			LineOut(Parm1)
			IrcRexxDisplay(Parm1 "written.",Win)
			Return ""
		end
	end
end

/* Show output of External OS/2 text program in current window */
if (Verb = '/EXEC') then do
	CMD = "C:\OS2\CMD.EXE"
	if (Parm1 <> '') then do
		ADDRESS CMD xParm1 xParms '| rxqueue'
		nr = queued()
		do i=1 to nr
			Parse pull line
			if line <> ' ' Then IrcRexxDisplay(line,Win)
		end
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide a command and any appropriate",Win)
		IrcRexxDisplay(ErStr2 "parameters that you wish to run.",Win)
	end
	Return ""
end


/* Pipe output of External OS/2 text program to current channel or query */
if (Verb = '/PIPE') then do
	CMD = "C:\OS2\CMD.EXE"
	if (Parm1 <> '') then do
		ADDRESS CMD xParm1 xParms '| rxqueue'
		nr = queued()
		do i=1 to nr
			Parse pull line
			if line <> ' ' Then IrcRexxCommand(line, Win)
		end
	end
	else do
		IrcRexxDisplay(ErStr1 "You must provide a command and any appropriate",Win)
		IrcRexxDisplay(ErStr2 "parameters that you wish to run.",Win)
	end
	Return ""
end


/* Start an OS/2 Program */
if (Verb = '/START') then do
	CMD = "C:\OS2\CMD.EXE"
	address CMD 'start /n ' allvars 
	ircrexxdisplay(' ', win)
	ircrexxdisplay('Command Routed to Shell', win)
	return ''
end


/* Save the Current Environment */
if (Verb = '/SAVE') then do
	configfile=value('configfile',,pool)
	aliases=value('aliases',,pool)
	joinactions=value('joinactions',,pool)
	buffer=value('buffer',,pool)
	rollbuffer=value('rollbuffer',,pool)
	log=value('log',,pool)
	logme=value('logme',,pool)
	greet=value('greet',,pool)
	greetmsg=value('greetmsg',,pool)
	autorun=value('autorun',,pool)
	greetscr=value('greetscr',,pool)
	join=value('join',,pool)
	onjoin=value('onjoin',,pool)
	onleave=value('onleave',,pool)
	kickmirc=value('kickmirc',,pool)
	onphrase=value('onphrase',,pool)
	phrases=value('phrases',,pool)
	idlemsg=value('idlemsg',,pool)
	noidle=value('noidle',,pool)
	idlespeed=value('idlespeed',,pool)
	speechjoin=value('speechjoin',,pool)
	speechleave=value('speechleave',,pool)
	speechtext=value('speechtext',,pool)


	ircrexxcommand('/exec erase '||configfile, win)
	
	lineout(configfile,,1)
	lineout(configfile,"/library")
	lineout(configfile,"/set configfile "||configfile)
	lineout(configfile,"/set autorun "||autorun)
	lineout(configfile,"/set nummsgs 0")
	lineout(configfile,"/set aliases 0")
	lineout(configfile,"/set joinactions 0")
	lineout(configfile,"/set phrases 0")
	lineout(configfile,"/set idlecount 0")
	lineout(configfile,"/set buffer "||buffer)
	lineout(configfile,"/set rollbuffer "||rollbuffer)
	lineout(configfile,"/set log "||log)
	lineout(configfile,"/set logme "||logme)
	lineout(configfile,"/set greetmsg "||greetmsg)
	lineout(configfile,"/set idlemsg "||idlemsg)
	lineout(configfile,"/set greet "||greet)
	lineout(configfile,"/set greetscr "||greetscr)
	lineout(configfile,"/set join "||join)
	lineout(configfile,"/set onjoin "||onjoin)
	lineout(configfile,"/set onleave "||onleave)
	lineout(configfile,"/set kickmirc "||kickmirc)
	lineout(configfile,"/set onphrase "||onphrase)
	lineout(configfile,"/set noidle "||noidle)
	lineout(configfile,"/set idlespeed "||idlespeed)
	lineout(configfile,"/set speechjoin "||speechjoin)
	lineout(configfile,"/set speechleave "||speechleave)
	lineout(configfile,"/set speechtext "||speechtext)	

	do i = 1 to aliases
		alias = value(alias.i,,pool)
		command = value(command.i,,pool)
		lineout(configfile,"/alias "||alias||" "||command)

	end
	IrcRexxDisplay('Aliases written', win)

	do i = 1 to phrases
		phrase = value(phrase.i,,pool)
		phraction = value(phraction.i,,pool)
		lineout(configfile, "/phrase "||phrase||", "||phraction)
	end
	ircrexxdisplay('Search Phrases Written', win)

	lineout(configfile, "/run "||autorun)
	IrcRexxDisplay('Autorun written', win)
	
	do i = 1 to joinactions
		nick = value(nick.i,,pool)
		host = value(host.i,,pool)
		action = value(action.i,,pool)
		lineout(configfile,"/add "||nick||" "||host||" "||action)
	end	
 	ircrexxdisplay('Join Actions Written', win)
	
	lineout(configfile)

	IrcRexxDisplay('Environment Saved to '||configfile,Win)
	Return ""
end

/* Re-Initialize the Environment */
if Verb='/INIT' then do
	configfile=value('configfile',,pool)
	ircrexxcommand("/run "||configfile, win)
end


/* Load the REXX library */
if Verb='/LIBRARY' then do
	call rxfuncadd 'rexxlibregister', 'rexxlib', 'rexxlibregister'
	call rexxlibregister
	ircrexxdisplay('REXX External Library Registered', win)

	return ""
end


/* Everything Else */
Return "OK"