#include <QtGui>
#include "mainwindow.h"
#include <QTime>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);


    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());

    // Translations
    const QString locale = QLocale::system().name();

    // Qt translations
    QTranslator qtTranslator;
    qtTranslator.load("qt_" + locale,
                    QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    a.installTranslator(&qtTranslator);

    // Program translations
    #if defined(Q_OS_OS2) || defined(Q_OS_WIN)
      QString localeDir = qApp->applicationDirPath() + QDir::separator() + "translations";
    #else
      QString localeDir = '/usr/share/easypaint' + QDir::separator() + "translations";
    #endif
    QTranslator translator;
    translator.load("easypaint_" + locale, localeDir);
    a.installTranslator(&translator);

    MainWindow w;
    w.show();

    return a.exec();
}
