#include "CImageModel.h"

#include <QtGui/QImage>
#include <QtGui/QBrush>
#include <QtGui/QPen>
#include <QtGui/QPainter>

/*!
 \brief конструктор новой модели

 \param width_ ширина модели
 \param height_ высота модели
*/
CImageModel::CImageModel(int width_, int height_)
{
    image = new QImage(width_, height_, QImage::Format_ARGB32_Premultiplied);
    QBrush *brush = new QBrush(Qt::white, Qt::SolidPattern);
    QPen *pen = new QPen;
    pen->setWidth(1);
    pen->setColor(Qt::white);
    QPainter *painter = new QPainter(image);
    painter->setBrush(*brush);
    painter->setPen(*pen);
    painter->drawRect(0, 0, width_, height_);
    painter->end();
    delete painter;
    delete pen;
    delete brush;
    filePath.clear();
}

CImageModel::~CImageModel()
{
    delete image;
}

/*!
 \brief метод реализуюший загрузку изображения из файла

 \param fileName имя файла
 \return bool флаг для обозначения удачной\неудачной загрузки
*/
bool CImageModel::loadImage(const QString &fileName)
{
    return image->load(fileName);
}

/*!
 \brief метод реализующий сохранение изображения в файл

 \param fileName имя файла
*/
void CImageModel::saveImage(const QString &fileName)
{
    image->save(fileName);
}

/*!
 \brief метод для получения указателя на изображения

 \return QImage* возвращаемое изображение
*/
QImage *CImageModel::getImage()
{
    return image;
}

/*!
 \brief метод для установки изображения

 \param tempImage изображения для установки
*/
void CImageModel::setImage(const QImage &tempImage)
{
    *image = tempImage;
}
