/*
** WORKLab System Solutions
** installation & setup of LOGOART
** usage:   install [<target_directory>] or
**          install 
**
** RIP-Version, 1997
*/

target_dir     = "LOGOART"
version        = "Version 1.12"
version_short  = "V1.12"
bin_pack       = "ARTV11.ZIP"
clip_pack      = "CLIPART.ZIP"
bitmap_pack    = "BITMAP.ZIP"
kvec_pack      = "KVEC191.ZIP"
workshop_pack  = "WORKSHOP.ZIP"

hyellow  ='[1;33m[1A'
hwhite   ='[1;37m[1A'
nline    = "0D0A"x                                        /* new line */

/*----------------------------------------------------------------------*/
/* start of code                                                        */
/*----------------------------------------------------------------------*/

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

say nline hyellow
say "---------- LOGOART SETUP AND INSTALLATION ("||version||") ----------"nline
parse arg target
say hwhite
call notes

/*----------------------------------------------------------------------*/
/* resolve source and target                                            */
/*----------------------------------------------------------------------*/
source = directory();

if target= "" then target = "C:\"||target_dir;
if target="." then target = directory();

/* get target drive */
call GetTargetDrive source target


/*----------------------------------------------------------------------*/
/* create target directory and copy files                               */
/*----------------------------------------------------------------------*/

/* check target has enough space */
"@echo off"
result=0
do while result==0
   call DriveIsBigEnough SysDriveInfo(left(target,2))
   if result == 0 then do
      say "!!Enter full directory path:"
      target=""
      do while stream(target, 'c', 'query exists')==""
         pull target
      end
   end
end

/* create directory if needed */
if target \= source then do
   rc = SysMkDir(target);
   if rc > 0 & rc \=5 then do
      say "could not create" target;
      call abort;
   end  /* Do */

   if rc = 5 then do
      say target "already exists. Overwrite files ? (Y/N)";
      pull cont;
      if cont \= 'Y' then call abort;
   end /* do */

   say "copying files ..";
   "copy " source||"\*" target;
end
source=source||"\"

/* make directory for cliparts */
call directory target 
rc = SysMkDir("CLIPART");
rc = SysMkDir("BITMAP");
rc = SysMkDir("KVEC");
rc = SysMkDir("WORKSHOP");

"move" clip_pack "clipart"
"move" bitmap_pack "bitmap"
"move" kvec_pack "kvec"
"move" workshop_pack "workshop"
"@echo on"

say "unzip in progress..";
/* BIN */
"unzip -o" bin_pack
"del" bin_pack
/* CLIPART */
call directory target||"\clipart" 
"..\unzip -o" clip_pack
"del" clip_pack
/* BITMAP */
call directory target||"\bitmap" 
"..\unzip -o" bitmap_pack
"del" bitmap_pack
call directory target||"\kvec" 
"..\unzip -o" kvec_pack
"del" kvec_pack
call directory target||"\workshop" 
"..\unzip -o" workshop_pack
"del" workshop_pack

call directory target 

/* parse config.sys and update LIBPATH and LOGOART_HOME */
say "update config.sys .."
call parser target

/* make WPS objects */
call makefldr version_short

/*----------------------------------------------------------------------*/
/* create program objects on WPS-Desktop                                 */
/*----------------------------------------------------------------------*/
say nline "Your config.sys has been updated (old under config.sav)"
say       "Please reboot your computer to activate changes." nline

say hyellow
say "*** LOGOART installation ended. ***";
say hwhite
exit;

/*----------------------------------------------------------------------*/
/* DriveIsBigEnough                                                    */
/*----------------------------------------------------------------------*/
DriveIsBigEnough:
parse arg drive free total name
if free < 5000000 then do
   Beep(500,100);
   say "ERROR--------"
   say drive "has not enough space for installing LogoArt."
   say""
   return 0;
end
return 1;

/*----------------------------------------------------------------------*/
/* DriveFreeSpace                                                      */
/*----------------------------------------------------------------------*/
DriveFreeSpace:
parse arg drive free total name
if datatype(free, 'w') \= 1 then return 0;
say "---> [" ||drive||"] " trunc(free/1000000,1) "MB free space"
return 0;

/*----------------------------------------------------------------------*/
/* GetTargetDrive                                                      */
/*----------------------------------------------------------------------*/
GetTargetDrive:
parse arg source target
do forever
   /* list of all drives and their sizes */
   say nline "Drive:      Free-Space (5 MB needed)"
   say "==================================="
   list = SysDriveMap('C:');
   do i=1 to words(list)
      call DriveFreeSpace SysDriveInfo(word(list,i))  
   end

   say nline "Installing from ["||source ||"] to ["||target||"]."
   say "Target will be created if needed. Continue ? (Y/N/Q-Quit)";
   pull cont
   if cont = 'Y' | cont = 'y' then leave
   if cont = 'Q' | cont = 'q' then call abort

   result=0
   do while result==0
      say "Enter full directory path:"
      pull target
      /*if stream(target, 'c', 'query exists')= "" then iterate*/
      if filespec("drive", target)= "" then do
         Beep(500,100);
         say "ERROR--------"
         iterate
      end
      call DriveIsBigEnough SysDriveInfo(left(target,2))
   end

end
return

notes:
n.1="The installation procedure does the following :"
n.2=" 1) copies all source files from the *current* directory to the"
n.3="    indicated target-directory (def: C:\LOGOART)"
n.4=" 2) generates the target-directory if not already there (if"
n.5="    already there files with same names will be replaced..)"
n.6=" 3) creates WPS folder and objects for sample art-files and"
n.7="    executables."
n.8=""
n.9=" NOTE:  If you have installed a beta/previous version of this"
n.10="       product, it is recommended to delete those files first."
n.11=""
n.12=""
n.13="       MAKE SURE UNZIP.EXE IS ON THE SYSTEM PATH. IF NECESSARY"
n.14="       DOWNLOAD IT FROM THE SAME PLACE YOU GOT THIS FILE."
n.15=""
n.16="       YOU NEED 4MB FREE SPACE FOR INSTALLING LOGOART."
n.17=""
n.18="       This is a specially enabled Version for distribution"
n.19="       thru the Internet (RIP System). As such, the install"
n.20="       overhead has been reduced to a minimum."
n.21="               --------------------------------"
n.22="Press enter to continue"

n1.0=""
n1.1="By proceeding with the installation of this product you agree"
n1.2="with the license terms as stated in the attached readme-file."
n1.3="If you dont agree or you have not read the terms then Cancel"
n1.4="now."
n1.5=""
n1.6="You may want to read the README-file before proceeding."
n1.7=""

do i=1 to 22
   say n.i;
end 
pull

do i=0 to 7
   say n1.i;
end 
say "I agree(Y/N)";
pull cont
if cont \= 'Y' & cont \= 'y' then call abort;
say "               --------------------------------" nline

return;

/*----------------------------------------------------------------------*/
/* abort                                                                */
/*----------------------------------------------------------------------*/
abort:
say hyellow
say "*** LOGOART installation aborted. ***"
say hwhite

/*----------------------------------------------------------------------*/
/* usage                                                                */
/*----------------------------------------------------------------------*/
usage:
u.0 = ""
u.1 = "usage:  install [<full target_path>]";
u.2 = "        ex. install e:/logoart";
u.3 = "";

do i=0 to 3
   say u.i;
end /* do */


exit;

