/* i-Merge.CMD */

SAY
SAY 'i-Merge merges two 24-bit TGA files with an identical file size and with'
SAY 'identical header. The TGA files have to be as simple as possible. No RLE'
SAY 'and no interlacing, and no mirroring nor flipping. If there is an error,'
SAY 'then i-Merge.CMD will not print any error message.'
SAY
SAY 'Usage:'
SAY
SAY '   i-Merge.CMD <input_file_1> <input_file_2> <output_file> <color>'
SAY
SAY 'Example:'
SAY
SAY '   I-MERGE.CMD BLACKWHITE.TGA OVERLAY.TGA NEW_IMG.TGA FFFFFF'
SAY
SAY 'If the RGB color FFFFFF (always 6 characters, color white in this case)'
SAY 'is found in the 24-bit input file BLACKWHITE.TGA, then the white pixels' 
SAY 'of BLACKWHITE.TGA will be replaced by the matching pixel of OVERLAY.TGA'
SAY 'and the output will be saved to the new file NEW_IMG.TGA'

PARSE ARG in1 arg1
IF Left(in1,1)='"' THEN PARSE ARG '"' in1 '"' arg1
arg1=Strip(arg1)
PARSE VAR arg1 in2 arg2
IF Left(in2,1)='"' THEN PARSE VAR arg1 '"' in2 '"' arg2
arg2=Strip(arg2)
PARSE VAR arg2 out arg1
IF Left(out,1)='"' THEN PARSE VAR arg2 '"' out '"' arg1
arg1=Strip(arg1)
PARSE VAR arg1 rgb . 
IF Left(rgb,1)='"' THEN PARSE VAR arg1 '"' rgb '"' .
rgb1=Strip(rgb)
IF in1='' THEN EXIT
IF in2='' THEN EXIT
IF out='' THEN EXIT
IF rgb='' THEN EXIT
IF Stream(in1,'C','QUERY EXISTS')='' THEN EXIT
IF Stream(in2,'C','QUERY EXISTS')='' THEN EXIT
IF Stream(out,'C','QUERY EXISTS')<>'' THEN EXIT
IF Stream(in1,'C','QUERY SIZE')<>Stream(in2,'C','QUERY SIZE') THEN EXIT
IF Length(rgb)<>6 THEN EXIT
IF DataType(rgb,'X')=0 THEN EXIT
header1=CharIn(in1,1,18)
header2=CharIn(in2,1,18)
IF header1<>header2 | Length(header1)<>18 THEN DO
   CALL CharOut in1
   CALL CharOut in2
   EXIT
END
PARSE VAR rgb 1 rgb1 3 rgb2 5 rgb3 7 .
rgb=X2C(rgb3)||X2C(rgb2)||X2C(rgb1)
CALL CharOut out,header1
DO WHILE Chars(in1)>0
   pixel1=CharIn(in1,,3)
   pixel2=CharIn(in2,,3)
   IF pixel1==rgb THEN pixel1=pixel2
   CALL CharOut out,pixel1
END
CALL CharOut in1
CALL CharOut in2
CALL CharOut out
SAY
SAY 'File "'||out||'" created.'

EXIT
