
#include <alch.h>

class TObject {
  virtual ~TObject() {}
  virtual void Idle() {}
};

#define LIST_ALLOC_LENGTH 32

class List {

  TObject **Items;
  int       Alloced;
  int       Count;

  List() {
    Items   = NULL;
    Alloced = 0;
    Count   = 0;
  }

  void alloc_new( int len ) {
    if ( Alloced > len ) return;
    while ( Alloced <= len ) Alloced += LIST_ALLOC_LENGTH;
    if ( Items == NULL ) Items = (TObject**)malloc(Alloced*4);
                    else Items = (TObject**)realloc(Items,Alloced*4);
  }

  void Clear() {
    for( int i=0; i<Count; i++ ) delete Items[i];
    free(Items);
    Items   = NULL;
    Alloced = 0;
    Count   = 0;
  }

  ~List() {
    Clear();
  }

  int Add( TObject *Object ) {
    alloc_new(Count+1);
    Items[Count] = Object;
    return Count++;
  }

  TObject *operator[]( int pos ) {
    return Items[pos];
  }
};
