/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Renames a frame list created by MainActor to a specific   *
 *  file name format.                                         *
 *                                                            *
 *  Last modified: 09/06/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  SetInfoText("Renaming frames ...")

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  sourcebase="e:\tmp\test" /* Source is of the format: "e:\tmp\testXXXX.tga */
  destbase="e:\test"     
  format="tga"             /* This example renames to "e:\test.XXX */
  numberofframes=40        /* Convert 40 frames */

                           /* It should be fairly easy to change this to */
                           /* any special format */  

  i=1
  DO WHILE i <= numberofframes
    oldname=sourcebase || Right( "0000" || i, 4) || "." || format
    newname=destbase || "." || Right( "000" || i, 3)
                           /* If you need more than three digits, use */
                           /* for example Right( "0000" || i, 4) which */
                           /* converts to c:\test.XXXX */
    say "Renaming:" oldname "to" newname
    'copy' newname oldname '1>NULL 2>NULL'
    i=i+1
  END