/* REXX   ---------------------------------------------------------
 * AutoFTP.cmd :
 *------------------------------------------------------------------
 * 03-16-93 originally by Patrick J. Mueller & Cliff Nadler
 * 03-16-96 Modified by Jason I. Glithero
 *------------------------------------------------------------------*/

trace off

/*------------------------------------------------------------------
 * load functions, if needed
 *------------------------------------------------------------------*/
if RxFuncQuery("FtpLoadFuncs") then
   do
   rc = RxFuncAdd("FtpLoadFuncs","RxFtp","FtpLoadFuncs")
   rc = FtpLoadFuncs()
   end

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

/*------------------------------------------------------------------
 * set up signal
 *------------------------------------------------------------------*/
signal on halt

parse value SysTextScreenSize() with rows cols

/*------------------------------------------------------------------
 * get parameters
 *------------------------------------------------------------------*/
parse arg host user pass .

/*------------------------------------------------------------------
 * set things
 *------------------------------------------------------------------*/

InfoFile = "Info.txt"

host = LINEIN(InfoFile)    /* Gets the first line of info.txt */
user = LINEIN(InfoFile)
pass = LINEIN(InfoFile)
hostdir = LINEIN(InfoFile)

rc = FtpSetUser(host,user,pass)
err = FtpChDir(hostdir)

   if (host <> "") then
      status = "connected to" user"@"host
   else
      status = "not connected to a host"

   junk = FtpPwd('dir')
   if (junk <> 0) then
      dir = "not specified"

   say d2c(218) || copies(d2c(196),70)
   say d2c(179) || " AutoFtp:" time() status
   say d2c(179) || " directory:" dir
   say d2c(192) || copies(d2c(196),70)

   /*---------------------------------------------------------------
    * Download command
    *---------------------------------------------------------------*/
   
   DownLoadFile = "FileList.txt"
   GetFile = LINEIN(DownLoadFile)
   
   do while  GetFile <> ""
     say 'Downloading . . . . . ' GetFile 
     rc = FtpGet("e:\tmp\"GetFile ,GetFile ,"BINARY")
     GetFile = LINEIN(DownLoadFile)
   end /* do */

   rc = FtpLogoff()
   host = ""
   user = ""
   pass = ""

/*------------------------------------------------------------------
 * quit
 *------------------------------------------------------------------*/
done:
rc = FtpSetUser("X","X","X")
rc = FtpLogoff()
exit

/*------------------------------------------------------------------
 * break condition
 *------------------------------------------------------------------*/
halt:
   say "Terminating ..."
   signal done

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure

   say "usage:"
   say "   command ..."
   say "is used to run ftp commands on a remote host"
   say
   say "where:"
   say "   command can be one of:"
   say "       connect host user password"
   say "       close"
   say "       site site-command"
   say "       dir pattern"
   say "       ls  pattern"
   say "       get remotefile [localfile]"
   say "       getb remotefile [localfile]"
   say "       put localfile [remotefile]"
   say "       putb localfile [remotefile]"
   say "       uput localfile [remotefile]"
   say "       uputb localfile [remotefile]"
   say "       rename oldname newname"
   say "       delete filename"
   say "       append remotefile [localfile]"
   say "       appendb remotefile [localfile]"
   say "       sys"
   say "       md directory"
   say "       cd directory"
   say "       rd directory"
   say "       pwd"
   say "       quit"

   return 0
